// KeyNode.h: interface for the CKeyNode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KEYNODE_H__6A29F1C5_D77A_41C9_A921_D1038A367B54__INCLUDED_)
#define AFX_KEYNODE_H__6A29F1C5_D77A_41C9_A921_D1038A367B54__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#include "MathLibrary.h"

class CFileStream;

class CKeyNode : public CUnknown  
{
protected:
	int				m_nParent;
	KINEMATICS		m_kinematics;

public:
	CKeyNode();
	virtual ~CKeyNode();

	virtual bool Read(CFileStream* lpStream);

	// inline
	///////////////////////////////////////////////////////////////////////////
	int		   GetParent()		{ return m_nParent;	}
	KINEMATICS GetKinematices()	{ return m_kinematics; }
};

#endif // !defined(AFX_KEYNODE_H__6A29F1C5_D77A_41C9_A921_D1038A367B54__INCLUDED_)
