// Material.cpp: implementation of the CMaterial class.
//
//////////////////////////////////////////////////////////////////////

#include "Material.h"

#include "Texture.h"
#include "Kernel.h"

#include "OpenGL.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMaterial::CMaterial()
{
	m_pszClassName = "CMaterial";

	///////////////////////////////////////////////////////////////////////////
	m_pTexture = NULL;
}

CMaterial::~CMaterial()
{

}

void CMaterial::Apply()
{
	if (m_pTexture)
		m_pTexture->Apply();

    // Use OpenGL ICD Version
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,  (GLfloat*) &m_ambient);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,  (GLfloat*) &m_diffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, (GLfloat*) &m_specular);

	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, m_shininess);
}

bool CMaterial::Read(CFileStream *lpStream)
{
	CFileStream* pStream = lpStream;

	char szName[80];
	pStream->ReadString(szName);
	if (!CUnknown::Create(szName))
		return false;

	pStream->Read(&m_ambient, sizeof(COLOR), 1);
	pStream->Read(&m_diffuse, sizeof(COLOR), 1);
	pStream->Read(&m_specular, sizeof(COLOR), 1);

	pStream->Read(&m_shininess, sizeof(float), 1);

	int nLength = pStream->ReadString(szName);
	if (nLength)
		m_pTexture = CKernel::LookupTexture(szName);

	return true;
}
