// Material.h: interface for the CMaterial class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MATERIAL_H__9893ACC7_5B9F_4FB8_A2EA_AB841EEB7394__INCLUDED_)
#define AFX_MATERIAL_H__9893ACC7_5B9F_4FB8_A2EA_AB841EEB7394__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#pragma pack(1)
typedef struct _COLOR
{
	union
	{
		float	c[4];
		struct
		{
			float	red, green, blue;
			float	alpha;
		};
	};
} COLOR, *LPCOLOR;
#pragma pack()

class CFileStream;
class CTexture;

class CMaterial : public CUnknown  
{
protected:
	COLOR		m_ambient;		// Ambient color RGB
	COLOR		m_diffuse;		// Diffuse color RGBA
	COLOR		m_specular;		// Specular 'shininess'

	float		m_shininess;	// Shininess

	CTexture*	m_pTexture;

public:
	CMaterial();
	virtual ~CMaterial();

	virtual bool Read(CFileStream* lpStream);
	virtual void Apply();
};

#endif // !defined(AFX_MATERIAL_H__9893ACC7_5B9F_4FB8_A2EA_AB841EEB7394__INCLUDED_)
