// Mesh.h: interface for the CMesh class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESH_H__5A539CF8_BF0B_4B9F_B02C_3F8AE8FF0662__INCLUDED_)
#define AFX_MESH_H__5A539CF8_BF0B_4B9F_B02C_3F8AE8FF0662__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#include "MathLibrary.h"

// Untransformed/unlit vertices
// (GL_T2F_N3F_V3F)
#pragma pack(1)
typedef struct _VERTEX
{
	FLOAT	tu, tv;			// Texture coordinates
	FLOAT	nx, ny, nz;		// Normal
	FLOAT	x, y, z;		// Homogeneous coordinates
} VERTEX, *LPVERTEX;
#pragma pack()

class CFileStream;
class CMeshFace;

class CMesh : public CUnknown  
{
protected:
	LPVECTOR3D	m_pVector;

	// Vertices
	DWORD		m_dwNumVertices;
	LPVERTEX	m_pVertices;

	int*		m_pBones;

	// Faces
	DWORD		m_dwNumMeshFaces;
	CMeshFace*	m_pMeshFaces;

	LPMATRIX	m_pTransform;

public:
	CMesh();
	virtual ~CMesh();

	virtual void Destroy();

	virtual bool Read(CFileStream* lpStream);

	virtual void Update();
	virtual void Render();

	// inline
	///////////////////////////////////////////////////////////////////////////
	DWORD    GetNumVertices()		{ return m_dwNumVertices; }
	LPVERTEX GetVertices()			{ return m_pVertices; }

	int*     GetBones()				{ return m_pBones; }

	DWORD      GetNumMeshFaces()	{ return m_dwNumMeshFaces; }
	CMeshFace* GetMeshFaces()		{ return m_pMeshFaces; }

	void SetTransform(LPMATRIX lpTransform)
	{
		m_pTransform = lpTransform;
	}
};

#endif // !defined(AFX_MESH_H__5A539CF8_BF0B_4B9F_B02C_3F8AE8FF0662__INCLUDED_)
