// MeshFace.h: interface for the CMeshFace class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESHFACE_H__2998B239_884F_4D76_A02F_DDF8C6AB4FE6__INCLUDED_)
#define AFX_MESHFACE_H__2998B239_884F_4D76_A02F_DDF8C6AB4FE6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

class CFileStream;

class CMaterial;
class CFace;

class CMeshFace : public CUnknown  
{
protected:
	CMaterial*	m_pMaterial;

	DWORD		m_dwNumFaces;
	CFace*		m_pFaces;

	LPDWORD	m_pIndices;
	DWORD	m_dwNumIndices;

public:
	CMeshFace();
	virtual ~CMeshFace();

	virtual void Destroy();

	virtual bool Read(CFileStream* lpStream);
	virtual void Render();

	// inline
	///////////////////////////////////////////////////////////////////////////
	DWORD  GetNumFaces()		{ return m_dwNumFaces; }
	CFace* GetFaces()			{ return m_pFaces; }
};

#endif // !defined(AFX_MESHFACE_H__2998B239_884F_4D76_A02F_DDF8C6AB4FE6__INCLUDED_)
