// MeshFrame.h: interface for the CMeshFrame class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESHFRAME_H__04AA79E8_1B0C_481A_91F9_4AA5A5CD69BE__INCLUDED_)
#define AFX_MESHFRAME_H__04AA79E8_1B0C_481A_91F9_4AA5A5CD69BE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#include "MathLibrary.h"

class CMesh;

class CKeyNode;
class CKeyFrame;

class CFileStream;

class CMeshFrame : public CUnknown  
{
protected:
	DWORD		m_dwNumMeshs;
	CMesh*		m_pMeshs;

	DWORD		m_dwNumKeyNodes;
	CKeyNode*	m_pKeyNodes;

	LPMATRIX	m_pTransform;
	
	CKeyFrame*	m_pKeyFrame;

protected:
	bool ReadHeader(CFileStream *lpStream);

public:
	CMeshFrame();
	virtual ~CMeshFrame();

	virtual void Destroy();

	virtual bool Load(LPSTR lpszFileName);
	
	virtual void Update();	
	virtual void Render();

	// inline
	///////////////////////////////////////////////////////////////////////////
	CMesh* GetMeshs()				{ return m_pMeshs; }
	DWORD  GetNumMeshs()			{ return m_dwNumMeshs; }

	CKeyNode* GetKeyNodes()			{ return m_pKeyNodes; }
	DWORD     GetNumKeyNodes()		{ return m_dwNumKeyNodes; }

	void SetKeyFrame(CKeyFrame* lpKeyFrame)
	{
		m_pKeyFrame = lpKeyFrame;
	}
};

#endif // !defined(AFX_MESHFRAME_H__04AA79E8_1B0C_481A_91F9_4AA5A5CD69BE__INCLUDED_)
