// NodeKey.cpp: implementation of the CNodeKey class.
//
//////////////////////////////////////////////////////////////////////

#include "NodeKey.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNodeKey::CNodeKey()
{
	m_pszClassName = "CNodeKey";

	///////////////////////////////////////////////////////////////////////////
	m_pszName = NULL;
	m_pKinematics = NULL;

	m_nParent = -1;
}

CNodeKey::~CNodeKey()
{
	Destroy();
}

void CNodeKey::Destroy()
{
	if (m_pKinematics)
	{
		delete [] m_pKinematics;
		m_pKinematics = NULL;
	}

	CUnknown::Destroy();
}

bool CNodeKey::Read(CFileStream *lpStream, DWORD dwNumFrames)
{
	CFileStream* pStream = lpStream;

	char szName[80];
	pStream->ReadString(szName);
	if (!CUnknown::Create(szName))
		return false;

	pStream->Read(&m_nParent, sizeof(int), 1);

	///////////////////////////////////////////////////////////////////////////////////////////////
	m_pKinematics = new KINEMATICS [dwNumFrames];
	if (!m_pKinematics)
		return false;

	pStream->Read(m_pKinematics, sizeof(KINEMATICS), dwNumFrames);

	return true;
}
