// NodeKey.h: interface for the CNodeKey class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NODEKEY_H__A0EC499C_6C7B_4D8D_AA2A_43991B4454C2__INCLUDED_)
#define AFX_NODEKEY_H__A0EC499C_6C7B_4D8D_AA2A_43991B4454C2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#include "MathLibrary.h"

class CFileStream;

class CNodeKey : public CUnknown  
{
public:
	int				m_nParent;
	LPKINEMATICS	m_pKinematics;

public:
	CNodeKey();
	virtual ~CNodeKey();

	virtual void Destroy();

	virtual bool Read(CFileStream* lpStream, DWORD dwNumFrames);

	// inline
	///////////////////////////////////////////////////////////////////////////
	int			 GetParent()		{ return m_nParent; }
	LPKINEMATICS GetKinematices()	{ return m_pKinematics;	}
};

#endif // !defined(AFX_NODEKEY_H__A0EC499C_6C7B_4D8D_AA2A_43991B4454C2__INCLUDED_)
