/*
	Win32 Low Level OpenGL Hardware Accelerate Library
	(DEFAULT, VOODOO)

			(c) Copyright 1999-2002

	File Name	: OpenGL.C

	Date		: Create	1999. 03. 08	(Version 0.0.1)
                  Update    2001. 04. 06    (Version 0.0.2)
				  Update	2002. 04. 12	(Version 0.0.3)
*/
#include "OpenGL.h"


/*
	OpenGL ICD 1.2 Reference.
*/
void      		(APIENTRY *glAccum)(GLenum op, GLfloat value) = NULL;
void      		(APIENTRY *glAlphaFunc)(GLenum func, GLclampf ref) = NULL;
GLboolean 		(APIENTRY *glAreTexturesResident)(GLsizei n, const GLuint *textures, GLboolean *residences) = NULL;
void      		(APIENTRY *glArrayElement)(GLint i) = NULL;
void      		(APIENTRY *glBegin)(GLenum mode) = NULL;
void      		(APIENTRY *glBindTexture)(GLenum target, GLuint texture) = NULL;
void      		(APIENTRY *glBitmap)(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) = NULL;
void      		(APIENTRY *glBlendFunc)(GLenum sfactor, GLenum dfactor) = NULL;
void      		(APIENTRY *glCallList)(GLuint list) = NULL;
void      		(APIENTRY *glCallLists)(GLsizei n, GLenum type, const GLvoid *lists) = NULL;
void      		(APIENTRY *glClear)(GLbitfield mask) = NULL;
void      		(APIENTRY *glClearAccum)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) = NULL;
void      		(APIENTRY *glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) = NULL;
void      		(APIENTRY *glClearDepth)(GLclampd depth) = NULL;
void      		(APIENTRY *glClearIndex)(GLfloat c) = NULL;
void      		(APIENTRY *glClearStencil)(GLint s) = NULL;
void      		(APIENTRY *glClipPlane)(GLenum plane, const GLdouble *equation) = NULL;
void      		(APIENTRY *glColor3b)(GLbyte red, GLbyte green, GLbyte blue) = NULL;
void      		(APIENTRY *glColor3bv)(const GLbyte *v) = NULL;
void      		(APIENTRY *glColor3d)(GLdouble red, GLdouble green, GLdouble blue) = NULL;
void      		(APIENTRY *glColor3dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glColor3f)(GLfloat red, GLfloat green, GLfloat blue) = NULL;
void      		(APIENTRY *glColor3fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glColor3i)(GLint red, GLint green, GLint blue) = NULL;
void      		(APIENTRY *glColor3iv)(const GLint *v) = NULL;
void      		(APIENTRY *glColor3s)(GLshort red, GLshort green, GLshort blue) = NULL;
void      		(APIENTRY *glColor3sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glColor3ub)(GLubyte red, GLubyte green, GLubyte blue) = NULL;
void      		(APIENTRY *glColor3ubv)(const GLubyte *v) = NULL;
void      		(APIENTRY *glColor3ui)(GLuint red, GLuint green, GLuint blue) = NULL;
void      		(APIENTRY *glColor3uiv)(const GLuint *v) = NULL;
void      		(APIENTRY *glColor3us)(GLushort red, GLushort green, GLushort blue) = NULL;
void      		(APIENTRY *glColor3usv)(const GLushort *v) = NULL;
void      		(APIENTRY *glColor4b)(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) = NULL;
void      		(APIENTRY *glColor4bv)(const GLbyte *v) = NULL;
void      		(APIENTRY *glColor4d)(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) = NULL;
void      		(APIENTRY *glColor4dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glColor4f)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) = NULL;
void      		(APIENTRY *glColor4fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glColor4i)(GLint red, GLint green, GLint blue, GLint alpha) = NULL;
void      		(APIENTRY *glColor4iv)(const GLint *v) = NULL;
void      		(APIENTRY *glColor4s)(GLshort red, GLshort green, GLshort blue, GLshort alpha) = NULL;
void      		(APIENTRY *glColor4sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glColor4ub)(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) = NULL;
void      		(APIENTRY *glColor4ubv)(const GLubyte *v) = NULL;
void      		(APIENTRY *glColor4ui)(GLuint red, GLuint green, GLuint blue, GLuint alpha) = NULL;
void      		(APIENTRY *glColor4uiv)(const GLuint *v) = NULL;
void      		(APIENTRY *glColor4us)(GLushort red, GLushort green, GLushort blue, GLushort alpha) = NULL;
void      		(APIENTRY *glColor4usv)(const GLushort *v) = NULL;
void      		(APIENTRY *glColorMask)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) = NULL;
void      		(APIENTRY *glColorMaterial)(GLenum face, GLenum mode) = NULL;
void      		(APIENTRY *glColorPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) = NULL;
void      		(APIENTRY *glCopyPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) = NULL;
void      		(APIENTRY *glCopyTexImage1D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) = NULL;
void      		(APIENTRY *glCopyTexImage2D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) = NULL;
void      		(APIENTRY *glCopyTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) = NULL;
void      		(APIENTRY *glCopyTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) = NULL;
void      		(APIENTRY *glCullFace)(GLenum mode) = NULL;
void      		(APIENTRY *glDeleteLists)(GLuint list, GLsizei range) = NULL;
void      		(APIENTRY *glDeleteTextures)(GLsizei n, const GLuint *textures) = NULL;
void      		(APIENTRY *glDepthFunc)(GLenum func) = NULL;
void      		(APIENTRY *glDepthMask)(GLboolean flag) = NULL;
void      		(APIENTRY *glDepthRange)(GLclampd zNear, GLclampd zFar) = NULL;
void      		(APIENTRY *glDisable)(GLenum cap) = NULL;
void      		(APIENTRY *glDisableClientState)(GLenum array) = NULL;
void      		(APIENTRY *glDrawArrays)(GLenum mode, GLint first, GLsizei count) = NULL;
void      		(APIENTRY *glDrawBuffer)(GLenum mode) = NULL;
void      		(APIENTRY *glDrawElements)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices) = NULL;
void      		(APIENTRY *glDrawPixels)(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) = NULL;
void      		(APIENTRY *glEdgeFlag)(GLboolean flag) = NULL;
void      		(APIENTRY *glEdgeFlagPointer)(GLsizei stride, const GLboolean *pointer) = NULL;
void      		(APIENTRY *glEdgeFlagv)(const GLboolean *flag) = NULL;
void      		(APIENTRY *glEnable)(GLenum cap) = NULL;
void      		(APIENTRY *glEnableClientState)(GLenum array) = NULL;
void      		(APIENTRY *glEnd)(void) = NULL;
void      		(APIENTRY *glEndList)(void) = NULL;
void      		(APIENTRY *glEvalCoord1d)(GLdouble u) = NULL;
void      		(APIENTRY *glEvalCoord1dv)(const GLdouble *u) = NULL;
void      		(APIENTRY *glEvalCoord1f)(GLfloat u) = NULL;
void      		(APIENTRY *glEvalCoord1fv)(const GLfloat *u) = NULL;
void      		(APIENTRY *glEvalCoord2d)(GLdouble u, GLdouble v) = NULL;
void      		(APIENTRY *glEvalCoord2dv)(const GLdouble *u) = NULL;
void      		(APIENTRY *glEvalCoord2f)(GLfloat u, GLfloat v) = NULL;
void      		(APIENTRY *glEvalCoord2fv)(const GLfloat *u) = NULL;
void      		(APIENTRY *glEvalMesh1)(GLenum mode, GLint i1, GLint i2) = NULL;
void      		(APIENTRY *glEvalMesh2)(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) = NULL;
void			(APIENTRY *glEvalPoint1)(GLint i) = NULL;
void			(APIENTRY *glEvalPoint2)(GLint i, GLint j) = NULL;
void			(APIENTRY *glFeedbackBuffer)(GLsizei size, GLenum type, GLfloat *buffer) = NULL;
void			(APIENTRY *glFinish)(void) = NULL;
void			(APIENTRY *glFlush)(void) = NULL;
void			(APIENTRY *glFogf)(GLenum pname, GLfloat param) = NULL;
void			(APIENTRY *glFogfv)(GLenum pname, const GLfloat *params) = NULL;
void			(APIENTRY *glFogi)(GLenum pname, GLint param) = NULL;
void			(APIENTRY *glFogiv)(GLenum pname, const GLint *params) = NULL;
void			(APIENTRY *glFrontFace)(GLenum mode) = NULL;
void			(APIENTRY *glFrustum)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) = NULL;
GLuint			(APIENTRY *glGenLists)(GLsizei range) = NULL;
void			(APIENTRY *glGenTextures)(GLsizei n, GLuint *textures) = NULL;
void			(APIENTRY *glGetBooleanv)(GLenum pname, GLboolean *params) = NULL;
void			(APIENTRY *glGetClipPlane)(GLenum plane, GLdouble *equation) = NULL;
void			(APIENTRY *glGetDoublev)(GLenum pname, GLdouble *params) = NULL;
GLenum			(APIENTRY *glGetError)(void) = NULL;
void			(APIENTRY *glGetFloatv)(GLenum pname, GLfloat *params) = NULL;
void			(APIENTRY *glGetIntegerv)(GLenum pname, GLint *params) = NULL;
void			(APIENTRY *glGetLightfv)(GLenum light, GLenum pname, GLfloat *params) = NULL;
void			(APIENTRY *glGetLightiv)(GLenum light, GLenum pname, GLint *params) = NULL;
void			(APIENTRY *glGetMapdv)(GLenum target, GLenum query, GLdouble *v) = NULL;
void			(APIENTRY *glGetMapfv)(GLenum target, GLenum query, GLfloat *v) = NULL;
void			(APIENTRY *glGetMapiv)(GLenum target, GLenum query, GLint *v) = NULL;
void			(APIENTRY *glGetMaterialfv)(GLenum face, GLenum pname, GLfloat *params) = NULL;
void			(APIENTRY *glGetMaterialiv)(GLenum face, GLenum pname, GLint *params) = NULL;
void			(APIENTRY *glGetPixelMapfv)(GLenum map, GLfloat *values) = NULL;
void			(APIENTRY *glGetPixelMapuiv)(GLenum map, GLuint *values) = NULL;
void			(APIENTRY *glGetPixelMapusv)(GLenum map, GLushort *values) = NULL;
void			(APIENTRY *glGetPointerv)(GLenum pname, GLvoid* *params) = NULL;
void			(APIENTRY *glGetPolygonStipple)(GLubyte *mask) = NULL;
const GLubyte*	(APIENTRY *glGetString)(GLenum name) = NULL;
void			(APIENTRY *glGetTexEnvfv)(GLenum target, GLenum pname, GLfloat *params) = NULL;
void      		(APIENTRY *glGetTexEnviv)(GLenum target, GLenum pname, GLint *params) = NULL;
void      		(APIENTRY *glGetTexGendv)(GLenum coord, GLenum pname, GLdouble *params) = NULL;
void      		(APIENTRY *glGetTexGenfv)(GLenum coord, GLenum pname, GLfloat *params) = NULL;
void      		(APIENTRY *glGetTexGeniv)(GLenum coord, GLenum pname, GLint *params) = NULL;
void      		(APIENTRY *glGetTexImage)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels) = NULL;
void      		(APIENTRY *glGetTexLevelParameterfv)(GLenum target, GLint level, GLenum pname, GLfloat *params) = NULL;
void      		(APIENTRY *glGetTexLevelParameteriv)(GLenum target, GLint level, GLenum pname, GLint *params) = NULL;
void      		(APIENTRY *glGetTexParameterfv)(GLenum target, GLenum pname, GLfloat *params) = NULL;
void      		(APIENTRY *glGetTexParameteriv)(GLenum target, GLenum pname, GLint *params) = NULL;
void      		(APIENTRY *glHint)(GLenum target, GLenum mode) = NULL;
void      		(APIENTRY *glIndexMask)(GLuint mask) = NULL;
void      		(APIENTRY *glIndexPointer)(GLenum type, GLsizei stride, const GLvoid *pointer) = NULL;
void      		(APIENTRY *glIndexd)(GLdouble c) = NULL;
void      		(APIENTRY *glIndexdv)(const GLdouble *c) = NULL;
void      		(APIENTRY *glIndexf)(GLfloat c) = NULL;
void      		(APIENTRY *glIndexfv)(const GLfloat *c) = NULL;
void      		(APIENTRY *glIndexi)(GLint c) = NULL;
void      		(APIENTRY *glIndexiv)(const GLint *c) = NULL;
void      		(APIENTRY *glIndexs)(GLshort c) = NULL;
void      		(APIENTRY *glIndexsv)(const GLshort *c) = NULL;
void      		(APIENTRY *glIndexub)(GLubyte c) = NULL;
void      		(APIENTRY *glIndexubv)(const GLubyte *c) = NULL;
void      		(APIENTRY *glInitNames)(void) = NULL;
void      		(APIENTRY *glInterleavedArrays)(GLenum format, GLsizei stride, const GLvoid *pointer) = NULL;
GLboolean 		(APIENTRY *glIsEnabled)(GLenum cap) = NULL;
GLboolean 		(APIENTRY *glIsList)(GLuint list) = NULL;
GLboolean 		(APIENTRY *glIsTexture)(GLuint texture) = NULL;
void      		(APIENTRY *glLightModelf)(GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glLightModelfv)(GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glLightModeli)(GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glLightModeliv)(GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glLightf)(GLenum light, GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glLightfv)(GLenum light, GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glLighti)(GLenum light, GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glLightiv)(GLenum light, GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glLineStipple)(GLint factor, GLushort pattern) = NULL;
void      		(APIENTRY *glLineWidth)(GLfloat width) = NULL;
void      		(APIENTRY *glListBase)(GLuint base) = NULL;
void      		(APIENTRY *glLoadIdentity)(void) = NULL;
void      		(APIENTRY *glLoadMatrixd)(const GLdouble *m) = NULL;
void      		(APIENTRY *glLoadMatrixf)(const GLfloat *m) = NULL;
void      		(APIENTRY *glLoadName)(GLuint name) = NULL;
void      		(APIENTRY *glLogicOp)(GLenum opcode) = NULL;
void      		(APIENTRY *glMap1d)(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points) = NULL;
void      		(APIENTRY *glMap1f)(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points) = NULL;
void      		(APIENTRY *glMap2d)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points) = NULL;
void      		(APIENTRY *glMap2f)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points) = NULL;
void      		(APIENTRY *glMapGrid1d)(GLint un, GLdouble u1, GLdouble u2) = NULL;
void      		(APIENTRY *glMapGrid1f)(GLint un, GLfloat u1, GLfloat u2) = NULL;
void      		(APIENTRY *glMapGrid2d)(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) = NULL;
void      		(APIENTRY *glMapGrid2f)(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) = NULL;
void      		(APIENTRY *glMaterialf)(GLenum face, GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glMaterialfv)(GLenum face, GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glMateriali)(GLenum face, GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glMaterialiv)(GLenum face, GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glMatrixMode)(GLenum mode) = NULL;
void      		(APIENTRY *glMultMatrixd)(const GLdouble *m) = NULL;
void      		(APIENTRY *glMultMatrixf)(const GLfloat *m) = NULL;
void      		(APIENTRY *glNewList)(GLuint list, GLenum mode) = NULL;
void      		(APIENTRY *glNormal3b)(GLbyte nx, GLbyte ny, GLbyte nz) = NULL;
void      		(APIENTRY *glNormal3bv)(const GLbyte *v) = NULL;
void      		(APIENTRY *glNormal3d)(GLdouble nx, GLdouble ny, GLdouble nz) = NULL;
void      		(APIENTRY *glNormal3dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glNormal3f)(GLfloat nx, GLfloat ny, GLfloat nz) = NULL;
void      		(APIENTRY *glNormal3fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glNormal3i)(GLint nx, GLint ny, GLint nz) = NULL;
void      		(APIENTRY *glNormal3iv)(const GLint *v) = NULL;
void      		(APIENTRY *glNormal3s)(GLshort nx, GLshort ny, GLshort nz) = NULL;
void      		(APIENTRY *glNormal3sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glNormalPointer)(GLenum type, GLsizei stride, const GLvoid *pointer) = NULL;
void      		(APIENTRY *glOrtho)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) = NULL;
void      		(APIENTRY *glPassThrough)(GLfloat token) = NULL;
void      		(APIENTRY *glPixelMapfv)(GLenum map, GLint mapsize, const GLfloat *values) = NULL;
void      		(APIENTRY *glPixelMapuiv)(GLenum map, GLint mapsize, const GLuint *values) = NULL;
void      		(APIENTRY *glPixelMapusv)(GLenum map, GLint mapsize, const GLushort *values) = NULL;
void      		(APIENTRY *glPixelStoref)(GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glPixelStorei)(GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glPixelTransferf)(GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glPixelTransferi)(GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glPixelZoom)(GLfloat xfactor, GLfloat yfactor) = NULL;
void      		(APIENTRY *glPointSize)(GLfloat size) = NULL;
void      		(APIENTRY *glPolygonMode)(GLenum face, GLenum mode) = NULL;
void      		(APIENTRY *glPolygonOffset)(GLfloat factor, GLfloat units) = NULL;
void      		(APIENTRY *glPolygonStipple)(const GLubyte *mask) = NULL;
void      		(APIENTRY *glPopAttrib)(void) = NULL;
void      		(APIENTRY *glPopClientAttrib)(void) = NULL;
void      		(APIENTRY *glPopMatrix)(void) = NULL;
void      		(APIENTRY *glPopName)(void) = NULL;
void      		(APIENTRY *glPrioritizeTextures)(GLsizei n, const GLuint *textures, const GLclampf *priorities) = NULL;
void      		(APIENTRY *glPushAttrib)(GLbitfield mask) = NULL;
void      		(APIENTRY *glPushClientAttrib)(GLbitfield mask) = NULL;
void      		(APIENTRY *glPushMatrix)(void) = NULL;
void      		(APIENTRY *glPushName)(GLuint name) = NULL;
void      		(APIENTRY *glRasterPos2d)(GLdouble x, GLdouble y) = NULL;
void      		(APIENTRY *glRasterPos2dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glRasterPos2f)(GLfloat x, GLfloat y) = NULL;
void      		(APIENTRY *glRasterPos2fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glRasterPos2i)(GLint x, GLint y) = NULL;
void      		(APIENTRY *glRasterPos2iv)(const GLint *v) = NULL;
void      		(APIENTRY *glRasterPos2s)(GLshort x, GLshort y) = NULL;
void      		(APIENTRY *glRasterPos2sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glRasterPos3d)(GLdouble x, GLdouble y, GLdouble z) = NULL;
void      		(APIENTRY *glRasterPos3dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glRasterPos3f)(GLfloat x, GLfloat y, GLfloat z) = NULL;
void      		(APIENTRY *glRasterPos3fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glRasterPos3i)(GLint x, GLint y, GLint z) = NULL;
void      		(APIENTRY *glRasterPos3iv)(const GLint *v) = NULL;
void      		(APIENTRY *glRasterPos3s)(GLshort x, GLshort y, GLshort z) = NULL;
void      		(APIENTRY *glRasterPos3sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glRasterPos4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w) = NULL;
void      		(APIENTRY *glRasterPos4dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glRasterPos4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w) = NULL;
void      		(APIENTRY *glRasterPos4fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glRasterPos4i)(GLint x, GLint y, GLint z, GLint w) = NULL;
void      		(APIENTRY *glRasterPos4iv)(const GLint *v) = NULL;
void      		(APIENTRY *glRasterPos4s)(GLshort x, GLshort y, GLshort z, GLshort w) = NULL;
void      		(APIENTRY *glRasterPos4sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glReadBuffer)(GLenum mode) = NULL;
void      		(APIENTRY *glReadPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels) = NULL;
void      		(APIENTRY *glRectd)(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) = NULL;
void      		(APIENTRY *glRectdv)(const GLdouble *v1, const GLdouble *v2) = NULL;
void      		(APIENTRY *glRectf)(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) = NULL;
void      		(APIENTRY *glRectfv)(const GLfloat *v1, const GLfloat *v2) = NULL;
void      		(APIENTRY *glRecti)(GLint x1, GLint y1, GLint x2, GLint y2) = NULL;
void      		(APIENTRY *glRectiv)(const GLint *v1, const GLint *v2) = NULL;
void      		(APIENTRY *glRects)(GLshort x1, GLshort y1, GLshort x2, GLshort y2) = NULL;
void      		(APIENTRY *glRectsv)(const GLshort *v1, const GLshort *v2) = NULL;
GLint     		(APIENTRY *glRenderMode)(GLenum mode) = NULL;
void      		(APIENTRY *glRotated)(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) = NULL;
void      		(APIENTRY *glRotatef)(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) = NULL;
void      		(APIENTRY *glScaled)(GLdouble x, GLdouble y, GLdouble z) = NULL;
void      		(APIENTRY *glScalef)(GLfloat x, GLfloat y, GLfloat z) = NULL;
void      		(APIENTRY *glScissor)(GLint x, GLint y, GLsizei width, GLsizei height) = NULL;
void      		(APIENTRY *glSelectBuffer)(GLsizei size, GLuint *buffer) = NULL;
void      		(APIENTRY *glShadeModel)(GLenum mode) = NULL;
void      		(APIENTRY *glStencilFunc)(GLenum func, GLint ref, GLuint mask) = NULL;
void      		(APIENTRY *glStencilMask)(GLuint mask) = NULL;
void      		(APIENTRY *glStencilOp)(GLenum fail, GLenum zfail, GLenum zpass) = NULL;
void      		(APIENTRY *glTexCoord1d)(GLdouble s) = NULL;
void      		(APIENTRY *glTexCoord1dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glTexCoord1f)(GLfloat s) = NULL;
void      		(APIENTRY *glTexCoord1fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glTexCoord1i)(GLint s) = NULL;
void      		(APIENTRY *glTexCoord1iv)(const GLint *v) = NULL;
void      		(APIENTRY *glTexCoord1s)(GLshort s) = NULL;
void      		(APIENTRY *glTexCoord1sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glTexCoord2d)(GLdouble s, GLdouble t) = NULL;
void      		(APIENTRY *glTexCoord2dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glTexCoord2f)(GLfloat s, GLfloat t) = NULL;
void      		(APIENTRY *glTexCoord2fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glTexCoord2i)(GLint s, GLint t) = NULL;
void      		(APIENTRY *glTexCoord2iv)(const GLint *v) = NULL;
void      		(APIENTRY *glTexCoord2s)(GLshort s, GLshort t) = NULL;
void      		(APIENTRY *glTexCoord2sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glTexCoord3d)(GLdouble s, GLdouble t, GLdouble r) = NULL;
void      		(APIENTRY *glTexCoord3dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glTexCoord3f)(GLfloat s, GLfloat t, GLfloat r) = NULL;
void      		(APIENTRY *glTexCoord3fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glTexCoord3i)(GLint s, GLint t, GLint r) = NULL;
void      		(APIENTRY *glTexCoord3iv)(const GLint *v) = NULL;
void      		(APIENTRY *glTexCoord3s)(GLshort s, GLshort t, GLshort r) = NULL;
void      		(APIENTRY *glTexCoord3sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glTexCoord4d)(GLdouble s, GLdouble t, GLdouble r, GLdouble q) = NULL;
void      		(APIENTRY *glTexCoord4dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glTexCoord4f)(GLfloat s, GLfloat t, GLfloat r, GLfloat q) = NULL;
void      		(APIENTRY *glTexCoord4fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glTexCoord4i)(GLint s, GLint t, GLint r, GLint q) = NULL;
void      		(APIENTRY *glTexCoord4iv)(const GLint *v) = NULL;
void      		(APIENTRY *glTexCoord4s)(GLshort s, GLshort t, GLshort r, GLshort q) = NULL;
void      		(APIENTRY *glTexCoord4sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glTexCoordPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) = NULL;
void      		(APIENTRY *glTexEnvf)(GLenum target, GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glTexEnvfv)(GLenum target, GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glTexEnvi)(GLenum target, GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glTexEnviv)(GLenum target, GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glTexGend)(GLenum coord, GLenum pname, GLdouble param) = NULL;
void      		(APIENTRY *glTexGendv)(GLenum coord, GLenum pname, const GLdouble *params) = NULL;
void      		(APIENTRY *glTexGenf)(GLenum coord, GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glTexGenfv)(GLenum coord, GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glTexGeni)(GLenum coord, GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glTexGeniv)(GLenum coord, GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glTexImage1D)(GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels) = NULL;
void      		(APIENTRY *glTexImage2D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels) = NULL;
void      		(APIENTRY *glTexParameterf)(GLenum target, GLenum pname, GLfloat param) = NULL;
void      		(APIENTRY *glTexParameterfv)(GLenum target, GLenum pname, const GLfloat *params) = NULL;
void      		(APIENTRY *glTexParameteri)(GLenum target, GLenum pname, GLint param) = NULL;
void      		(APIENTRY *glTexParameteriv)(GLenum target, GLenum pname, const GLint *params) = NULL;
void      		(APIENTRY *glTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels) = NULL;
void      		(APIENTRY *glTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) = NULL;
void      		(APIENTRY *glTranslated)(GLdouble x, GLdouble y, GLdouble z) = NULL;
void      		(APIENTRY *glTranslatef)(GLfloat x, GLfloat y, GLfloat z) = NULL;
void      		(APIENTRY *glVertex2d)(GLdouble x, GLdouble y) = NULL;
void      		(APIENTRY *glVertex2dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glVertex2f)(GLfloat x, GLfloat y) = NULL;
void      		(APIENTRY *glVertex2fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glVertex2i)(GLint x, GLint y) = NULL;
void      		(APIENTRY *glVertex2iv)(const GLint *v) = NULL;
void      		(APIENTRY *glVertex2s)(GLshort x, GLshort y) = NULL;
void      		(APIENTRY *glVertex2sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glVertex3d)(GLdouble x, GLdouble y, GLdouble z) = NULL;
void      		(APIENTRY *glVertex3dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glVertex3f)(GLfloat x, GLfloat y, GLfloat z) = NULL;
void      		(APIENTRY *glVertex3fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glVertex3i)(GLint x, GLint y, GLint z) = NULL;
void      		(APIENTRY *glVertex3iv)(const GLint *v) = NULL;
void      		(APIENTRY *glVertex3s)(GLshort x, GLshort y, GLshort z) = NULL;
void      		(APIENTRY *glVertex3sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glVertex4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w) = NULL;
void      		(APIENTRY *glVertex4dv)(const GLdouble *v) = NULL;
void      		(APIENTRY *glVertex4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w) = NULL;
void      		(APIENTRY *glVertex4fv)(const GLfloat *v) = NULL;
void      		(APIENTRY *glVertex4i)(GLint x, GLint y, GLint z, GLint w) = NULL;
void      		(APIENTRY *glVertex4iv)(const GLint *v) = NULL;
void      		(APIENTRY *glVertex4s)(GLshort x, GLshort y, GLshort z, GLshort w) = NULL;
void      		(APIENTRY *glVertex4sv)(const GLshort *v) = NULL;
void      		(APIENTRY *glVertexPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) = NULL;
void      		(APIENTRY *glViewport)(GLint x, GLint y, GLsizei width, GLsizei height) = NULL;


/*
	OpenGL 1.2 Win32 bindings
*/
BOOL			(APIENTRY *fnwglCopyContext)(HGLRC hglrcSrc, HGLRC hlglrcDst, UINT mask) = NULL;
HGLRC 			(APIENTRY *fnwglCreateContext)(HDC) = NULL;
BOOL  			(APIENTRY *fnwglDeleteContext)(HGLRC) = NULL;
PROC  			(APIENTRY *fnwglGetProcAddress)(LPCSTR) = NULL;
BOOL  			(APIENTRY *fnwglMakeCurrent)(HDC, HGLRC) = NULL;

BOOL  			(APIENTRY *wglSwapBuffers)(HDC) = NULL;
int   			(APIENTRY *wglChoosePixelFormat)(HDC, CONST PIXELFORMATDESCRIPTOR *) = NULL;
int   			(APIENTRY *wglDescribePixelFormat)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR) = NULL;
BOOL  			(APIENTRY *wglSetPixelFormat)(HDC, int, CONST PIXELFORMATDESCRIPTOR *) = NULL;


/*****************************************************************************************************
**	GLX EXTENSIONS
*****************************************************************************************************/
	
// GLX_ARB_get_proc_address
#if defined __linux__
PFNGLXGETPROCADDRESSARB						glXGetProcAddressARB = NULL;
#endif

/*****************************************************************************************************
**	WGL EXTENSIONS
*****************************************************************************************************/

// WGL_ARB_pixel_format
PFNWGLGETPIXELFORMATATTRIBIVARBPROC			wglGetPixelFormatAttribivARB = NULL;
PFNWGLGETPIXELFORMATATTRIBFVARBPROC			wglGetPixelFormatAttribfvARB = NULL;
PFNWGLCHOOSEPIXELFORMATARBPROC				wglChoosePixelFormatARB = NULL;
	
PFNWGLGETEXTENSIONSSTRINGARBPROC			wglGetExtensionsStringARB = NULL;
	
// WGL_ARB_pbuffer	
PFNWGLCREATEPBUFFERARBPROC					wglCreatePbufferARB = NULL;
PFNWGLGETPBUFFERDCARBPROC					wglGetPbufferDCARB = NULL;
PFNWGLRELEASEPBUFFERDCARBPROC				wglReleasePbufferDCARB = NULL;
PFNWGLDESTROYPBUFFERARBPROC					wglDestroyPbufferARB = NULL;
PFNWGLQUERYPBUFFERARBPROC					wglQueryPbufferARB = NULL;
	
// WGL_ARB_render_texture	
PFNWGLBINDTEXIMAGEARBPROC					wglBindTeximageARB = NULL;
PFNWGLRELEASETEXIMAGEARBPROC				wglReleaseTeximageARB = NULL;
PFNWGLSETPBUFFERATTRIBARBPROC				wglSetPbufferAttribARB = NULL;
		
	
/*****************************************************************************************************
**	EXT EXTENSIONS	
*****************************************************************************************************/

// WGL_EXT_extensions_string
PFNWGLGETEXTENSIONSSTRINGEXTPROC			wglGetExtensionsStringEXT = NULL;
	
// WGL_EXT_pixel_format	
PFNWGLGETPIXELFORMATATTRIBIVEXT				wglGetPixelFormatAttribivEXT = NULL;
PFNWGLGETPIXELFORMATATTRIBFVEXT				wglGetPixelFormatAttribfvEXT = NULL;
PFNWGLCHOOSEPIXELFORMATEXT					wglChoosePixelFormatEXT = NULL;
	
// WGL_EXT_pbuffer	
PFNWGLCREATEPBUFFEREXT 						wglCreatePbufferEXT = NULL;
PFNWGLGETPBUFFERDCEXT						wglGetPbufferDCEXT = NULL;
PFWGLRELEASEPBUFFERDCEXT					wglReleasePbufferDCEXT = NULL;
PFWGLDESTROYPBUFFEREXT 						wglDestroyPbufferEXT = NULL;
PFWGLQUERYPBUFFEREXT						wglQueryPbufferEXT = NULL;

// WGL_EXT_swap_control	
PFNWGLSWAPINTERVALEXTPROC					wglSwapIntervalEXT = NULL;
PFNWGLGETSWAPINTERVALEXTPROC				wglGetSwapIntervalEXT = NULL;
	
// GL_WIN_swap_hint		
PFNGLADDSWAPHINTRECTWINPROC					glAddSwapHintRectWIN = NULL;	

// GL_EXT_cull_vertex
PFNGLCULLPARAMETERDVEXTPROC					glCullParameterdvEXT = NULL;
PFNGLCULLPARAMETERFVEXTPROC					glCullParameterfvEXT = NULL;
	
// GL_EXT_separate_specular_color		
PFNGLSECONDARYCOLOR3UBVEXTPROC 				glSecondaryColor3ubvEXT = NULL;

// GL_EXT_paletted_texture	
PFNGLCOLORTABLEEXTPROC 						glColorTableEXT = NULL;

// GL_EXT_point_parameters
PFNGLPOINTPARAMETERFEXTPROC					glPointParameterfEXT = NULL;
PFNGLPOINTPARAMETERFVEXTPROC				glPointParameterfvEXT = NULL;

// GL_EXT_fog_coord	
PFNGLFOGCOORDFEXTPROC						glFogCoordfEXT = NULL;

// GL_EXT_compiled_vertex_array	
PFNGLLOCKARRAYSEXTPROC 						glLockArraysEXT = NULL;
PFNGLUNLOCKARRAYSEXTPROC					glUnlockArraysEXT = NULL;
	
// GL_EXT_draw_range_elements	
PFNGLDRAWRANGEELEMENTSEXTPROC				glDrawRangeElementsEXT = NULL;
	
// GL_EXT_vertex_weighting
PFNGLVERTEXWEIGHTFEXTPROC					glVertexWeightfEXT = NULL;
PFNGLVERTEXWEIGHTFVEXTPROC 					glVertexWeightfvEXT = NULL;
PFNGLVERTEXWEIGHTPOINTEREXTPROC				glVertexWeightPointerEXT = NULL;

// GL_EXT_vertex_shader
PFNGLBEGINVERTEXSHADEREXTPROC 				glBeginVertexShaderEXT = NULL;
PFNGLENDVERTEXSHADEREXTPROC					glEndVertexShaderEXT = NULL;
PFNGLBINDVERTEXSHADEREXTPROC				glBindVertexShaderEXT = NULL;
PFNGLGENVERTEXSHADERSEXTPROC				glGenVertexShadersEXT = NULL;
PFNGLDELETEVERTEXSHADEREXTPROC				glDeleteVertexShaderEXT = NULL;
PFNGLSHADEROP1EXTPROC 						glShaderOp1EXT = NULL;
PFNGLSHADEROP2EXTPROC 						glShaderOp2EXT = NULL; 												  
PFNGLSHADEROP3EXTPROC 						glShaderOp3EXT = NULL;
PFNGLSWIZZLEEXTPROC							glSwizzleEXT = NULL;
PFNGLWRITEMASKEXTPROC 						glWriteMaskEXT = NULL;
PFNGLINSERTCOMPONENTEXTPROC					glInsertComponentEXT = NULL;
PFNGLEXTRACTCOMPONENTEXTPROC				glExtractComponentEXT = NULL;
PFNGLGENSYMBOLSEXTPROC						glGenSymbolsEXT = NULL;
PFNGLSETINVARIANTEXTPROC					glSetInvariantEXT = NULL;
PFNGLSETLOCALCONSTANTEXTPROC				glSetLocalConstantEXT = NULL;
PFNGLVARIANTBVEXTPROC 						glVariantbvEXT = NULL;
PFNGLVARIANTSVEXTPROC 						glVariantsvEXT = NULL;
PFNGLVARIANTIVEXTPROC 						glVariantivEXT = NULL;
PFNGLVARIANTFVEXTPROC 						glVariantfvEXT = NULL;
PFNGLVARIANTDVEXTPROC 						glVariantdvEXT = NULL;
PFNGLVARIANTUBVEXTPROC						glVariantubvEXT = NULL;
PFNGLVARIANTUSVEXTPROC						glVariantusvEXT = NULL;
PFNGLVARIANTUIVEXTPROC						glVariantuivEXT = NULL;
PFNGLVARIANTPOINTEREXTPROC					glVariantPointerEXT = NULL;
PFNGLENABLEVARIANTCLIENTSTATEEXTPROC		glEnableVariantClientStateEXT = NULL;
PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC		glDisableVariantClientStateEXT = NULL;
PFNGLBINDLIGHTPARAMETEREXTPROC				glBindLightParameterEXT = NULL;
PFNGLBINDMATERIALPARAMETEREXTPROC 			glBindMaterialParameterEXT = NULL;
PFNGLBINDTEXGENPARAMETEREXTPROC				glBindTexGenParameterEXT = NULL;
PFNGLBINDTEXTUREUNITPARAMETEREXTPROC		glBindTextureUnitParameterEXT = NULL;
PFNGLBINDPARAMETEREXTPROC 					glBindParameterEXT = NULL;
PFNGLISVARIANTENABLEDEXTPROC				glIsVariantEnabledEXT = NULL;
PFNGLGETVARIANTBOOLEANVEXTPROC				glGetVariantBooleanvEXT = NULL;
PFNGLGETVARIANTINTEGERVEXTPROC				glGetVariantIntegervEXT = NULL;
PFNGLGETVARIANTFLOATVEXTPROC				glGetVariantFloatvEXT = NULL;
PFNGLGETVARIANTPOINTERVEXTPROC				glGetVariantPointervEXT = NULL;
PFNGLGETINVARIANTBOOLEANVEXTPROC			glGetInvariantBooleanvEXT = NULL;
PFNGLGETINVARIANTINTEGERVEXTPROC			glGetInvariantIntegervEXT = NULL;
PFNGLGETINVARIANTFLOATVEXTPROC				glGetInvariantFloatvEXT = NULL;
PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC		glGetLocalConstantBooleanvEXT = NULL;
PFNGLGETLOCALCONSTANTINTEGERVEXTPROC		glGetLocalConstantIntegervEXT = NULL;
PFNGLGETLOCALCONSTANTFLOATVEXTPROC			glGetLocalConstantFloatvEXT = NULL;

// GL_EXT_vertex_array
PFNGLARRAYELEMENTEXTPROC					glArrayElementEXT = NULL;
PFNGLCOLORPOINTEREXTPROC					glColorPointerEXT = NULL;
PFNGLDRAWARRAYSEXTPROC						glDrawArraysEXT = NULL;
PFNGLEDGEFLAGPOINTEREXTPROC					glEdgeFlagPointerEXT = NULL;
PFNGLGETPOINTERVEXTPROC						glGetPointervEXT = NULL;
PFNGLINDEXPOINTEREXTPROC					glIndexPointerEXT = NULL;
PFNGLNORMALPOINTEREXTPROC					glNormalPointerEXT = NULL;
PFNGLTEXCOORDPOINTEREXTPROC					glTexCoordPointerEXT = NULL;
PFNGLVERTEXPOINTEREXTPROC					glVertexPointerEXT = NULL;

/*********************************************************************************************************
**	ARB EXTENSIONS
*********************************************************************************************************/

// GL_ARB_multisample
PFNGLSAMPLECOVERAGEARBPROC					glSampleCoverageARB = NULL;

// GL_ARB_transpose_matrix	
PFNGLLOADTRANSPOSEMATRIXFARB				glLoadTransposeMatrixfARB = NULL;
PFNGLMULTTRANSPOSEMATRIXFARB				glMultTransposeMatrixfARB = NULL;

// GL_ARB_multitexture	
PFNGLCLIENTACTIVETEXTUREARBPROC				glClientActiveTextureARB = NULL;
PFNGLACTIVETEXTUREARBPROC 					glActiveTextureARB = NULL;
PFNGLMULTITEXCOORD2FARBPROC					glMultiTexCoord2fARB = NULL;
PFNGLMULTITEXCOORD4FARBPROC					glMultiTexCoord4fARB = NULL;
PFNGLMULTITEXCOORD2FVARBPROC				glMultiTexCoord2fvARB = NULL;
PFNGLMULTITEXCOORD4FVARBPROC				glMultiTexCoord4fvARB = NULL;

// GL_ARB_compression	
PFNGLCOMPRESSEDTEXIMAGE1DARB				glCompressedTexImage1DARB = NULL;
PFNGLCOMPRESSEDTEXIMAGE2DARB				glCompressedTexImage2DARB = NULL;
PFNGLCOMPRESSEDTEXIMAGE3DARB				glCompressedTexImage3DARB = NULL;
PFNGLGETCOMPRESSEDTEXIMAGEARB 				glGetCompressedTexImageARB = NULL;
	
// GL_ARB_vertex_blend		
PFNGLWEIGHTBVARBPROC						glWeightbvARB = NULL;
PFNGLWEIGHTSVARBPROC						glWeightsvARB = NULL;
PFNGLWEIGHTIVARBPROC						glWeightivARB = NULL;
PFNGLWEIGHTFVARBPROC						glWeightfvARB = NULL;
PFNGLWEIGHTDVARBPROC						glWeightdvARB = NULL;
PFNGLWEIGHTUBVARBPROC 						glWeightubvARB = NULL;
PFNGLWEIGHTUSVARBPROC 						glWeightusvARB = NULL;
PFNGLWEIGHTUIVARBPROC 						glWeightuivARB = NULL;
PFNGLWEIGHTPOINTERARBPROC 					glWeightPointerARB = NULL;
PFNGLVERTEXBLENDARBPROC						glVertexBlendARB = NULL;
		
		
/*****************************************************************************************************
**	3DFX EXTENSIONS
*****************************************************************************************************/

// GL_3DFX_tbuffer
PGNGLTBUFFERMASK3DFX						glTbufferMask3DFX = NULL;


/*************************************************************************************************************
**	nVidia EXTENSIONS
**************************************************************************************************************/

// NV_vertex_array_range
PFNGLFLUSHVERTEXARRAYRANGENVPROC			glFlushVertexArrayRangeNV = NULL;
PFNGLVERTEXARRAYRANGENVPROC					glVertexArrayRangeNV = NULL;
PFNWGLALLOCATEMEMORYNVPROC					wglAllocateMemoryNV = NULL;
PFNWGLFREEMEMORYNVPROC						wglFreeMemoryNV = NULL;
	
// NV_fence
PFNGLGENFENCESNVPROC						glGenFencesNV = NULL;
PFNGLDELETEFENCESNVPROC						glDeleteFencesNV = NULL;
PFNGLSETFENCENVPROC							glSetFenceNV = NULL;
PFNGLTESTFENCENVPROC						glTestFenceNV = NULL;
PFNGLFINISHFENCENVPROC						glFinishFenceNV = NULL;
PFNGLISFENCENVPROC							glIsFenceNV = NULL;
PFNGLGETFENCEIVNVPROC 						glGetFenceivNV = NULL;

// GL_NV_ext_combine
PFNGLCOMBINERPARAMETERFVNVPROC				glCombinerParameterfvNV = NULL;
PFNGLCOMBINERPARAMETERIVNVPROC				glCombinerParameterivNV = NULL;
PFNGLCOMBINERPARAMETERFNVPROC 				glCombinerParameterfNV = NULL;
PFNGLCOMBINERPARAMETERINVPROC 				glCombinerParameteriNV = NULL;
PFNGLCOMBINERINPUTNVPROC					glCombinerInputNV = NULL;
PFNGLCOMBINEROUTPUTNVPROC 					glCombinerOutputNV = NULL;
PFNGLFINALCOMBINERINPUTNVPROC 				glFinalCombinerInputNV = NULL;
PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC		glGetCombinerInputParameterfvNV = NULL;
PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC		glGetCombinerInputParameterivNV = NULL;
PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC		glGetCombinerOutputParameterfvNV = NULL;
PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC		glGetCombinerOutputParameterivNV = NULL;
PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC	glGetFinalCombinerInputParameterfvNV = NULL;
PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC	glGetFinalCombinerInputParameterivNV = NULL;

// GL_NV_vertex_program (DX8 vertex shaders)
PFNGLBINDPROGRAMNVPROC						glBindProgramNV = NULL;
PFNGLDELETEPROGRAMSNVPROC 					glDeleteProgramsNV = NULL;
PFNGLEXECUTEPROGRAMNVPROC 					glExecuteProgramNV = NULL;
PFNGLGENPROGRAMSNVPROC						glGenProgramsNV = NULL;
PFNGLAREPROGRAMSRESIDENTNVPROC				glAreProgramsResidentNV = NULL;
PFNGLREQUESTRESIDENTPROGRAMSNVPROC			glRequestResidentProgramsNV = NULL;
PFNGLGETPROGRAMPARAMETERFVNVPROC			glGetProgramParameterfvNV = NULL;
PFNGLGETPROGRAMPARAMETERDVNVPROC			glGetProgramParameterdvNV = NULL;
PFNGLGETPROGRAMIVNVPROC						glGetProgramivNV = NULL;
PFNGLGETPROGRAMSTRINGNVPROC					glGetProgramStringNV = NULL;
PFNGLGETTRACKMATRIXIVNVPROC					glGetTrackMatrixivNV = NULL;
PFNGLGETVERTEXATTRIBDVNVPROC				glGetVertexAttribdvNV = NULL;
PFNGLGETVERTEXATTRIBFVNVPROC				glGetVertexAttribfvNV = NULL;
PFNGLGETVERTEXATTRIBIVNVPROC				glGetVertexAttribivNV = NULL;
PFNGLGETVERTEXATTRIBPOINTERVNVPROC			glGetVertexAttribPointervNV = NULL;
PFNGLISPROGRAMNVPROC						glIsProgramNV = NULL;
PFNGLLOADPROGRAMNVPROC						glLoadProgramNV = NULL;
PFNGLPROGRAMPARAMETER4FNVPROC 				glProgramParameter4fNV = NULL;
PFNGLPROGRAMPARAMETER4DNVPROC 				glProgramParameter4dNV = NULL;
PFNGLPROGRAMPARAMETER4DVNVPROC				glProgramParameter4dvNV = NULL;
PFNGLPROGRAMPARAMETER4FVNVPROC				glProgramParameter4fvNV = NULL;
PFNGLPROGRAMPARAMETERS4DVNVPROC				glProgramParameters4dvNV = NULL;
PFNGLPROGRAMPARAMETERS4FVNVPROC				glProgramParameters4fvNV = NULL;
PFNGLTRACKMATRIXNVPROC						glTrackMatrixNV = NULL;
PFNGLVERTEXATTRIBPOINTERNVPROC				glVertexAttribPointerNV = NULL;
PFNGLVERTEXATTRIB1SNVPROC 					glVertexAttrib1sNV = NULL;
PFNGLVERTEXATTRIB1FNVPROC 					glVertexAttrib1fNV = NULL;
PFNGLVERTEXATTRIB1DNVPROC 					glVertexAttrib1dNV = NULL;
PFNGLVERTEXATTRIB2SNVPROC 					glVertexAttrib2sNV = NULL;
PFNGLVERTEXATTRIB2FNVPROC 					glVertexAttrib2fNV = NULL;
PFNGLVERTEXATTRIB2DNVPROC 					glVertexAttrib2dNV = NULL;
PFNGLVERTEXATTRIB3SNVPROC 					glVertexAttrib3sNV = NULL;
PFNGLVERTEXATTRIB3FNVPROC 					glVertexAttrib3fNV = NULL;
PFNGLVERTEXATTRIB3DNVPROC 					glVertexAttrib3dNV = NULL;
PFNGLVERTEXATTRIB4SNVPROC 					glVertexAttrib4sNV = NULL;
PFNGLVERTEXATTRIB4FNVPROC 					glVertexAttrib4fNV = NULL;
PFNGLVERTEXATTRIB4DNVPROC 					glVertexAttrib4dNV = NULL;
PFNGLVERTEXATTRIB4UBNVPROC					glVertexAttrib4ubNV = NULL;
PFNGLVERTEXATTRIB1SVNVPROC					glVertexAttrib1svNV = NULL;
PFNGLVERTEXATTRIB1FVNVPROC					glVertexAttrib1fvNV = NULL;
PFNGLVERTEXATTRIB1DVNVPROC					glVertexAttrib1dvNV = NULL;
PFNGLVERTEXATTRIB2SVNVPROC					glVertexAttrib2svNV = NULL;
PFNGLVERTEXATTRIB2FVNVPROC					glVertexAttrib2fvNV = NULL;
PFNGLVERTEXATTRIB2DVNVPROC					glVertexAttrib2dvNV = NULL;
PFNGLVERTEXATTRIB3SVNVPROC					glVertexAttrib3svNV = NULL;
PFNGLVERTEXATTRIB3FVNVPROC					glVertexAttrib3fvNV = NULL;
PFNGLVERTEXATTRIB3DVNVPROC					glVertexAttrib3dvNV = NULL;
PFNGLVERTEXATTRIB4SVNVPROC					glVertexAttrib4svNV = NULL;
PFNGLVERTEXATTRIB4FVNVPROC					glVertexAttrib4fvNV = NULL;
PFNGLVERTEXATTRIB4DVNVPROC					glVertexAttrib4dvNV = NULL;
PFNGLVERTEXATTRIB4UBVNVPROC					glVertexAttrib4ubvNV = NULL;
PFNGLVERTEXATTRIBS1SVNVPROC					glVertexAttribs1svNV = NULL;
PFNGLVERTEXATTRIBS1FVNVPROC					glVertexAttribs1fvNV = NULL;
PFNGLVERTEXATTRIBS1DVNVPROC					glVertexAttribs1dvNV = NULL;
PFNGLVERTEXATTRIBS2SVNVPROC					glVertexAttribs2svNV = NULL;
PFNGLVERTEXATTRIBS2FVNVPROC					glVertexAttribs2fvNV = NULL;
PFNGLVERTEXATTRIBS2DVNVPROC					glVertexAttribs2dvNV = NULL;
PFNGLVERTEXATTRIBS3SVNVPROC					glVertexAttribs3svNV = NULL;
PFNGLVERTEXATTRIBS3FVNVPROC					glVertexAttribs3fvNV = NULL;
PFNGLVERTEXATTRIBS3DVNVPROC					glVertexAttribs3dvNV = NULL;
PFNGLVERTEXATTRIBS4SVNVPROC					glVertexAttribs4svNV = NULL;
PFNGLVERTEXATTRIBS4FVNVPROC					glVertexAttribs4fvNV = NULL;
PFNGLVERTEXATTRIBS4DVNVPROC					glVertexAttribs4dvNV = NULL;
PFNGLVERTEXATTRIBS4UBVNVPROC				glVertexAttribs4ubvNV = NULL;


/*************************************************************************************************************
**	ATI EXTENSIONS
*************************************************************************************************************/

// GL_ATI_envmap_bumpmap
PFNGLTEXBUMPPARAMETERIVATIPROC				glTexBumpParameterivATI = NULL;
PFNGLTEXBUMPPARAMETERFVATIPROC				glTexBumpParameterfvATI = NULL;
PFNGLGETTEXBUMPPARAMETERIVATIPROC 			glGetTexBumpParameterivATI = NULL;
PFNGLGETTEXBUMPPARAMETERFVATIPROC 			glGetTexBumpParameterfvATI = NULL;
	
// GL_ATI_envmap_bumpmap
PFNGLGENFRAGMENTSHADERSATIPROC				glGenFragmentShadersATI = NULL;
PFNGLBINDFRAGMENTSHADERATIPROC				glBindFragmentShaderATI = NULL;
PFNGLDELETEFRAGMENTSHADERATIPROC			glDeleteFragmentShaderATI = NULL;
PFNGLBEGINFRAGMENTSHADERATIPROC				glBeginFragmentShaderATI = NULL;
PFNGLENDFRAGMENTSHADERATIPROC 				glEndFragmentShaderATI = NULL;
PFNGLPASSTEXCOORDATIPROC					glPassTexCoordATI = NULL;
PFNGLSAMPLEMAPATIPROC 						glSampleMapATI = NULL;
PFNGLCOLORFRAGMENTOP1ATIPROC				glColorFragmentOp1ATI = NULL;
PFNGLCOLORFRAGMENTOP2ATIPROC				glColorFragmentOp2ATI = NULL;
PFNGLCOLORFRAGMENTOP3ATIPROC				glColorFragmentOp3ATI = NULL;
PFNGLALPHAFRAGMENTOP1ATIPROC				glAlphaFragmentOp1ATI = NULL;
PFNGLALPHAFRAGMENTOP2ATIPROC				glAlphaFragmentOp2ATI = NULL;
PFNGLALPHAFRAGMENTOP3ATIPROC				glAlphaFragmentOp3ATI = NULL;
PFNGLSETFRAGMENTSHADERCONSTANTATIPROC 		glSetFragmentShaderConstantATI = NULL; 

// GL_ATI_pn_triangles
PFNGLPNTRIANGLESIATIPROC					glPNTrianglesiATI = NULL;
PFNGLPNTRIANGLESFATIPROC					glPNTrianglesfATI = NULL;

// GL_ATI_vertex_array_object
PFNGLMAPOBJECTBUFFERATI						glMapObjectBufferATI = NULL;
PFNGLUNMAPOBJECTBUFFERATI					glUnmapObjectBufferATI = NULL;

// GL_ATI_vertex_array_object
PFNGLNEWOBJECTBUFFERATIPROC					glNewObjectBufferATI = NULL;
PFNGLISOBJECTBUFFERATIPROC					glIsObjectBufferATI = NULL;
PFNGLUPDATEOBJECTBUFFERATIPROC				glUpdateObjectBufferATI = NULL;									 
PFNGLGETOBJECTBUFFERFVATIPROC 				glGetObjectBufferfvATI = NULL;
PFNGLGETOBJECTBUFFERIVATIPROC 				glGetObjectBufferivATI = NULL;
PFNGLFREEOBJECTBUFFERATIPROC				glFreeObjectBufferATI = NULL;
PFNGLARRAYOBJECTATIPROC						glArrayObjectATI = NULL;
PFNGLGETARRAYOBJECTFVATIPROC				glGetArrayObjectfvATI = NULL;
PFNGLGETARRAYOBJECTIVATIPROC				glGetArrayObjectivATI = NULL;
PFNGLVARIANTARRAYOBJECTATIPROC				glVariantArrayObjectATI = NULL;
PFNGLGETVARIANTARRAYOBJECTFVATIPROC			glGetVariantArrayObjectfvATI = NULL;
PFNGLGETVARIANTARRAYOBJECTIVATIPROC			glGetVariantArrayObjectivATI = NULL;

// GL_ATI_element_array
PFNGLELEMENTPOINTERATIPROC					glElementPointerATI = NULL;
PFNGLDRAWELEMENTARRAYATIPROC				glDrawElementArrayATI = NULL;
PFNGLDRAWRANGEELEMENTARRAYATIPROC 			glDrawRangeElementArrayATI = NULL;

///////////////////////////////////////////////////////////////////////////////
/*
	OpenGL Extensions
*/

// GL_3DFX
BOOL	bIsGL_3DFX_tbuffer = FALSE;

// GL_ATI
BOOL	bIsGL_ATI_vertex_array_object = FALSE;
BOOL	bIsGL_ATI_element_array = FALSE;
BOOL	bIsGL_ATI_map_object_buffer = FALSE;
BOOL	bIsGL_ATI_fragment_shader = FALSE;
BOOL	bIsGL_ATI_pn_triangles = FALSE;
BOOL	bIsGL_ATI_envmap_bumpmap = FALSE;

// GL_ARB_
BOOL	bIsGL_ARB_multitexture = FALSE;
BOOL	bIsGL_ARB_texture_compression = FALSE;
BOOL	bIsGL_ARB_transpose_matrix = FALSE;
BOOL	bIsGL_ARB_vertex_blend = FALSE;

BOOL	bIsGL_ARB_texture_cube_map = FALSE;
BOOL	bIsGL_ARB_texture_env_add = FALSE;

// GL_EXT_
BOOL	bIsGL_EXT_separate_specular_color = FALSE;
BOOL	bIsGL_EXT_fog_coord = FALSE;
BOOL	bIsGL_EXT_paletted_texture = FALSE;
BOOL	bIsGL_EXT_compiled_vertex_array = FALSE;
BOOL	bIsGL_EXT_draw_range_elements = FALSE;
BOOL	bIsGL_EXT_vertex_array = FALSE;
BOOL	bIsGL_EXT_vertex_shader = FALSE;
BOOL	bIsGL_EXT_vertex_weighting = FALSE;

BOOL	bIsGL_EXT_packed_pixels = FALSE;				// adds packed pixel formats for glDrawPixels, glReadPixels, glTexImage, etc. 
BOOL	bIsGL_EXT_point_parameters = FALSE;
BOOL	bIsGL_EXT_texture_compression_s3tc = FALSE;
BOOL	bIsGL_EXT_texture_env_combine = FALSE;
BOOL	bIsGL_EXT_cull_vertex = FALSE;

// GL_NV
BOOL	bIsGL_NV_vertex_program = FALSE;
BOOL	bIsGL_NV_register_combiners = FALSE;
BOOL	bIsGL_NV_vertex_array_range = FALSE;
BOOL	bIsGL_NV_fence = FALSE;

// GL_S3
BOOL	bIsGL_S3_s3tc = FALSE;

// GL_WIN
BOOL	bIsGL_WIN_swap_hint = FALSE;

// WGL_EXT_
BOOL	bIsWGL_EXT_swap_control = FALSE;

// WGL_3DFX
BOOL	bIsWGL_3DFX_gamma_control = FALSE;

///////////////////////////////////////////////////////////////////////////////
GLint	iMAX_TEXTURE_SIZE = 0;
GLint	iMAX_ACTIVE_TEXTURES_ARB = 0;

BOOL	bIsOpenGLAccel = FALSE;
BOOL	bIsOpenGLMiniport = FALSE;

BOOL IsOpenGLAccel(LPSTR lpszFileName)
{
	int						nPixelFormat;
	PIXELFORMATDESCRIPTOR	pfd;

	HDC						hDC;
	HINSTANCE				hInstance;

	BOOL					genericFormat, genericAccel;
	BOOL					bIsAccel = FALSE;

	///////////////////////////////////////////////////////////////////////////
	int (APIENTRY *pwglChoosePixelFormat)(HDC, CONST PIXELFORMATDESCRIPTOR *);
	int (APIENTRY *pwglDescribePixelFormat)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
	///////////////////////////////////////////////////////////////////////////

	// Reset Value
	bIsAccel = FALSE;

	// Load OpenGL DLL
	hInstance = LoadLibrary(lpszFileName);
	if (!hInstance)
		return FALSE;

	pwglChoosePixelFormat = (LPVOID) GetProcAddress(hInstance, "wglChoosePixelFormat");
	if (!pwglChoosePixelFormat)
		goto __ERROR;

	pwglDescribePixelFormat = (LPVOID) GetProcAddress(hInstance, "wglDescribePixelFormat");
	if (!pwglDescribePixelFormat)
		goto __ERROR;

	// Get Desktop DC
	hDC = GetDC(NULL);
	if (!hDC)
		goto __ERROR;

	// PIXELFORMATDESCRIPTOR
	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));
    pfd.nSize		 = sizeof(PIXELFORMATDESCRIPTOR);	// Size of this pfd
    pfd.nVersion	 = 1;								// Version Number
    pfd.dwFlags		 = PFD_DRAW_TO_WINDOW |				// Support Window
					   PFD_SUPPORT_OPENGL |				// Support OpenGL
					   PFD_DOUBLEBUFFER;				// Double Buffered
    pfd.dwLayerMask  = PFD_MAIN_PLANE;					// Main drawing plane
    pfd.iPixelType   = PFD_TYPE_RGBA;					// RGB color buffer
	pfd.cDepthBits	 = 32;
	pfd.cStencilBits = 8;

	nPixelFormat = pwglChoosePixelFormat(hDC, &pfd);
	if (nPixelFormat < 0)
		goto __ERROR;

	// what did we get I wonder
	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));
	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	if (!pwglDescribePixelFormat(hDC, nPixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd))
		goto __ERROR;

	// Check Hardware OpenGL
	genericFormat = (pfd.dwFlags & PFD_GENERIC_FORMAT) != 0;
	genericAccel  = (pfd.dwFlags & PFD_GENERIC_ACCELERATED) != 0;

	// Determine hardware driver status by the combination of these
	// two flags.  Both FALSE means ICD, both TRUE means MCD.
	if (genericFormat == genericAccel)
		bIsAccel = TRUE;


__ERROR:
	if (hDC)
		ReleaseDC(NULL, hDC);

	if (hInstance)
		FreeLibrary(hInstance);

	return bIsAccel;
}


int IsVoodooOpenGL()
{
	typedef struct GlideHwConfigStruct GLIDEHWCONFIG;
	struct GlideHwConfigStruct
	{
		int   num_sst;
		char  filler[4096]; // hope this is big enough
	};

	BOOL              (__stdcall* GLIDEFUN_grSstQueryBoards)(GLIDEHWCONFIG* hwconfig);
	int               retValue = FALSE;
	HINSTANCE         hGlide = NULL;
	GLIDEHWCONFIG     glideHwConfig;

	// load glide
	hGlide = LoadLibrary("glide2x.dll");
	if ( !hGlide )
		return FALSE;

	// get query function
	GLIDEFUN_grSstQueryBoards = (void*) GetProcAddress(hGlide, "_grSstQueryBoards@4");

	// count the boards
	if (GLIDEFUN_grSstQueryBoards)
	{
		GLIDEFUN_grSstQueryBoards(&glideHwConfig);
		if (glideHwConfig.num_sst > 0)
			retValue = TRUE;
	}

	FreeLibrary(hGlide);

	return retValue;
}

static LPVOID SafeProcAddress(HINSTANCE hInstance, LPSTR lpszName)
{
	char pszMsg[80];

	FARPROC	pfnFunc = GetProcAddress(hInstance, lpszName);
	if (!pfnFunc)
	{
		wsprintf(pszMsg, "GetProcAddress(\"%s\") failed!", lpszName);
		MessageBox(NULL, pszMsg, "ERROR", MB_OK);
	}

	return pfnFunc;
}

#define	GL_PROC_ADDRESS(name)	\
		name = SafeProcAddress(glInstance, #name)
#define	GL_GDI_PROC_ADDRESS(name)	\
		wgl##name = SafeProcAddress(hInstance, #name)

#define	WGL_PROC_ADDRESS(name)	\
		fn##name = SafeProcAddress(glInstance, #name)
#define	WGL_GDI_PROC_ADDRESS(name)	\
		wgl##name = SafeProcAddress(glInstance, "wgl"#name)

#ifndef PFD_GENERIC_ACCELERATED
#define PFD_GENERIC_ACCELERATED         0x00001000
#endif


static HINSTANCE glInstance = NULL;

static BOOL bIsInstalled = FALSE;
static int	glDriver = GL_DEFAULT;

int LoadOpenGLDriver(int nDriver)
{
	LPCSTR pszDriverList[] = 
	{
		"OPENGL32.DLL", // MS Default OpenGL

		"3DFXVGL.DLL",	// 3Dfx Voodoo
		"PVRGL.DLL",	// PowerVR
		"OPENGL.DLL",	// SGI OpenGL
		NULL
	};

	if (bIsInstalled)
		return TRUE;

	glInstance = LoadLibrary(pszDriverList[nDriver]);
	if (!glInstance)
		return FALSE;


	/*
		OpenGL ICD 1.2 Reference.
	*/
	GL_PROC_ADDRESS(glAccum);
	GL_PROC_ADDRESS(glAlphaFunc);
	GL_PROC_ADDRESS(glAreTexturesResident);
	GL_PROC_ADDRESS(glArrayElement);
	GL_PROC_ADDRESS(glBegin);
	GL_PROC_ADDRESS(glBindTexture);
	GL_PROC_ADDRESS(glBitmap);
	GL_PROC_ADDRESS(glBlendFunc);
	GL_PROC_ADDRESS(glCallList);
	GL_PROC_ADDRESS(glCallLists);
	GL_PROC_ADDRESS(glClear);
	GL_PROC_ADDRESS(glClearAccum);
	GL_PROC_ADDRESS(glClearColor);
	GL_PROC_ADDRESS(glClearDepth);
	GL_PROC_ADDRESS(glClearIndex);
	GL_PROC_ADDRESS(glClearStencil);
	GL_PROC_ADDRESS(glClipPlane);
	GL_PROC_ADDRESS(glColor3b);
	GL_PROC_ADDRESS(glColor3bv);
	GL_PROC_ADDRESS(glColor3d);
	GL_PROC_ADDRESS(glColor3dv);
	GL_PROC_ADDRESS(glColor3f);
	GL_PROC_ADDRESS(glColor3fv);
	GL_PROC_ADDRESS(glColor3i);
	GL_PROC_ADDRESS(glColor3iv);
	GL_PROC_ADDRESS(glColor3s);
	GL_PROC_ADDRESS(glColor3sv);
	GL_PROC_ADDRESS(glColor3ub);
	GL_PROC_ADDRESS(glColor3ubv);
	GL_PROC_ADDRESS(glColor3ui);
	GL_PROC_ADDRESS(glColor3uiv);
	GL_PROC_ADDRESS(glColor3us);
	GL_PROC_ADDRESS(glColor3usv);
	GL_PROC_ADDRESS(glColor4b);
	GL_PROC_ADDRESS(glColor4bv);
	GL_PROC_ADDRESS(glColor4d);
	GL_PROC_ADDRESS(glColor4dv);
	GL_PROC_ADDRESS(glColor4f);
	GL_PROC_ADDRESS(glColor4fv);
	GL_PROC_ADDRESS(glColor4i);
	GL_PROC_ADDRESS(glColor4iv);
	GL_PROC_ADDRESS(glColor4s);
	GL_PROC_ADDRESS(glColor4sv);
	GL_PROC_ADDRESS(glColor4ub);
	GL_PROC_ADDRESS(glColor4ubv);
	GL_PROC_ADDRESS(glColor4ui);
	GL_PROC_ADDRESS(glColor4uiv);
	GL_PROC_ADDRESS(glColor4us);
	GL_PROC_ADDRESS(glColor4usv);
	GL_PROC_ADDRESS(glColorMask);
	GL_PROC_ADDRESS(glColorMaterial);
	GL_PROC_ADDRESS(glColorPointer);
	GL_PROC_ADDRESS(glCopyPixels);
	GL_PROC_ADDRESS(glCopyTexImage1D);
	GL_PROC_ADDRESS(glCopyTexImage2D);
	GL_PROC_ADDRESS(glCopyTexSubImage1D);
	GL_PROC_ADDRESS(glCopyTexSubImage2D);
	GL_PROC_ADDRESS(glCullFace);
	GL_PROC_ADDRESS(glDeleteLists);
	GL_PROC_ADDRESS(glDeleteTextures);
	GL_PROC_ADDRESS(glDepthFunc);
	GL_PROC_ADDRESS(glDepthMask);
	GL_PROC_ADDRESS(glDepthRange);
	GL_PROC_ADDRESS(glDisable);
	GL_PROC_ADDRESS(glDisableClientState);
	GL_PROC_ADDRESS(glDrawArrays);
	GL_PROC_ADDRESS(glDrawBuffer);
	GL_PROC_ADDRESS(glDrawElements);
	GL_PROC_ADDRESS(glDrawPixels);
	GL_PROC_ADDRESS(glEdgeFlag);
	GL_PROC_ADDRESS(glEdgeFlagPointer);
	GL_PROC_ADDRESS(glEdgeFlagv);
	GL_PROC_ADDRESS(glEnable);
	GL_PROC_ADDRESS(glEnableClientState);
	GL_PROC_ADDRESS(glEnd);
	GL_PROC_ADDRESS(glEndList);
	GL_PROC_ADDRESS(glEvalCoord1d);
	GL_PROC_ADDRESS(glEvalCoord1dv);
	GL_PROC_ADDRESS(glEvalCoord1f);
	GL_PROC_ADDRESS(glEvalCoord1fv);
	GL_PROC_ADDRESS(glEvalCoord2d);
	GL_PROC_ADDRESS(glEvalCoord2dv);
	GL_PROC_ADDRESS(glEvalCoord2f);
	GL_PROC_ADDRESS(glEvalCoord2fv);
	GL_PROC_ADDRESS(glEvalMesh1);
	GL_PROC_ADDRESS(glEvalMesh2);
	GL_PROC_ADDRESS(glEvalPoint1);
	GL_PROC_ADDRESS(glEvalPoint2);
	GL_PROC_ADDRESS(glFeedbackBuffer);
	GL_PROC_ADDRESS(glFinish);
	GL_PROC_ADDRESS(glFlush);
	GL_PROC_ADDRESS(glFogf);
	GL_PROC_ADDRESS(glFogfv);
	GL_PROC_ADDRESS(glFogi);
	GL_PROC_ADDRESS(glFogiv);
	GL_PROC_ADDRESS(glFrontFace);
	GL_PROC_ADDRESS(glFrustum);
	GL_PROC_ADDRESS(glGenLists);
	GL_PROC_ADDRESS(glGenTextures);
	GL_PROC_ADDRESS(glGetBooleanv);
	GL_PROC_ADDRESS(glGetClipPlane);
	GL_PROC_ADDRESS(glGetDoublev);
	GL_PROC_ADDRESS(glGetError);
	GL_PROC_ADDRESS(glGetFloatv);
	GL_PROC_ADDRESS(glGetIntegerv);
	GL_PROC_ADDRESS(glGetLightfv);
	GL_PROC_ADDRESS(glGetLightiv);
	GL_PROC_ADDRESS(glGetMapdv);
	GL_PROC_ADDRESS(glGetMapfv);
	GL_PROC_ADDRESS(glGetMapiv);
	GL_PROC_ADDRESS(glGetMaterialfv);
	GL_PROC_ADDRESS(glGetMaterialiv);
	GL_PROC_ADDRESS(glGetPixelMapfv);
	GL_PROC_ADDRESS(glGetPixelMapuiv);
	GL_PROC_ADDRESS(glGetPixelMapusv);
	GL_PROC_ADDRESS(glGetPointerv);
	GL_PROC_ADDRESS(glGetPolygonStipple);
	GL_PROC_ADDRESS(glGetString);
	GL_PROC_ADDRESS(glGetTexEnvfv);
	GL_PROC_ADDRESS(glGetTexEnviv);
	GL_PROC_ADDRESS(glGetTexGendv);
	GL_PROC_ADDRESS(glGetTexGenfv);
	GL_PROC_ADDRESS(glGetTexGeniv);
	GL_PROC_ADDRESS(glGetTexImage);
	GL_PROC_ADDRESS(glGetTexLevelParameterfv);
	GL_PROC_ADDRESS(glGetTexLevelParameteriv);
	GL_PROC_ADDRESS(glGetTexParameterfv);
	GL_PROC_ADDRESS(glGetTexParameteriv);
	GL_PROC_ADDRESS(glHint);
	GL_PROC_ADDRESS(glIndexMask);
	GL_PROC_ADDRESS(glIndexPointer);
	GL_PROC_ADDRESS(glIndexd);
	GL_PROC_ADDRESS(glIndexdv);
	GL_PROC_ADDRESS(glIndexf);
	GL_PROC_ADDRESS(glIndexfv);
	GL_PROC_ADDRESS(glIndexi);
	GL_PROC_ADDRESS(glIndexiv);
	GL_PROC_ADDRESS(glIndexs);
	GL_PROC_ADDRESS(glIndexsv);
	GL_PROC_ADDRESS(glIndexub);
	GL_PROC_ADDRESS(glIndexubv);
	GL_PROC_ADDRESS(glInitNames);
	GL_PROC_ADDRESS(glInterleavedArrays);
	GL_PROC_ADDRESS(glIsEnabled);
	GL_PROC_ADDRESS(glIsList);
	GL_PROC_ADDRESS(glIsTexture);
	GL_PROC_ADDRESS(glLightModelf);
	GL_PROC_ADDRESS(glLightModelfv);
	GL_PROC_ADDRESS(glLightModeli);
	GL_PROC_ADDRESS(glLightModeliv);
	GL_PROC_ADDRESS(glLightf);
	GL_PROC_ADDRESS(glLightfv);
	GL_PROC_ADDRESS(glLighti);
	GL_PROC_ADDRESS(glLightiv);
	GL_PROC_ADDRESS(glLineStipple);
	GL_PROC_ADDRESS(glLineWidth);
	GL_PROC_ADDRESS(glListBase);
	GL_PROC_ADDRESS(glLoadIdentity);
	GL_PROC_ADDRESS(glLoadMatrixd);
	GL_PROC_ADDRESS(glLoadMatrixf);
	GL_PROC_ADDRESS(glLoadName);
	GL_PROC_ADDRESS(glLogicOp);
	GL_PROC_ADDRESS(glMap1d);
	GL_PROC_ADDRESS(glMap1f);
	GL_PROC_ADDRESS(glMap2d);
	GL_PROC_ADDRESS(glMap2f);
	GL_PROC_ADDRESS(glMapGrid1d);
	GL_PROC_ADDRESS(glMapGrid1f);
	GL_PROC_ADDRESS(glMapGrid2d);
	GL_PROC_ADDRESS(glMapGrid2f);
	GL_PROC_ADDRESS(glMaterialf);
	GL_PROC_ADDRESS(glMaterialfv);
	GL_PROC_ADDRESS(glMateriali);
	GL_PROC_ADDRESS(glMaterialiv);
	GL_PROC_ADDRESS(glMatrixMode);
	GL_PROC_ADDRESS(glMultMatrixd);
	GL_PROC_ADDRESS(glMultMatrixf);
	GL_PROC_ADDRESS(glNewList);
	GL_PROC_ADDRESS(glNormal3b);
	GL_PROC_ADDRESS(glNormal3bv);
	GL_PROC_ADDRESS(glNormal3d);
	GL_PROC_ADDRESS(glNormal3dv);
	GL_PROC_ADDRESS(glNormal3f);
	GL_PROC_ADDRESS(glNormal3fv);
	GL_PROC_ADDRESS(glNormal3i);
	GL_PROC_ADDRESS(glNormal3iv);
	GL_PROC_ADDRESS(glNormal3s);
	GL_PROC_ADDRESS(glNormal3sv);
	GL_PROC_ADDRESS(glNormalPointer);
	GL_PROC_ADDRESS(glOrtho);
	GL_PROC_ADDRESS(glPassThrough);
	GL_PROC_ADDRESS(glPixelMapfv);
	GL_PROC_ADDRESS(glPixelMapuiv);
	GL_PROC_ADDRESS(glPixelMapusv);
	GL_PROC_ADDRESS(glPixelStoref);
	GL_PROC_ADDRESS(glPixelStorei);
	GL_PROC_ADDRESS(glPixelTransferf);
	GL_PROC_ADDRESS(glPixelTransferi);
	GL_PROC_ADDRESS(glPixelZoom);
	GL_PROC_ADDRESS(glPointSize);
	GL_PROC_ADDRESS(glPolygonMode);
	GL_PROC_ADDRESS(glPolygonOffset);
	GL_PROC_ADDRESS(glPolygonStipple);
	GL_PROC_ADDRESS(glPopAttrib);
	GL_PROC_ADDRESS(glPopClientAttrib);
	GL_PROC_ADDRESS(glPopMatrix);
	GL_PROC_ADDRESS(glPopName);
	GL_PROC_ADDRESS(glPrioritizeTextures);
	GL_PROC_ADDRESS(glPushAttrib);
	GL_PROC_ADDRESS(glPushClientAttrib);
	GL_PROC_ADDRESS(glPushMatrix);
	GL_PROC_ADDRESS(glPushName);
	GL_PROC_ADDRESS(glRasterPos2d);
	GL_PROC_ADDRESS(glRasterPos2dv);
	GL_PROC_ADDRESS(glRasterPos2f);
	GL_PROC_ADDRESS(glRasterPos2fv);
	GL_PROC_ADDRESS(glRasterPos2i);
	GL_PROC_ADDRESS(glRasterPos2iv);
	GL_PROC_ADDRESS(glRasterPos2s);
	GL_PROC_ADDRESS(glRasterPos2sv);
	GL_PROC_ADDRESS(glRasterPos3d);
	GL_PROC_ADDRESS(glRasterPos3dv);
	GL_PROC_ADDRESS(glRasterPos3f);
	GL_PROC_ADDRESS(glRasterPos3fv);
	GL_PROC_ADDRESS(glRasterPos3i);
	GL_PROC_ADDRESS(glRasterPos3iv);
	GL_PROC_ADDRESS(glRasterPos3s);
	GL_PROC_ADDRESS(glRasterPos3sv);
	GL_PROC_ADDRESS(glRasterPos4d);
	GL_PROC_ADDRESS(glRasterPos4dv);
	GL_PROC_ADDRESS(glRasterPos4f);
	GL_PROC_ADDRESS(glRasterPos4fv);
	GL_PROC_ADDRESS(glRasterPos4i);
	GL_PROC_ADDRESS(glRasterPos4iv);
	GL_PROC_ADDRESS(glRasterPos4s);
	GL_PROC_ADDRESS(glRasterPos4sv);
	GL_PROC_ADDRESS(glReadBuffer);
	GL_PROC_ADDRESS(glReadPixels);
	GL_PROC_ADDRESS(glRectd);
	GL_PROC_ADDRESS(glRectdv);
	GL_PROC_ADDRESS(glRectf);
	GL_PROC_ADDRESS(glRectfv);
	GL_PROC_ADDRESS(glRecti);
	GL_PROC_ADDRESS(glRectiv);
	GL_PROC_ADDRESS(glRects);
	GL_PROC_ADDRESS(glRectsv);
	GL_PROC_ADDRESS(glRenderMode);
	GL_PROC_ADDRESS(glRotated);
	GL_PROC_ADDRESS(glRotatef);
	GL_PROC_ADDRESS(glScaled);
	GL_PROC_ADDRESS(glScalef);
	GL_PROC_ADDRESS(glScissor);
	GL_PROC_ADDRESS(glSelectBuffer);
	GL_PROC_ADDRESS(glShadeModel);
	GL_PROC_ADDRESS(glStencilFunc);
	GL_PROC_ADDRESS(glStencilMask);
	GL_PROC_ADDRESS(glStencilOp);
	GL_PROC_ADDRESS(glTexCoord1d);
	GL_PROC_ADDRESS(glTexCoord1dv);
	GL_PROC_ADDRESS(glTexCoord1f);
	GL_PROC_ADDRESS(glTexCoord1fv);
	GL_PROC_ADDRESS(glTexCoord1i);
	GL_PROC_ADDRESS(glTexCoord1iv);
	GL_PROC_ADDRESS(glTexCoord1s);
	GL_PROC_ADDRESS(glTexCoord1sv);
	GL_PROC_ADDRESS(glTexCoord2d);
	GL_PROC_ADDRESS(glTexCoord2dv);
	GL_PROC_ADDRESS(glTexCoord2f);
	GL_PROC_ADDRESS(glTexCoord2fv);
	GL_PROC_ADDRESS(glTexCoord2i);
	GL_PROC_ADDRESS(glTexCoord2iv);
	GL_PROC_ADDRESS(glTexCoord2s);
	GL_PROC_ADDRESS(glTexCoord2sv);
	GL_PROC_ADDRESS(glTexCoord3d);
	GL_PROC_ADDRESS(glTexCoord3dv);
	GL_PROC_ADDRESS(glTexCoord3f);
	GL_PROC_ADDRESS(glTexCoord3fv);
	GL_PROC_ADDRESS(glTexCoord3i);
	GL_PROC_ADDRESS(glTexCoord3iv);
	GL_PROC_ADDRESS(glTexCoord3s);
	GL_PROC_ADDRESS(glTexCoord3sv);
	GL_PROC_ADDRESS(glTexCoord4d);
	GL_PROC_ADDRESS(glTexCoord4dv);
	GL_PROC_ADDRESS(glTexCoord4f);
	GL_PROC_ADDRESS(glTexCoord4fv);
	GL_PROC_ADDRESS(glTexCoord4i);
	GL_PROC_ADDRESS(glTexCoord4iv);
	GL_PROC_ADDRESS(glTexCoord4s);
	GL_PROC_ADDRESS(glTexCoord4sv);
	GL_PROC_ADDRESS(glTexCoordPointer);
	GL_PROC_ADDRESS(glTexEnvf);
	GL_PROC_ADDRESS(glTexEnvfv);
	GL_PROC_ADDRESS(glTexEnvi);
	GL_PROC_ADDRESS(glTexEnviv);
	GL_PROC_ADDRESS(glTexGend);
	GL_PROC_ADDRESS(glTexGendv);
	GL_PROC_ADDRESS(glTexGenf);
	GL_PROC_ADDRESS(glTexGenfv);
	GL_PROC_ADDRESS(glTexGeni);
	GL_PROC_ADDRESS(glTexGeniv);
	GL_PROC_ADDRESS(glTexImage1D);
	GL_PROC_ADDRESS(glTexImage2D);
	GL_PROC_ADDRESS(glTexParameterf);
	GL_PROC_ADDRESS(glTexParameterfv);
	GL_PROC_ADDRESS(glTexParameteri);
	GL_PROC_ADDRESS(glTexParameteriv);
	GL_PROC_ADDRESS(glTexSubImage1D);
	GL_PROC_ADDRESS(glTexSubImage2D);
	GL_PROC_ADDRESS(glTranslated);
	GL_PROC_ADDRESS(glTranslatef);
	GL_PROC_ADDRESS(glVertex2d);
	GL_PROC_ADDRESS(glVertex2dv);
	GL_PROC_ADDRESS(glVertex2f);
	GL_PROC_ADDRESS(glVertex2fv);
	GL_PROC_ADDRESS(glVertex2i);
	GL_PROC_ADDRESS(glVertex2iv);
	GL_PROC_ADDRESS(glVertex2s);
	GL_PROC_ADDRESS(glVertex2sv);
	GL_PROC_ADDRESS(glVertex3d);
	GL_PROC_ADDRESS(glVertex3dv);
	GL_PROC_ADDRESS(glVertex3f);
	GL_PROC_ADDRESS(glVertex3fv);
	GL_PROC_ADDRESS(glVertex3i);
	GL_PROC_ADDRESS(glVertex3iv);
	GL_PROC_ADDRESS(glVertex3s);
	GL_PROC_ADDRESS(glVertex3sv);
	GL_PROC_ADDRESS(glVertex4d);
	GL_PROC_ADDRESS(glVertex4dv);
	GL_PROC_ADDRESS(glVertex4f);
	GL_PROC_ADDRESS(glVertex4fv);
	GL_PROC_ADDRESS(glVertex4i);
	GL_PROC_ADDRESS(glVertex4iv);
	GL_PROC_ADDRESS(glVertex4s);
	GL_PROC_ADDRESS(glVertex4sv);
	GL_PROC_ADDRESS(glVertexPointer);
	GL_PROC_ADDRESS(glViewport);

	/*
		OpenGL 1.1 Win32 bindings
	*/
	WGL_PROC_ADDRESS(wglCopyContext);
	WGL_PROC_ADDRESS(wglCreateContext);
	WGL_PROC_ADDRESS(wglDeleteContext);
	WGL_PROC_ADDRESS(wglGetProcAddress);
	WGL_PROC_ADDRESS(wglMakeCurrent);

	if (nDriver == GL_DEFAULT)
	{
        // if this is the default opengl32.dll, we need to
        // dynalink from gdi32.dll for the following functions
        // because Win2k does some magic before calling opengl32.dll
		HINSTANCE hInstance = GetModuleHandle("GDI32.DLL");
		if (!hInstance)
			return FALSE;

		GL_GDI_PROC_ADDRESS(SwapBuffers);
		GL_GDI_PROC_ADDRESS(ChoosePixelFormat);
		GL_GDI_PROC_ADDRESS(DescribePixelFormat);
		GL_GDI_PROC_ADDRESS(SetPixelFormat);
	}
	else
	{
		WGL_GDI_PROC_ADDRESS(SwapBuffers);
		WGL_GDI_PROC_ADDRESS(ChoosePixelFormat);
		WGL_GDI_PROC_ADDRESS(DescribePixelFormat);
		WGL_GDI_PROC_ADDRESS(SetPixelFormat);
	}

	glDriver = nDriver;
	bIsInstalled = TRUE;

	return TRUE;
}

void UnloadOpenGLDriver()
{
	if (!bIsInstalled)
		return;

	if (glInstance)
	{
		FreeLibrary(glInstance);
		glInstance = NULL;
	}

	bIsInstalled = FALSE;
}

LPSTR GetOpenGLDriverName(int nDriver)
{
	LPSTR pszDriverNames[] =
    {
		"Default OpenGL Driver",
		"3dfx Standalone OpenGL Driver",
		"PowerVR OpenGL Driver",
		"SGI Software OpenGL Driver",
		NULL,
	};

	return pszDriverNames[nDriver];
}

int GetCurrentOpenGLDriver()
{
	return glDriver;
}

LPSTR GetCurrentOpenGLDriverName()
{
	return GetOpenGLDriverName(glDriver);
}

void CheckOpenGLExtensions()
{
	// check for existance in the list of extension names, and if it's there
    // look up all of the functions and set the flag stating multitexturing
    // is availible.
	LPSTR pszExtensions;
	pszExtensions = (LPSTR) glGetString(GL_EXTENSIONS);

	if (strstr(pszExtensions, "GL_WIN_swap_hint"))
	{
		glAddSwapHintRectWIN	= (LPVOID) fnwglGetProcAddress("glAddSwapHintRectWIN");
		
		bIsGL_WIN_swap_hint = TRUE;
	}

	// 3dfx
	if (strstr(pszExtensions, "GL_3DFX_tbuffer"))
	{
		glTbufferMask3DFX	= (LPVOID) fnwglGetProcAddress("glTbufferMask3DFX");

		bIsGL_3DFX_tbuffer = TRUE;
	}

	// ATI
	if (strstr(pszExtensions, "GL_ATI_vertex_array_object"))
	{
		glNewObjectBufferATI			= (LPVOID) fnwglGetProcAddress("glNewObjectBufferATI");
		glIsObjectBufferATI				= (LPVOID) fnwglGetProcAddress("glIsObjectBufferATI");
		glUpdateObjectBufferATI			= (LPVOID) fnwglGetProcAddress("glUpdateObjectBufferATI");
		glGetObjectBufferfvATI			= (LPVOID) fnwglGetProcAddress("glGetObjectBufferfvATI");
		glGetObjectBufferivATI			= (LPVOID) fnwglGetProcAddress("glGetObjectBufferivATI");
		glFreeObjectBufferATI			= (LPVOID) fnwglGetProcAddress("glFreeObjectBufferATI");
		glArrayObjectATI				= (LPVOID) fnwglGetProcAddress("glArrayObjectATI");
		glGetArrayObjectfvATI			= (LPVOID) fnwglGetProcAddress("glGetArrayObjectfvATI");
		glGetArrayObjectivATI			= (LPVOID) fnwglGetProcAddress("glGetArrayObjectivATI");
		glVariantArrayObjectATI			= (LPVOID) fnwglGetProcAddress("glVariantArrayObjectATI");
		glGetVariantArrayObjectfvATI	= (LPVOID) fnwglGetProcAddress("glGetVariantArrayObjectfvATI");
		glGetVariantArrayObjectivATI	= (LPVOID) fnwglGetProcAddress("glGetVariantArrayObjectivATI");
		
		bIsGL_ATI_vertex_array_object = TRUE;

		if (strstr(pszExtensions, "GL_ATI_element_array"))
		{
			glElementPointerATI			= (LPVOID) fnwglGetProcAddress("glElementPointerATI");
			glDrawElementArrayATI		= (LPVOID) fnwglGetProcAddress("glDrawElementArrayATI");
			glDrawRangeElementArrayATI	= (LPVOID) fnwglGetProcAddress("glDrawRangeElementArrayATI");

			bIsGL_ATI_element_array = TRUE;
		}

		// pure undocumented function, courtesy ATI Technologies
		if (strstr(pszExtensions, "GL_ATI_map_object_buffer"))
		{
			glMapObjectBufferATI		= (LPVOID) fnwglGetProcAddress("glMapObjectBufferATI");
			glUnmapObjectBufferATI		= (LPVOID) fnwglGetProcAddress("glUnmapObjectBufferATI");

			bIsGL_ATI_map_object_buffer = TRUE;
		}
	}

	if (strstr(pszExtensions, "GL_ATI_fragment_shader"))
	{
		glGenFragmentShadersATI			= (LPVOID) fnwglGetProcAddress("glGenFragmentShadersATI");
		glBindFragmentShaderATI			= (LPVOID) fnwglGetProcAddress("glBindFragmentShaderATI");
		glDeleteFragmentShaderATI		= (LPVOID) fnwglGetProcAddress("glDeleteFragmentShaderATI");
		glBeginFragmentShaderATI		= (LPVOID) fnwglGetProcAddress("glBeginFragmentShaderATI");
		glEndFragmentShaderATI			= (LPVOID) fnwglGetProcAddress("glEndFragmentShaderATI");
		glPassTexCoordATI				= (LPVOID) fnwglGetProcAddress("glPassTexCoordATI");
		glSampleMapATI					= (LPVOID) fnwglGetProcAddress("glSampleMapATI");
		glColorFragmentOp1ATI			= (LPVOID) fnwglGetProcAddress("glColorFragmentOp1ATI");
		glColorFragmentOp2ATI			= (LPVOID) fnwglGetProcAddress("glColorFragmentOp2ATI");
		glColorFragmentOp3ATI			= (LPVOID) fnwglGetProcAddress("glColorFragmentOp3ATI");
		glAlphaFragmentOp1ATI			= (LPVOID) fnwglGetProcAddress("glAlphaFragmentOp1ATI");
		glAlphaFragmentOp2ATI			= (LPVOID) fnwglGetProcAddress("glAlphaFragmentOp2ATI");
		glAlphaFragmentOp3ATI			= (LPVOID) fnwglGetProcAddress("glAlphaFragmentOp3ATI");
		glSetFragmentShaderConstantATI	= (LPVOID) fnwglGetProcAddress("glSetFragmentShaderConstantATI");

		bIsGL_ATI_fragment_shader = TRUE;
	}
	if (strstr(pszExtensions, "GL_ATI_envmap_bumpmap"))
	{
		glTexBumpParameterivATI			= (LPVOID) fnwglGetProcAddress("glTexBumpParameterivATI");
		glTexBumpParameterfvATI			= (LPVOID) fnwglGetProcAddress("glTexBumpParameterfvATI");
		glGetTexBumpParameterivATI		= (LPVOID) fnwglGetProcAddress("glGetTexBumpParameterivATI");
		glGetTexBumpParameterfvATI		= (LPVOID) fnwglGetProcAddress("glGetTexBumpParameterfvATI");

		bIsGL_ATI_envmap_bumpmap = TRUE;
	}
	if (strstr(pszExtensions, "GL_ATI_pn_triangles"))
	{
		glPNTrianglesiATI				= (LPVOID) fnwglGetProcAddress("glPNTrianglesiATI");
		glPNTrianglesfATI				= (LPVOID) fnwglGetProcAddress("glPNTrianglesfATI");

		bIsGL_ATI_pn_triangles = TRUE;
	}

	// EXT
	if (strstr(pszExtensions, "GL_EXT_separate_specular_color"))
	{
		glSecondaryColor3ubvEXT		= (LPVOID) fnwglGetProcAddress("glSecondaryColor3ubvEXT");

		bIsGL_EXT_separate_specular_color = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_fog_coord"))
	{
		glFogCoordfEXT				= (LPVOID) fnwglGetProcAddress("glFogCoordfEXT");

		bIsGL_EXT_fog_coord = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_paletted_texture"))
	{
		glColorTableEXT				= (LPVOID) fnwglGetProcAddress("glColorTableEXT");

		bIsGL_EXT_paletted_texture = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_compiled_vertex_array"))
	{
		glLockArraysEXT				= (LPVOID) fnwglGetProcAddress("glLockArraysEXT");
		glUnlockArraysEXT			= (LPVOID) fnwglGetProcAddress("glUnlockArraysEXT");

		bIsGL_EXT_compiled_vertex_array = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_draw_range_elements"))
	{
		glDrawRangeElementsEXT		= (LPVOID) fnwglGetProcAddress("glDrawRangeElementsEXT");

		bIsGL_EXT_draw_range_elements = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_vertex_array"))
	{
		glArrayElementEXT			= (LPVOID) fnwglGetProcAddress("glArrayElementEXT");
		glColorPointerEXT			= (LPVOID) fnwglGetProcAddress("glColorPointerEXT");
		glDrawArraysEXT				= (LPVOID) fnwglGetProcAddress("glDrawArraysEXT");
		glEdgeFlagPointerEXT		= (LPVOID) fnwglGetProcAddress("glEdgeFlagPointerEXT");
		glGetPointervEXT			= (LPVOID) fnwglGetProcAddress("glGetPointervEXT");
		glIndexPointerEXT			= (LPVOID) fnwglGetProcAddress("glIndexPointerEXT");
		glNormalPointerEXT			= (LPVOID) fnwglGetProcAddress("glNormalPointerEXT");
		glTexCoordPointerEXT		= (LPVOID) fnwglGetProcAddress("glTexCoordPointerEXT");
		glVertexPointerEXT			= (LPVOID) fnwglGetProcAddress("glVertexPointerEXT");

		bIsGL_EXT_vertex_array = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_vertex_shader"))
	{
		glBeginVertexShaderEXT			= (LPVOID) fnwglGetProcAddress("glBeginVertexShaderEXT");
		glEndVertexShaderEXT			= (LPVOID) fnwglGetProcAddress("glEndVertexShaderEXT");
		glBindVertexShaderEXT			= (LPVOID) fnwglGetProcAddress("glBindVertexShaderEXT");
		glGenVertexShadersEXT			= (LPVOID) fnwglGetProcAddress("glGenVertexShadersEXT");
		glDeleteVertexShaderEXT			= (LPVOID) fnwglGetProcAddress("glDeleteVertexShaderEXT");
		glShaderOp1EXT					= (LPVOID) fnwglGetProcAddress("glShaderOp1EXT");
		glShaderOp2EXT					= (LPVOID) fnwglGetProcAddress("glShaderOp2EXT");
		glShaderOp3EXT					= (LPVOID) fnwglGetProcAddress("glShaderOp3EXT");
		glSwizzleEXT					= (LPVOID) fnwglGetProcAddress("glSwizzleEXT");
		glWriteMaskEXT					= (LPVOID) fnwglGetProcAddress("glWriteMaskEXT");
		glInsertComponentEXT			= (LPVOID) fnwglGetProcAddress("glInsertComponentEXT");
		glExtractComponentEXT			= (LPVOID) fnwglGetProcAddress("glExtractComponentEXT");
		glGenSymbolsEXT					= (LPVOID) fnwglGetProcAddress("glGenSymbolsEXT");
		glSetInvariantEXT				= (LPVOID) fnwglGetProcAddress("glSetInvariantEXT");
		glSetLocalConstantEXT			= (LPVOID) fnwglGetProcAddress("glSetLocalConstantEXT");
		glVariantbvEXT					= (LPVOID) fnwglGetProcAddress("glVariantbvEXT");
		glVariantsvEXT					= (LPVOID) fnwglGetProcAddress("glVariantsvEXT");
		glVariantivEXT					= (LPVOID) fnwglGetProcAddress("glVariantivEXT");
		glVariantfvEXT					= (LPVOID) fnwglGetProcAddress("glVariantfvEXT");
		glVariantdvEXT					= (LPVOID) fnwglGetProcAddress("glVariantdvEXT");
		glVariantubvEXT					= (LPVOID) fnwglGetProcAddress("glVariantubvEXT");
		glVariantusvEXT					= (LPVOID) fnwglGetProcAddress("glVariantusvEXT");
		glVariantuivEXT					= (LPVOID) fnwglGetProcAddress("glVariantuivEXT");
		glVariantPointerEXT				= (LPVOID) fnwglGetProcAddress("glVariantPointerEXT");
		glEnableVariantClientStateEXT	= (LPVOID) fnwglGetProcAddress("glEnableVariantClientStateEXT");
		glDisableVariantClientStateEXT	= (LPVOID) fnwglGetProcAddress("glDisableVariantClientStateEXT");
		glBindLightParameterEXT			= (LPVOID) fnwglGetProcAddress("glBindLightParameterEXT");
		glBindMaterialParameterEXT		= (LPVOID) fnwglGetProcAddress("glBindMaterialParameterEXT");
		glBindTexGenParameterEXT		= (LPVOID) fnwglGetProcAddress("glBindTexGenParameterEXT");
		glBindTextureUnitParameterEXT	= (LPVOID) fnwglGetProcAddress("glBindTextureUnitParameterEXT");
		glBindParameterEXT				= (LPVOID) fnwglGetProcAddress("glBindParameterEXT");
		glIsVariantEnabledEXT			= (LPVOID) fnwglGetProcAddress("glIsVariantEnabledEXT");
		glGetVariantBooleanvEXT			= (LPVOID) fnwglGetProcAddress("glGetVariantBooleanvEXT");
		glGetVariantIntegervEXT			= (LPVOID) fnwglGetProcAddress("glGetVariantIntegervEXT");
		glGetVariantFloatvEXT			= (LPVOID) fnwglGetProcAddress("glGetVariantFloatvEXT");
		glGetVariantPointervEXT			= (LPVOID) fnwglGetProcAddress("glGetVariantPointervEXT");
		glGetInvariantBooleanvEXT		= (LPVOID) fnwglGetProcAddress("glGetInvariantBooleanvEXT");
		glGetInvariantIntegervEXT		= (LPVOID) fnwglGetProcAddress("glGetInvariantIntegervEXT");
		glGetInvariantFloatvEXT			= (LPVOID) fnwglGetProcAddress("glGetInvariantFloatvEXT");
		glGetLocalConstantBooleanvEXT	= (LPVOID) fnwglGetProcAddress("glGetLocalConstantBooleanvEXT");
		glGetLocalConstantIntegervEXT	= (LPVOID) fnwglGetProcAddress("glGetLocalConstantIntegervEXT");
		glGetLocalConstantFloatvEXT		= (LPVOID) fnwglGetProcAddress("glGetLocalConstantFloatvEXT");

		bIsGL_EXT_vertex_shader = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_vertex_weighting"))
	{
		glVertexWeightfEXT			= (LPVOID) fnwglGetProcAddress("glVertexWeightfEXT");
		glVertexWeightfvEXT			= (LPVOID) fnwglGetProcAddress("glVertexWeightfvEXT");
		glVertexWeightPointerEXT	= (LPVOID) fnwglGetProcAddress("glVertexWeightPointerEXT");

		bIsGL_EXT_vertex_weighting = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_packed_pixels"))
	{
		bIsGL_EXT_packed_pixels = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_point_parameters"))
	{
		glPointParameterfEXT    = (LPVOID) fnwglGetProcAddress("glPointParameterfEXT");
		glPointParameterfvEXT	= (LPVOID) fnwglGetProcAddress("glPointParameterfvEXT");

		bIsGL_EXT_point_parameters = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_texture_compression_s3tc"))
	{
		bIsGL_EXT_texture_compression_s3tc = TRUE;
	}
	if (strstr(pszExtensions, "GL_EXT_cull_vertex"))
	{
		float transform[4] = { 0, 0, 1, 0 };

		glCullParameterdvEXT = (LPVOID) fnwglGetProcAddress("glCullParameterdvEXT");
		glCullParameterfvEXT = (LPVOID) fnwglGetProcAddress("glCullParameterfvEXT");

		bIsGL_EXT_cull_vertex = TRUE;

		glEnable(GL_CULL_VERTEX_EXT);
		glCullParameterfvEXT(GL_CULL_VERTEX_EYE_POSITION_EXT, transform);
	}

	// ARB
	if (strstr(pszExtensions, "GL_ARB_multitexture"))
	{
		glActiveTextureARB			= (LPVOID) fnwglGetProcAddress("glActiveTextureARB");
		glClientActiveTextureARB	= (LPVOID) fnwglGetProcAddress("glClientActiveTextureARB");

		glMultiTexCoord2fARB		= (LPVOID) fnwglGetProcAddress("glMultiTexCoord2fARB");
		glMultiTexCoord4fARB		= (LPVOID) fnwglGetProcAddress("glMultiTexCoord4fARB");
		glMultiTexCoord2fvARB		= (LPVOID) fnwglGetProcAddress("glMultiTexCoord2fvARB");
		glMultiTexCoord4fvARB		= (LPVOID) fnwglGetProcAddress("glMultiTexCoord4fvARB");

		bIsGL_ARB_multitexture = TRUE;

		// Get Max Active Textures
		glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB, &iMAX_ACTIVE_TEXTURES_ARB);
	}
	if (strstr(pszExtensions, "GL_ARB_texture_compression"))
	{
		glCompressedTexImage1DARB	 = (LPVOID) fnwglGetProcAddress("glCompressedTexImage1DARB");
		glCompressedTexImage2DARB	 = (LPVOID) fnwglGetProcAddress("glCompressedTexImage2DARB");
		glCompressedTexImage3DARB	 = (LPVOID) fnwglGetProcAddress("glCompressedTexImage3DARB");
		glGetCompressedTexImageARB	 = (LPVOID) fnwglGetProcAddress("glGetCompressedTexImageARB");

		bIsGL_ARB_texture_compression = TRUE;
	}
	if (strstr(pszExtensions, "GL_ARB_transpose_matrix"))
	{
		glLoadTransposeMatrixfARB	 = (LPVOID) fnwglGetProcAddress("glLoadTransposeMatrixfARB");
		glMultTransposeMatrixfARB	 = (LPVOID) fnwglGetProcAddress("glMultTransposeMatrixfARB");

		bIsGL_ARB_transpose_matrix = TRUE;
	}
	if (strstr(pszExtensions, "GL_ARB_vertex_blend"))
	{
		glWeightbvARB		= (LPVOID) fnwglGetProcAddress("glWeightbvARB");
		glWeightsvARB		= (LPVOID) fnwglGetProcAddress("glWeightsvARB");
		glWeightivARB		= (LPVOID) fnwglGetProcAddress("glWeightivARB");
		glWeightfvARB		= (LPVOID) fnwglGetProcAddress("glWeightfvARB");
		glWeightdvARB		= (LPVOID) fnwglGetProcAddress("glWeightdvARB");
		glWeightubvARB		= (LPVOID) fnwglGetProcAddress("glWeightubvARB");
		glWeightusvARB		= (LPVOID) fnwglGetProcAddress("glWeightusvARB");
		glWeightuivARB		= (LPVOID) fnwglGetProcAddress("glWeightuivARB");
		glWeightPointerARB	= (LPVOID) fnwglGetProcAddress("glWeightPointerARB");
		glVertexBlendARB	= (LPVOID) fnwglGetProcAddress("glVertexBlendARB");

		bIsGL_ARB_vertex_blend = TRUE;
	}
	if (strstr(pszExtensions, "GL_ARB_texture_cube_map"))
	{
		bIsGL_ARB_texture_cube_map = TRUE;
	}

	if (strstr(pszExtensions, "GL_ARB_texture_env_add"))
	{
		bIsGL_ARB_texture_env_add = TRUE;
	}

	// NV
	if (strstr(pszExtensions, "GL_NV_vertex_program"))
	{
		glBindProgramNV				= (LPVOID) fnwglGetProcAddress("glBindProgramNV");
		glDeleteProgramsNV			= (LPVOID) fnwglGetProcAddress("glDeleteProgramsNV");
		glExecuteProgramNV			= (LPVOID) fnwglGetProcAddress("glExecuteProgramNV");
		glGenProgramsNV				= (LPVOID) fnwglGetProcAddress("glGenProgramsNV");
		glAreProgramsResidentNV		= (LPVOID) fnwglGetProcAddress("glAreProgramsResidentNV");
		glRequestResidentProgramsNV	= (LPVOID) fnwglGetProcAddress("glRequestResidentProgramsNV");
		glGetProgramParameterfvNV	= (LPVOID) fnwglGetProcAddress("glGetProgramParameterfvNV");
		glGetProgramParameterdvNV	= (LPVOID) fnwglGetProcAddress("glGetProgramParameterdvNV");
		glGetProgramivNV			= (LPVOID) fnwglGetProcAddress("glGetProgramivNV");
		glGetProgramStringNV		= (LPVOID) fnwglGetProcAddress("glGetProgramStringNV");
		glGetTrackMatrixivNV		= (LPVOID) fnwglGetProcAddress("glGetTrackMatrixivNV");
		glGetVertexAttribdvNV		= (LPVOID) fnwglGetProcAddress("glGetVertexAttribdvNV");
		glGetVertexAttribfvNV		= (LPVOID) fnwglGetProcAddress("glGetVertexAttribfvNV");
		glGetVertexAttribivNV		= (LPVOID) fnwglGetProcAddress("glGetVertexAttribivNV");
		glGetVertexAttribPointervNV	= (LPVOID) fnwglGetProcAddress("glGetVertexAttribPointervNV");
		glIsProgramNV				= (LPVOID) fnwglGetProcAddress("glIsProgramNV");
		glLoadProgramNV				= (LPVOID) fnwglGetProcAddress("glLoadProgramNV");
		glProgramParameter4fNV		= (LPVOID) fnwglGetProcAddress("glProgramParameter4fNV");
		glProgramParameter4dNV		= (LPVOID) fnwglGetProcAddress("glProgramParameter4dNV");
		glProgramParameter4dvNV		= (LPVOID) fnwglGetProcAddress("glProgramParameter4dvNV");
		glProgramParameter4fvNV		= (LPVOID) fnwglGetProcAddress("glProgramParameter4fvNV");
		glProgramParameters4dvNV	= (LPVOID) fnwglGetProcAddress("glProgramParameters4dvNV");
		glProgramParameters4fvNV	= (LPVOID) fnwglGetProcAddress("glProgramParameters4fvNV");
		glTrackMatrixNV				= (LPVOID) fnwglGetProcAddress("glTrackMatrixNV");
		glVertexAttribPointerNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribPointerNV");	
		glVertexAttrib1fNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib1fNV");
		glVertexAttrib2fNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib2fNV");
		glVertexAttrib3fNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib3fNV");
		glVertexAttrib4fNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib4fNV");
		glVertexAttrib4ubNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib4ubNV");
		glVertexAttrib1fvNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib1fvNV");
		glVertexAttrib2fvNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib2fvNV");
		glVertexAttrib3fvNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib3fvNV");
		glVertexAttrib4fvNV			= (LPVOID) fnwglGetProcAddress("glVertexAttrib4fvNV");
		glVertexAttrib4ubvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttrib4ubvNV");
		glVertexAttribs1fvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribs1fvNV");
		glVertexAttribs2fvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribs2fvNV");
		glVertexAttribs3fvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribs3fvNV");
		glVertexAttribs4fvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribs4fvNV");
		glVertexAttribs4ubvNV		= (LPVOID) fnwglGetProcAddress("glVertexAttribs4ubvNVS");

		bIsGL_NV_vertex_program = TRUE;
	}	 
	if (strstr(pszExtensions, "GL_NV_register_combiners"))
	{
		glCombinerParameterfvNV					= (LPVOID) fnwglGetProcAddress("glCombinerParameterfvNV");
		glCombinerParameterivNV					= (LPVOID) fnwglGetProcAddress("glCombinerParameterivNV");
		glCombinerParameterfNV					= (LPVOID) fnwglGetProcAddress("glCombinerParameterfNV");
		glCombinerParameteriNV					= (LPVOID) fnwglGetProcAddress("glCombinerParameteriNV");
		glCombinerInputNV						= (LPVOID) fnwglGetProcAddress("glCombinerInputNV");
		glCombinerOutputNV						= (LPVOID) fnwglGetProcAddress("glCombinerOutputNV");
		glFinalCombinerInputNV					= (LPVOID) fnwglGetProcAddress("glFinalCombinerInputNV");
		glGetCombinerInputParameterfvNV			= (LPVOID) fnwglGetProcAddress("glGetCombinerInputParameterfvNV");
		glGetCombinerInputParameterivNV			= (LPVOID) fnwglGetProcAddress("glGetCombinerInputParameterivNV");
		glGetCombinerOutputParameterfvNV		= (LPVOID) fnwglGetProcAddress("glGetCombinerOutputParameterfvNV");
		glGetCombinerOutputParameterivNV		= (LPVOID) fnwglGetProcAddress("glGetCombinerOutputParameterivNV");
		glGetFinalCombinerInputParameterfvNV	= (LPVOID) fnwglGetProcAddress("glGetFinalCombinerInputParameterfvNV");
		glGetFinalCombinerInputParameterivNV	= (LPVOID) fnwglGetProcAddress("glGetFinalCombinerInputParameterivNV");

		bIsGL_NV_register_combiners = TRUE;
	}
    if (strstr(pszExtensions, "GL_NV_vertex_array_range")) 
	{   
		glFlushVertexArrayRangeNV	= (LPVOID) fnwglGetProcAddress("glFlushVertexArrayRangeNV");
		glVertexArrayRangeNV		= (LPVOID) fnwglGetProcAddress("glVertexArrayRangeNV");
		wglAllocateMemoryNV			= (LPVOID) fnwglGetProcAddress("wglAllocateMemoryNV");
		wglFreeMemoryNV				= (LPVOID) fnwglGetProcAddress("wglFreeMemoryNV");

		bIsGL_NV_vertex_array_range = TRUE;

		if (strstr(pszExtensions, "GL_NV_fence")) 
		{
			glGenFencesNV		= (LPVOID) fnwglGetProcAddress("glGenFencesNV");
			glDeleteFencesNV	= (LPVOID) fnwglGetProcAddress("glDeleteFencesNV");
			glSetFenceNV		= (LPVOID) fnwglGetProcAddress("glSetFenceNV");
			glTestFenceNV		= (LPVOID) fnwglGetProcAddress("glTestFenceNV");
			glFinishFenceNV		= (LPVOID) fnwglGetProcAddress("glFinishFenceNV");
			glIsFenceNV			= (LPVOID) fnwglGetProcAddress("glIsFenceNV");
			glGetFenceivNV		= (LPVOID) fnwglGetProcAddress("glGetFenceivNV");

			bIsGL_NV_fence = TRUE;
		}
	}

	if (strstr(pszExtensions, "GL_S3_s3tc"))
	{
		bIsGL_S3_s3tc = TRUE;
	}

	// WGL
	if (strstr(pszExtensions, "WGL_EXT_swap_control"))
	{
		wglSwapIntervalEXT		= (LPVOID) fnwglGetProcAddress("wglSwapIntervalEXT");
		wglGetSwapIntervalEXT	= (LPVOID) fnwglGetProcAddress("wglGetSwapIntervalEXT");

		bIsWGL_EXT_swap_control = TRUE;

		wglSwapIntervalEXT(1);
	}
	if (strstr(pszExtensions, "WGL_3DFX_gamma_control"))
	{
		bIsWGL_3DFX_gamma_control = TRUE;
	}

	glGetIntegerv(GL_MAX_TEXTURE_SIZE, &iMAX_TEXTURE_SIZE);
}

HGLRC CreateOpenGL(HDC hDC)
{
	int						nPixelFormat;
	HGLRC					hRC;
	PIXELFORMATDESCRIPTOR	pfd;

	BOOL					genericFormat, genericAccel;

	if (!bIsInstalled)
		return NULL;

	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));

    pfd.nSize		 = sizeof(PIXELFORMATDESCRIPTOR);	// Size of this pfd
    pfd.nVersion	 = 1;								// Version Number
    pfd.dwFlags		 = PFD_DRAW_TO_WINDOW |				// Support Window
					   PFD_SUPPORT_OPENGL |				// Support OpenGL
					   PFD_DOUBLEBUFFER;				// Double Buffered
    pfd.dwLayerMask  = PFD_MAIN_PLANE;					// Main drawing plane
    pfd.iPixelType   = PFD_TYPE_RGBA;					// RGB color buffer
	pfd.cDepthBits	 = 32;
	pfd.cStencilBits = 0;

	nPixelFormat = wglChoosePixelFormat(hDC, &pfd);
	if (nPixelFormat < 0)
		return FALSE;

	// what did we get I wonder
	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));
    pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);

	if (!wglDescribePixelFormat(hDC, nPixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd))
		return FALSE;

	// Check Hardware OpenGL
	genericFormat = (pfd.dwFlags & PFD_GENERIC_FORMAT) != 0;
	genericAccel  = (pfd.dwFlags & PFD_GENERIC_ACCELERATED) != 0;

	// Determine hardware driver status by the combination of these
	// two flags.  Both FALSE means ICD, both TRUE means MCD.
	if (genericFormat == genericAccel)
	{
		bIsOpenGLAccel = TRUE;

		if (genericFormat)
			bIsOpenGLMiniport = TRUE;
	}

	// Set the format
	if (!wglSetPixelFormat(hDC, nPixelFormat, &pfd))
		return FALSE;

	// Link the Win Device Context with the OGL Rendering Context
    hRC = fnwglCreateContext(hDC);
	if (!hRC)
		return NULL;

	// Specify the target DeviceContext (window) of the subsequent OGL calls
    fnwglMakeCurrent(hDC, hRC);

	// Check OpenGL Extensions
	CheckOpenGLExtensions();

	return hRC;
}

void DestroyOpenGL(HGLRC hRC)
{
	if (!bIsInstalled)
		return;

	// free the target DeviceContext (window)
	fnwglMakeCurrent(NULL, NULL);

	// release definitely OGL Rendering Context
	fnwglDeleteContext(hRC);
}