/*
	Win32 Low Level OpenGL Hardware Accelerate Library
	( DEFAULT, VOODOO )
		
			(c) Copyright 1999-2002

	File Name	: OpenGL.h

	Date		: Create	1999. 03. 08	( Version 0.0.1 )
                  Update    2001. 04. 06
				  Update	2002. 04. 12
*/

#ifndef __OpenGL_H__
#define __OpenGL_H__

// STRICT is the only supported option (NOSTRICT is no longer supported)
#ifndef STRICT
#define STRICT 1
#endif

#include <windows.h>


#ifndef PI
#define PI		3.141592653589793
#endif




/*
** Copyright 1996 Silicon Graphics, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Silicon Graphics, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
*/

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef signed char GLbyte;
typedef short GLshort;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned int GLuint;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef void GLvoid;

/*************************************************************/

/* Version */
#define GL_VERSION_1_1                    1

/* AccumOp */
#define GL_ACCUM                          0x0100
#define GL_LOAD                           0x0101
#define GL_RETURN                         0x0102
#define GL_MULT                           0x0103
#define GL_ADD                            0x0104

/* AlphaFunction */
#define GL_NEVER                          0x0200
#define GL_LESS                           0x0201
#define GL_EQUAL                          0x0202
#define GL_LEQUAL                         0x0203
#define GL_GREATER                        0x0204
#define GL_NOTEQUAL                       0x0205
#define GL_GEQUAL                         0x0206
#define GL_ALWAYS                         0x0207

/* AttribMask */
#define GL_CURRENT_BIT                    0x00000001
#define GL_POINT_BIT                      0x00000002
#define GL_LINE_BIT                       0x00000004
#define GL_POLYGON_BIT                    0x00000008
#define GL_POLYGON_STIPPLE_BIT            0x00000010
#define GL_PIXEL_MODE_BIT                 0x00000020
#define GL_LIGHTING_BIT                   0x00000040
#define GL_FOG_BIT                        0x00000080
#define GL_DEPTH_BUFFER_BIT               0x00000100
#define GL_ACCUM_BUFFER_BIT               0x00000200
#define GL_STENCIL_BUFFER_BIT             0x00000400
#define GL_VIEWPORT_BIT                   0x00000800
#define GL_TRANSFORM_BIT                  0x00001000
#define GL_ENABLE_BIT                     0x00002000
#define GL_COLOR_BUFFER_BIT               0x00004000
#define GL_HINT_BIT                       0x00008000
#define GL_EVAL_BIT                       0x00010000
#define GL_LIST_BIT                       0x00020000
#define GL_TEXTURE_BIT                    0x00040000
#define GL_SCISSOR_BIT                    0x00080000
#define GL_ALL_ATTRIB_BITS                0x000fffff

/* BeginMode */
#define GL_POINTS                         0x0000
#define GL_LINES                          0x0001
#define GL_LINE_LOOP                      0x0002
#define GL_LINE_STRIP                     0x0003
#define GL_TRIANGLES                      0x0004
#define GL_TRIANGLE_STRIP                 0x0005
#define GL_TRIANGLE_FAN                   0x0006
#define GL_QUADS                          0x0007
#define GL_QUAD_STRIP                     0x0008
#define GL_POLYGON                        0x0009

/* BlendingFactorDest */
#define GL_ZERO                           0
#define GL_ONE                            1
#define GL_SRC_COLOR                      0x0300
#define GL_ONE_MINUS_SRC_COLOR            0x0301
#define GL_SRC_ALPHA                      0x0302
#define GL_ONE_MINUS_SRC_ALPHA            0x0303
#define GL_DST_ALPHA                      0x0304
#define GL_ONE_MINUS_DST_ALPHA            0x0305

/* BlendingFactorSrc */
/*      GL_ZERO */
/*      GL_ONE */
#define GL_DST_COLOR                      0x0306
#define GL_ONE_MINUS_DST_COLOR            0x0307
#define GL_SRC_ALPHA_SATURATE             0x0308
/*      GL_SRC_ALPHA */
/*      GL_ONE_MINUS_SRC_ALPHA */
/*      GL_DST_ALPHA */
/*      GL_ONE_MINUS_DST_ALPHA */

/* Boolean */
#define GL_TRUE                           1
#define GL_FALSE                          0

/* ClearBufferMask */
/*      GL_COLOR_BUFFER_BIT */
/*      GL_ACCUM_BUFFER_BIT */
/*      GL_STENCIL_BUFFER_BIT */
/*      GL_DEPTH_BUFFER_BIT */

/* ClientArrayType */
/*      GL_VERTEX_ARRAY */
/*      GL_NORMAL_ARRAY */
/*      GL_COLOR_ARRAY */
/*      GL_INDEX_ARRAY */
/*      GL_TEXTURE_COORD_ARRAY */
/*      GL_EDGE_FLAG_ARRAY */

/* ClipPlaneName */
#define GL_CLIP_PLANE0                    0x3000
#define GL_CLIP_PLANE1                    0x3001
#define GL_CLIP_PLANE2                    0x3002
#define GL_CLIP_PLANE3                    0x3003
#define GL_CLIP_PLANE4                    0x3004
#define GL_CLIP_PLANE5                    0x3005

/* ColorMaterialFace */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_FRONT_AND_BACK */

/* ColorMaterialParameter */
/*      GL_AMBIENT */
/*      GL_DIFFUSE */
/*      GL_SPECULAR */
/*      GL_EMISSION */
/*      GL_AMBIENT_AND_DIFFUSE */

/* ColorPointerType */
/*      GL_BYTE */
/*      GL_UNSIGNED_BYTE */
/*      GL_SHORT */
/*      GL_UNSIGNED_SHORT */
/*      GL_INT */
/*      GL_UNSIGNED_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* CullFaceMode */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_FRONT_AND_BACK */

/* DataType */
#define GL_BYTE                           0x1400
#define GL_UNSIGNED_BYTE                  0x1401
#define GL_SHORT                          0x1402
#define GL_UNSIGNED_SHORT                 0x1403
#define GL_INT                            0x1404
#define GL_UNSIGNED_INT                   0x1405
#define GL_FLOAT                          0x1406
#define GL_2_BYTES                        0x1407
#define GL_3_BYTES                        0x1408
#define GL_4_BYTES                        0x1409
#define GL_DOUBLE                         0x140A

/* DepthFunction */
/*      GL_NEVER */
/*      GL_LESS */
/*      GL_EQUAL */
/*      GL_LEQUAL */
/*      GL_GREATER */
/*      GL_NOTEQUAL */
/*      GL_GEQUAL */
/*      GL_ALWAYS */

/* DrawBufferMode */
#define GL_NONE                           0
#define GL_FRONT_LEFT                     0x0400
#define GL_FRONT_RIGHT                    0x0401
#define GL_BACK_LEFT                      0x0402
#define GL_BACK_RIGHT                     0x0403
#define GL_FRONT                          0x0404
#define GL_BACK                           0x0405
#define GL_LEFT                           0x0406
#define GL_RIGHT                          0x0407
#define GL_FRONT_AND_BACK                 0x0408
#define GL_AUX0                           0x0409
#define GL_AUX1                           0x040A
#define GL_AUX2                           0x040B
#define GL_AUX3                           0x040C

/* Enable */
/*      GL_FOG */
/*      GL_LIGHTING */
/*      GL_TEXTURE_1D */
/*      GL_TEXTURE_2D */
/*      GL_LINE_STIPPLE */
/*      GL_POLYGON_STIPPLE */
/*      GL_CULL_FACE */
/*      GL_ALPHA_TEST */
/*      GL_BLEND */
/*      GL_INDEX_LOGIC_OP */
/*      GL_COLOR_LOGIC_OP */
/*      GL_DITHER */
/*      GL_STENCIL_TEST */
/*      GL_DEPTH_TEST */
/*      GL_CLIP_PLANE0 */
/*      GL_CLIP_PLANE1 */
/*      GL_CLIP_PLANE2 */
/*      GL_CLIP_PLANE3 */
/*      GL_CLIP_PLANE4 */
/*      GL_CLIP_PLANE5 */
/*      GL_LIGHT0 */
/*      GL_LIGHT1 */
/*      GL_LIGHT2 */
/*      GL_LIGHT3 */
/*      GL_LIGHT4 */
/*      GL_LIGHT5 */
/*      GL_LIGHT6 */
/*      GL_LIGHT7 */
/*      GL_TEXTURE_GEN_S */
/*      GL_TEXTURE_GEN_T */
/*      GL_TEXTURE_GEN_R */
/*      GL_TEXTURE_GEN_Q */
/*      GL_MAP1_VERTEX_3 */
/*      GL_MAP1_VERTEX_4 */
/*      GL_MAP1_COLOR_4 */
/*      GL_MAP1_INDEX */
/*      GL_MAP1_NORMAL */
/*      GL_MAP1_TEXTURE_COORD_1 */
/*      GL_MAP1_TEXTURE_COORD_2 */
/*      GL_MAP1_TEXTURE_COORD_3 */
/*      GL_MAP1_TEXTURE_COORD_4 */
/*      GL_MAP2_VERTEX_3 */
/*      GL_MAP2_VERTEX_4 */
/*      GL_MAP2_COLOR_4 */
/*      GL_MAP2_INDEX */
/*      GL_MAP2_NORMAL */
/*      GL_MAP2_TEXTURE_COORD_1 */
/*      GL_MAP2_TEXTURE_COORD_2 */
/*      GL_MAP2_TEXTURE_COORD_3 */
/*      GL_MAP2_TEXTURE_COORD_4 */
/*      GL_POINT_SMOOTH */
/*      GL_LINE_SMOOTH */
/*      GL_POLYGON_SMOOTH */
/*      GL_SCISSOR_TEST */
/*      GL_COLOR_MATERIAL */
/*      GL_NORMALIZE */
/*      GL_AUTO_NORMAL */
/*      GL_VERTEX_ARRAY */
/*      GL_NORMAL_ARRAY */
/*      GL_COLOR_ARRAY */
/*      GL_INDEX_ARRAY */
/*      GL_TEXTURE_COORD_ARRAY */
/*      GL_EDGE_FLAG_ARRAY */
/*      GL_POLYGON_OFFSET_POINT */
/*      GL_POLYGON_OFFSET_LINE */
/*      GL_POLYGON_OFFSET_FILL */

/* ErrorCode */
#define GL_NO_ERROR                       0
#define GL_INVALID_ENUM                   0x0500
#define GL_INVALID_VALUE                  0x0501
#define GL_INVALID_OPERATION              0x0502
#define GL_STACK_OVERFLOW                 0x0503
#define GL_STACK_UNDERFLOW                0x0504
#define GL_OUT_OF_MEMORY                  0x0505

/* FeedBackMode */
#define GL_2D                             0x0600
#define GL_3D                             0x0601
#define GL_3D_COLOR                       0x0602
#define GL_3D_COLOR_TEXTURE               0x0603
#define GL_4D_COLOR_TEXTURE               0x0604

/* FeedBackToken */
#define GL_PASS_THROUGH_TOKEN             0x0700
#define GL_POINT_TOKEN                    0x0701
#define GL_LINE_TOKEN                     0x0702
#define GL_POLYGON_TOKEN                  0x0703
#define GL_BITMAP_TOKEN                   0x0704
#define GL_DRAW_PIXEL_TOKEN               0x0705
#define GL_COPY_PIXEL_TOKEN               0x0706
#define GL_LINE_RESET_TOKEN               0x0707

/* FogMode */
/*      GL_LINEAR */
#define GL_EXP                            0x0800
#define GL_EXP2                           0x0801


/* FogParameter */
/*      GL_FOG_COLOR */
/*      GL_FOG_DENSITY */
/*      GL_FOG_END */
/*      GL_FOG_INDEX */
/*      GL_FOG_MODE */
/*      GL_FOG_START */

/* FrontFaceDirection */
#define GL_CW                             0x0900
#define GL_CCW                            0x0901

/* GetMapTarget */
#define GL_COEFF                          0x0A00
#define GL_ORDER                          0x0A01
#define GL_DOMAIN                         0x0A02

/* GetPixelMap */
/*      GL_PIXEL_MAP_I_TO_I */
/*      GL_PIXEL_MAP_S_TO_S */
/*      GL_PIXEL_MAP_I_TO_R */
/*      GL_PIXEL_MAP_I_TO_G */
/*      GL_PIXEL_MAP_I_TO_B */
/*      GL_PIXEL_MAP_I_TO_A */
/*      GL_PIXEL_MAP_R_TO_R */
/*      GL_PIXEL_MAP_G_TO_G */
/*      GL_PIXEL_MAP_B_TO_B */
/*      GL_PIXEL_MAP_A_TO_A */

/* GetPointerTarget */
/*      GL_VERTEX_ARRAY_POINTER */
/*      GL_NORMAL_ARRAY_POINTER */
/*      GL_COLOR_ARRAY_POINTER */
/*      GL_INDEX_ARRAY_POINTER */
/*      GL_TEXTURE_COORD_ARRAY_POINTER */
/*      GL_EDGE_FLAG_ARRAY_POINTER */

/* GetTarget */
#define GL_CURRENT_COLOR                  0x0B00
#define GL_CURRENT_INDEX                  0x0B01
#define GL_CURRENT_NORMAL                 0x0B02
#define GL_CURRENT_TEXTURE_COORDS         0x0B03
#define GL_CURRENT_RASTER_COLOR           0x0B04
#define GL_CURRENT_RASTER_INDEX           0x0B05
#define GL_CURRENT_RASTER_TEXTURE_COORDS  0x0B06
#define GL_CURRENT_RASTER_POSITION        0x0B07
#define GL_CURRENT_RASTER_POSITION_VALID  0x0B08
#define GL_CURRENT_RASTER_DISTANCE        0x0B09
#define GL_POINT_SMOOTH                   0x0B10
#define GL_POINT_SIZE                     0x0B11
#define GL_POINT_SIZE_RANGE               0x0B12
#define GL_POINT_SIZE_GRANULARITY         0x0B13
#define GL_LINE_SMOOTH                    0x0B20
#define GL_LINE_WIDTH                     0x0B21
#define GL_LINE_WIDTH_RANGE               0x0B22
#define GL_LINE_WIDTH_GRANULARITY         0x0B23
#define GL_LINE_STIPPLE                   0x0B24
#define GL_LINE_STIPPLE_PATTERN           0x0B25
#define GL_LINE_STIPPLE_REPEAT            0x0B26
#define GL_LIST_MODE                      0x0B30
#define GL_MAX_LIST_NESTING               0x0B31
#define GL_LIST_BASE                      0x0B32
#define GL_LIST_INDEX                     0x0B33
#define GL_POLYGON_MODE                   0x0B40
#define GL_POLYGON_SMOOTH                 0x0B41
#define GL_POLYGON_STIPPLE                0x0B42
#define GL_EDGE_FLAG                      0x0B43
#define GL_CULL_FACE                      0x0B44
#define GL_CULL_FACE_MODE                 0x0B45
#define GL_FRONT_FACE                     0x0B46
#define GL_LIGHTING                       0x0B50
#define GL_LIGHT_MODEL_LOCAL_VIEWER       0x0B51
#define GL_LIGHT_MODEL_TWO_SIDE           0x0B52
#define GL_LIGHT_MODEL_AMBIENT            0x0B53
#define GL_SHADE_MODEL                    0x0B54
#define GL_COLOR_MATERIAL_FACE            0x0B55
#define GL_COLOR_MATERIAL_PARAMETER       0x0B56
#define GL_COLOR_MATERIAL                 0x0B57
#define GL_FOG                            0x0B60
#define GL_FOG_INDEX                      0x0B61
#define GL_FOG_DENSITY                    0x0B62
#define GL_FOG_START                      0x0B63
#define GL_FOG_END                        0x0B64
#define GL_FOG_MODE                       0x0B65
#define GL_FOG_COLOR                      0x0B66
#define GL_DEPTH_RANGE                    0x0B70
#define GL_DEPTH_TEST                     0x0B71
#define GL_DEPTH_WRITEMASK                0x0B72
#define GL_DEPTH_CLEAR_VALUE              0x0B73
#define GL_DEPTH_FUNC                     0x0B74
#define GL_ACCUM_CLEAR_VALUE              0x0B80
#define GL_STENCIL_TEST                   0x0B90
#define GL_STENCIL_CLEAR_VALUE            0x0B91
#define GL_STENCIL_FUNC                   0x0B92
#define GL_STENCIL_VALUE_MASK             0x0B93
#define GL_STENCIL_FAIL                   0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL        0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS        0x0B96
#define GL_STENCIL_REF                    0x0B97
#define GL_STENCIL_WRITEMASK              0x0B98
#define GL_MATRIX_MODE                    0x0BA0
#define GL_NORMALIZE                      0x0BA1
#define GL_VIEWPORT                       0x0BA2
#define GL_MODELVIEW_STACK_DEPTH          0x0BA3
#define GL_PROJECTION_STACK_DEPTH         0x0BA4
#define GL_TEXTURE_STACK_DEPTH            0x0BA5
#define GL_MODELVIEW_MATRIX               0x0BA6
#define GL_PROJECTION_MATRIX              0x0BA7
#define GL_TEXTURE_MATRIX                 0x0BA8
#define GL_ATTRIB_STACK_DEPTH             0x0BB0
#define GL_CLIENT_ATTRIB_STACK_DEPTH      0x0BB1
#define GL_ALPHA_TEST                     0x0BC0
#define GL_ALPHA_TEST_FUNC                0x0BC1
#define GL_ALPHA_TEST_REF                 0x0BC2
#define GL_DITHER                         0x0BD0
#define GL_BLEND_DST                      0x0BE0
#define GL_BLEND_SRC                      0x0BE1
#define GL_BLEND                          0x0BE2
#define GL_LOGIC_OP_MODE                  0x0BF0
#define GL_INDEX_LOGIC_OP                 0x0BF1
#define GL_COLOR_LOGIC_OP                 0x0BF2
#define GL_AUX_BUFFERS                    0x0C00
#define GL_DRAW_BUFFER                    0x0C01
#define GL_READ_BUFFER                    0x0C02
#define GL_SCISSOR_BOX                    0x0C10
#define GL_SCISSOR_TEST                   0x0C11
#define GL_INDEX_CLEAR_VALUE              0x0C20
#define GL_INDEX_WRITEMASK                0x0C21
#define GL_COLOR_CLEAR_VALUE              0x0C22
#define GL_COLOR_WRITEMASK                0x0C23
#define GL_INDEX_MODE                     0x0C30
#define GL_RGBA_MODE                      0x0C31
#define GL_DOUBLEBUFFER                   0x0C32
#define GL_STEREO                         0x0C33
#define GL_RENDER_MODE                    0x0C40
#define GL_PERSPECTIVE_CORRECTION_HINT    0x0C50
#define GL_POINT_SMOOTH_HINT              0x0C51
#define GL_LINE_SMOOTH_HINT               0x0C52
#define GL_POLYGON_SMOOTH_HINT            0x0C53
#define GL_FOG_HINT                       0x0C54
#define GL_TEXTURE_GEN_S                  0x0C60
#define GL_TEXTURE_GEN_T                  0x0C61
#define GL_TEXTURE_GEN_R                  0x0C62
#define GL_TEXTURE_GEN_Q                  0x0C63
#define GL_PIXEL_MAP_I_TO_I               0x0C70
#define GL_PIXEL_MAP_S_TO_S               0x0C71
#define GL_PIXEL_MAP_I_TO_R               0x0C72
#define GL_PIXEL_MAP_I_TO_G               0x0C73
#define GL_PIXEL_MAP_I_TO_B               0x0C74
#define GL_PIXEL_MAP_I_TO_A               0x0C75
#define GL_PIXEL_MAP_R_TO_R               0x0C76
#define GL_PIXEL_MAP_G_TO_G               0x0C77
#define GL_PIXEL_MAP_B_TO_B               0x0C78
#define GL_PIXEL_MAP_A_TO_A               0x0C79
#define GL_PIXEL_MAP_I_TO_I_SIZE          0x0CB0
#define GL_PIXEL_MAP_S_TO_S_SIZE          0x0CB1
#define GL_PIXEL_MAP_I_TO_R_SIZE          0x0CB2
#define GL_PIXEL_MAP_I_TO_G_SIZE          0x0CB3
#define GL_PIXEL_MAP_I_TO_B_SIZE          0x0CB4
#define GL_PIXEL_MAP_I_TO_A_SIZE          0x0CB5
#define GL_PIXEL_MAP_R_TO_R_SIZE          0x0CB6
#define GL_PIXEL_MAP_G_TO_G_SIZE          0x0CB7
#define GL_PIXEL_MAP_B_TO_B_SIZE          0x0CB8
#define GL_PIXEL_MAP_A_TO_A_SIZE          0x0CB9
#define GL_UNPACK_SWAP_BYTES              0x0CF0
#define GL_UNPACK_LSB_FIRST               0x0CF1
#define GL_UNPACK_ROW_LENGTH              0x0CF2
#define GL_UNPACK_SKIP_ROWS               0x0CF3
#define GL_UNPACK_SKIP_PIXELS             0x0CF4
#define GL_UNPACK_ALIGNMENT               0x0CF5
#define GL_PACK_SWAP_BYTES                0x0D00
#define GL_PACK_LSB_FIRST                 0x0D01
#define GL_PACK_ROW_LENGTH                0x0D02
#define GL_PACK_SKIP_ROWS                 0x0D03
#define GL_PACK_SKIP_PIXELS               0x0D04
#define GL_PACK_ALIGNMENT                 0x0D05
#define GL_MAP_COLOR                      0x0D10
#define GL_MAP_STENCIL                    0x0D11
#define GL_INDEX_SHIFT                    0x0D12
#define GL_INDEX_OFFSET                   0x0D13
#define GL_RED_SCALE                      0x0D14
#define GL_RED_BIAS                       0x0D15
#define GL_ZOOM_X                         0x0D16
#define GL_ZOOM_Y                         0x0D17
#define GL_GREEN_SCALE                    0x0D18
#define GL_GREEN_BIAS                     0x0D19
#define GL_BLUE_SCALE                     0x0D1A
#define GL_BLUE_BIAS                      0x0D1B
#define GL_ALPHA_SCALE                    0x0D1C
#define GL_ALPHA_BIAS                     0x0D1D
#define GL_DEPTH_SCALE                    0x0D1E
#define GL_DEPTH_BIAS                     0x0D1F
#define GL_MAX_EVAL_ORDER                 0x0D30
#define GL_MAX_LIGHTS                     0x0D31
#define GL_MAX_CLIP_PLANES                0x0D32
#define GL_MAX_TEXTURE_SIZE               0x0D33
#define GL_MAX_PIXEL_MAP_TABLE            0x0D34
#define GL_MAX_ATTRIB_STACK_DEPTH         0x0D35
#define GL_MAX_MODELVIEW_STACK_DEPTH      0x0D36
#define GL_MAX_NAME_STACK_DEPTH           0x0D37
#define GL_MAX_PROJECTION_STACK_DEPTH     0x0D38
#define GL_MAX_TEXTURE_STACK_DEPTH        0x0D39
#define GL_MAX_VIEWPORT_DIMS              0x0D3A
#define GL_MAX_CLIENT_ATTRIB_STACK_DEPTH  0x0D3B
#define GL_SUBPIXEL_BITS                  0x0D50
#define GL_INDEX_BITS                     0x0D51
#define GL_RED_BITS                       0x0D52
#define GL_GREEN_BITS                     0x0D53
#define GL_BLUE_BITS                      0x0D54
#define GL_ALPHA_BITS                     0x0D55
#define GL_DEPTH_BITS                     0x0D56
#define GL_STENCIL_BITS                   0x0D57
#define GL_ACCUM_RED_BITS                 0x0D58
#define GL_ACCUM_GREEN_BITS               0x0D59
#define GL_ACCUM_BLUE_BITS                0x0D5A
#define GL_ACCUM_ALPHA_BITS               0x0D5B
#define GL_NAME_STACK_DEPTH               0x0D70
#define GL_AUTO_NORMAL                    0x0D80
#define GL_MAP1_COLOR_4                   0x0D90
#define GL_MAP1_INDEX                     0x0D91
#define GL_MAP1_NORMAL                    0x0D92
#define GL_MAP1_TEXTURE_COORD_1           0x0D93
#define GL_MAP1_TEXTURE_COORD_2           0x0D94
#define GL_MAP1_TEXTURE_COORD_3           0x0D95
#define GL_MAP1_TEXTURE_COORD_4           0x0D96
#define GL_MAP1_VERTEX_3                  0x0D97
#define GL_MAP1_VERTEX_4                  0x0D98
#define GL_MAP2_COLOR_4                   0x0DB0
#define GL_MAP2_INDEX                     0x0DB1
#define GL_MAP2_NORMAL                    0x0DB2
#define GL_MAP2_TEXTURE_COORD_1           0x0DB3
#define GL_MAP2_TEXTURE_COORD_2           0x0DB4
#define GL_MAP2_TEXTURE_COORD_3           0x0DB5
#define GL_MAP2_TEXTURE_COORD_4           0x0DB6
#define GL_MAP2_VERTEX_3                  0x0DB7
#define GL_MAP2_VERTEX_4                  0x0DB8
#define GL_MAP1_GRID_DOMAIN               0x0DD0
#define GL_MAP1_GRID_SEGMENTS             0x0DD1
#define GL_MAP2_GRID_DOMAIN               0x0DD2
#define GL_MAP2_GRID_SEGMENTS             0x0DD3
#define GL_TEXTURE_1D                     0x0DE0
#define GL_TEXTURE_2D                     0x0DE1
#define GL_FEEDBACK_BUFFER_POINTER        0x0DF0
#define GL_FEEDBACK_BUFFER_SIZE           0x0DF1
#define GL_FEEDBACK_BUFFER_TYPE           0x0DF2
#define GL_SELECTION_BUFFER_POINTER       0x0DF3
#define GL_SELECTION_BUFFER_SIZE          0x0DF4
/*      GL_TEXTURE_BINDING_1D */
/*      GL_TEXTURE_BINDING_2D */
/*      GL_VERTEX_ARRAY */
/*      GL_NORMAL_ARRAY */
/*      GL_COLOR_ARRAY */
/*      GL_INDEX_ARRAY */
/*      GL_TEXTURE_COORD_ARRAY */
/*      GL_EDGE_FLAG_ARRAY */
/*      GL_VERTEX_ARRAY_SIZE */
/*      GL_VERTEX_ARRAY_TYPE */
/*      GL_VERTEX_ARRAY_STRIDE */
/*      GL_NORMAL_ARRAY_TYPE */
/*      GL_NORMAL_ARRAY_STRIDE */
/*      GL_COLOR_ARRAY_SIZE */
/*      GL_COLOR_ARRAY_TYPE */
/*      GL_COLOR_ARRAY_STRIDE */
/*      GL_INDEX_ARRAY_TYPE */
/*      GL_INDEX_ARRAY_STRIDE */
/*      GL_TEXTURE_COORD_ARRAY_SIZE */
/*      GL_TEXTURE_COORD_ARRAY_TYPE */
/*      GL_TEXTURE_COORD_ARRAY_STRIDE */
/*      GL_EDGE_FLAG_ARRAY_STRIDE */
/*      GL_POLYGON_OFFSET_FACTOR */
/*      GL_POLYGON_OFFSET_UNITS */

/* GetTextureParameter */
/*      GL_TEXTURE_MAG_FILTER */
/*      GL_TEXTURE_MIN_FILTER */
/*      GL_TEXTURE_WRAP_S */
/*      GL_TEXTURE_WRAP_T */
#define GL_TEXTURE_WIDTH                  0x1000
#define GL_TEXTURE_HEIGHT                 0x1001
#define GL_TEXTURE_INTERNAL_FORMAT        0x1003
#define GL_TEXTURE_BORDER_COLOR           0x1004
#define GL_TEXTURE_BORDER                 0x1005
/*      GL_TEXTURE_RED_SIZE */
/*      GL_TEXTURE_GREEN_SIZE */
/*      GL_TEXTURE_BLUE_SIZE */
/*      GL_TEXTURE_ALPHA_SIZE */
/*      GL_TEXTURE_LUMINANCE_SIZE */
/*      GL_TEXTURE_INTENSITY_SIZE */
/*      GL_TEXTURE_PRIORITY */
/*      GL_TEXTURE_RESIDENT */

/* HintMode */
#define GL_DONT_CARE                      0x1100
#define GL_FASTEST                        0x1101
#define GL_NICEST                         0x1102

/* HintTarget */
/*      GL_PERSPECTIVE_CORRECTION_HINT */
/*      GL_POINT_SMOOTH_HINT */
/*      GL_LINE_SMOOTH_HINT */
/*      GL_POLYGON_SMOOTH_HINT */
/*      GL_FOG_HINT */
/*      GL_PHONG_HINT */

/* IndexPointerType */
/*      GL_SHORT */
/*      GL_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* LightModelParameter */
/*      GL_LIGHT_MODEL_AMBIENT */
/*      GL_LIGHT_MODEL_LOCAL_VIEWER */
/*      GL_LIGHT_MODEL_TWO_SIDE */

/* LightName */
#define GL_LIGHT0                         0x4000
#define GL_LIGHT1                         0x4001
#define GL_LIGHT2                         0x4002
#define GL_LIGHT3                         0x4003
#define GL_LIGHT4                         0x4004
#define GL_LIGHT5                         0x4005
#define GL_LIGHT6                         0x4006
#define GL_LIGHT7                         0x4007

/* LightParameter */
#define GL_AMBIENT                        0x1200
#define GL_DIFFUSE                        0x1201
#define GL_SPECULAR                       0x1202
#define GL_POSITION                       0x1203
#define GL_SPOT_DIRECTION                 0x1204
#define GL_SPOT_EXPONENT                  0x1205
#define GL_SPOT_CUTOFF                    0x1206
#define GL_CONSTANT_ATTENUATION           0x1207
#define GL_LINEAR_ATTENUATION             0x1208
#define GL_QUADRATIC_ATTENUATION          0x1209

/* InterleavedArrays */
/*      GL_V2F */
/*      GL_V3F */
/*      GL_C4UB_V2F */
/*      GL_C4UB_V3F */
/*      GL_C3F_V3F */
/*      GL_N3F_V3F */
/*      GL_C4F_N3F_V3F */
/*      GL_T2F_V3F */
/*      GL_T4F_V4F */
/*      GL_T2F_C4UB_V3F */
/*      GL_T2F_C3F_V3F */
/*      GL_T2F_N3F_V3F */
/*      GL_T2F_C4F_N3F_V3F */
/*      GL_T4F_C4F_N3F_V4F */

/* ListMode */
#define GL_COMPILE                        0x1300
#define GL_COMPILE_AND_EXECUTE            0x1301

/* ListNameType */
/*      GL_BYTE */
/*      GL_UNSIGNED_BYTE */
/*      GL_SHORT */
/*      GL_UNSIGNED_SHORT */
/*      GL_INT */
/*      GL_UNSIGNED_INT */
/*      GL_FLOAT */
/*      GL_2_BYTES */
/*      GL_3_BYTES */
/*      GL_4_BYTES */

/* LogicOp */
#define GL_CLEAR                          0x1500
#define GL_AND                            0x1501
#define GL_AND_REVERSE                    0x1502
#define GL_COPY                           0x1503
#define GL_AND_INVERTED                   0x1504
#define GL_NOOP                           0x1505
#define GL_XOR                            0x1506
#define GL_OR                             0x1507
#define GL_NOR                            0x1508
#define GL_EQUIV                          0x1509
#define GL_INVERT                         0x150A
#define GL_OR_REVERSE                     0x150B
#define GL_COPY_INVERTED                  0x150C
#define GL_OR_INVERTED                    0x150D
#define GL_NAND                           0x150E
#define GL_SET                            0x150F

/* MapTarget */
/*      GL_MAP1_COLOR_4 */
/*      GL_MAP1_INDEX */
/*      GL_MAP1_NORMAL */
/*      GL_MAP1_TEXTURE_COORD_1 */
/*      GL_MAP1_TEXTURE_COORD_2 */
/*      GL_MAP1_TEXTURE_COORD_3 */
/*      GL_MAP1_TEXTURE_COORD_4 */
/*      GL_MAP1_VERTEX_3 */
/*      GL_MAP1_VERTEX_4 */
/*      GL_MAP2_COLOR_4 */
/*      GL_MAP2_INDEX */
/*      GL_MAP2_NORMAL */
/*      GL_MAP2_TEXTURE_COORD_1 */
/*      GL_MAP2_TEXTURE_COORD_2 */
/*      GL_MAP2_TEXTURE_COORD_3 */
/*      GL_MAP2_TEXTURE_COORD_4 */
/*      GL_MAP2_VERTEX_3 */
/*      GL_MAP2_VERTEX_4 */

/* MaterialFace */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_FRONT_AND_BACK */

/* MaterialParameter */
#define GL_EMISSION                       0x1600
#define GL_SHININESS                      0x1601
#define GL_AMBIENT_AND_DIFFUSE            0x1602
#define GL_COLOR_INDEXES                  0x1603
/*      GL_AMBIENT */
/*      GL_DIFFUSE */
/*      GL_SPECULAR */

/* MatrixMode */
#define GL_MODELVIEW                      0x1700
#define GL_PROJECTION                     0x1701
#define GL_TEXTURE                        0x1702

/* MeshMode1 */
/*      GL_POINT */
/*      GL_LINE */

/* MeshMode2 */
/*      GL_POINT */
/*      GL_LINE */
/*      GL_FILL */

/* NormalPointerType */
/*      GL_BYTE */
/*      GL_SHORT */
/*      GL_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* PixelCopyType */
#define GL_COLOR                          0x1800
#define GL_DEPTH                          0x1801
#define GL_STENCIL                        0x1802

/* PixelFormat */
#define GL_COLOR_INDEX                    0x1900
#define GL_STENCIL_INDEX                  0x1901
#define GL_DEPTH_COMPONENT                0x1902
#define GL_RED                            0x1903
#define GL_GREEN                          0x1904
#define GL_BLUE                           0x1905
#define GL_ALPHA                          0x1906
#define GL_RGB                            0x1907
#define GL_RGBA                           0x1908
#define GL_LUMINANCE                      0x1909
#define GL_LUMINANCE_ALPHA                0x190A

/* PixelMap */
/*      GL_PIXEL_MAP_I_TO_I */
/*      GL_PIXEL_MAP_S_TO_S */
/*      GL_PIXEL_MAP_I_TO_R */
/*      GL_PIXEL_MAP_I_TO_G */
/*      GL_PIXEL_MAP_I_TO_B */
/*      GL_PIXEL_MAP_I_TO_A */
/*      GL_PIXEL_MAP_R_TO_R */
/*      GL_PIXEL_MAP_G_TO_G */
/*      GL_PIXEL_MAP_B_TO_B */
/*      GL_PIXEL_MAP_A_TO_A */

/* PixelStore */
/*      GL_UNPACK_SWAP_BYTES */
/*      GL_UNPACK_LSB_FIRST */
/*      GL_UNPACK_ROW_LENGTH */
/*      GL_UNPACK_SKIP_ROWS */
/*      GL_UNPACK_SKIP_PIXELS */
/*      GL_UNPACK_ALIGNMENT */
/*      GL_PACK_SWAP_BYTES */
/*      GL_PACK_LSB_FIRST */
/*      GL_PACK_ROW_LENGTH */
/*      GL_PACK_SKIP_ROWS */
/*      GL_PACK_SKIP_PIXELS */
/*      GL_PACK_ALIGNMENT */

/* PixelTransfer */
/*      GL_MAP_COLOR */
/*      GL_MAP_STENCIL */
/*      GL_INDEX_SHIFT */
/*      GL_INDEX_OFFSET */
/*      GL_RED_SCALE */
/*      GL_RED_BIAS */
/*      GL_GREEN_SCALE */
/*      GL_GREEN_BIAS */
/*      GL_BLUE_SCALE */
/*      GL_BLUE_BIAS */
/*      GL_ALPHA_SCALE */
/*      GL_ALPHA_BIAS */
/*      GL_DEPTH_SCALE */
/*      GL_DEPTH_BIAS */

/* PixelType */
#define GL_BITMAP                         0x1A00
/*      GL_BYTE */
/*      GL_UNSIGNED_BYTE */
/*      GL_SHORT */
/*      GL_UNSIGNED_SHORT */
/*      GL_INT */
/*      GL_UNSIGNED_INT */
/*      GL_FLOAT */

/* PolygonMode */
#define GL_POINT                          0x1B00
#define GL_LINE                           0x1B01
#define GL_FILL                           0x1B02

/* ReadBufferMode */
/*      GL_FRONT_LEFT */
/*      GL_FRONT_RIGHT */
/*      GL_BACK_LEFT */
/*      GL_BACK_RIGHT */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_LEFT */
/*      GL_RIGHT */
/*      GL_AUX0 */
/*      GL_AUX1 */
/*      GL_AUX2 */
/*      GL_AUX3 */

/* RenderingMode */
#define GL_RENDER                         0x1C00
#define GL_FEEDBACK                       0x1C01
#define GL_SELECT                         0x1C02

/* ShadingModel */
#define GL_FLAT                           0x1D00
#define GL_SMOOTH                         0x1D01


/* StencilFunction */
/*      GL_NEVER */
/*      GL_LESS */
/*      GL_EQUAL */
/*      GL_LEQUAL */
/*      GL_GREATER */
/*      GL_NOTEQUAL */
/*      GL_GEQUAL */
/*      GL_ALWAYS */

/* StencilOp */
/*      GL_ZERO */
#define GL_KEEP                           0x1E00
#define GL_REPLACE                        0x1E01
#define GL_INCR                           0x1E02
#define GL_DECR                           0x1E03
/*      GL_INVERT */

/* StringName */
#define GL_VENDOR                         0x1F00
#define GL_RENDERER                       0x1F01
#define GL_VERSION                        0x1F02
#define GL_EXTENSIONS                     0x1F03

/* TextureCoordName */
#define GL_S                              0x2000
#define GL_T                              0x2001
#define GL_R                              0x2002
#define GL_Q                              0x2003

/* TexCoordPointerType */
/*      GL_SHORT */
/*      GL_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* TextureEnvMode */
#define GL_MODULATE                       0x2100
#define GL_DECAL                          0x2101
/*      GL_BLEND */
/*      GL_REPLACE */

/* TextureEnvParameter */
#define GL_TEXTURE_ENV_MODE               0x2200
#define GL_TEXTURE_ENV_COLOR              0x2201

/* TextureEnvTarget */
#define GL_TEXTURE_ENV                    0x2300

/* TextureGenMode */
#define GL_EYE_LINEAR                     0x2400
#define GL_OBJECT_LINEAR                  0x2401
#define GL_SPHERE_MAP                     0x2402

/* TextureGenParameter */
#define GL_TEXTURE_GEN_MODE               0x2500
#define GL_OBJECT_PLANE                   0x2501
#define GL_EYE_PLANE                      0x2502

/* TextureMagFilter */
#define GL_NEAREST                        0x2600
#define GL_LINEAR                         0x2601

/* TextureMinFilter */
/*      GL_NEAREST */
/*      GL_LINEAR */
#define GL_NEAREST_MIPMAP_NEAREST         0x2700
#define GL_LINEAR_MIPMAP_NEAREST          0x2701
#define GL_NEAREST_MIPMAP_LINEAR          0x2702
#define GL_LINEAR_MIPMAP_LINEAR           0x2703

/* TextureParameterName */
#define GL_TEXTURE_MAG_FILTER             0x2800
#define GL_TEXTURE_MIN_FILTER             0x2801
#define GL_TEXTURE_WRAP_S                 0x2802
#define GL_TEXTURE_WRAP_T                 0x2803
/*      GL_TEXTURE_BORDER_COLOR */
/*      GL_TEXTURE_PRIORITY */

/* TextureTarget */
/*      GL_TEXTURE_1D */
/*      GL_TEXTURE_2D */
/*      GL_PROXY_TEXTURE_1D */
/*      GL_PROXY_TEXTURE_2D */

/* TextureWrapMode */
#define GL_CLAMP                          0x2900
#define GL_REPEAT                         0x2901

/* VertexPointerType */
/*      GL_SHORT */
/*      GL_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* ClientAttribMask */
#define GL_CLIENT_PIXEL_STORE_BIT         0x00000001
#define GL_CLIENT_VERTEX_ARRAY_BIT        0x00000002
#define GL_CLIENT_ALL_ATTRIB_BITS         0xffffffff

/* polygon_offset */
#define GL_POLYGON_OFFSET_FACTOR          0x8038
#define GL_POLYGON_OFFSET_UNITS           0x2A00
#define GL_POLYGON_OFFSET_POINT           0x2A01
#define GL_POLYGON_OFFSET_LINE            0x2A02
#define GL_POLYGON_OFFSET_FILL            0x8037

/* texture */
#define GL_ALPHA4                         0x803B
#define GL_ALPHA8                         0x803C
#define GL_ALPHA12                        0x803D
#define GL_ALPHA16                        0x803E
#define GL_LUMINANCE4                     0x803F
#define GL_LUMINANCE8                     0x8040
#define GL_LUMINANCE12                    0x8041
#define GL_LUMINANCE16                    0x8042
#define GL_LUMINANCE4_ALPHA4              0x8043
#define GL_LUMINANCE6_ALPHA2              0x8044
#define GL_LUMINANCE8_ALPHA8              0x8045
#define GL_LUMINANCE12_ALPHA4             0x8046
#define GL_LUMINANCE12_ALPHA12            0x8047
#define GL_LUMINANCE16_ALPHA16            0x8048
#define GL_INTENSITY                      0x8049
#define GL_INTENSITY4                     0x804A
#define GL_INTENSITY8                     0x804B
#define GL_INTENSITY12                    0x804C
#define GL_INTENSITY16                    0x804D
#define GL_R3_G3_B2                       0x2A10
#define GL_RGB4                           0x804F
#define GL_RGB5                           0x8050
#define GL_RGB8                           0x8051
#define GL_RGB10                          0x8052
#define GL_RGB12                          0x8053
#define GL_RGB16                          0x8054
#define GL_RGBA2                          0x8055
#define GL_RGBA4                          0x8056
#define GL_RGB5_A1                        0x8057
#define GL_RGBA8                          0x8058
#define GL_RGB10_A2                       0x8059
#define GL_RGBA12                         0x805A
#define GL_RGBA16                         0x805B
#define GL_TEXTURE_RED_SIZE               0x805C
#define GL_TEXTURE_GREEN_SIZE             0x805D
#define GL_TEXTURE_BLUE_SIZE              0x805E
#define GL_TEXTURE_ALPHA_SIZE             0x805F
#define GL_TEXTURE_LUMINANCE_SIZE         0x8060
#define GL_TEXTURE_INTENSITY_SIZE         0x8061
#define GL_PROXY_TEXTURE_1D               0x8063
#define GL_PROXY_TEXTURE_2D               0x8064

/* texture_object */
#define GL_TEXTURE_PRIORITY               0x8066
#define GL_TEXTURE_RESIDENT               0x8067
#define GL_TEXTURE_BINDING_1D             0x8068
#define GL_TEXTURE_BINDING_2D             0x8069

/* vertex_array */
#define GL_VERTEX_ARRAY                   0x8074
#define GL_NORMAL_ARRAY                   0x8075
#define GL_COLOR_ARRAY                    0x8076
#define GL_INDEX_ARRAY                    0x8077
#define GL_TEXTURE_COORD_ARRAY            0x8078
#define GL_EDGE_FLAG_ARRAY                0x8079
#define GL_VERTEX_ARRAY_SIZE              0x807A
#define GL_VERTEX_ARRAY_TYPE              0x807B
#define GL_VERTEX_ARRAY_STRIDE            0x807C
#define GL_NORMAL_ARRAY_TYPE              0x807E
#define GL_NORMAL_ARRAY_STRIDE            0x807F
#define GL_COLOR_ARRAY_SIZE               0x8081
#define GL_COLOR_ARRAY_TYPE               0x8082
#define GL_COLOR_ARRAY_STRIDE             0x8083
#define GL_INDEX_ARRAY_TYPE               0x8085
#define GL_INDEX_ARRAY_STRIDE             0x8086
#define GL_TEXTURE_COORD_ARRAY_SIZE       0x8088
#define GL_TEXTURE_COORD_ARRAY_TYPE       0x8089
#define GL_TEXTURE_COORD_ARRAY_STRIDE     0x808A
#define GL_EDGE_FLAG_ARRAY_STRIDE         0x808C
#define GL_VERTEX_ARRAY_POINTER           0x808E
#define GL_NORMAL_ARRAY_POINTER           0x808F
#define GL_COLOR_ARRAY_POINTER            0x8090
#define GL_INDEX_ARRAY_POINTER            0x8091
#define GL_TEXTURE_COORD_ARRAY_POINTER    0x8092
#define GL_EDGE_FLAG_ARRAY_POINTER        0x8093
#define GL_V2F                            0x2A20
#define GL_V3F                            0x2A21
#define GL_C4UB_V2F                       0x2A22
#define GL_C4UB_V3F                       0x2A23
#define GL_C3F_V3F                        0x2A24
#define GL_N3F_V3F                        0x2A25
#define GL_C4F_N3F_V3F                    0x2A26
#define GL_T2F_V3F                        0x2A27
#define GL_T4F_V4F                        0x2A28
#define GL_T2F_C4UB_V3F                   0x2A29
#define GL_T2F_C3F_V3F                    0x2A2A
#define GL_T2F_N3F_V3F                    0x2A2B
#define GL_T2F_C4F_N3F_V3F                0x2A2C
#define GL_T4F_C4F_N3F_V4F                0x2A2D


/*
** OpenGL 1.3 extensions
**
** Additional extensions (c) Copyright 1998 S3 Incorporated.
** Additional extensions (c) Copyright 2001 NVidia Corp.
** Additional extensions (c) Copyright 2000 3Dfx Interactive.
** Additional extensions (c) Copyright 2001-2002 ATI Incorporated.
**
*/

/*****************************************************************************************************
**	GLX EXTENSIONS
*****************************************************************************************************/
#if defined __linux__

#ifndef GLX_ARB_get_proc_address
#define GLX_ARB_get_proc_address 1

typedef void * (*APIENTRY PFNGLXGETPROCADDRESSARB)(const GLubyte *procName);

#endif
#endif


/*****************************************************************************************************
**	WGL EXTENSIONS
*****************************************************************************************************/

#if (defined(_WIN32) || defined(__WIN32__))
/*
** WGL_ARB_pixel_format
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/
#ifndef WGL_ARB_pixel_format
#define WGL_ARB_pixel_format 1

#define WGL_NUMBER_PIXEL_FORMATS_ARB		0x2000
#define WGL_DRAW_TO_WINDOW_ARB				0x2001
#define WGL_DRAW_TO_BITMAP_ARB				0x2002
#define WGL_ACCELERATION_ARB				0x2003
#define WGL_NEED_PALETTE_ARB				0x2004
#define WGL_NEED_SYSTEM_PALETTE_ARB 		0x2005
#define WGL_SWAP_LAYER_BUFFERS_ARB			0x2006
#define WGL_SWAP_METHOD_ARB 				0x2007
#define WGL_NUMBER_OVERLAYS_ARB 			0x2008
#define WGL_NUMBER_UNDERLAYS_ARB			0x2009
#define WGL_TRANSPARENT_ARB 				0x200A
#define WGL_TRANSPARENT_RED_VALUE_ARB		0x2037
#define WGL_TRANSPARENT_GREEN_VALUE_ARB 	0x2038
#define WGL_TRANSPARENT_BLUE_VALUE_ARB		0x2039
#define WGL_TRANSPARENT_ALPHA_VALUE_ARB 	0x203A
#define WGL_TRANSPARENT_INDEX_VALUE_ARB 	0x203B
#define WGL_SHARE_DEPTH_ARB 				0x200C
#define WGL_SHARE_STENCIL_ARB				0x200D
#define WGL_SHARE_ACCUM_ARB 				0x200E
#define WGL_SUPPORT_GDI_ARB 				0x200F
#define WGL_SUPPORT_OPENGL_ARB				0x2010
#define WGL_DOUBLE_BUFFER_ARB				0x2011
#define WGL_STEREO_ARB						0x2012
#define WGL_PIXEL_TYPE_ARB					0x2013
#define WGL_COLOR_BITS_ARB					0x2014
#define WGL_RED_BITS_ARB					0x2015
#define WGL_RED_SHIFT_ARB					0x2016
#define WGL_GREEN_BITS_ARB					0x2017
#define WGL_GREEN_SHIFT_ARB 				0x2018
#define WGL_BLUE_BITS_ARB					0x2019
#define WGL_BLUE_SHIFT_ARB					0x201A
#define WGL_ALPHA_BITS_ARB					0x201B
#define WGL_ALPHA_SHIFT_ARB 				0x201C
#define WGL_ACCUM_BITS_ARB					0x201D
#define WGL_ACCUM_RED_BITS_ARB				0x201E
#define WGL_ACCUM_GREEN_BITS_ARB			0x201F
#define WGL_ACCUM_BLUE_BITS_ARB 			0x2020
#define WGL_ACCUM_ALPHA_BITS_ARB			0x2021
#define WGL_DEPTH_BITS_ARB					0x2022
#define WGL_STENCIL_BITS_ARB				0x2023
#define WGL_AUX_BUFFERS_ARB 				0x2024
#define WGL_NO_ACCELERATION_ARB 			0x2025
#define WGL_GENERIC_ACCELERATION_ARB		0x2026
#define WGL_FULL_ACCELERATION_ARB			0x2027
#define WGL_SWAP_EXCHANGE_ARB				0x2028
#define WGL_SWAP_COPY_ARB					0x2029
#define WGL_SWAP_UNDEFINED_ARB				0x202A
#define WGL_TYPE_RGBA_ARB					0x202B
#define WGL_TYPE_COLORINDEX_ARB 			0x202C


typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBIVARBPROC)(
										HDC hDC,
										int iPixelFormat,
										int iLayerPlane,
										UINT nAttributes,
										const int *piAttributes,
										int *piValues);
typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBFVARBPROC)(
										HDC hDC,
										int iPixelFormat,
										int iLayerPlane,
										UINT nAttributes,
										const int *piAttributes,
										FLOAT *pfValues);
typedef BOOL (WINAPI * PFNWGLCHOOSEPIXELFORMATARBPROC)(
										HDC hDC,
										const int *piAttribIList,
										const FLOAT *pfAttribFList,
										UINT nMaxFormats,
										int *piFormats,
										UINT *nNumFormats);

#endif /* WGL_ARB_pixel_format */

#ifndef WGL_ARB_extensions_string
#define WGL_ARB_extensions_string 1
typedef const char * (WINAPI * PFNWGLGETEXTENSIONSSTRINGARBPROC)(HDC hdc);
#endif

/*
** WGL_ARB_make_current_read
**
**  Support:
**   Rage 128 * based : Supported
**   Radeon   * based : Supported
*/
#ifndef WGL_ARB_make_current_read
typedef BOOL (WINAPI * PFNWGLMAKECONTEXTCURRENTARBPROC)(
#define WGL_ARB_make_current_read 1
                                        HDC hDrawDC,
                                        HDC hReadDC,
                                        HGLRC hGLRC);
typedef HDC (WINAPI * PFNWGLGETCURRENTREADDCARBPROC)(VOID);

#endif /* WGL_ARB_make_current_read */

/*
** WGL_ARB_pbuffer
**
**  Support:
**   Rage 128 * based : Supported
**   Radeon   * based : Supported
*/
#ifndef WGL_ARB_pbuffer
#define WGL_ARB_pbuffer 1

#define WGL_DRAW_TO_PBUFFER_ARB              0x202D
#define WGL_MAX_PBUFFER_PIXELS_ARB           0x202E
#define WGL_MAX_PBUFFER_WIDTH_ARB            0x202F
#define WGL_MAX_PBUFFER_HEIGHT_ARB           0x2030
#define WGL_PBUFFER_LARGEST_ARB              0x2033
#define WGL_PBUFFER_WIDTH_ARB                0x2034
#define WGL_PBUFFER_HEIGHT_ARB               0x2035
#define WGL_PBUFFER_LOST_ARB				 0x2036

DECLARE_HANDLE(HPBUFFERARB);

typedef HPBUFFERARB (WINAPI * PFNWGLCREATEPBUFFERARBPROC)(
                                        HDC hDC,
                                        int iPixelFormat,
                                        int iWidth,
                                        int iHeight,
                                        const int *piAttribList);
typedef HDC (WINAPI * PFNWGLGETPBUFFERDCARBPROC)(HPBUFFERARB hPbuffer);
typedef int (WINAPI * PFNWGLRELEASEPBUFFERDCARBPROC)(
                                        HPBUFFERARB hPbuffer,
                                        HDC hDC);
typedef BOOL (WINAPI * PFNWGLDESTROYPBUFFERARBPROC)(HPBUFFERARB hPbuffer);
typedef BOOL (WINAPI * PFNWGLQUERYPBUFFERARBPROC)(
                                        HPBUFFERARB hPbuffer,
                                        int iAttribute,
                                        int *piValue);
#endif /* WGL_ARB_pbuffer */


/*
** WGL_ARB_render_texture
**
**  Support:
**   Rage 128 * based : Supported
**   Radeon   * based : Supported
*/
#ifndef WGL_ARB_render_texture
#define WGL_ARB_render_texture 1

#define WGL_BIND_TO_TEXTURE_RGB_ARB			0x2070
#define WGL_BIND_TO_TEXTURE_RGBA_ARB		0x2071
#define WGL_TEXTURE_FORMAT_ARB				0x2072
#define WGL_TEXTURE_TARGET_ARB				0x2073
#define WGL_MIPMAP_TEXTURE_ARB				0x2074
#define WGL_TEXTURE_RGB_ARB					0x2075
#define WGL_TEXTURE_RGBA_ARB				0x2076
#define WGL_NO_TEXTURE_ARB					0x2077
#define WGL_TEXTURE_CUBE_MAP_ARB			0x2078
#define WGL_TEXTURE_1D_ARB					0x2079
#define WGL_TEXTURE_2D_ARB					0x207A
#define WGL_MIPMAP_LEVEL_ARB				0x207B
#define WGL_CUBE_MAP_FACE_ARB				0x207C
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB	0x207D
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB 0x207E
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB	0x207F
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB 0x2080
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB	0x2081
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB 0x2082
#define WGL_FRONT_LEFT_ARB					0x2083
#define WGL_FRONT_RIGHT_ARB					0x2084
#define WGL_BACK_LEFT_ARB					0x2085
#define WGL_BACK_RIGHT_ARB					0x2086
#define WGL_AUX0_ARB						0x2087
#define WGL_AUX1_ARB						0x2088
#define WGL_AUX2_ARB						0x2089
#define WGL_AUX3_ARB						0x208A
#define WGL_AUX4_ARB						0x208B
#define WGL_AUX5_ARB						0x208C
#define WGL_AUX6_ARB						0x208D
#define WGL_AUX7_ARB						0x208E
#define WGL_AUX8_ARB						0x208F
#define WGL_AUX9_ARB						0x2090

typedef BOOL (WINAPI * PFNWGLBINDTEXIMAGEARBPROC)(HPBUFFERARB hPbuffer, int iBuffer,
												  const int *piAttribList);
typedef BOOL (WINAPI * PFNWGLRELEASETEXIMAGEARBPROC)(HPBUFFERARB hPbuffer, int iBuffer);
typedef BOOL (WINAPI * PFNWGLSETPBUFFERATTRIBARBPROC)(HPBUFFERARB hPbuffer, 
													   const int *piAttribList);
#endif


/*****************************************************************************************************
**	EXT EXTENSIONS
*****************************************************************************************************/

/*
** WGL_EXT_extensions_string
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/
#ifndef WGL_EXT_extensions_string
#define WGL_EXT_extensions_string 1

typedef const char * (WINAPI * PFNWGLGETEXTENSIONSSTRINGEXTPROC)(VOID);

#endif /* WGL_EXT_extensions_string */

/*
** WGL_EXT_pixel_format
**
**	Support:
**	 Geforce2 or + : Supported
*/	
#ifndef WGL_EXT_pixel_format
#define WGL_EXT_pixel_format	1

#define WGL_NUMBER_PIXEL_FORMATS_EXT		 0x2000
#define WGL_DRAW_TO_WINDOW_EXT				 0x2001
#define WGL_DRAW_TO_BITMAP_EXT				 0x2002
#define WGL_ACCELERATION_EXT				 0x2003
#define WGL_NEED_PALETTE_EXT				 0x2004
#define WGL_NEED_SYSTEM_PALETTE_EXT 		 0x2005
#define WGL_SWAP_LAYER_BUFFERS_EXT			 0x2006
#define WGL_SWAP_METHOD_EXT 				 0x2007
#define WGL_NUMBER_OVERLAYS_EXT 			 0x2008
#define WGL_NUMBER_UNDERLAYS_EXT			 0x2009
#define WGL_TRANSPARENT_EXT 				 0x200A
#define WGL_TRANSPARENT_VALUE_EXT			 0x200B
#define WGL_SHARE_DEPTH_EXT 				 0x200C
#define WGL_SHARE_STENCIL_EXT				 0x200D
#define WGL_SHARE_ACCUM_EXT 				 0x200E
#define WGL_SUPPORT_GDI_EXT 				 0x200F
#define WGL_SUPPORT_OPENGL_EXT				 0x2010
#define WGL_DOUBLE_BUFFER_EXT				 0x2011
#define WGL_STEREO_EXT						 0x2012
#define WGL_PIXEL_TYPE_EXT					 0x2013
#define WGL_COLOR_BITS_EXT					 0x2014
#define WGL_RED_BITS_EXT					 0x2015
#define WGL_RED_SHIFT_EXT					 0x2016
#define WGL_GREEN_BITS_EXT					 0x2017
#define WGL_GREEN_SHIFT_EXT 				 0x2018
#define WGL_BLUE_BITS_EXT					 0x2019
#define WGL_BLUE_SHIFT_EXT					 0x201A
#define WGL_ALPHA_BITS_EXT					 0x201B
#define WGL_ALPHA_SHIFT_EXT 				 0x201C
#define WGL_ACCUM_BITS_EXT					 0x201D
#define WGL_ACCUM_RED_BITS_EXT				 0x201E
#define WGL_ACCUM_GREEN_BITS_EXT			 0x201F
#define WGL_ACCUM_BLUE_BITS_EXT 			 0x2020
#define WGL_ACCUM_ALPHA_BITS_EXT			 0x2021
#define WGL_DEPTH_BITS_EXT					 0x2022
#define WGL_STENCIL_BITS_EXT				 0x2023
#define WGL_AUX_BUFFERS_EXT 				 0x2024
#define WGL_NO_ACCELERATION_EXT 			 0x2025
#define WGL_GENERIC_ACCELERATION_EXT		 0x2026
#define WGL_FULL_ACCELERATION_EXT			 0x2027
#define WGL_SWAP_EXCHANGE_EXT				 0x2028
#define WGL_SWAP_COPY_EXT					 0x2029
#define WGL_SWAP_UNDEFINED_EXT				 0x202A
#define WGL_TYPE_RGBA_EXT					 0x202B
#define WGL_TYPE_COLORINDEX_EXT 			 0x202C

typedef BOOL (APIENTRY * PFNWGLGETPIXELFORMATATTRIBIVEXT)(
HDC hdc, GLint iPixelFormat,GLint iLayerPlane, UINT nAttributes,GLint *piAttributes,GLint *piValues);

typedef BOOL (APIENTRY * PFNWGLGETPIXELFORMATATTRIBFVEXT)(
HDC hdc, GLint iPixelFormat,GLint iLayerPlane, UINT nAttributes,GLint *piAttributes,FLOAT *pfValues);

typedef BOOL (APIENTRY * PFNWGLCHOOSEPIXELFORMATEXT)(
HDC hdc, const GLint *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, GLint *piFormats, UINT *nNumFormats);

#endif // WGL_EXT_pixel_format


/*
** WGL_EXT_pbuffer
**
**	Support:
**	 Geforce2 or + : Supported
*/	

#ifndef WGL_EXT_pbuffer
#define WGL_EXT_pbuffer 1

#define WGL_DRAW_TO_PBUFFER_EXT 		  0x202D
#define WGL_MAX_PBUFFER_PIXELS_EXT		  0x202E
#define WGL_MAX_PBUFFER_WIDTH_EXT		  0x202F
#define WGL_MAX_PBUFFER_HEIGHT_EXT		  0x2030
#define WGL_OPTIMAL_PBUFFER_WIDTH_EXT	  0x2031
#define WGL_OPTIMAL_PBUFFER_HEIGHT_EXT	  0x2032
#define WGL_PBUFFER_LARGEST_EXT 		  0x2033
#define WGL_PBUFFER_WIDTH_EXT			  0x2034
#define WGL_PBUFFER_HEIGHT_EXT			  0x2035

typedef void * HPBUFFEREXT;
typedef HPBUFFEREXT (APIENTRY *PFNWGLCREATEPBUFFEREXT)(HDC hDC, GLint iPixelFormat, GLint iWidth, GLint iHeight, const GLint *piAttribList);
typedef HDC (APIENTRY *PFNWGLGETPBUFFERDCEXT)(HPBUFFEREXT hPbuffer);
typedef GLint (APIENTRY *PFWGLRELEASEPBUFFERDCEXT)(HPBUFFEREXT hPbuffer, HDC hDC);
typedef BOOL(APIENTRY *PFWGLDESTROYPBUFFEREXT)(HPBUFFEREXT hPbuffer);
typedef BOOL(APIENTRY *PFWGLQUERYPBUFFEREXT)(HPBUFFEREXT hPbuffer, GLint iAttribute, GLint *piValue);

#endif 


/*
** WGL_EXT_swap_control
**
**	Support:
**	 Geforce2 or + : Supported
*/	

#ifndef WGL_EXT_swap_control
#define WGL_EXT_swap_control 1

typedef GLint (APIENTRY * PFNWGLSWAPINTERVALEXTPROC)(GLint);
typedef GLint (APIENTRY * PFNWGLGETSWAPINTERVALEXTPROC)(void);

#endif


/*
** GL_WIN_swap_hint
**
**	Support:
**	 Geforce2 or + : Supported
*/	

#ifndef GL_WIN_swap_hint
#define GL_WIN_swap_hint 1
typedef void (APIENTRY * PFNGLADDSWAPHINTRECTWINPROC)(GLint x, GLint y, GLsizei width, GLsizei height);
#endif

#endif // _WIN32


#ifndef GL_EXT_texture_edge_clamp
#define GL_EXT_texture_edge_clamp				1
#define GL_CLAMP_TO_EDGE_EXT					0x812F
#endif

/*
** GL_EXT_cull_vertex
**
**	Support:
**	 Geforce2 or + : Supported
*/	 

#ifndef GL_EXT_cull_vertex
#define GL_EXT_cull_vertex	1

#define GL_CULL_VERTEX_EXT						0x81AA
#define GL_CULL_VERTEX_EYE_POSITION_EXT 		0x81AB
#define GL_CULL_VERTEX_OBJECT_POSITION_EXT		0x81AC

typedef void (APIENTRY * PFNGLCULLPARAMETERDVEXTPROC)(GLenum pname, GLdouble* params);
typedef void (APIENTRY * PFNGLCULLPARAMETERFVEXTPROC)(GLenum pname, GLfloat* params);

#endif

/*
** GL_EXT_point_parameter
**
**	Support:
**	 Geforce2 or + : Supported
*/	 

#ifndef GL_EXT_point_parameter
#define GL_EXT_point_parameter	1

#define GL_POINT_SIZE_MIN_EXT					0x8126
#define GL_POINT_SIZE_MAX_EXT					0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE_EXT		0x8128
#define GL_DISTANCE_ATTENUATION_EXT 			0x8129

typedef void (APIENTRY * PFNGLPOINTPARAMETERFEXTPROC)(GLenum pname, GLfloat param);
typedef void (APIENTRY * PFNGLPOINTPARAMETERFVEXTPROC)(GLenum pname, const GLfloat *params);

#endif

/*
** GL_EXT_separate_specular_color
**
**	Support:
**	 Geforce2 or + : Supported
*/	 
#ifndef GL_EXT_separate_specular_color
#define GL_EXT_separate_specular_color	1

#define GL_CURRENT_SECONDARY_COLOR_EXT			0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT		0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EX		0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT 	0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT	0x845D
#define GL_SECONDARY_COLOR_ARRAY_EXT			0x845E
#define GL_LIGHT_MODEL_COLOR_CONTROL			0x81F8
#define GL_SINGLE_COLOR 						0x81F9
#define GL_SEPARATE_SPECULAR_COLOR				0x81FA

typedef void (APIENTRY * PFNGLSECONDARYCOLOR3BEXTPROC)(GLbyte red, GLbyte green, GLbyte blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3SEXTPROC)(GLshort red, GLshort green, GLshort blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3IEXTPROC)(GLint red, GLint green, GLint blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3FEXTPROC)(GLfloat red, GLfloat green, GLfloat blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3DEXTPROC)(GLdouble red, GLdouble green, GLdouble blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3UBEXTPROC)(GLubyte red, GLubyte green, GLubyte blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3USEXTPROC)(GLushort red, GLushort green, GLushort blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3UIEXTPROC)(GLuint red, GLuint green, GLuint blue);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3BVEXTPROC)(const GLbyte *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3SVEXTPROC)(const GLshort *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3IVEXTPROC)(const GLint *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3FVEXTPROC)(const GLfloat *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3DVEXTPROC)(const GLdouble *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3UBVEXTPROC)(const GLubyte *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3USVEXTPROC)(const GLushort *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLOR3UIVEXTPROC)(const GLuint *v);
typedef void (APIENTRY * PFNGLSECONDARYCOLORPOINTEREXTPROC)(GLint size, GLenum type, GLsizei stride, GLvoid *pointer);

#endif


/*
** GL_EXT_paletted_texture
**
**	Support:
**	 Geforce2 or + : Supported
*/	 

#ifndef GL_EXT_paletted_texture
#define GL_EXT_paletted_texture 	1

typedef void (APIENTRY * PFNGLCOLORTABLEEXTPROC)(GLenum target, GLenum internalFormat, GLsizei width, GLenum format,GLenum type, const GLvoid *data);
#endif


// GL_EXT_color_sum
#define GL_COLOR_SUM_EXT						0x8458

// GL_EXT_clip_volume_hint
#define GL_CLIP_VOLUME_CLIPPING_HINT_EXT		0x80F0


/*
** GL_EXT_fog_coord
**
**	Support:
**	 Geforce2 or + : Supported
*/	 
#ifndef GL_EXT_fog_coord
#define GL_EXT_fog_coord	1

#define GL_FOG_COORDINATE_SOURCE_EXT			 0x8450
#define GL_FOG_COORDINATE_EXT					 0x8451
#define GL_FRAGMENT_DEPTH_EXT					 0x8452
#define GL_CURRENT_FOG_COORDINATE_EXT			 0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT		 0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT		 0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT		 0x8456
#define GL_FOG_COORDINATE_ARRAY_EXT				 0x8457

typedef void (APIENTRY * PFNGLFOGCOORDFEXTPROC)(GLfloat coord);
typedef void (APIENTRY * PFNGLFOGCOORDFVEXTPROC)(const GLfloat *coord);
typedef void (APIENTRY * PFNGLFOGCOORDDEXTPROC)(GLdouble coord);
typedef void (APIENTRY * PFNGLFOGCOORDDVEXTPROC)(const GLdouble *coord);
typedef void (APIENTRY * PFNGLFOGCOORDPOINTEREXTPROC)(GLenum type, GLsizei stride, const GLvoid *pointer);

#endif


/*
** GL_EXT_vertex_array
**
**	Support:
**	 Geforce2 or + : Supported
*/	 
#ifndef GL_EXT_vertex_array 
#define GL_EXT_vertex_array 1

#define GL_VERTEX_ARRAY_EXT 					0x8074
#define GL_NORMAL_ARRAY_EXT 					0x8075
#define GL_COLOR_ARRAY_EXT						0x8076
#define GL_INDEX_ARRAY_EXT						0x8077
#define GL_TEXTURE_COORD_ARRAY_EXT				0x8078
#define GL_EDGE_FLAG_ARRAY_EXT					0x8079
#define GL_VERTEX_ARRAY_SIZE_EXT				0x807A
#define GL_VERTEX_ARRAY_TYPE_EXT				0x807B
#define GL_VERTEX_ARRAY_STRIDE_EXT				0x807C
#define GL_VERTEX_ARRAY_COUNT_EXT				0x807D
#define GL_NORMAL_ARRAY_TYPE_EXT				0x807E
#define GL_NORMAL_ARRAY_STRIDE_EXT				0x807F
#define GL_NORMAL_ARRAY_COUNT_EXT				0x8080
#define GL_COLOR_ARRAY_SIZE_EXT 				0x8081
#define GL_COLOR_ARRAY_TYPE_EXT 				0x8082
#define GL_COLOR_ARRAY_STRIDE_EXT				0x8083
#define GL_COLOR_ARRAY_COUNT_EXT				0x8084
#define GL_INDEX_ARRAY_TYPE_EXT 				0x8085
#define GL_INDEX_ARRAY_STRIDE_EXT				0x8086
#define GL_INDEX_ARRAY_COUNT_EXT				0x8087
#define GL_TEXTURE_COORD_ARRAY_SIZE_EXT 		0x8088
#define GL_TEXTURE_COORD_ARRAY_TYPE_EXT 		0x8089
#define GL_TEXTURE_COORD_ARRAY_STRIDE_EXT		0x808A
#define GL_TEXTURE_COORD_ARRAY_COUNT_EXT		0x808B
#define GL_EDGE_FLAG_ARRAY_STRIDE_EXT			0x808C
#define GL_EDGE_FLAG_ARRAY_COUNT_EXT			0x808D
#define GL_VERTEX_ARRAY_POINTER_EXT 			0x808E
#define GL_NORMAL_ARRAY_POINTER_EXT 			0x808F
#define GL_COLOR_ARRAY_POINTER_EXT				0x8090
#define GL_INDEX_ARRAY_POINTER_EXT				0x8091
#define GL_TEXTURE_COORD_ARRAY_POINTER_EXT		0x8092
#define GL_EDGE_FLAG_ARRAY_POINTER_EXT			0x8093

typedef void (APIENTRY * PFNGLARRAYELEMENTEXTPROC)(GLint i);
typedef void (APIENTRY * PFNGLCOLORPOINTEREXTPROC)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLDRAWARRAYSEXTPROC)(GLenum mode, GLint first, GLsizei count);
typedef void (APIENTRY * PFNGLEDGEFLAGPOINTEREXTPROC)(GLsizei stride, GLsizei count, const GLboolean *pointer);
typedef void (APIENTRY * PFNGLGETPOINTERVEXTPROC)(GLenum pname, GLvoid* *params);
typedef void (APIENTRY * PFNGLINDEXPOINTEREXTPROC)(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLNORMALPOINTEREXTPROC)(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLTEXCOORDPOINTEREXTPROC)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLVERTEXPOINTEREXTPROC)(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

#endif

/*
** GL_EXT_compiled_vertex_array
**
**	Support:
**	 Geforce2 or + : Supported
*/	 

#ifndef GL_VERSION_1_2
#ifndef GL_EXT_compiled_vertex_array
#define GL_EXT_compiled_vertex_array 1

#define GL_ARRAY_ELEMENT_LOCK_FIRST_EXT 		0x81A8
#define GL_ARRAY_ELEMENT_LOCK_COUNT_EXT 		0x81A9

typedef void (APIENTRY * PFNGLLOCKARRAYSEXTPROC)(GLint first, GLsizei count);
typedef void (APIENTRY * PFNGLUNLOCKARRAYSEXTPROC)(void);

#endif // GL_EXT_compiled_vertex_array
#endif // GL_VERSION_1_2

/*
** GL_EXT_draw_range_elements
**
**	Support:
**	 Geforce2 or + : Supported
*/	 

#ifndef  GL_EXT_draw_range_elements
#define  GL_EXT_draw_range_elements 1

typedef void *(APIENTRY * PFNGLDRAWRANGEELEMENTSEXTPROC)( GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);

#endif


/*
** GL_EXT_vertex_weighting
**
**	Support:
**	 Geforce2 or + : Supported
*/	  

#ifndef GL_EXT_vertex_weighting 
#define GL_EXT_vertex_weighting 1

#define GL_VERTEX_WEIGHTING_EXT 				 0x8509
												
#define GL_MODELVIEW0_EXT						 0x1700
#define GL_MODELVIEW1_EXT						 0x850a
												
#define GL_CURRENT_VERTEX_WEIGHT_EXT			 0x850b
#define GL_VERTEX_WEIGHT_ARRAY_EXT				 0x850c
#define GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT 		 0x850d
#define GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT 		 0x850e
#define GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT		 0x850f
#define GL_MODELVIEW0_STACK_DEPTH_EXT			 0x0BA3
#define GL_MODELVIEW1_STACK_DEPTH_EXT			 0x8502
#define GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT		 0x8510

typedef void (APIENTRY *PFNGLVERTEXWEIGHTFEXTPROC)(float weight);
typedef void (APIENTRY *PFNGLVERTEXWEIGHTFVEXTPROC)(float *weight);
typedef void (APIENTRY *PFNGLVERTEXWEIGHTPOINTEREXTPROC)(GLint size, enum type, GLsizei stride, void *pointer);

#endif

/* EXT_abgr */
#define GL_ABGR_EXT 							0x8000
												
/* EXT_bgra */									
#define GL_BGR_EXT								0x80E0
#define GL_BGRA_EXT 							0x80E1
												
/* EXT_shared_texture_palette */				
#define GL_SHARED_TEXTURE_PALETTE_EXT			0x81FB
												
/* GL_EXT_packed_pixels */							
#ifndef GL_EXT_packed_pixels
#define GL_EXT_packed_pixels 1

#define GL_UNSIGNED_BYTE_3_3_2_EXT				0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4_EXT			0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1_EXT			0x8034
#define GL_UNSIGNED_INT_8_8_8_8_EXT 			0x8035
#define GL_UNSIGNED_INT_10_10_10_2_EXT			0x8036

#endif
											
												
/* EXT_clip_volume_hint */						
#define GL_CLIP_VOLUME_CLIPPING_HINT_EXT		0x80F0
												
/* EXT_stencil_wrap */							
#define GL_INCR_WRAP_EXT						0x8507
#define GL_DECR_WRAP_EXT						0x8508
												

/* EXT_texture_filter_anisotropic */
#ifndef GL_EXT_texture_filter_anisotropic
#define GL_EXT_texture_filter_anisotropic	1

#define GL_TEXTURE_MAX_ANISOTROPY_EXT			0x84fe	  
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT		0x84ff

#endif

/*
** GL_EXT_vertex_shader
**
**	Support:
**	 Rage 128 * based : Supported (software)
**	 Radeon   * based : Supported (software)
**	 R200	  * based : Supported
*/
#ifndef GL_EXT_vertex_shader
#define GL_EXT_vertex_shader 1

#define GL_VERTEX_SHADER_EXT								0x8780
#define GL_VERTEX_SHADER_BINDING_EXT						0x8781
#define GL_OP_INDEX_EXT 									0x8782
#define GL_OP_NEGATE_EXT									0x8783
#define GL_OP_DOT3_EXT										0x8784
#define GL_OP_DOT4_EXT										0x8785
#define GL_OP_MUL_EXT										0x8786
#define GL_OP_ADD_EXT										0x8787
#define GL_OP_MADD_EXT										0x8788
#define GL_OP_FRAC_EXT										0x8789
#define GL_OP_MAX_EXT										0x878A
#define GL_OP_MIN_EXT										0x878B
#define GL_OP_SET_GE_EXT									0x878C
#define GL_OP_SET_LT_EXT									0x878D
#define GL_OP_CLAMP_EXT 									0x878E
#define GL_OP_FLOOR_EXT 									0x878F
#define GL_OP_ROUND_EXT 									0x8790
#define GL_OP_EXP_BASE_2_EXT								0x8791
#define GL_OP_LOG_BASE_2_EXT								0x8792
#define GL_OP_POWER_EXT 									0x8793
#define GL_OP_RECIP_EXT 									0x8794
#define GL_OP_RECIP_SQRT_EXT								0x8795
#define GL_OP_SUB_EXT										0x8796
#define GL_OP_CROSS_PRODUCT_EXT 							0x8797
#define GL_OP_MULTIPLY_MATRIX_EXT							0x8798
#define GL_OP_MOV_EXT										0x8799
#define GL_OUTPUT_VERTEX_EXT								0x879A
#define GL_OUTPUT_COLOR0_EXT								0x879B
#define GL_OUTPUT_COLOR1_EXT								0x879C
#define GL_OUTPUT_TEXTURE_COORD0_EXT						0x879D
#define GL_OUTPUT_TEXTURE_COORD1_EXT						0x879E
#define GL_OUTPUT_TEXTURE_COORD2_EXT						0x879F
#define GL_OUTPUT_TEXTURE_COORD3_EXT						0x87A0
#define GL_OUTPUT_TEXTURE_COORD4_EXT						0x87A1
#define GL_OUTPUT_TEXTURE_COORD5_EXT						0x87A2
#define GL_OUTPUT_TEXTURE_COORD6_EXT						0x87A3
#define GL_OUTPUT_TEXTURE_COORD7_EXT						0x87A4
#define GL_OUTPUT_TEXTURE_COORD8_EXT						0x87A5
#define GL_OUTPUT_TEXTURE_COORD9_EXT						0x87A6
#define GL_OUTPUT_TEXTURE_COORD10_EXT						0x87A7
#define GL_OUTPUT_TEXTURE_COORD11_EXT						0x87A8
#define GL_OUTPUT_TEXTURE_COORD12_EXT						0x87A9
#define GL_OUTPUT_TEXTURE_COORD13_EXT						0x87AA
#define GL_OUTPUT_TEXTURE_COORD14_EXT						0x87AB
#define GL_OUTPUT_TEXTURE_COORD15_EXT						0x87AC
#define GL_OUTPUT_TEXTURE_COORD16_EXT						0x87AD
#define GL_OUTPUT_TEXTURE_COORD17_EXT						0x87AE
#define GL_OUTPUT_TEXTURE_COORD18_EXT						0x87AF
#define GL_OUTPUT_TEXTURE_COORD19_EXT						0x87B0
#define GL_OUTPUT_TEXTURE_COORD20_EXT						0x87B1
#define GL_OUTPUT_TEXTURE_COORD21_EXT						0x87B2
#define GL_OUTPUT_TEXTURE_COORD22_EXT						0x87B3
#define GL_OUTPUT_TEXTURE_COORD23_EXT						0x87B4
#define GL_OUTPUT_TEXTURE_COORD24_EXT						0x87B5
#define GL_OUTPUT_TEXTURE_COORD25_EXT						0x87B6
#define GL_OUTPUT_TEXTURE_COORD26_EXT						0x87B7
#define GL_OUTPUT_TEXTURE_COORD27_EXT						0x87B8
#define GL_OUTPUT_TEXTURE_COORD28_EXT						0x87B9
#define GL_OUTPUT_TEXTURE_COORD29_EXT						0x87BA
#define GL_OUTPUT_TEXTURE_COORD30_EXT						0x87BB
#define GL_OUTPUT_TEXTURE_COORD31_EXT						0x87BC
#define GL_OUTPUT_FOG_EXT									0x87BD
#define GL_SCALAR_EXT										0x87BE
#define GL_VECTOR_EXT										0x87BF
#define GL_MATRIX_EXT										0x87C0
#define GL_VARIANT_EXT										0x87C1
#define GL_INVARIANT_EXT									0x87C2
#define GL_LOCAL_CONSTANT_EXT								0x87C3
#define GL_LOCAL_EXT										0x87C4
#define GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT				0x87C5
#define GL_MAX_VERTEX_SHADER_VARIANTS_EXT					0x87C6
#define GL_MAX_VERTEX_SHADER_INVARIANTS_EXT 				0x87C7
#define GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT			0x87C8
#define GL_MAX_VERTEX_SHADER_LOCALS_EXT 					0x87C9
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT 	0x87CA
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT 		0x87CB
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT		0x87CC
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT	0x87CD
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT			0x87CE
#define GL_VERTEX_SHADER_INSTRUCTIONS_EXT					0x87CF
#define GL_VERTEX_SHADER_VARIANTS_EXT						0x87D0
#define GL_VERTEX_SHADER_INVARIANTS_EXT 					0x87D1
#define GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT				0x87D2
#define GL_VERTEX_SHADER_LOCALS_EXT 						0x87D3
#define GL_VERTEX_SHADER_OPTIMIZED_EXT						0x87D4
#define GL_X_EXT											0x87D5
#define GL_Y_EXT											0x87D6
#define GL_Z_EXT											0x87D7
#define GL_W_EXT											0x87D8
#define GL_NEGATIVE_X_EXT									0x87D9
#define GL_NEGATIVE_Y_EXT									0x87DA
#define GL_NEGATIVE_Z_EXT									0x87DB
#define GL_NEGATIVE_W_EXT									0x87DC
#define GL_ZERO_EXT 										0x87DD
#define GL_ONE_EXT											0x87DE
#define GL_NEGATIVE_ONE_EXT 								0x87DF
#define GL_NORMALIZED_RANGE_EXT 							0x87E0
#define GL_FULL_RANGE_EXT									0x87E1
#define GL_CURRENT_VERTEX_EXT								0x87E2
#define GL_MVP_MATRIX_EXT									0x87E3
#define GL_VARIANT_VALUE_EXT								0x87E4
#define GL_VARIANT_DATATYPE_EXT 							0x87E5
#define GL_VARIANT_ARRAY_STRIDE_EXT 						0x87E6
#define GL_VARIANT_ARRAY_TYPE_EXT							0x87E7
#define GL_VARIANT_ARRAY_EXT								0x87E8
#define GL_VARIANT_ARRAY_POINTER_EXT						0x87E9
#define GL_INVARIANT_VALUE_EXT								0x87EA
#define GL_INVARIANT_DATATYPE_EXT							0x87EB
#define GL_LOCAL_CONSTANT_VALUE_EXT 						0x87EC
#define GL_LOCAL_CONSTANT_DATATYPE_EXT						0x87ED

typedef GLvoid	  (APIENTRY * PFNGLBEGINVERTEXSHADEREXTPROC)(void);
typedef GLvoid	  (APIENTRY * PFNGLENDVERTEXSHADEREXTPROC)(void);
typedef GLvoid	  (APIENTRY * PFNGLBINDVERTEXSHADEREXTPROC)(GLuint id);
typedef GLuint	  (APIENTRY * PFNGLGENVERTEXSHADERSEXTPROC)(GLuint range);
typedef GLvoid	  (APIENTRY * PFNGLDELETEVERTEXSHADEREXTPROC)(GLuint id);
typedef GLvoid	  (APIENTRY * PFNGLSHADEROP1EXTPROC)(GLenum op, GLuint res, GLuint arg1);
typedef GLvoid	  (APIENTRY * PFNGLSHADEROP2EXTPROC)(GLenum op, GLuint res, GLuint arg1,
													 GLuint arg2);
typedef GLvoid	  (APIENTRY * PFNGLSHADEROP3EXTPROC)(GLenum op, GLuint res, GLuint arg1,
													 GLuint arg2, GLuint arg3);
typedef GLvoid	  (APIENTRY * PFNGLSWIZZLEEXTPROC)(GLuint res, GLuint in, GLenum outX,
												   GLenum outY, GLenum outZ, GLenum outW);
typedef GLvoid	  (APIENTRY * PFNGLWRITEMASKEXTPROC)(GLuint res, GLuint in, GLenum outX,
													 GLenum outY, GLenum outZ, GLenum outW);
typedef GLvoid	  (APIENTRY * PFNGLINSERTCOMPONENTEXTPROC)(GLuint res, GLuint src, GLuint num);
typedef GLvoid	  (APIENTRY * PFNGLEXTRACTCOMPONENTEXTPROC)(GLuint res, GLuint src, GLuint num);
typedef GLuint	  (APIENTRY * PFNGLGENSYMBOLSEXTPROC)(GLenum dataType, GLenum storageType,
													  GLenum range, GLuint components);
typedef GLvoid	  (APIENTRY * PFNGLSETINVARIANTEXTPROC)(GLuint id, GLenum type, GLvoid *addr);
typedef GLvoid	  (APIENTRY * PFNGLSETLOCALCONSTANTEXTPROC)(GLuint id, GLenum type, GLvoid *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTBVEXTPROC)(GLuint id, GLbyte *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTSVEXTPROC)(GLuint id, GLshort *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTIVEXTPROC)(GLuint id, GLint *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTFVEXTPROC)(GLuint id, GLfloat *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTDVEXTPROC)(GLuint id, GLdouble *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTUBVEXTPROC)(GLuint id, GLubyte *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTUSVEXTPROC)(GLuint id, GLushort *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTUIVEXTPROC)(GLuint id, GLuint *addr);
typedef GLvoid	  (APIENTRY * PFNGLVARIANTPOINTEREXTPROC)(GLuint id, GLenum type,
														  GLuint stride, GLvoid *addr);
typedef GLvoid	  (APIENTRY * PFNGLENABLEVARIANTCLIENTSTATEEXTPROC)(GLuint id);
typedef GLvoid	  (APIENTRY * PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC)(GLuint id);
typedef GLuint	  (APIENTRY * PFNGLBINDLIGHTPARAMETEREXTPROC)(GLenum light, GLenum value);
typedef GLuint	  (APIENTRY * PFNGLBINDMATERIALPARAMETEREXTPROC)(GLenum face, GLenum value);
typedef GLuint	  (APIENTRY * PFNGLBINDTEXGENPARAMETEREXTPROC)(GLenum unit, GLenum coord,
															   GLenum value);
typedef GLuint	  (APIENTRY * PFNGLBINDTEXTUREUNITPARAMETEREXTPROC)(GLenum unit, GLenum value);
typedef GLuint	  (APIENTRY * PFNGLBINDPARAMETEREXTPROC)(GLenum value);
typedef GLboolean (APIENTRY * PFNGLISVARIANTENABLEDEXTPROC)(GLuint id, GLenum cap);
typedef GLvoid	  (APIENTRY * PFNGLGETVARIANTBOOLEANVEXTPROC)(GLuint id, GLenum value,
															  GLboolean *data);
typedef GLvoid	  (APIENTRY * PFNGLGETVARIANTINTEGERVEXTPROC)(GLuint id, GLenum value,
															  GLint *data);
typedef GLvoid	  (APIENTRY * PFNGLGETVARIANTFLOATVEXTPROC)(GLuint id, GLenum value,
														    GLfloat *data);
typedef GLvoid	  (APIENTRY * PFNGLGETVARIANTPOINTERVEXTPROC)(GLuint id, GLenum value,
															  GLvoid **data);
typedef GLvoid	  (APIENTRY * PFNGLGETINVARIANTBOOLEANVEXTPROC)(GLuint id, GLenum value,
															    GLboolean *data);
typedef GLvoid	  (APIENTRY * PFNGLGETINVARIANTINTEGERVEXTPROC)(GLuint id, GLenum value,
															    GLint *data);
typedef GLvoid	  (APIENTRY * PFNGLGETINVARIANTFLOATVEXTPROC)(GLuint id, GLenum value,
															  GLfloat *data);
typedef GLvoid	  (APIENTRY * PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC)(GLuint id, GLenum value,
																    GLboolean *data);
typedef GLvoid	  (APIENTRY * PFNGLGETLOCALCONSTANTINTEGERVEXTPROC)(GLuint id, GLenum value,
																    GLint *data);
typedef GLvoid	  (APIENTRY * PFNGLGETLOCALCONSTANTFLOATVEXTPROC)(GLuint id, GLenum value,
																  GLfloat *data);


#endif /* GL_EXT_vertex_shader */

/*********************************************************************************************************
**	SGIS EXTENSIONS
*********************************************************************************************************/

#ifndef GL_SGIS_generate_mipmap
#define GL_SGIS_generate_mipmap 1

#define GL_GENERATE_MIPMAP_SGIS 								0x8191
#define GL_GENERATE_MIPMAP_HINT_SGIS							0x8192
															
#endif														
															
#ifndef GL_SGIS_texture_lod									
#define GL_SGIS_texture_lod  1								
															
#define GL_TEXTURE_MIN_LOD_SGIS 								0x813A
#define GL_TEXTURE_MAX_LOD_SGIS 								0x813B
#define GL_TEXTURE_BASE_LEVEL_SGIS								0x813C
#define GL_TEXTURE_MAX_LEVEL_SGIS								0x813D
															
#endif														
#ifndef GL_SGIS_texture_border_clamp						
#define GL_SGIS_texture_border_clamp							1
															
#define GL_CLAMP_TO_BORDER_SGIS 								0x812D
#endif

#ifndef GL_SGIX_shadow
#define GL_SGIX_shadow 1

#define GL_TEXTURE_COMPARE_SGIX                                 0x819A
#define GL_TEXTURE_COMPARE_OPERATOR_SGIX                        0x819B
#define GL_TEXTURE_LEQUAL_R_SGIX                                0x819C
#define GL_TEXTURE_GEQUAL_R_SGIX                                0x819D

#endif /* GL_SGIX_shadow */

#ifndef GL_SGIX_depth_texture
#define GL_SGIX_depth_texture 1

#define GL_DEPTH_COMPONENT16_SGIX                               0x81A5
#define GL_DEPTH_COMPONENT24_SGIX                               0x81A6
#define GL_DEPTH_COMPONENT32_SGIX                               0x81A7

#endif /* GL_SGIX_depth_texture */


/*********************************************************************************************************
**	ARB EXTENSIONS
*********************************************************************************************************/

#ifndef GL_ARB_multisample
#define GL_ARB_multisample	1

typedef GLvoid (APIENTRY * PFNGLSAMPLECOVERAGEARBPROC) (GLclampf value, GLboolean invert);

#define WGL_SAMPLE_BUFFERS_ARB				0x2041
#define WGL_SAMPLES_ARB 					0x2042

#define GL_MULTISAMPLE_ARB					0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB 	0x809E
#define GL_SAMPLE_ALPHA_TO_ONE_ARB			0x809F
#define GL_SAMPLE_COVERAGE_ARB				0x80A0

#define GL_MULTISAMPLE_BIT_ARB				0x20000000

#define GL_SAMPLE_BUFFERS_ARB				0x80A8
#define GL_SAMPLES_ARB						0x80A9
#define GL_SAMPLE_COVERAGE_VALUE_ARB		0x80AA
#define GL_SAMPLE_COVERAGE_INVERT_ARB		0x80AB

#endif

/*
** GL_ARB_texture_env_dot3
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/
					
#ifndef GL_ARB_texture_env_dot3
#define GL_ARB_texture_env_dot3 1

#define GL_DOT3_RGB_ARB 						0x86AE
#define GL_DOT3_RGBA_ARB						0x86AF
#endif

/*
** GL_ARB_transpose_matrix
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/
#ifndef GL_ARB_transpose_matrix
#define GL_ARB_transpose_matrix 1

typedef void (APIENTRY *PFNGLLOADTRANSPOSEMATRIXFARB) (float m[16]);
typedef void (APIENTRY *PFNGLMULTTRANSPOSEMATRIXFARB) (float m[16]);

#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB	0x84E3
#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB	0x84E4
#define GL_TRANSPOSE_TEXTURE_MATRIX_ARB 	0x84E5
#define GL_TRANSPOSE_COLOR_MATRIX_ARB		0x84E6

#endif

/*
** GL_ARB_multitexture
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/

#ifndef GL_ARB_multitexture
#define GL_ARB_multitexture 1
#define GL_ACTIVE_TEXTURE_ARB				0x84E0
#define GL_CLIENT_ACTIVE_TEXTURE_ARB		0x84E1
#define GL_MAX_TEXTURE_UNITS_ARB			0x84E2
#define GL_TEXTURE0_ARB 					0x84C0
#define GL_TEXTURE1_ARB 					0x84C1
#define GL_TEXTURE2_ARB 					0x84C2
#define GL_TEXTURE3_ARB 					0x84C3
#define GL_TEXTURE4_ARB 					0x84C4
#define GL_TEXTURE5_ARB 					0x84C5
#define GL_TEXTURE6_ARB 					0x84C6
#define GL_TEXTURE7_ARB 					0x84C7
#define GL_TEXTURE8_ARB 					0x84C8
#define GL_TEXTURE9_ARB 					0x84C9
#define GL_TEXTURE10_ARB					0x84CA
#define GL_TEXTURE11_ARB					0x84CB
#define GL_TEXTURE12_ARB					0x84CC
#define GL_TEXTURE13_ARB					0x84CD
#define GL_TEXTURE14_ARB					0x84CE
#define GL_TEXTURE15_ARB					0x84CF
#define GL_TEXTURE16_ARB					0x84D0
#define GL_TEXTURE17_ARB					0x84D1
#define GL_TEXTURE18_ARB					0x84D2
#define GL_TEXTURE19_ARB					0x84D3
#define GL_TEXTURE20_ARB					0x84D4
#define GL_TEXTURE21_ARB					0x84D5
#define GL_TEXTURE22_ARB					0x84D6
#define GL_TEXTURE23_ARB					0x84D7
#define GL_TEXTURE24_ARB					0x84D8
#define GL_TEXTURE25_ARB					0x84D9
#define GL_TEXTURE26_ARB					0x84DA
#define GL_TEXTURE27_ARB					0x84DB
#define GL_TEXTURE28_ARB					0x84DC
#define GL_TEXTURE29_ARB					0x84DD
#define GL_TEXTURE30_ARB					0x84DE
#define GL_TEXTURE31_ARB					0x84DF

typedef void (APIENTRY * PFNGLMULTITEXCOORD1DARBPROC)(GLenum target, GLdouble s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1DVARBPROC)(GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1FARBPROC)(GLenum target, GLfloat s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1FVARBPROC)(GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1IARBPROC)(GLenum target, GLint s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1IVARBPROC)(GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1SARBPROC)(GLenum target, GLshort s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1SVARBPROC)(GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2DARBPROC)(GLenum target, GLdouble s, GLdouble t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2DVARBPROC)(GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2FARBPROC)(GLenum target, GLfloat s, GLfloat t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2FVARBPROC)(GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2IARBPROC)(GLenum target, GLint s, GLint t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2IVARBPROC)(GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2SARBPROC)(GLenum target, GLshort s, GLshort t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2SVARBPROC)(GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3DARBPROC)(GLenum target, GLdouble s, GLdouble t, GLdouble r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3DVARBPROC)(GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3FARBPROC)(GLenum target, GLfloat s, GLfloat t, GLfloat r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3FVARBPROC)(GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3IARBPROC)(GLenum target, GLint s, GLint t, GLint r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3IVARBPROC)(GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3SARBPROC)(GLenum target, GLshort s, GLshort t, GLshort r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3SVARBPROC)(GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4DARBPROC)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4DVARBPROC)(GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4FARBPROC)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4FVARBPROC)(GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4IARBPROC)(GLenum target, GLint s, GLint t, GLint r, GLint q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4IVARBPROC)(GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4SARBPROC)(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4SVARBPROC)(GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLACTIVETEXTUREARBPROC)(GLenum target);
typedef void (APIENTRY * PFNGLCLIENTACTIVETEXTUREARBPROC)(GLenum target);

#endif


/*
** GL_ARB_compression
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/

#ifndef GL_ARB_compression
#define GL_ARB_compression 1

#define GL_COMPRESSED_ALPHA_ARB 				0x84E9
#define GL_COMPRESSED_LUMINANCE_ARB 			0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB		0x84EB
#define GL_COMPRESSED_INTENSITY_ARB 			0x84EC
#define GL_COMPRESSED_RGB_ARB					0x84ED
#define GL_COMPRESSED_RGBA_ARB					0x84EE
#define GL_TEXTURE_COMPRESSION_HINT_ARB 		0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB	0x86A0
#define GL_TEXTURE_COMPRESSED_ARB				0x86A1

#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB	0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB		0x86A3


typedef void (APIENTRY * PFNGLCOMPRESSEDTEXIMAGE3DARB)(GLenum target, GLint level,
			GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data);
typedef void (APIENTRY * PFNGLCOMPRESSEDTEXIMAGE2DARB)(GLenum target, GLint level,
			GLint internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data);
typedef void (APIENTRY * PFNGLCOMPRESSEDTEXIMAGE1DARB)(GLenum target, GLint level,
			GLint internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data);
typedef void (APIENTRY * PFNGLGETCOMPRESSEDTEXIMAGEARB)(GLenum target, GLint lod, const void *img);

#endif //


/*
** GL_ARB_vertex_blend
**
**	Support:
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/

#ifndef GL_ARB_vertex_blend 
#define GL_ARB_vertex_blend 				1

#define GL_MAX_VERTEX_UNITS_ARB 			0x86A4
#define GL_ACTIVE_VERTEX_UNITS_ARB			0x86A5
#define GL_WEIGHT_SUM_UNITY_ARB 			0x86A6		
#define GL_VERTEX_BLEND_ARB 				0x86A7
#define GL_CURRENT_WEIGHT_ARB				0x86A8
#define GL_WEIGHT_ARRAY_TYPE_ARB			0x86A9
#define GL_WEIGHT_ARRAY_STRIDE_ARB			0x86AA
#define GL_WEIGHT_ARRAY_SIZE_ARB			0x86AB
#define GL_WEIGHT_ARRAY_POINTER_ARB 		0x86AC
#define GL_WEIGHT_ARRAY_ARB 				0x86AD
#define GL_MODELVIEW0_ARB					0x1700
#define GL_MODELVIEW1_ARB					0x850a
#define GL_MODELVIEW2_ARB					0x8722
#define GL_MODELVIEW3_ARB					0x8723
#define GL_MODELVIEW4_ARB					0x8724
#define GL_MODELVIEW5_ARB					0x8725
#define GL_MODELVIEW6_ARB					0x8726
#define GL_MODELVIEW7_ARB					0x8727
#define GL_MODELVIEW8_ARB					0x8728
#define GL_MODELVIEW9_ARB					0x8729
#define GL_MODELVIEW10_ARB					0x872A
#define GL_MODELVIEW11_ARB					0x872B
#define GL_MODELVIEW12_ARB					0x872C
#define GL_MODELVIEW13_ARB					0x872D
#define GL_MODELVIEW14_ARB					0x872E
#define GL_MODELVIEW15_ARB					0x872F
#define GL_MODELVIEW16_ARB					0x8730
#define GL_MODELVIEW17_ARB					0x8731
#define GL_MODELVIEW18_ARB					0x8732
#define GL_MODELVIEW19_ARB					0x8733
#define GL_MODELVIEW20_ARB					0x8734
#define GL_MODELVIEW21_ARB					0x8735
#define GL_MODELVIEW22_ARB					0x8736
#define GL_MODELVIEW23_ARB					0x8737
#define GL_MODELVIEW24_ARB					0x8738
#define GL_MODELVIEW25_ARB					0x8739
#define GL_MODELVIEW26_ARB					0x873A
#define GL_MODELVIEW27_ARB					0x873B
#define GL_MODELVIEW28_ARB					0x873C
#define GL_MODELVIEW29_ARB					0x873D
#define GL_MODELVIEW30_ARB					0x873E
#define GL_MODELVIEW31_ARB					0x873F

typedef void (APIENTRY *PFNGLWEIGHTBVARBPROC)(GLint size, GLbyte *weights);
typedef void (APIENTRY *PFNGLWEIGHTSVARBPROC)(GLint size, GLshort *weights);
typedef void (APIENTRY *PFNGLWEIGHTIVARBPROC)(GLint size, GLint *weights);
typedef void (APIENTRY *PFNGLWEIGHTFVARBPROC)(GLint size, GLfloat *weights);
typedef void (APIENTRY *PFNGLWEIGHTDVARBPROC)(GLint size, GLdouble *weights);
typedef void (APIENTRY *PFNGLWEIGHTUBVARBPROC)(GLint size, GLubyte *weights);
typedef void (APIENTRY *PFNGLWEIGHTUSVARBPROC)(GLint size, GLushort *weights);
typedef void (APIENTRY *PFNGLWEIGHTUIVARBPROC)(GLint size, GLuint *weights);
typedef void (APIENTRY *PFNGLWEIGHTPOINTERARBPROC)(GLint size, GLenum type, GLsizei stride, GLvoid *pointer);
typedef void (APIENTRY *PFNGLVERTEXBLENDARBPROC)(GLint count);

#endif /* GL_ARB_vertex_blend */


/*
** GL_ARB_texture_cube_map
**
**	Support:
**	 Geforce * based : Supported
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/

#ifndef GL_ARB_texture_cube_map
#define GL_ARB_texture_cube_map 			1

#define GL_NORMAL_MAP_ARB					0x8511
#define GL_REFLECTION_MAP_ARB				0x8512
#define GL_TEXTURE_CUBE_MAP_ARB 			0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB 	0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB	0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB	0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB	0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB	0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB	0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB	0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB		0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB	0x851C

#endif // GL_ARB_texture_cube_map


/*
** GL_ARB_texture_env_combine
**
**	Support:
**	 Geforce * based : Supported
**	 Rage 128 * based : Supported
**	 Radeon   * based : Supported
*/
			
#ifndef GL_ARB_texture_env_combine				
#define GL_ARB_texture_env_combine 1

#define GL_COMBINE_ARB							0x8570
#define GL_COMBINE_RGB_ARB						0x8571
#define GL_COMBINE_ALPHA_ARB					0x8572
#define GL_RGB_SCALE_ARB						0x8573
#define GL_ADD_SIGNED_ARB						0x8574
#define GL_INTERPOLATE_ARB						0x8575
#define GL_CONSTANT_ARB 						0x8576
#define GL_PRIMARY_COLOR_ARB					0x8577
#define GL_PREVIOUS_ARB 						0x8578
#define GL_SOURCE0_RGB_ARB						0x8580
#define GL_SOURCE1_RGB_ARB						0x8581
#define GL_SOURCE2_RGB_ARB						0x8582
#define GL_SOURCE0_ALPHA_ARB					0x8588
#define GL_SOURCE1_ALPHA_ARB					0x8589
#define GL_SOURCE2_ALPHA_ARB					0x858A
#define GL_OPERAND0_RGB_ARB 					0x8590
#define GL_OPERAND1_RGB_ARB 					0x8591
#define GL_OPERAND2_RGB_ARB 					0x8592
#define GL_OPERAND0_ALPHA_ARB					0x8598
#define GL_OPERAND1_ALPHA_ARB					0x8599
#define GL_OPERAND2_ALPHA_ARB					0x859A

#endif // GL_ARB_texture_env_combine

/*****************************************************************************************************
**	S3 EXTENSIONS
*****************************************************************************************************/
#ifndef GL_S3_s3tc
#define GL_S3_s3tc	1

#define GL_RGB_S3TC 							0x83A0
#define GL_RGB4_S3TC							0x83A1
#define GL_RGBA_S3TC							0x83A2
#define GL_RGBA4_S3TC							0x83A3
#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 		0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT		0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT		0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT		0x83F3

#endif

/*****************************************************************************************************
**	3DFX EXTENSIONS
*****************************************************************************************************/

#ifndef GL_3DFX_tbuffer
#define GL_3DFX_tbuffer 1
typedef void (APIENTRY * PGNGLTBUFFERMASK3DFX)(GLuint mask);
#endif

#ifndef GL_3DFX_texture_compression_FXT1
#define GL_3DFX_texture_compression_FXT1	1

#define GL_COMPRESSED_RGBA_FXT1_3DFX		0x86B1
#define GL_COMPRESSED_RGB_FXT1_3DFX 		0x86B0
#endif

#ifndef GL_3DFX_multisample
#define GL_3DFX_multisample 				1

#define GLX_SAMPLE_BUFFERS_3DFX 			0x8050
#define GLX_SAMPLES_3DFX					0x8051
#define WGL_SAMPLE_BUFFERS_3DFX 			0x2060
#define WGL_SAMPLES_3DFX					0x2061
#define GL_MULTISAMPLE_3DFX 				0x86B2
#define GL_SAMPLE_BUFFERS_3DFX				0x86B3
#define GL_SAMPLES_3DFX 					0x86B4
#define GL_MULTISAMPLE_BIT_3DFX 			0x20000000

#endif


/*************************************************************************************************************
**	nVidia EXTENSIONS
**************************************************************************************************************/

/*
** GL_NV_texgen_emboss
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_texgen_emboss
#define GL_NV_texgen_emboss 	1

#define GL_EMBOSS_MAP_NV					0x855F
#define GL_EMBOSS_LIGHT_NV					0x855D
#define GL_EMBOSS_CONSTANT_NV				0x855E
#endif

/*
** NV_texgen_reflection
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_texgen_reflection
#define GL_NV_texgen_reflection 1

#define GL_NORMAL_MAP_NV					0x8511
#define GL_REFLECTION_MAP_NV				0x8512
#endif

/*
** NV_texture_env_combine4
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_texture_env_combine4
#define GL_NV_texture_env_combine4	1

#define GL_COMBINE4_NV						0x8503
#define GL_SOURCE3_RGB_NV					0x8583
#define GL_SOURCE3_ALPHA_NV 				0x858B
#define GL_OPERAND3_RGB_NV					0x8593
#define GL_OPERAND3_ALPHA_NV				0x859B
#endif


/*
** GL_NV_light_max_exponent
**
** Support:
**	 Geforce
*/
#ifndef GL_NV_light_max_exponent
#define GL_NV_light_max_exponent	1

#define GL_MAX_SHININESS_NV 				 0x8504
#define GL_MAX_SPOT_EXPONENT_NV 			 0x8505

#endif


/*
** GL_NV_fog_distance
**
** Support:
**	 Geforce
*/
#ifndef GL_NV_fog_distance
#define GL_NV_fog_distance			1

#define GL_FOG_DISTANCE_MODE_NV 			 0x855A
#define GL_EYE_RADIAL_NV					 0x855B
#define GL_EYE_PLANE_ABSOLUTE_NV			 0x855C

#endif

/*
** GL_NV_packed_depth_stencil
**
** Support:
**	 Geforce
*/
#ifndef GL_NV_packed_depth_stencil
#define GL_NV_packed_depth_stencil	1
	
#define GL_DEPTH_STENCIL_NV 				 0x84F9
#define GL_UNSIGNED_INT_24_8_NV 			 0x84FA

#endif

/*
** GL_NV_texture_rectangle
**
** Support:
**	 Geforce
*/
#ifndef GL_NV_texture_rectangle
#define GL_NV_texture_rectangle 	1

#define GL_TEXTURE_RECTANGLE_NV 			 0x84F5
#define GL_TEXTURE_BINDING_RECTANGLE_NV 	 0x84F6
#define GL_PROXY_TEXTURE_RECTANGLE_NV		 0x84F7 
#define GL_MAX_RECTANGLE_TEXTURE_SIZE_NV	 0x84F8

#endif

/*
** NV_register_combiners
**
** Support:
**	 Geforce
*/
#ifndef GL_NV_register_combiners
#define GL_NV_register_combiners	1

#define GL_REGISTER_COMBINERS_NV			0x8522
#define GL_COMBINER0_NV 					0x8550
#define GL_COMBINER1_NV 					0x8551
#define GL_COMBINER2_NV 					0x8552
#define GL_COMBINER3_NV 					0x8553
#define GL_COMBINER4_NV 					0x8554
#define GL_COMBINER5_NV 					0x8555
#define GL_COMBINER6_NV 					0x8556
#define GL_COMBINER7_NV 					0x8557
#define GL_VARIABLE_A_NV					0x8523
#define GL_VARIABLE_B_NV					0x8524
#define GL_VARIABLE_C_NV					0x8525
#define GL_VARIABLE_D_NV					0x8526
#define GL_VARIABLE_E_NV					0x8527
#define GL_VARIABLE_F_NV					0x8528
#define GL_VARIABLE_G_NV					0x8529
/*		GL_ZERO */
#define GL_CONSTANT_COLOR0_NV				0x852A
#define GL_CONSTANT_COLOR1_NV				0x852B
/*		GL_FOG */
#define GL_PRIMARY_COLOR_NV 				0x852C
#define GL_SECONDARY_COLOR_NV				0x852D
#define GL_SPARE0_NV						0x852E
#define GL_SPARE1_NV						0x852F
/*		GL_TEXTURE0_ARB */
/*		GL_TEXTURE1_ARB */
#define GL_UNSIGNED_IDENTITY_NV 			0x8536
#define GL_UNSIGNED_INVERT_NV				0x8537
#define GL_EXPAND_NORMAL_NV 				0x8538
#define GL_EXPAND_NEGATE_NV 				0x8539
#define GL_HALF_BIAS_NORMAL_NV				0x853A
#define GL_HALF_BIAS_NEGATE_NV				0x853B
#define GL_SIGNED_IDENTITY_NV				0x853C
#define GL_SIGNED_NEGATE_NV 				0x853D
#define GL_E_TIMES_F_NV 					0x8531
#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV	0x8532
/*		GL_NONE */
#define GL_SCALE_BY_TWO_NV					0x853E
#define GL_SCALE_BY_FOUR_NV 				0x853F
#define GL_SCALE_BY_ONE_HALF_NV 			0x8540
#define GL_BIAS_BY_NEGATIVE_ONE_HALF_NV 	0x8541
#define GL_DISCARD_NV						0x8530
#define GL_COMBINER_INPUT_NV				0x8542
#define GL_COMBINER_MAPPING_NV				0x8543
#define GL_COMBINER_COMPONENT_USAGE_NV		0x8544
#define GL_COMBINER_AB_DOT_PRODUCT_NV		0x8545
#define GL_COMBINER_CD_DOT_PRODUCT_NV		0x8546
#define GL_COMBINER_MUX_SUM_NV				0x8547
#define GL_COMBINER_SCALE_NV				0x8548
#define GL_COMBINER_BIAS_NV 				0x8549
#define GL_COMBINER_AB_OUTPUT_NV			0x854a
#define GL_COMBINER_CD_OUTPUT_NV			0x854b
#define GL_COMBINER_SUM_OUTPUT_NV			0x854c
#define GL_MAX_GENERAL_COMBINERS_NV 		0x854d
#define GL_NUM_GENERAL_COMBINERS_NV 		0x854e
#define GL_COLOR_SUM_CLAMP_NV				0x854f
#endif

/*
** GL_NV_vertex_array_range
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_vertex_array_range
#define GL_NV_vertex_array_range 1

#define GL_VERTEX_ARRAY_RANGE_NV				0x851D
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV 		0x851E
#define GL_VERTEX_ARRAY_RANGE_VALID_NV			0x851F
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV	0x8520
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV		0x8521
#define GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV	0x8533

typedef void	* (APIENTRY *PFNWGLALLOCATEMEMORYNVPROC)(GLint size, float readfreq, float writefreq, float priority);
typedef void	  (APIENTRY *PFNWGLFREEMEMORYNVPROC)(void* pointer);
typedef void	  (APIENTRY *PFNGLFLUSHVERTEXARRAYRANGENVPROC)(void);
typedef void	  (APIENTRY *PFNGLVERTEXARRAYRANGENVPROC)(GLsizei size, const GLvoid *pointer);

#endif // NV_vertex_array_range

/*
** GL_NV_fence
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_fence
#define GL_NV_fence 1

#define GL_ALL_COMPLETED_NV 					 0x84F2
#define GL_FENCE_STATUS_NV						 0x84F3
#define GL_FENCE_CONDITION_NV					 0x84F4

typedef void		(APIENTRY * PFNGLDELETEFENCESNVPROC)(GLsizei n, const GLuint *fences);
typedef void		(APIENTRY * PFNGLGENFENCESNVPROC)(GLsizei n, GLuint *fences);
typedef GLboolean	(APIENTRY * PFNGLISFENCENVPROC)(GLuint fence);
typedef GLboolean	(APIENTRY * PFNGLTESTFENCENVPROC)(GLuint fence);
typedef void		(APIENTRY * PFNGLGETFENCEIVNVPROC)(GLuint fence, GLenum pname, GLint *params);
typedef void		(APIENTRY * PFNGLFINISHFENCENVPROC)(GLuint fence);
typedef void		(APIENTRY * PFNGLSETFENCENVPROC)(GLuint fence, GLenum condition);

#endif // NV_fence

/*
** GL_NV_ext_combine
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_ext_combine
#define GL_NV_ext_combine 1

typedef void (APIENTRY * PFNGLCOMBINERPARAMETERFVNVPROC)(GLenum pname, const GLfloat *params);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERFNVPROC)(GLenum pname, GLfloat param);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERIVNVPROC)(GLenum pname, const GLint *params);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERINVPROC)(GLenum pname, GLint param);
typedef void (APIENTRY * PFNGLCOMBINERINPUTNVPROC)(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef void (APIENTRY * PFNGLCOMBINEROUTPUTNVPROC)(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
typedef void (APIENTRY * PFNGLFINALCOMBINERINPUTNVPROC)(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef void (APIENTRY * PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC)(GLenum stage, GLenum portion, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC)(GLenum stage, GLenum portion, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC)(GLenum variable, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC)(GLenum variable, GLenum pname, GLint *params);

#endif


/*
** GL_NV_evaluators
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_evaluators
#define GL_NV_evaluators	1

typedef void (APIENTRY *PFNGLMAPCONTROLPOINTSNV)(enum target, GLuint index, enum type,
							GLsizei ustride, GLsizei vstride,
							GLint uorder, GLint vorder,
							GLboolean packed,
							const void *points);

typedef void (APIENTRY *PFNGLMAPPARAMETERIVNV)(enum target, enum pname, const GLint *params);
typedef void (APIENTRY *PFNGLMAPPARAMETERFVNV)(enum target, enum pname, const float *params);

typedef void (APIENTRY *PFNGLGETMAPCONTROLPOINTSNV)(enum target, GLuint index, enum type,
						   GLsizei ustride, GLsizei vstride,
						   GLboolean packed, void *points);

typedef VOID (APIENTRY *PFNGLGETMAPPARAMETERIVNV)(enum target, enum pname, GLint *params);
typedef void (APIENTRY *PFNGLGETMAPPARAMETERFVNV)(enum target, enum pname, float *params);
typedef void (APIENTRY *PFNGLGETMAPATTRIBPARAMETERIVNV)(enum target, GLuint index, enum pname,
							   GLint *params);
typedef void (APIENTRY *PFNGLGETMAPATTRIBPARAMETERFVNV)(enum target, GLuint index, enum pname,
							   float *params);

typedef void (APIENTRY *PFNGLEVALMAPSNV)(enum target, enum mode);



typedef void (APIENTRY *PFNGLMAPCONTROLPOINTSNV)(enum target, GLuint index, enum type,
						GLsizei ustride, GLsizei vstride,
						GLint uorder, GLint vorder,
						GLboolean packed,
						const void *points);

typedef void (APIENTRY *PFNGLMAPPARAMETERIVNV)(enum target, enum pname, const GLint *params);
typedef void (APIENTRY *PFNGLMAPPARAMETERFVNV)(enum target, enum pname, const float *params);

typedef void (APIENTRY *PFNGLGETMAPCONTROLPOINTSNV)(enum target, GLuint index, enum type,
						   GLsizei ustride, GLsizei vstride,
						   GLboolean packed, void *points);

typedef void (APIENTRY *PFNGLGETMAPPARAMETERIVNV)(enum target, enum pname, GLint *params);
typedef void (APIENTRY *PFNGLGETMAPPARAMETERFVNV)(enum target, enum pname, float *params);
typedef void (APIENTRY *PFNGLGETMAPATTRIBPARAMETERIVNV)(enum target, GLuint index, enum pname,
							   GLint *params);
typedef void (APIENTRY *PFNGLGETMAPATTRIBPARAMETERFVNV)(enum target, GLuint index, enum pname,
							   float *params);

typedef void (APIENTRY *PFNGLEVALMAPSNV)(enum target, enum mode);
#define GL_EVAL_2D_NV							 0x86C0
#define GL_EVAL_TRIANGULAR_2D_NV				 0x86C1
#define GL_MAP_TESSELLATION_NV					 0x86C2
#define GL_MAP_ATTRIB_U_ORDER_NV				 0x86C3
#define GL_MAP_ATTRIB_V_ORDER_NV				 0x86C4
#define GL_EVAL_FRACTIONAL_TESSELLATION_NV		 0x86C5
#define GL_EVAL_VERTEX_ATTRIB0_NV				 0x86C6
#define GL_EVAL_VERTEX_ATTRIB1_NV				 0x86C7
#define GL_EVAL_VERTEX_ATTRIB2_NV				 0x86C8
#define GL_EVAL_VERTEX_ATTRIB3_NV				 0x86C9
#define GL_EVAL_VERTEX_ATTRIB4_NV				 0x86CA
#define GL_EVAL_VERTEX_ATTRIB5_NV				 0x86CB
#define GL_EVAL_VERTEX_ATTRIB6_NV				 0x86CC
#define GL_EVAL_VERTEX_ATTRIB7_NV				 0x86CD
#define GL_EVAL_VERTEX_ATTRIB8_NV				 0x86CE
#define GL_EVAL_VERTEX_ATTRIB9_NV				 0x86CF
#define GL_EVAL_VERTEX_ATTRIB10_NV				 0x86D0
#define GL_EVAL_VERTEX_ATTRIB11_NV				 0x86D1
#define GL_EVAL_VERTEX_ATTRIB12_NV				 0x86D2
#define GL_EVAL_VERTEX_ATTRIB13_NV				 0x86D3
#define GL_EVAL_VERTEX_ATTRIB14_NV				 0x86D4
#define GL_EVAL_VERTEX_ATTRIB15_NV				 0x86D5
#define GL_MAX_MAP_TESSELLATION_NV				 0x86D6
#define GL_MAX_RATIONAL_EVAL_ORDER_NV			 0x86D7

#endif


/*
** GL_NV_vertex_program (DX8 vertex shaders)
** http://oss.sgi.com/projects/ogl-sample/registry/NV/vertex_program.txt
**
** Support:
**	 Geforce
*/

#ifndef GL_NV_vertex_program
#define GL_NV_vertex_program 1

#define GL_VERTEX_PROGRAM_NV							  0x8620 
#define GL_VERTEX_PROGRAM_POINT_SIZE_NV 				  0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_NV					  0x8643
  
#define GL_VERTEX_STATE_PROGRAM_NV						  0x8621 

#define GL_ATTRIB_ARRAY_SIZE_NV 						  0x8623
#define GL_ATTRIB_ARRAY_STRIDE_NV						  0x8624
#define GL_ATTRIB_ARRAY_TYPE_NV 						  0x8625
#define GL_CURRENT_ATTRIB_NV							  0x8626

#define GL_PROGRAM_PARAMETER_NV 						  0x8644

#define GL_ATTRIB_ARRAY_POINTER_NV						  0x8645

#define GL_PROGRAM_TARGET_NV							  0x8646
#define GL_PROGRAM_LENGTH_NV							  0x8627
#define GL_PROGRAM_RESIDENT_NV							  0x8647

#define GL_PROGRAM_STRING_NV							  0x8628

#define GL_TRACK_MATRIX_NV								  0x8648
#define GL_TRACK_MATRIX_TRANSFORM_NV					  0x8649

#define GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV				  0x862E
#define GL_MAX_TRACK_MATRICES_NV						  0x862F
#define GL_CURRENT_MATRIX_STACK_DEPTH_NV				  0x8640
#define GL_CURRENT_MATRIX_NV							  0x8641
#define GL_VERTEX_PROGRAM_BINDING_NV					  0x864A
#define GL_PROGRAM_ERROR_POSITION_NV					  0x864B

#define GL_MODELVIEW_PROJECTION_NV						  0x8629
 
#define GL_MATRIX0_NV									  0x8630
#define GL_MATRIX1_NV									  0x8631
#define GL_MATRIX2_NV									  0x8632
#define GL_MATRIX3_NV									  0x8633
#define GL_MATRIX4_NV									  0x8634
#define GL_MATRIX5_NV									  0x8635
#define GL_MATRIX6_NV									  0x8636
#define GL_MATRIX7_NV									  0x8637

#define GL_IDENTITY_NV									  0x862A
#define GL_INVERSE_NV									  0x862B
#define GL_TRANSPOSE_NV 								  0x862C
#define GL_INVERSE_TRANSPOSE_NV 						  0x862D 

#define GL_VERTEX_ATTRIB_ARRAY0_NV						  0x8650
#define GL_VERTEX_ATTRIB_ARRAY1_NV						  0x8651
#define GL_VERTEX_ATTRIB_ARRAY2_NV						  0x8652
#define GL_VERTEX_ATTRIB_ARRAY3_NV						  0x8653
#define GL_VERTEX_ATTRIB_ARRAY4_NV						  0x8654
#define GL_VERTEX_ATTRIB_ARRAY5_NV						  0x8655
#define GL_VERTEX_ATTRIB_ARRAY6_NV						  0x8656
#define GL_VERTEX_ATTRIB_ARRAY7_NV						  0x8657
#define GL_VERTEX_ATTRIB_ARRAY8_NV						  0x8658
#define GL_VERTEX_ATTRIB_ARRAY9_NV						  0x8659
#define GL_VERTEX_ATTRIB_ARRAY10_NV 					  0x865A
#define GL_VERTEX_ATTRIB_ARRAY11_NV 					  0x865B
#define GL_VERTEX_ATTRIB_ARRAY12_NV 					  0x865C
#define GL_VERTEX_ATTRIB_ARRAY13_NV 					  0x865D
#define GL_VERTEX_ATTRIB_ARRAY14_NV 					  0x865E
#define GL_VERTEX_ATTRIB_ARRAY15_NV 					  0x865F

#define GL_MAP1_VERTEX_ATTRIB0_4_NV 					  0x8660
#define GL_MAP1_VERTEX_ATTRIB1_4_NV 					  0x8661
#define GL_MAP1_VERTEX_ATTRIB2_4_NV 					  0x8662
#define GL_MAP1_VERTEX_ATTRIB3_4_NV 					  0x8663
#define GL_MAP1_VERTEX_ATTRIB4_4_NV 					  0x8664
#define GL_MAP1_VERTEX_ATTRIB5_4_NV 					  0x8665
#define GL_MAP1_VERTEX_ATTRIB6_4_NV 					  0x8666
#define GL_MAP1_VERTEX_ATTRIB7_4_NV 					  0x8667
#define GL_MAP1_VERTEX_ATTRIB8_4_NV 					  0x8668
#define GL_MAP1_VERTEX_ATTRIB9_4_NV 					  0x8669
#define GL_MAP1_VERTEX_ATTRIB10_4_NV					  0x866A
#define GL_MAP1_VERTEX_ATTRIB11_4_NV					  0x866B
#define GL_MAP1_VERTEX_ATTRIB12_4_NV					  0x866C
#define GL_MAP1_VERTEX_ATTRIB13_4_NV					  0x866D
#define GL_MAP1_VERTEX_ATTRIB14_4_NV					  0x866E
#define GL_MAP1_VERTEX_ATTRIB15_4_NV					  0x866F

#define GL_MAP2_VERTEX_ATTRIB0_4_NV 					  0x8670
#define GL_MAP2_VERTEX_ATTRIB1_4_NV 					  0x8671
#define GL_MAP2_VERTEX_ATTRIB2_4_NV 					  0x8672
#define GL_MAP2_VERTEX_ATTRIB3_4_NV 					  0x8673
#define GL_MAP2_VERTEX_ATTRIB4_4_NV 					  0x8674
#define GL_MAP2_VERTEX_ATTRIB5_4_NV 					  0x8675
#define GL_MAP2_VERTEX_ATTRIB6_4_NV 					  0x8676
#define GL_MAP2_VERTEX_ATTRIB7_4_NV 					  0x8677
#define GL_MAP2_VERTEX_ATTRIB8_4_NV 					  0x8678
#define GL_MAP2_VERTEX_ATTRIB9_4_NV 					  0x8679
#define GL_MAP2_VERTEX_ATTRIB10_4_NV					  0x867A
#define GL_MAP2_VERTEX_ATTRIB11_4_NV					  0x867B
#define GL_MAP2_VERTEX_ATTRIB12_4_NV					  0x867C
#define GL_MAP2_VERTEX_ATTRIB13_4_NV					  0x867D
#define GL_MAP2_VERTEX_ATTRIB14_4_NV					  0x867E
#define GL_MAP2_VERTEX_ATTRIB15_4_NV					  0x867F

typedef void (APIENTRY * PFNGLBINDPROGRAMNVPROC)(GLenum target, GLuint id);
typedef void (APIENTRY * PFNGLDELETEPROGRAMSNVPROC)(GLsizei n, const GLuint *ids);
typedef void (APIENTRY * PFNGLEXECUTEPROGRAMNVPROC)(GLenum target, GLuint id, const GLfloat *params);
typedef void (APIENTRY * PFNGLGENPROGRAMSNVPROC)(GLsizei n, GLuint *ids);
typedef GLboolean (APIENTRY * PFNGLAREPROGRAMSRESIDENTNVPROC)(GLsizei n, const GLuint *ids, GLboolean *residences);
typedef void (APIENTRY * PFNGLREQUESTRESIDENTPROGRAMSNVPROC)(GLsizei n, GLuint *ids);
typedef void (APIENTRY * PFNGLGETPROGRAMPARAMETERFVNVPROC)(GLenum target, GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETPROGRAMPARAMETERDVNVPROC)(GLenum target, GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRY * PFNGLGETPROGRAMIVNVPROC)(GLuint id, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETPROGRAMSTRINGNVPROC)(GLuint id, GLenum pname, GLubyte *program);
typedef void (APIENTRY * PFNGLGETTRACKMATRIXIVNVPROC)(GLenum target, GLuint address, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBDVNVPROC)(GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBFVNVPROC)(GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBIVNVPROC)(GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBPOINTERVNVPROC)(GLuint index, GLenum pname, void **pointer);
typedef GLboolean (APIENTRY * PFNGLISPROGRAMNVPROC)(GLuint id);
typedef void (APIENTRY * PFNGLLOADPROGRAMNVPROC)(GLenum target, GLuint id, GLsizei len, const GLubyte *program);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4FNVPROC)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4DNVPROC)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4DVNVPROC)(GLenum target, GLuint index, const GLdouble *params);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4FVNVPROC)(GLenum target, GLuint index, const GLfloat *params);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETERS4DVNVPROC)(GLenum target, GLuint index, GLuint num, const GLdouble *params);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETERS4FVNVPROC)(GLenum target, GLuint index, GLuint num, const GLfloat *params);
typedef void (APIENTRY * PFNGLTRACKMATRIXNVPROC)(GLenum target, GLuint address, GLenum matrix, GLenum transform);
typedef void (APIENTRY * PFNGLVERTEXATTRIBPOINTERNVPROC)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SNVPROC)(GLuint index, GLshort x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FNVPROC)(GLuint index, GLfloat x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DNVPROC)(GLuint index, GLdouble x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SNVPROC)(GLuint index, GLshort x, GLshort y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FNVPROC)(GLuint index, GLfloat x, GLfloat y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DNVPROC)(GLuint index, GLdouble x, GLdouble y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SNVPROC)(GLuint index, GLshort x, GLshort y, GLshort z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FNVPROC)(GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DNVPROC)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SNVPROC)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FNVPROC)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DNVPROC)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4UBNVPROC)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SVNVPROC)(GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FVNVPROC)(GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DVNVPROC)(GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SVNVPROC)(GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FVNVPROC)(GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DVNVPROC)(GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SVNVPROC)(GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FVNVPROC)(GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DVNVPROC)(GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SVNVPROC)(GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FVNVPROC)(GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DVNVPROC)(GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4UBVNVPROC)(GLuint index, const GLubyte *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1SVNVPROC)(GLuint index, GLsizei n, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1FVNVPROC)(GLuint index, GLsizei n, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1DVNVPROC)(GLuint index, GLsizei n, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2SVNVPROC)(GLuint index, GLsizei n, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2FVNVPROC)(GLuint index, GLsizei n, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2DVNVPROC)(GLuint index, GLsizei n, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3SVNVPROC)(GLuint index, GLsizei n, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3FVNVPROC)(GLuint index, GLsizei n, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3DVNVPROC)(GLuint index, GLsizei n, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4SVNVPROC)(GLuint index, GLsizei n, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4FVNVPROC)(GLuint index, GLsizei n, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4DVNVPROC)(GLuint index, GLsizei n, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4UBVNVPROC)(GLuint index, GLsizei n, const GLubyte *v);

#endif

/*************************************************************************************************************
**	ATI EXTENSIONS
*************************************************************************************************************/

/*
** GL_ATI_envmap_bumpmap
**
** Support:
**	 Rage 128 * based  : Not Supported
**	 Radeon   * based  : Supported
**	 R200	  * based  : Supported
*/
#ifndef GL_ATI_envmap_bumpmap
#define GL_ATI_envmap_bumpmap 1

#define GL_BUMP_ROT_MATRIX_ATI					   0x8775
#define GL_BUMP_ROT_MATRIX_SIZE_ATI 			   0x8776
#define GL_BUMP_NUM_TEX_UNITS_ATI				   0x8777
#define GL_BUMP_TEX_UNITS_ATI					   0x8778
#define GL_DUDV_ATI 							   0x8779
#define GL_DU8DV8_ATI							   0x877A
#define GL_BUMP_ENVMAP_ATI						   0x877B
#define GL_BUMP_TARGET_ATI						   0x877C

typedef void (APIENTRY * PFNGLTEXBUMPPARAMETERIVATIPROC)(GLenum pname, GLint *param);
typedef void (APIENTRY * PFNGLTEXBUMPPARAMETERFVATIPROC)(GLenum pname, GLfloat *param);
typedef void (APIENTRY * PFNGLGETTEXBUMPPARAMETERIVATIPROC)(GLenum pname, GLint *param);
typedef void (APIENTRY * PFNGLGETTEXBUMPPARAMETERFVATIPROC)(GLenum pname, GLfloat *param);

#endif /* GL_ATI_envmap_bumpmap */


/*
** GL_ATI_fragment_shader
**
** Support:
**	 Rage 128 * based  : Not Supported
**	 Radeon   * based  : Not Supported
**	 R200	  * based  : Supported
*/
#ifndef GL_ATI_fragment_shader
#define GL_ATI_fragment_shader 1

#define GL_FRAGMENT_SHADER_ATI						0x8920
#define GL_REG_0_ATI								0x8921
#define GL_REG_1_ATI								0x8922
#define GL_REG_2_ATI								0x8923
#define GL_REG_3_ATI								0x8924
#define GL_REG_4_ATI								0x8925
#define GL_REG_5_ATI								0x8926
#define GL_REG_6_ATI								0x8927
#define GL_REG_7_ATI								0x8928
#define GL_REG_8_ATI								0x8929
#define GL_REG_9_ATI								0x892A
#define GL_REG_10_ATI								0x892B
#define GL_REG_11_ATI								0x892C
#define GL_REG_12_ATI								0x892D
#define GL_REG_13_ATI								0x892E
#define GL_REG_14_ATI								0x892F
#define GL_REG_15_ATI								0x8930
#define GL_REG_16_ATI								0x8931
#define GL_REG_17_ATI								0x8932
#define GL_REG_18_ATI								0x8933
#define GL_REG_19_ATI								0x8934
#define GL_REG_20_ATI								0x8935
#define GL_REG_21_ATI								0x8936
#define GL_REG_22_ATI								0x8937
#define GL_REG_23_ATI								0x8938
#define GL_REG_24_ATI								0x8939
#define GL_REG_25_ATI								0x893A
#define GL_REG_26_ATI								0x893B
#define GL_REG_27_ATI								0x893C
#define GL_REG_28_ATI								0x893D
#define GL_REG_29_ATI								0x893E
#define GL_REG_30_ATI								0x893F
#define GL_REG_31_ATI								0x8940
#define GL_CON_0_ATI								0x8941
#define GL_CON_1_ATI								0x8942
#define GL_CON_2_ATI								0x8943
#define GL_CON_3_ATI								0x8944
#define GL_CON_4_ATI								0x8945
#define GL_CON_5_ATI								0x8946
#define GL_CON_6_ATI								0x8947
#define GL_CON_7_ATI								0x8948
#define GL_CON_8_ATI								0x8949
#define GL_CON_9_ATI								0x894A
#define GL_CON_10_ATI								0x894B
#define GL_CON_11_ATI								0x894C
#define GL_CON_12_ATI								0x894D
#define GL_CON_13_ATI								0x894E
#define GL_CON_14_ATI								0x894F
#define GL_CON_15_ATI								0x8950
#define GL_CON_16_ATI								0x8951
#define GL_CON_17_ATI								0x8952
#define GL_CON_18_ATI								0x8953
#define GL_CON_19_ATI								0x8954
#define GL_CON_20_ATI								0x8955
#define GL_CON_21_ATI								0x8956
#define GL_CON_22_ATI								0x8957
#define GL_CON_23_ATI								0x8958
#define GL_CON_24_ATI								0x8959
#define GL_CON_25_ATI								0x895A
#define GL_CON_26_ATI								0x895B
#define GL_CON_27_ATI								0x895C
#define GL_CON_28_ATI								0x895D
#define GL_CON_29_ATI								0x895E
#define GL_CON_30_ATI								0x895F
#define GL_CON_31_ATI								0x8960
#define GL_MOV_ATI									0x8961
#define GL_ADD_ATI									0x8963
#define GL_MUL_ATI									0x8964
#define GL_SUB_ATI									0x8965
#define GL_DOT3_ATI 								0x8966
#define GL_DOT4_ATI 								0x8967
#define GL_MAD_ATI									0x8968
#define GL_LERP_ATI 								0x8969
#define GL_CND_ATI									0x896A
#define GL_CND0_ATI 								0x896B
#define GL_DOT2_ADD_ATI 							0x896C
#define GL_SECONDARY_INTERPOLATOR_ATI				0x896D
#define GL_NUM_FRAGMENT_REGISTERS_ATI				0x896E
#define GL_NUM_FRAGMENT_CONSTANTS_ATI				0x896F
#define GL_NUM_PASSES_ATI							0x8970
#define GL_NUM_INSTRUCTIONS_PER_PASS_ATI			0x8971
#define GL_NUM_INSTRUCTIONS_TOTAL_ATI				0x8972
#define GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI	0x8973
#define GL_NUM_LOOPBACK_COMPONENTS_ATI				0x8974
#define GL_COLOR_ALPHA_PAIRING_ATI					0x8975
#define GL_SWIZZLE_STR_ATI							0x8976
#define GL_SWIZZLE_STQ_ATI							0x8977
#define GL_SWIZZLE_STR_DR_ATI						0x8978
#define GL_SWIZZLE_STQ_DQ_ATI						0x8979
#define GL_SWIZZLE_STRQ_ATI 						0x897A
#define GL_SWIZZLE_STRQ_DQ_ATI						0x897B
#define GL_RED_BIT_ATI								0x00000001
#define GL_GREEN_BIT_ATI							0x00000002
#define GL_BLUE_BIT_ATI 							0x00000004
#define GL_2X_BIT_ATI								0x00000001
#define GL_4X_BIT_ATI								0x00000002
#define GL_8X_BIT_ATI								0x00000004
#define GL_HALF_BIT_ATI 							0x00000008
#define GL_QUARTER_BIT_ATI							0x00000010
#define GL_EIGHTH_BIT_ATI							0x00000020
#define GL_SATURATE_BIT_ATI 						0x00000040
#define GL_COMP_BIT_ATI 							0x00000002
#define GL_NEGATE_BIT_ATI							0x00000004
#define GL_BIAS_BIT_ATI 							0x00000008


typedef GLuint (APIENTRY *PFNGLGENFRAGMENTSHADERSATIPROC)(GLuint range);
typedef GLvoid (APIENTRY *PFNGLBINDFRAGMENTSHADERATIPROC)(GLuint id);
typedef GLvoid (APIENTRY *PFNGLDELETEFRAGMENTSHADERATIPROC)(GLuint id);
typedef GLvoid (APIENTRY *PFNGLBEGINFRAGMENTSHADERATIPROC)(GLvoid);
typedef GLvoid (APIENTRY *PFNGLENDFRAGMENTSHADERATIPROC)(GLvoid);
typedef GLvoid (APIENTRY *PFNGLPASSTEXCOORDATIPROC)(GLuint dst, GLuint coord, GLenum swizzle);
typedef GLvoid (APIENTRY *PFNGLSAMPLEMAPATIPROC)(GLuint dst, GLuint interp, GLenum swizzle);
typedef GLvoid (APIENTRY *PFNGLCOLORFRAGMENTOP1ATIPROC)(GLenum op, GLuint dst, GLuint dstMask,
									   GLuint dstMod, GLuint arg1, GLuint arg1Rep,
									   GLuint arg1Mod);
typedef GLvoid (APIENTRY *PFNGLCOLORFRAGMENTOP2ATIPROC)(GLenum op, GLuint dst, GLuint dstMask,
									   GLuint dstMod, GLuint arg1, GLuint arg1Rep,
									   GLuint arg1Mod, GLuint arg2, GLuint arg2Rep,
									   GLuint arg2Mod);
typedef GLvoid (APIENTRY *PFNGLCOLORFRAGMENTOP3ATIPROC)(GLenum op, GLuint dst, GLuint dstMask,
									   GLuint dstMod, GLuint arg1, GLuint arg1Rep,
									   GLuint arg1Mod, GLuint arg2, GLuint arg2Rep,
									   GLuint arg2Mod, GLuint arg3, GLuint arg3Rep,
									   GLuint arg3Mod);
typedef GLvoid (APIENTRY *PFNGLALPHAFRAGMENTOP1ATIPROC)(GLenum op, GLuint dst, GLuint dstMod,
									   GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
typedef GLvoid (APIENTRY *PFNGLALPHAFRAGMENTOP2ATIPROC)(GLenum op, GLuint dst, GLuint dstMod,
									   GLuint arg1, GLuint arg1Rep, GLuint arg1Mod,
									   GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
typedef GLvoid (APIENTRY *PFNGLALPHAFRAGMENTOP3ATIPROC)(GLenum op, GLuint dst, GLuint dstMod,
									   GLuint arg1, GLuint arg1Rep, GLuint arg1Mod,
									   GLuint arg2, GLuint arg2Rep, GLuint arg2Mod,
									   GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
typedef GLvoid (APIENTRY *PFNGLSETFRAGMENTSHADERCONSTANTATIPROC)(GLuint dst, const GLfloat *value);

#endif /* GL_ATI_fragment_shader */


/*
** GL_ATI_pn_triangles
**
** Support
**	 Rage 128 * based  : Not Supported
**	 Radeon   * based  : Not Supported
**	 R200	  * based  : Supported
*/
#ifndef GL_ATI_pn_triangles
#define GL_ATI_pn_triangles 1

#define GL_PN_TRIANGLES_ATI 						0x87F0
#define GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI	0x87F1
#define GL_PN_TRIANGLES_POINT_MODE_ATI				0x87F2
#define GL_PN_TRIANGLES_NORMAL_MODE_ATI 			0x87F3
#define GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI		0x87F4
#define GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI		0x87F5
#define GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI		0x87F6
#define GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI		0x87F7
#define GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI	0x87F8

typedef void (APIENTRY *PFNGLPNTRIANGLESIATIPROC)(GLenum pname, GLint param);
typedef void (APIENTRY *PFNGLPNTRIANGLESFATIPROC)(GLenum pname, GLfloat param);

#endif


/*
** GL_ATI_map_object_buffer
**
** Support:
**	 Rage 128 * based : Not supported
**	 Radeon   * based : Supported
**	 Chaplin  * based : Supported
*/
#ifndef GL_ATI_map_object_buffer
#define GL_ATI_map_object_buffer		1

typedef void *(APIENTRY * PFNGLMAPOBJECTBUFFERATI)(GLuint buffer);
typedef void  (APIENTRY * PFNGLUNMAPOBJECTBUFFERATI)(GLuint buffer);

#endif

/*
** GL_ATI_vertex_array_object
**
** Support:
**	 Rage 128 * based : Not supported
**	 Radeon   * based : Supported
**	 Chaplin  * based : Supported
*/
#ifndef GL_ATI_vertex_array_object
#define GL_ATI_vertex_array_object		1

#define GL_STATIC_ATI					0x8760
#define GL_DYNAMIC_ATI					0x8761
#define GL_PRESERVE_ATI 				0x8762
#define GL_DISCARD_ATI					0x8763

#define GL_OBJECT_BUFFER_SIZE_ATI		0x8764
#define GL_OBJECT_BUFFER_USAGE_ATI		0x8765
#define GL_ARRAY_OBJECT_BUFFER_ATI		0x8766
#define GL_ARRAY_OBJECT_OFFSET_ATI		0x8767

typedef GLuint (APIENTRY * PFNGLNEWOBJECTBUFFERATIPROC)(GLsizei size, const GLvoid *pointer, GLenum usage);
typedef GLboolean (APIENTRY * PFNGLISOBJECTBUFFERATIPROC)(GLuint buffer);
typedef void (APIENTRY * PFNGLUPDATEOBJECTBUFFERATIPROC)(GLuint buffer, GLuint offset, GLsizei size,
														 const GLvoid *pointer, GLenum preserve);
typedef void (APIENTRY * PFNGLGETOBJECTBUFFERFVATIPROC)(GLuint buffer, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETOBJECTBUFFERIVATIPROC)(GLuint buffer, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLFREEOBJECTBUFFERATIPROC)(GLuint buffer);
typedef void (APIENTRY * PFNGLARRAYOBJECTATIPROC)(GLenum array, GLint size, GLenum type,
												  GLsizei stride, GLuint buffer, GLuint offset);
typedef void (APIENTRY * PFNGLGETARRAYOBJECTFVATIPROC)(GLenum array, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETARRAYOBJECTIVATIPROC)(GLenum array, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLVARIANTARRAYOBJECTATIPROC)(GLuint id, GLenum type,
														 GLsizei stride, GLuint buffer, GLuint offset);
typedef void (APIENTRY * PFNGLGETVARIANTARRAYOBJECTFVATIPROC)(GLuint id, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETVARIANTARRAYOBJECTIVATIPROC)(GLuint id, GLenum pname, GLint *params);

#endif

/*
** GL_ATI_element_array
**
** Support:
**	 Rage 128 * based : Not supported
**	 Radeon   * based : Supported
**	 Chaplin  * based : Supported
*/
#ifndef GL_ATI_element_array
#define GL_ATI_element_array			1

#define GL_ELEMENT_ARRAY_ATI									0x8768
																
#define GL_ELEMENT_ARRAY_TYPE_ATI								0x8769
#define GL_ELEMENT_ARRAY_POINTER_ATI							0x876A

typedef void (APIENTRY * PFNGLELEMENTPOINTERATIPROC)(GLenum type, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLDRAWELEMENTARRAYATIPROC)(GLenum mode, GLsizei count);
typedef void (APIENTRY * PFNGLDRAWRANGEELEMENTARRAYATIPROC)(GLenum mode, GLuint start, GLuint end, GLsizei count);

#endif // GL_ATI_element_array

#ifndef GL_ATIX_point_sprites
#define GL_ATIX_point_sprites			1

#define GL_TEXTURE_POINT_MODE_ATIX                              0x60b0
#define	GL_TEXTURE_POINT_ONE_COORD_ATIX                         0x60b1
#define	GL_TEXTURE_POINT_SPRITE_ATIX                            0x60b2
#define GL_POINT_SPRITE_CULL_MODE_ATIX                          0x60b3
#define GL_POINT_SPRITE_CULL_CENTER_ATIX                        0x60b4
#define GL_POINT_SPRITE_CULL_CLIP_ATIX                          0x60b5

#endif // GL_ATIX_point_sprites 

#ifndef GL_ATIX_texture_env_route
#define GL_ATIX_texture_env_route		1

#define GL_SECONDARY_COLOR_ATIX                                 0x8747
#define GL_TEXTURE_OUTPUT_RGB_ATIX                              0x8748
#define GL_TEXTURE_OUTPUT_ALPHA_ATIX                            0x8749

#endif // GL_ATIX_texture_env_route 


/*******************************************************************************************
  GL Library 
*******************************************************************************************/

// OpenGL Drivers
enum tagOpenGLDrivers
{
	GL_DEFAULT = 0,		// Default OpenGL Driver
	GL_VOODOO,			// 3dfx Standalone OpenGL Driver
	GL_POWERVR,
	GL_SGI,
	GL_MAXDRIVERS,
};

#ifdef __cplusplus
extern "C" {
#endif

	/*
		OpenGL 1.2 Reference.
		( ICD Driver )
	*/
	extern void      		(APIENTRY *glAccum)(GLenum op, GLfloat value);
	extern void      		(APIENTRY *glAlphaFunc)(GLenum func, GLclampf ref);
	extern GLboolean 		(APIENTRY *glAreTexturesResident)(GLsizei n, const GLuint *textures, GLboolean *residences);
	extern void      		(APIENTRY *glArrayElement)(GLint i);
	extern void      		(APIENTRY *glBegin)(GLenum mode);
	extern void      		(APIENTRY *glBindTexture)(GLenum target, GLuint texture);
	extern void      		(APIENTRY *glBitmap)(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
	extern void      		(APIENTRY *glBlendFunc)(GLenum sfactor, GLenum dfactor);
	extern void      		(APIENTRY *glCallList)(GLuint list);
	extern void      		(APIENTRY *glCallLists)(GLsizei n, GLenum type, const GLvoid *lists);
	extern void      		(APIENTRY *glClear)(GLbitfield mask);
	extern void      		(APIENTRY *glClearAccum)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	extern void      		(APIENTRY *glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	extern void      		(APIENTRY *glClearDepth)(GLclampd depth);
	extern void      		(APIENTRY *glClearIndex)(GLfloat c);
	extern void      		(APIENTRY *glClearStencil)(GLint s);
	extern void      		(APIENTRY *glClipPlane)(GLenum plane, const GLdouble *equation);
	extern void      		(APIENTRY *glColor3b)(GLbyte red, GLbyte green, GLbyte blue);
	extern void      		(APIENTRY *glColor3bv)(const GLbyte *v);
	extern void      		(APIENTRY *glColor3d)(GLdouble red, GLdouble green, GLdouble blue);
	extern void      		(APIENTRY *glColor3dv)(const GLdouble *v);
	extern void      		(APIENTRY *glColor3f)(GLfloat red, GLfloat green, GLfloat blue);
	extern void      		(APIENTRY *glColor3fv)(const GLfloat *v);
	extern void      		(APIENTRY *glColor3i)(GLint red, GLint green, GLint blue);
	extern void      		(APIENTRY *glColor3iv)(const GLint *v);
	extern void      		(APIENTRY *glColor3s)(GLshort red, GLshort green, GLshort blue);
	extern void      		(APIENTRY *glColor3sv)(const GLshort *v);
	extern void      		(APIENTRY *glColor3ub)(GLubyte red, GLubyte green, GLubyte blue);
	extern void      		(APIENTRY *glColor3ubv)(const GLubyte *v);
	extern void      		(APIENTRY *glColor3ui)(GLuint red, GLuint green, GLuint blue);
	extern void      		(APIENTRY *glColor3uiv)(const GLuint *v);
	extern void      		(APIENTRY *glColor3us)(GLushort red, GLushort green, GLushort blue);
	extern void      		(APIENTRY *glColor3usv)(const GLushort *v);
	extern void      		(APIENTRY *glColor4b)(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
	extern void      		(APIENTRY *glColor4bv)(const GLbyte *v);
	extern void      		(APIENTRY *glColor4d)(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
	extern void      		(APIENTRY *glColor4dv)(const GLdouble *v);
	extern void      		(APIENTRY *glColor4f)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	extern void      		(APIENTRY *glColor4fv)(const GLfloat *v);
	extern void      		(APIENTRY *glColor4i)(GLint red, GLint green, GLint blue, GLint alpha);
	extern void      		(APIENTRY *glColor4iv)(const GLint *v);
	extern void      		(APIENTRY *glColor4s)(GLshort red, GLshort green, GLshort blue, GLshort alpha);
	extern void      		(APIENTRY *glColor4sv)(const GLshort *v);
	extern void      		(APIENTRY *glColor4ub)(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
	extern void      		(APIENTRY *glColor4ubv)(const GLubyte *v);
	extern void      		(APIENTRY *glColor4ui)(GLuint red, GLuint green, GLuint blue, GLuint alpha);
	extern void      		(APIENTRY *glColor4uiv)(const GLuint *v);
	extern void      		(APIENTRY *glColor4us)(GLushort red, GLushort green, GLushort blue, GLushort alpha);
	extern void      		(APIENTRY *glColor4usv)(const GLushort *v);
	extern void      		(APIENTRY *glColorMask)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
	extern void      		(APIENTRY *glColorMaterial)(GLenum face, GLenum mode);
	extern void      		(APIENTRY *glColorPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	extern void      		(APIENTRY *glCopyPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
	extern void      		(APIENTRY *glCopyTexImage1D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
	extern void      		(APIENTRY *glCopyTexImage2D)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
	extern void      		(APIENTRY *glCopyTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
	extern void      		(APIENTRY *glCopyTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	extern void      		(APIENTRY *glCullFace)(GLenum mode);
	extern void      		(APIENTRY *glDeleteLists)(GLuint list, GLsizei range);
	extern void      		(APIENTRY *glDeleteTextures)(GLsizei n, const GLuint *textures);
	extern void      		(APIENTRY *glDepthFunc)(GLenum func);
	extern void      		(APIENTRY *glDepthMask)(GLboolean flag);
	extern void      		(APIENTRY *glDepthRange)(GLclampd zNear, GLclampd zFar);
	extern void      		(APIENTRY *glDisable)(GLenum cap);
	extern void      		(APIENTRY *glDisableClientState)(GLenum array);
	extern void      		(APIENTRY *glDrawArrays)(GLenum mode, GLint first, GLsizei count);
	extern void      		(APIENTRY *glDrawBuffer)(GLenum mode);
	extern void      		(APIENTRY *glDrawElements)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
	extern void      		(APIENTRY *glDrawPixels)(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	extern void      		(APIENTRY *glEdgeFlag)(GLboolean flag);
	extern void      		(APIENTRY *glEdgeFlagPointer)(GLsizei stride, const GLboolean *pointer);
	extern void      		(APIENTRY *glEdgeFlagv)(const GLboolean *flag);
	extern void      		(APIENTRY *glEnable)(GLenum cap);
	extern void      		(APIENTRY *glEnableClientState)(GLenum array);
	extern void      		(APIENTRY *glEnd)(void);
	extern void      		(APIENTRY *glEndList)(void);
	extern void      		(APIENTRY *glEvalCoord1d)(GLdouble u);
	extern void      		(APIENTRY *glEvalCoord1dv)(const GLdouble *u);
	extern void      		(APIENTRY *glEvalCoord1f)(GLfloat u);
	extern void      		(APIENTRY *glEvalCoord1fv)(const GLfloat *u);
	extern void      		(APIENTRY *glEvalCoord2d)(GLdouble u, GLdouble v);
	extern void      		(APIENTRY *glEvalCoord2dv)(const GLdouble *u);
	extern void      		(APIENTRY *glEvalCoord2f)(GLfloat u, GLfloat v);
	extern void      		(APIENTRY *glEvalCoord2fv)(const GLfloat *u);
	extern void      		(APIENTRY *glEvalMesh1)(GLenum mode, GLint i1, GLint i2);
	extern void      		(APIENTRY *glEvalMesh2)(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
	extern void				(APIENTRY *glEvalPoint1)(GLint i);
	extern void				(APIENTRY *glEvalPoint2)(GLint i, GLint j);
	extern void				(APIENTRY *glFeedbackBuffer)(GLsizei size, GLenum type, GLfloat *buffer);
	extern void				(APIENTRY *glFinish)(void);
	extern void				(APIENTRY *glFlush)(void);
	extern void				(APIENTRY *glFogf)(GLenum pname, GLfloat param);
	extern void				(APIENTRY *glFogfv)(GLenum pname, const GLfloat *params);
	extern void				(APIENTRY *glFogi)(GLenum pname, GLint param);
	extern void				(APIENTRY *glFogiv)(GLenum pname, const GLint *params);
	extern void				(APIENTRY *glFrontFace)(GLenum mode);
	extern void				(APIENTRY *glFrustum)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	extern GLuint			(APIENTRY *glGenLists)(GLsizei range);
	extern void				(APIENTRY *glGenTextures)(GLsizei n, GLuint *textures);
	extern void				(APIENTRY *glGetBooleanv)(GLenum pname, GLboolean *params);
	extern void				(APIENTRY *glGetClipPlane)(GLenum plane, GLdouble *equation);
	extern void				(APIENTRY *glGetDoublev)(GLenum pname, GLdouble *params);
	extern GLenum			(APIENTRY *glGetError)(void);
	extern void				(APIENTRY *glGetFloatv)(GLenum pname, GLfloat *params);
	extern void				(APIENTRY *glGetIntegerv)(GLenum pname, GLint *params);
	extern void				(APIENTRY *glGetLightfv)(GLenum light, GLenum pname, GLfloat *params);
	extern void				(APIENTRY *glGetLightiv)(GLenum light, GLenum pname, GLint *params);
	extern void				(APIENTRY *glGetMapdv)(GLenum target, GLenum query, GLdouble *v);
	extern void				(APIENTRY *glGetMapfv)(GLenum target, GLenum query, GLfloat *v);
	extern void				(APIENTRY *glGetMapiv)(GLenum target, GLenum query, GLint *v);
	extern void				(APIENTRY *glGetMaterialfv)(GLenum face, GLenum pname, GLfloat *params);
	extern void				(APIENTRY *glGetMaterialiv)(GLenum face, GLenum pname, GLint *params);
	extern void				(APIENTRY *glGetPixelMapfv)(GLenum map, GLfloat *values);
	extern void				(APIENTRY *glGetPixelMapuiv)(GLenum map, GLuint *values);
	extern void				(APIENTRY *glGetPixelMapusv)(GLenum map, GLushort *values);
	extern void				(APIENTRY *glGetPointerv)(GLenum pname, GLvoid* *params);
	extern void				(APIENTRY *glGetPolygonStipple)(GLubyte *mask);
	extern const GLubyte*	(APIENTRY *glGetString)(GLenum name);
	extern void				(APIENTRY *glGetTexEnvfv)(GLenum target, GLenum pname, GLfloat *params);
	extern void      		(APIENTRY *glGetTexEnviv)(GLenum target, GLenum pname, GLint *params);
	extern void      		(APIENTRY *glGetTexGendv)(GLenum coord, GLenum pname, GLdouble *params);
	extern void      		(APIENTRY *glGetTexGenfv)(GLenum coord, GLenum pname, GLfloat *params);
	extern void      		(APIENTRY *glGetTexGeniv)(GLenum coord, GLenum pname, GLint *params);
	extern void      		(APIENTRY *glGetTexImage)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
	extern void      		(APIENTRY *glGetTexLevelParameterfv)(GLenum target, GLint level, GLenum pname, GLfloat *params);
	extern void      		(APIENTRY *glGetTexLevelParameteriv)(GLenum target, GLint level, GLenum pname, GLint *params);
	extern void      		(APIENTRY *glGetTexParameterfv)(GLenum target, GLenum pname, GLfloat *params);
	extern void      		(APIENTRY *glGetTexParameteriv)(GLenum target, GLenum pname, GLint *params);
	extern void      		(APIENTRY *glHint)(GLenum target, GLenum mode);
	extern void      		(APIENTRY *glIndexMask)(GLuint mask);
	extern void      		(APIENTRY *glIndexPointer)(GLenum type, GLsizei stride, const GLvoid *pointer);
	extern void      		(APIENTRY *glIndexd)(GLdouble c);
	extern void      		(APIENTRY *glIndexdv)(const GLdouble *c);
	extern void      		(APIENTRY *glIndexf)(GLfloat c);
	extern void      		(APIENTRY *glIndexfv)(const GLfloat *c);
	extern void      		(APIENTRY *glIndexi)(GLint c);
	extern void      		(APIENTRY *glIndexiv)(const GLint *c);
	extern void      		(APIENTRY *glIndexs)(GLshort c);
	extern void      		(APIENTRY *glIndexsv)(const GLshort *c);
	extern void      		(APIENTRY *glIndexub)(GLubyte c);
	extern void      		(APIENTRY *glIndexubv)(const GLubyte *c);
	extern void      		(APIENTRY *glInitNames)(void);
	extern void      		(APIENTRY *glInterleavedArrays)(GLenum format, GLsizei stride, const GLvoid *pointer);
	extern GLboolean 		(APIENTRY *glIsEnabled)(GLenum cap);
	extern GLboolean 		(APIENTRY *glIsList)(GLuint list);
	extern GLboolean 		(APIENTRY *glIsTexture)(GLuint texture);
	extern void      		(APIENTRY *glLightModelf)(GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glLightModelfv)(GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glLightModeli)(GLenum pname, GLint param);
	extern void      		(APIENTRY *glLightModeliv)(GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glLightf)(GLenum light, GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glLightfv)(GLenum light, GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glLighti)(GLenum light, GLenum pname, GLint param);
	extern void      		(APIENTRY *glLightiv)(GLenum light, GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glLineStipple)(GLint factor, GLushort pattern);
	extern void      		(APIENTRY *glLineWidth)(GLfloat width);
	extern void      		(APIENTRY *glListBase)(GLuint base);
	extern void      		(APIENTRY *glLoadIdentity)(void);
	extern void      		(APIENTRY *glLoadMatrixd)(const GLdouble *m);
	extern void      		(APIENTRY *glLoadMatrixf)(const GLfloat *m);
	extern void      		(APIENTRY *glLoadName)(GLuint name);
	extern void      		(APIENTRY *glLogicOp)(GLenum opcode);
	extern void      		(APIENTRY *glMap1d)(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
	extern void      		(APIENTRY *glMap1f)(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
	extern void      		(APIENTRY *glMap2d)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
	extern void      		(APIENTRY *glMap2f)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
	extern void      		(APIENTRY *glMapGrid1d)(GLint un, GLdouble u1, GLdouble u2);
	extern void      		(APIENTRY *glMapGrid1f)(GLint un, GLfloat u1, GLfloat u2);
	extern void      		(APIENTRY *glMapGrid2d)(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
	extern void      		(APIENTRY *glMapGrid2f)(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
	extern void      		(APIENTRY *glMaterialf)(GLenum face, GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glMaterialfv)(GLenum face, GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glMateriali)(GLenum face, GLenum pname, GLint param);
	extern void      		(APIENTRY *glMaterialiv)(GLenum face, GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glMatrixMode)(GLenum mode);
	extern void      		(APIENTRY *glMultMatrixd)(const GLdouble *m);
	extern void      		(APIENTRY *glMultMatrixf)(const GLfloat *m);
	extern void      		(APIENTRY *glNewList)(GLuint list, GLenum mode);
	extern void      		(APIENTRY *glNormal3b)(GLbyte nx, GLbyte ny, GLbyte nz);
	extern void      		(APIENTRY *glNormal3bv)(const GLbyte *v);
	extern void      		(APIENTRY *glNormal3d)(GLdouble nx, GLdouble ny, GLdouble nz);
	extern void      		(APIENTRY *glNormal3dv)(const GLdouble *v);
	extern void      		(APIENTRY *glNormal3f)(GLfloat nx, GLfloat ny, GLfloat nz);
	extern void      		(APIENTRY *glNormal3fv)(const GLfloat *v);
	extern void      		(APIENTRY *glNormal3i)(GLint nx, GLint ny, GLint nz);
	extern void      		(APIENTRY *glNormal3iv)(const GLint *v);
	extern void      		(APIENTRY *glNormal3s)(GLshort nx, GLshort ny, GLshort nz);
	extern void      		(APIENTRY *glNormal3sv)(const GLshort *v);
	extern void      		(APIENTRY *glNormalPointer)(GLenum type, GLsizei stride, const GLvoid *pointer);
	extern void      		(APIENTRY *glOrtho)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	extern void      		(APIENTRY *glPassThrough)(GLfloat token);
	extern void      		(APIENTRY *glPixelMapfv)(GLenum map, GLint mapsize, const GLfloat *values);
	extern void      		(APIENTRY *glPixelMapuiv)(GLenum map, GLint mapsize, const GLuint *values);
	extern void      		(APIENTRY *glPixelMapusv)(GLenum map, GLint mapsize, const GLushort *values);
	extern void      		(APIENTRY *glPixelStoref)(GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glPixelStorei)(GLenum pname, GLint param);
	extern void      		(APIENTRY *glPixelTransferf)(GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glPixelTransferi)(GLenum pname, GLint param);
	extern void      		(APIENTRY *glPixelZoom)(GLfloat xfactor, GLfloat yfactor);
	extern void      		(APIENTRY *glPointSize)(GLfloat size);
	extern void      		(APIENTRY *glPolygonMode)(GLenum face, GLenum mode);
	extern void      		(APIENTRY *glPolygonOffset)(GLfloat factor, GLfloat units);
	extern void      		(APIENTRY *glPolygonStipple)(const GLubyte *mask);
	extern void      		(APIENTRY *glPopAttrib)(void);
	extern void      		(APIENTRY *glPopClientAttrib)(void);
	extern void      		(APIENTRY *glPopMatrix)(void);
	extern void      		(APIENTRY *glPopName)(void);
	extern void      		(APIENTRY *glPrioritizeTextures)(GLsizei n, const GLuint *textures, const GLclampf *priorities);
	extern void      		(APIENTRY *glPushAttrib)(GLbitfield mask);
	extern void      		(APIENTRY *glPushClientAttrib)(GLbitfield mask);
	extern void      		(APIENTRY *glPushMatrix)(void);
	extern void      		(APIENTRY *glPushName)(GLuint name);
	extern void      		(APIENTRY *glRasterPos2d)(GLdouble x, GLdouble y);
	extern void      		(APIENTRY *glRasterPos2dv)(const GLdouble *v);
	extern void      		(APIENTRY *glRasterPos2f)(GLfloat x, GLfloat y);
	extern void      		(APIENTRY *glRasterPos2fv)(const GLfloat *v);
	extern void      		(APIENTRY *glRasterPos2i)(GLint x, GLint y);
	extern void      		(APIENTRY *glRasterPos2iv)(const GLint *v);
	extern void      		(APIENTRY *glRasterPos2s)(GLshort x, GLshort y);
	extern void      		(APIENTRY *glRasterPos2sv)(const GLshort *v);
	extern void      		(APIENTRY *glRasterPos3d)(GLdouble x, GLdouble y, GLdouble z);
	extern void      		(APIENTRY *glRasterPos3dv)(const GLdouble *v);
	extern void      		(APIENTRY *glRasterPos3f)(GLfloat x, GLfloat y, GLfloat z);
	extern void      		(APIENTRY *glRasterPos3fv)(const GLfloat *v);
	extern void      		(APIENTRY *glRasterPos3i)(GLint x, GLint y, GLint z);
	extern void      		(APIENTRY *glRasterPos3iv)(const GLint *v);
	extern void      		(APIENTRY *glRasterPos3s)(GLshort x, GLshort y, GLshort z);
	extern void      		(APIENTRY *glRasterPos3sv)(const GLshort *v);
	extern void      		(APIENTRY *glRasterPos4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	extern void      		(APIENTRY *glRasterPos4dv)(const GLdouble *v);
	extern void      		(APIENTRY *glRasterPos4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	extern void      		(APIENTRY *glRasterPos4fv)(const GLfloat *v);
	extern void      		(APIENTRY *glRasterPos4i)(GLint x, GLint y, GLint z, GLint w);
	extern void      		(APIENTRY *glRasterPos4iv)(const GLint *v);
	extern void      		(APIENTRY *glRasterPos4s)(GLshort x, GLshort y, GLshort z, GLshort w);
	extern void      		(APIENTRY *glRasterPos4sv)(const GLshort *v);
	extern void      		(APIENTRY *glReadBuffer)(GLenum mode);
	extern void      		(APIENTRY *glReadPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
	extern void      		(APIENTRY *glRectd)(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
	extern void      		(APIENTRY *glRectdv)(const GLdouble *v1, const GLdouble *v2);
	extern void      		(APIENTRY *glRectf)(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
	extern void      		(APIENTRY *glRectfv)(const GLfloat *v1, const GLfloat *v2);
	extern void      		(APIENTRY *glRecti)(GLint x1, GLint y1, GLint x2, GLint y2);
	extern void      		(APIENTRY *glRectiv)(const GLint *v1, const GLint *v2);
	extern void      		(APIENTRY *glRects)(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
	extern void      		(APIENTRY *glRectsv)(const GLshort *v1, const GLshort *v2);
	extern GLint     		(APIENTRY *glRenderMode)(GLenum mode);
	extern void      		(APIENTRY *glRotated)(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
	extern void      		(APIENTRY *glRotatef)(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
	extern void      		(APIENTRY *glScaled)(GLdouble x, GLdouble y, GLdouble z);
	extern void      		(APIENTRY *glScalef)(GLfloat x, GLfloat y, GLfloat z);
	extern void      		(APIENTRY *glScissor)(GLint x, GLint y, GLsizei width, GLsizei height);
	extern void      		(APIENTRY *glSelectBuffer)(GLsizei size, GLuint *buffer);
	extern void      		(APIENTRY *glShadeModel)(GLenum mode);
	extern void      		(APIENTRY *glStencilFunc)(GLenum func, GLint ref, GLuint mask);
	extern void      		(APIENTRY *glStencilMask)(GLuint mask);
	extern void      		(APIENTRY *glStencilOp)(GLenum fail, GLenum zfail, GLenum zpass);
	extern void      		(APIENTRY *glTexCoord1d)(GLdouble s);
	extern void      		(APIENTRY *glTexCoord1dv)(const GLdouble *v);
	extern void      		(APIENTRY *glTexCoord1f)(GLfloat s);
	extern void      		(APIENTRY *glTexCoord1fv)(const GLfloat *v);
	extern void      		(APIENTRY *glTexCoord1i)(GLint s);
	extern void      		(APIENTRY *glTexCoord1iv)(const GLint *v);
	extern void      		(APIENTRY *glTexCoord1s)(GLshort s);
	extern void      		(APIENTRY *glTexCoord1sv)(const GLshort *v);
	extern void      		(APIENTRY *glTexCoord2d)(GLdouble s, GLdouble t);
	extern void      		(APIENTRY *glTexCoord2dv)(const GLdouble *v);
	extern void      		(APIENTRY *glTexCoord2f)(GLfloat s, GLfloat t);
	extern void      		(APIENTRY *glTexCoord2fv)(const GLfloat *v);
	extern void      		(APIENTRY *glTexCoord2i)(GLint s, GLint t);
	extern void      		(APIENTRY *glTexCoord2iv)(const GLint *v);
	extern void      		(APIENTRY *glTexCoord2s)(GLshort s, GLshort t);
	extern void      		(APIENTRY *glTexCoord2sv)(const GLshort *v);
	extern void      		(APIENTRY *glTexCoord3d)(GLdouble s, GLdouble t, GLdouble r);
	extern void      		(APIENTRY *glTexCoord3dv)(const GLdouble *v);
	extern void      		(APIENTRY *glTexCoord3f)(GLfloat s, GLfloat t, GLfloat r);
	extern void      		(APIENTRY *glTexCoord3fv)(const GLfloat *v);
	extern void      		(APIENTRY *glTexCoord3i)(GLint s, GLint t, GLint r);
	extern void      		(APIENTRY *glTexCoord3iv)(const GLint *v);
	extern void      		(APIENTRY *glTexCoord3s)(GLshort s, GLshort t, GLshort r);
	extern void      		(APIENTRY *glTexCoord3sv)(const GLshort *v);
	extern void      		(APIENTRY *glTexCoord4d)(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	extern void      		(APIENTRY *glTexCoord4dv)(const GLdouble *v);
	extern void      		(APIENTRY *glTexCoord4f)(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	extern void      		(APIENTRY *glTexCoord4fv)(const GLfloat *v);
	extern void      		(APIENTRY *glTexCoord4i)(GLint s, GLint t, GLint r, GLint q);
	extern void      		(APIENTRY *glTexCoord4iv)(const GLint *v);
	extern void      		(APIENTRY *glTexCoord4s)(GLshort s, GLshort t, GLshort r, GLshort q);
	extern void      		(APIENTRY *glTexCoord4sv)(const GLshort *v);
	extern void      		(APIENTRY *glTexCoordPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	extern void      		(APIENTRY *glTexEnvf)(GLenum target, GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glTexEnvfv)(GLenum target, GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glTexEnvi)(GLenum target, GLenum pname, GLint param);
	extern void      		(APIENTRY *glTexEnviv)(GLenum target, GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glTexGend)(GLenum coord, GLenum pname, GLdouble param);
	extern void      		(APIENTRY *glTexGendv)(GLenum coord, GLenum pname, const GLdouble *params);
	extern void      		(APIENTRY *glTexGenf)(GLenum coord, GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glTexGenfv)(GLenum coord, GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glTexGeni)(GLenum coord, GLenum pname, GLint param);
	extern void      		(APIENTRY *glTexGeniv)(GLenum coord, GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glTexImage1D)(GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	extern void      		(APIENTRY *glTexImage2D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	extern void      		(APIENTRY *glTexParameterf)(GLenum target, GLenum pname, GLfloat param);
	extern void      		(APIENTRY *glTexParameterfv)(GLenum target, GLenum pname, const GLfloat *params);
	extern void      		(APIENTRY *glTexParameteri)(GLenum target, GLenum pname, GLint param);
	extern void      		(APIENTRY *glTexParameteriv)(GLenum target, GLenum pname, const GLint *params);
	extern void      		(APIENTRY *glTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
	extern void      		(APIENTRY *glTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	extern void      		(APIENTRY *glTranslated)(GLdouble x, GLdouble y, GLdouble z);
	extern void      		(APIENTRY *glTranslatef)(GLfloat x, GLfloat y, GLfloat z);
	extern void      		(APIENTRY *glVertex2d)(GLdouble x, GLdouble y);
	extern void      		(APIENTRY *glVertex2dv)(const GLdouble *v);
	extern void      		(APIENTRY *glVertex2f)(GLfloat x, GLfloat y);
	extern void      		(APIENTRY *glVertex2fv)(const GLfloat *v);
	extern void      		(APIENTRY *glVertex2i)(GLint x, GLint y);
	extern void      		(APIENTRY *glVertex2iv)(const GLint *v);
	extern void      		(APIENTRY *glVertex2s)(GLshort x, GLshort y);
	extern void      		(APIENTRY *glVertex2sv)(const GLshort *v);
	extern void      		(APIENTRY *glVertex3d)(GLdouble x, GLdouble y, GLdouble z);
	extern void      		(APIENTRY *glVertex3dv)(const GLdouble *v);
	extern void      		(APIENTRY *glVertex3f)(GLfloat x, GLfloat y, GLfloat z);
	extern void      		(APIENTRY *glVertex3fv)(const GLfloat *v);
	extern void      		(APIENTRY *glVertex3i)(GLint x, GLint y, GLint z);
	extern void      		(APIENTRY *glVertex3iv)(const GLint *v);
	extern void      		(APIENTRY *glVertex3s)(GLshort x, GLshort y, GLshort z);
	extern void      		(APIENTRY *glVertex3sv)(const GLshort *v);
	extern void      		(APIENTRY *glVertex4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	extern void      		(APIENTRY *glVertex4dv)(const GLdouble *v);
	extern void      		(APIENTRY *glVertex4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	extern void      		(APIENTRY *glVertex4fv)(const GLfloat *v);
	extern void      		(APIENTRY *glVertex4i)(GLint x, GLint y, GLint z, GLint w);
	extern void      		(APIENTRY *glVertex4iv)(const GLint *v);
	extern void      		(APIENTRY *glVertex4s)(GLshort x, GLshort y, GLshort z, GLshort w);
	extern void      		(APIENTRY *glVertex4sv)(const GLshort *v);
	extern void      		(APIENTRY *glVertexPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	extern void      		(APIENTRY *glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);


	/*
		OpenGL 1.2 Win32 bindings
	*/
	extern BOOL				(APIENTRY *fnwglCopyContext)(HGLRC hglrcSrc, HGLRC hlglrcDst, UINT mask);
	extern HGLRC 			(APIENTRY *fnwglCreateContext)(HDC);
	extern BOOL  			(APIENTRY *fnwglDeleteContext)(HGLRC);
	extern PROC  			(APIENTRY *fnwglGetProcAddress)(LPCSTR);
	extern BOOL  			(APIENTRY *fnwglMakeCurrent)(HDC, HGLRC);
	
	extern BOOL  			(APIENTRY *wglSwapBuffers)(HDC);
	extern int   			(APIENTRY *wglChoosePixelFormat)(HDC, CONST PIXELFORMATDESCRIPTOR *);
	extern int   			(APIENTRY *wglDescribePixelFormat)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
	extern BOOL  			(APIENTRY *wglSetPixelFormat)(HDC, int, CONST PIXELFORMATDESCRIPTOR *);

    /*
        OpenGL Initialize
    */
	int						IsVoodooOpenGL();
	BOOL					IsOpenGLAccel(LPSTR lpszFileName);


	int						LoadOpenGLDriver(int nDriver);
	void					UnloadOpenGLDriver();

	LPSTR                   GetOpenGLDriverName(int nDriver);

	int						GetCurrentOpenGLDriver();
	LPSTR					GetCurrentOpenGLDriverName();

	HGLRC					CreateOpenGL(HDC hDC);
	void					DestroyOpenGL(HGLRC hRC);


	/*
		OpenGL Extensions.
	*/

/*****************************************************************************************************
**	GLX EXTENSIONS
*****************************************************************************************************/
#if defined __linux__
	// GLX_ARB_get_proc_address
	extern PFNGLXGETPROCADDRESSARB						glXGetProcAddressARB;
#endif

/*****************************************************************************************************
**	WGL EXTENSIONS
*****************************************************************************************************/

	// WGL_ARB_pixel_format
	extern PFNWGLGETPIXELFORMATATTRIBIVARBPROC			wglGetPixelFormatAttribivARB;
	extern PFNWGLGETPIXELFORMATATTRIBFVARBPROC			wglGetPixelFormatAttribfvARB;
	extern PFNWGLCHOOSEPIXELFORMATARBPROC				wglChoosePixelFormatARB;
	
	extern PFNWGLGETEXTENSIONSSTRINGARBPROC				wglGetExtensionsStringARB;
	
	// WGL_ARB_pbuffer	
	extern PFNWGLCREATEPBUFFERARBPROC					wglCreatePbufferARB;
	extern PFNWGLGETPBUFFERDCARBPROC					wglGetPbufferDCARB;
	extern PFNWGLRELEASEPBUFFERDCARBPROC				wglReleasePbufferDCARB;
	extern PFNWGLDESTROYPBUFFERARBPROC					wglDestroyPbufferARB;
	extern PFNWGLQUERYPBUFFERARBPROC					wglQueryPbufferARB;
	
	// WGL_ARB_render_texture	
	extern PFNWGLBINDTEXIMAGEARBPROC					wglBindTeximageARB;
	extern PFNWGLRELEASETEXIMAGEARBPROC					wglReleaseTeximageARB;
	extern PFNWGLSETPBUFFERATTRIBARBPROC				wglSetPbufferAttribARB;

	
	
/*****************************************************************************************************
**	EXT EXTENSIONS	
*****************************************************************************************************/

	// WGL_EXT_extensions_string
	extern PFNWGLGETEXTENSIONSSTRINGEXTPROC				wglGetExtensionsStringEXT;
	
	// WGL_EXT_pixel_format	
	extern PFNWGLGETPIXELFORMATATTRIBIVEXT				wglGetPixelFormatAttribivEXT;
	extern PFNWGLGETPIXELFORMATATTRIBFVEXT				wglGetPixelFormatAttribfvEXT;
	extern PFNWGLCHOOSEPIXELFORMATEXT					wglChoosePixelFormatEXT;
	
	// WGL_EXT_pbuffer	
	extern PFNWGLCREATEPBUFFEREXT 						wglCreatePbufferEXT;
	extern PFNWGLGETPBUFFERDCEXT						wglGetPbufferDCEXT;
	extern PFWGLRELEASEPBUFFERDCEXT						wglReleasePbufferDCEXT;
	extern PFWGLDESTROYPBUFFEREXT 						wglDestroyPbufferEXT;
	extern PFWGLQUERYPBUFFEREXT							wglQueryPbufferEXT;
	
	// WGL_EXT_swap_control	
	extern PFNWGLSWAPINTERVALEXTPROC					wglSwapIntervalEXT;
	extern PFNWGLGETSWAPINTERVALEXTPROC					wglGetSwapIntervalEXT;
		
	// GL_WIN_swap_hint		
	extern PFNGLADDSWAPHINTRECTWINPROC					glAddSwapHintRectWIN;	
	
	// GL_EXT_cull_vertex
	extern PFNGLCULLPARAMETERDVEXTPROC					glCullParameterdvEXT;
	extern PFNGLCULLPARAMETERFVEXTPROC					glCullParameterfvEXT;

	// GL_EXT_separate_specular_color		
	extern PFNGLSECONDARYCOLOR3UBVEXTPROC 				glSecondaryColor3ubvEXT;
	
	// GL_EXT_paletted_texture	
	extern PFNGLCOLORTABLEEXTPROC 						glColorTableEXT;

	// GL_EXT_point_parameters
	extern PFNGLPOINTPARAMETERFEXTPROC					glPointParameterfEXT;
	extern PFNGLPOINTPARAMETERFVEXTPROC					glPointParameterfvEXT;
	
	// GL_EXT_fog_coord	
	extern PFNGLFOGCOORDFEXTPROC						glFogCoordfEXT;
	
	// GL_EXT_compiled_vertex_array	
	extern PFNGLLOCKARRAYSEXTPROC 						glLockArraysEXT;
	extern PFNGLUNLOCKARRAYSEXTPROC						glUnlockArraysEXT;
	
	// GL_EXT_draw_range_elements	
	extern PFNGLDRAWRANGEELEMENTSEXTPROC				glDrawRangeElementsEXT;
	
	// GL_EXT_vertex_weighting
	extern PFNGLVERTEXWEIGHTFEXTPROC					glVertexWeightfEXT;
	extern PFNGLVERTEXWEIGHTFVEXTPROC 					glVertexWeightfvEXT;
	extern PFNGLVERTEXWEIGHTPOINTEREXTPROC				glVertexWeightPointerEXT;

	// GL_EXT_vertex_shader
	extern PFNGLBEGINVERTEXSHADEREXTPROC 				glBeginVertexShaderEXT;
	extern PFNGLENDVERTEXSHADEREXTPROC					glEndVertexShaderEXT;
	extern PFNGLBINDVERTEXSHADEREXTPROC					glBindVertexShaderEXT;
	extern PFNGLGENVERTEXSHADERSEXTPROC					glGenVertexShadersEXT;
	extern PFNGLDELETEVERTEXSHADEREXTPROC				glDeleteVertexShaderEXT;
	extern PFNGLSHADEROP1EXTPROC 						glShaderOp1EXT;
	extern PFNGLSHADEROP2EXTPROC 						glShaderOp2EXT; 												  
	extern PFNGLSHADEROP3EXTPROC 						glShaderOp3EXT;
	extern PFNGLSWIZZLEEXTPROC							glSwizzleEXT;
	extern PFNGLWRITEMASKEXTPROC 						glWriteMaskEXT;
	extern PFNGLINSERTCOMPONENTEXTPROC					glInsertComponentEXT;
	extern PFNGLEXTRACTCOMPONENTEXTPROC					glExtractComponentEXT;
	extern PFNGLGENSYMBOLSEXTPROC						glGenSymbolsEXT;
	extern PFNGLSETINVARIANTEXTPROC						glSetInvariantEXT;
	extern PFNGLSETLOCALCONSTANTEXTPROC					glSetLocalConstantEXT;
	extern PFNGLVARIANTBVEXTPROC 						glVariantbvEXT;
	extern PFNGLVARIANTSVEXTPROC 						glVariantsvEXT;
	extern PFNGLVARIANTIVEXTPROC 						glVariantivEXT;
	extern PFNGLVARIANTFVEXTPROC 						glVariantfvEXT;
	extern PFNGLVARIANTDVEXTPROC 						glVariantdvEXT;
	extern PFNGLVARIANTUBVEXTPROC						glVariantubvEXT;
	extern PFNGLVARIANTUSVEXTPROC						glVariantusvEXT;
	extern PFNGLVARIANTUIVEXTPROC						glVariantuivEXT;
	extern PFNGLVARIANTPOINTEREXTPROC					glVariantPointerEXT;
	extern PFNGLENABLEVARIANTCLIENTSTATEEXTPROC			glEnableVariantClientStateEXT;
	extern PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC		glDisableVariantClientStateEXT;
	extern PFNGLBINDLIGHTPARAMETEREXTPROC				glBindLightParameterEXT;
	extern PFNGLBINDMATERIALPARAMETEREXTPROC 			glBindMaterialParameterEXT;
	extern PFNGLBINDTEXGENPARAMETEREXTPROC				glBindTexGenParameterEXT;
	extern PFNGLBINDTEXTUREUNITPARAMETEREXTPROC			glBindTextureUnitParameterEXT;
	extern PFNGLBINDPARAMETEREXTPROC 					glBindParameterEXT;
	extern PFNGLISVARIANTENABLEDEXTPROC					glIsVariantEnabledEXT;
	extern PFNGLGETVARIANTBOOLEANVEXTPROC				glGetVariantBooleanvEXT;
	extern PFNGLGETVARIANTINTEGERVEXTPROC				glGetVariantIntegervEXT;
	extern PFNGLGETVARIANTFLOATVEXTPROC					glGetVariantFloatvEXT;
	extern PFNGLGETVARIANTPOINTERVEXTPROC				glGetVariantPointervEXT;
	extern PFNGLGETINVARIANTBOOLEANVEXTPROC				glGetInvariantBooleanvEXT;
	extern PFNGLGETINVARIANTINTEGERVEXTPROC				glGetInvariantIntegervEXT;
	extern PFNGLGETINVARIANTFLOATVEXTPROC				glGetInvariantFloatvEXT;
	extern PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC			glGetLocalConstantBooleanvEXT;
	extern PFNGLGETLOCALCONSTANTINTEGERVEXTPROC			glGetLocalConstantIntegervEXT;
	extern PFNGLGETLOCALCONSTANTFLOATVEXTPROC			glGetLocalConstantFloatvEXT;


/*********************************************************************************************************
**	ARB EXTENSIONS
*********************************************************************************************************/

	// GL_ARB_multisample
	extern PFNGLSAMPLECOVERAGEARBPROC					glSampleCoverageARB;
	
	// GL_ARB_transpose_matrix	
	extern PFNGLLOADTRANSPOSEMATRIXFARB					glLoadTransposeMatrixfARB;
	extern PFNGLMULTTRANSPOSEMATRIXFARB					glMultTransposeMatrixfARB;

	
	// GL_ARB_multitexture	
	extern PFNGLCLIENTACTIVETEXTUREARBPROC				glClientActiveTextureARB;
	extern PFNGLACTIVETEXTUREARBPROC 					glActiveTextureARB;
	extern PFNGLMULTITEXCOORD2FARBPROC					glMultiTexCoord2fARB;
	extern PFNGLMULTITEXCOORD4FARBPROC					glMultiTexCoord4fARB;
	extern PFNGLMULTITEXCOORD2FVARBPROC					glMultiTexCoord2fvARB;
	extern PFNGLMULTITEXCOORD4FVARBPROC					glMultiTexCoord4fvARB;
	
	// GL_ARB_compression	
	extern PFNGLCOMPRESSEDTEXIMAGE1DARB					glCompressedTexImage1DARB;
	extern PFNGLCOMPRESSEDTEXIMAGE2DARB					glCompressedTexImage2DARB;
	extern PFNGLCOMPRESSEDTEXIMAGE3DARB					glCompressedTexImage3DARB;
	extern PFNGLGETCOMPRESSEDTEXIMAGEARB 				glGetCompressedTexImageARB;
		
	// GL_ARB_vertex_blend		
	extern PFNGLWEIGHTBVARBPROC							glWeightbvARB;
	extern PFNGLWEIGHTSVARBPROC							glWeightsvARB;
	extern PFNGLWEIGHTIVARBPROC							glWeightivARB;
	extern PFNGLWEIGHTFVARBPROC							glWeightfvARB;
	extern PFNGLWEIGHTDVARBPROC							glWeightdvARB;
	extern PFNGLWEIGHTUBVARBPROC 						glWeightubvARB;
	extern PFNGLWEIGHTUSVARBPROC 						glWeightusvARB;
	extern PFNGLWEIGHTUIVARBPROC 						glWeightuivARB;
	extern PFNGLWEIGHTPOINTERARBPROC 					glWeightPointerARB;
	extern PFNGLVERTEXBLENDARBPROC						glVertexBlendARB;

	// GL_EXT_vertex_array
	extern PFNGLARRAYELEMENTEXTPROC						glArrayElementEXT;
	extern PFNGLCOLORPOINTEREXTPROC						glColorPointerEXT;
	extern PFNGLDRAWARRAYSEXTPROC						glDrawArraysEXT;
	extern PFNGLEDGEFLAGPOINTEREXTPROC					glEdgeFlagPointerEXT;
	extern PFNGLGETPOINTERVEXTPROC						glGetPointervEXT;
	extern PFNGLINDEXPOINTEREXTPROC						glIndexPointerEXT;
	extern PFNGLNORMALPOINTEREXTPROC					glNormalPointerEXT;
	extern PFNGLTEXCOORDPOINTEREXTPROC					glTexCoordPointerEXT;
	extern PFNGLVERTEXPOINTEREXTPROC					glVertexPointerEXT;
		
/*****************************************************************************************************
**	3DFX EXTENSIONS
*****************************************************************************************************/

	// GL_3DFX_tbuffer
	extern PGNGLTBUFFERMASK3DFX							glTbufferMask3DFX;


/*************************************************************************************************************
**	nVidia EXTENSIONS
**************************************************************************************************************/

	// NV_vertex_array_range
	extern PFNGLFLUSHVERTEXARRAYRANGENVPROC				glFlushVertexArrayRangeNV;
	extern PFNGLVERTEXARRAYRANGENVPROC					glVertexArrayRangeNV;
	extern PFNWGLALLOCATEMEMORYNVPROC					wglAllocateMemoryNV;
	extern PFNWGLFREEMEMORYNVPROC						wglFreeMemoryNV;
	
	// NV_fence
	extern PFNGLGENFENCESNVPROC							glGenFencesNV;
	extern PFNGLDELETEFENCESNVPROC						glDeleteFencesNV;
	extern PFNGLSETFENCENVPROC							glSetFenceNV;
	extern PFNGLTESTFENCENVPROC							glTestFenceNV;
	extern PFNGLFINISHFENCENVPROC						glFinishFenceNV;
	extern PFNGLISFENCENVPROC							glIsFenceNV;
	extern PFNGLGETFENCEIVNVPROC 						glGetFenceivNV;

	// GL_NV_ext_combine
	extern PFNGLCOMBINERPARAMETERFVNVPROC				glCombinerParameterfvNV;
	extern PFNGLCOMBINERPARAMETERIVNVPROC				glCombinerParameterivNV;
	extern PFNGLCOMBINERPARAMETERFNVPROC 				glCombinerParameterfNV;
	extern PFNGLCOMBINERPARAMETERINVPROC 				glCombinerParameteriNV;
	extern PFNGLCOMBINERINPUTNVPROC						glCombinerInputNV;
	extern PFNGLCOMBINEROUTPUTNVPROC 					glCombinerOutputNV;
	extern PFNGLFINALCOMBINERINPUTNVPROC 				glFinalCombinerInputNV;
	extern PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC		glGetCombinerInputParameterfvNV;
	extern PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC		glGetCombinerInputParameterivNV;
	extern PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC		glGetCombinerOutputParameterfvNV;
	extern PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC		glGetCombinerOutputParameterivNV;
	extern PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC	glGetFinalCombinerInputParameterfvNV;
	extern PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC	glGetFinalCombinerInputParameterivNV;

	// GL_NV_vertex_program (DX8 vertex shaders)
	extern PFNGLBINDPROGRAMNVPROC						glBindProgramNV;
	extern PFNGLDELETEPROGRAMSNVPROC 					glDeleteProgramsNV;
	extern PFNGLEXECUTEPROGRAMNVPROC 					glExecuteProgramNV;
	extern PFNGLGENPROGRAMSNVPROC						glGenProgramsNV;
	extern PFNGLAREPROGRAMSRESIDENTNVPROC				glAreProgramsResidentNV;
	extern PFNGLREQUESTRESIDENTPROGRAMSNVPROC			glRequestResidentProgramsNV;
	extern PFNGLGETPROGRAMPARAMETERFVNVPROC				glGetProgramParameterfvNV;
	extern PFNGLGETPROGRAMPARAMETERDVNVPROC				glGetProgramParameterdvNV;
	extern PFNGLGETPROGRAMIVNVPROC						glGetProgramivNV;
	extern PFNGLGETPROGRAMSTRINGNVPROC					glGetProgramStringNV;
	extern PFNGLGETTRACKMATRIXIVNVPROC					glGetTrackMatrixivNV;
	extern PFNGLGETVERTEXATTRIBDVNVPROC					glGetVertexAttribdvNV;
	extern PFNGLGETVERTEXATTRIBFVNVPROC					glGetVertexAttribfvNV;
	extern PFNGLGETVERTEXATTRIBIVNVPROC					glGetVertexAttribivNV;
	extern PFNGLGETVERTEXATTRIBPOINTERVNVPROC			glGetVertexAttribPointervNV;
	extern PFNGLISPROGRAMNVPROC							glIsProgramNV;
	extern PFNGLLOADPROGRAMNVPROC						glLoadProgramNV;
	extern PFNGLPROGRAMPARAMETER4FNVPROC 				glProgramParameter4fNV;
	extern PFNGLPROGRAMPARAMETER4DNVPROC 				glProgramParameter4dNV;
	extern PFNGLPROGRAMPARAMETER4DVNVPROC				glProgramParameter4dvNV;
	extern PFNGLPROGRAMPARAMETER4FVNVPROC				glProgramParameter4fvNV;
	extern PFNGLPROGRAMPARAMETERS4DVNVPROC				glProgramParameters4dvNV;
	extern PFNGLPROGRAMPARAMETERS4FVNVPROC				glProgramParameters4fvNV;
	extern PFNGLTRACKMATRIXNVPROC						glTrackMatrixNV;
	extern PFNGLVERTEXATTRIBPOINTERNVPROC				glVertexAttribPointerNV;
	extern PFNGLVERTEXATTRIB1SNVPROC 					glVertexAttrib1sNV;
	extern PFNGLVERTEXATTRIB1FNVPROC 					glVertexAttrib1fNV;
	extern PFNGLVERTEXATTRIB1DNVPROC 					glVertexAttrib1dNV;
	extern PFNGLVERTEXATTRIB2SNVPROC 					glVertexAttrib2sNV;
	extern PFNGLVERTEXATTRIB2FNVPROC 					glVertexAttrib2fNV;
	extern PFNGLVERTEXATTRIB2DNVPROC 					glVertexAttrib2dNV;
	extern PFNGLVERTEXATTRIB3SNVPROC 					glVertexAttrib3sNV;
	extern PFNGLVERTEXATTRIB3FNVPROC 					glVertexAttrib3fNV;
	extern PFNGLVERTEXATTRIB3DNVPROC 					glVertexAttrib3dNV;
	extern PFNGLVERTEXATTRIB4SNVPROC 					glVertexAttrib4sNV;
	extern PFNGLVERTEXATTRIB4FNVPROC 					glVertexAttrib4fNV;
	extern PFNGLVERTEXATTRIB4DNVPROC 					glVertexAttrib4dNV;
	extern PFNGLVERTEXATTRIB4UBNVPROC					glVertexAttrib4ubNV;
	extern PFNGLVERTEXATTRIB1SVNVPROC					glVertexAttrib1svNV;
	extern PFNGLVERTEXATTRIB1FVNVPROC					glVertexAttrib1fvNV;
	extern PFNGLVERTEXATTRIB1DVNVPROC					glVertexAttrib1dvNV;
	extern PFNGLVERTEXATTRIB2SVNVPROC					glVertexAttrib2svNV;
	extern PFNGLVERTEXATTRIB2FVNVPROC					glVertexAttrib2fvNV;
	extern PFNGLVERTEXATTRIB2DVNVPROC					glVertexAttrib2dvNV;
	extern PFNGLVERTEXATTRIB3SVNVPROC					glVertexAttrib3svNV;
	extern PFNGLVERTEXATTRIB3FVNVPROC					glVertexAttrib3fvNV;
	extern PFNGLVERTEXATTRIB3DVNVPROC					glVertexAttrib3dvNV;
	extern PFNGLVERTEXATTRIB4SVNVPROC					glVertexAttrib4svNV;
	extern PFNGLVERTEXATTRIB4FVNVPROC					glVertexAttrib4fvNV;
	extern PFNGLVERTEXATTRIB4DVNVPROC					glVertexAttrib4dvNV;
	extern PFNGLVERTEXATTRIB4UBVNVPROC					glVertexAttrib4ubvNV;
	extern PFNGLVERTEXATTRIBS1SVNVPROC					glVertexAttribs1svNV;
	extern PFNGLVERTEXATTRIBS1FVNVPROC					glVertexAttribs1fvNV;
	extern PFNGLVERTEXATTRIBS1DVNVPROC					glVertexAttribs1dvNV;
	extern PFNGLVERTEXATTRIBS2SVNVPROC					glVertexAttribs2svNV;
	extern PFNGLVERTEXATTRIBS2FVNVPROC					glVertexAttribs2fvNV;
	extern PFNGLVERTEXATTRIBS2DVNVPROC					glVertexAttribs2dvNV;
	extern PFNGLVERTEXATTRIBS3SVNVPROC					glVertexAttribs3svNV;
	extern PFNGLVERTEXATTRIBS3FVNVPROC					glVertexAttribs3fvNV;
	extern PFNGLVERTEXATTRIBS3DVNVPROC					glVertexAttribs3dvNV;
	extern PFNGLVERTEXATTRIBS4SVNVPROC					glVertexAttribs4svNV;
	extern PFNGLVERTEXATTRIBS4FVNVPROC					glVertexAttribs4fvNV;
	extern PFNGLVERTEXATTRIBS4DVNVPROC					glVertexAttribs4dvNV;
	extern PFNGLVERTEXATTRIBS4UBVNVPROC					glVertexAttribs4ubvNV;
		

/*************************************************************************************************************
**	ATI EXTENSIONS
*************************************************************************************************************/

	// GL_ATI_envmap_bumpmap
	extern PFNGLTEXBUMPPARAMETERIVATIPROC				glTexBumpParameterivATI;
	extern PFNGLTEXBUMPPARAMETERFVATIPROC				glTexBumpParameterfvATI;
	extern PFNGLGETTEXBUMPPARAMETERIVATIPROC 			glGetTexBumpParameterivATI;
	extern PFNGLGETTEXBUMPPARAMETERFVATIPROC 			glGetTexBumpParameterfvATI;
	
	// GL_ATI_envmap_bumpmap
	extern PFNGLGENFRAGMENTSHADERSATIPROC				glGenFragmentShadersATI;
	extern PFNGLBINDFRAGMENTSHADERATIPROC				glBindFragmentShaderATI;
	extern PFNGLDELETEFRAGMENTSHADERATIPROC				glDeleteFragmentShaderATI;
	extern PFNGLBEGINFRAGMENTSHADERATIPROC				glBeginFragmentShaderATI;
	extern PFNGLENDFRAGMENTSHADERATIPROC 				glEndFragmentShaderATI;
	extern PFNGLPASSTEXCOORDATIPROC						glPassTexCoordATI;
	extern PFNGLSAMPLEMAPATIPROC 						glSampleMapATI;
	extern PFNGLCOLORFRAGMENTOP1ATIPROC					glColorFragmentOp1ATI;
	extern PFNGLCOLORFRAGMENTOP2ATIPROC					glColorFragmentOp2ATI;
	extern PFNGLCOLORFRAGMENTOP3ATIPROC					glColorFragmentOp3ATI;
	extern PFNGLALPHAFRAGMENTOP1ATIPROC					glAlphaFragmentOp1ATI;
	extern PFNGLALPHAFRAGMENTOP2ATIPROC					glAlphaFragmentOp2ATI;
	extern PFNGLALPHAFRAGMENTOP3ATIPROC					glAlphaFragmentOp3ATI;
	extern PFNGLSETFRAGMENTSHADERCONSTANTATIPROC 		glSetFragmentShaderConstantATI; 

	// GL_ATI_pn_triangles
	extern PFNGLPNTRIANGLESIATIPROC						glPNTrianglesiATI;
	extern PFNGLPNTRIANGLESFATIPROC						glPNTrianglesfATI;

	// GL_ATI_vertex_array_object
	extern PFNGLMAPOBJECTBUFFERATI						glMapObjectBufferATI;
	extern PFNGLUNMAPOBJECTBUFFERATI					glUnmapObjectBufferATI;

	// GL_ATI_vertex_array_object
	extern PFNGLNEWOBJECTBUFFERATIPROC					glNewObjectBufferATI;
	extern PFNGLISOBJECTBUFFERATIPROC					glIsObjectBufferATI;
	extern PFNGLUPDATEOBJECTBUFFERATIPROC				glUpdateObjectBufferATI;									 
	extern PFNGLGETOBJECTBUFFERFVATIPROC 				glGetObjectBufferfvATI;
	extern PFNGLGETOBJECTBUFFERIVATIPROC 				glGetObjectBufferivATI;
	extern PFNGLFREEOBJECTBUFFERATIPROC					glFreeObjectBufferATI;
	extern PFNGLARRAYOBJECTATIPROC						glArrayObjectATI;
	extern PFNGLGETARRAYOBJECTFVATIPROC					glGetArrayObjectfvATI;
	extern PFNGLGETARRAYOBJECTIVATIPROC					glGetArrayObjectivATI;
	extern PFNGLVARIANTARRAYOBJECTATIPROC				glVariantArrayObjectATI;
	extern PFNGLGETVARIANTARRAYOBJECTFVATIPROC			glGetVariantArrayObjectfvATI;
	extern PFNGLGETVARIANTARRAYOBJECTIVATIPROC			glGetVariantArrayObjectivATI;

	// GL_ATI_element_array
	extern PFNGLELEMENTPOINTERATIPROC					glElementPointerATI;
	extern PFNGLDRAWELEMENTARRAYATIPROC					glDrawElementArrayATI;
	extern PFNGLDRAWRANGEELEMENTARRAYATIPROC 			glDrawRangeElementArrayATI;

	///////////////////////////////////////////////////////////////////////////
	void			CheckOpenGLExtensions();

	/*
		OpenGL Extensions.
	*/
	
	void			CheckOpenGLExtensions();

	// GL_3DFX
	extern BOOL		bIsGL_3DFX_tbuffer;

	// GL_ATI
	extern BOOL		bIsGL_ATI_vertex_array_object;
	extern BOOL		bIsGL_ATI_element_array;
	extern BOOL		bIsGL_ATI_map_object_buffer;
	extern BOOL		bIsGL_ATI_fragment_shader;
	extern BOOL		bIsGL_ATI_pn_triangles;
	extern BOOL		bIsGL_ATI_envmap_bumpmap;

	// GL_ARB_
	extern BOOL		bIsGL_ARB_multitexture;
	extern BOOL		bIsGL_ARB_texture_compression;
	extern BOOL		bIsGL_ARB_transpose_matrix;
	extern BOOL		bIsGL_ARB_vertex_blend;

	extern BOOL		bIsGL_ARB_texture_cube_map;
	extern BOOL		bIsGL_ARB_texture_env_add;

	// GL_EXT_
	extern BOOL		bIsGL_EXT_separate_specular_color;
	extern BOOL		bIsGL_EXT_fog_coord;
	extern BOOL		bIsGL_EXT_paletted_texture;
	extern BOOL		bIsGL_EXT_compiled_vertex_array;
	extern BOOL		bIsGL_EXT_draw_range_elements;
	extern BOOL		bIsGL_EXT_vertex_array;
	extern BOOL		bIsGL_EXT_vertex_shader;
	extern BOOL		bIsGL_EXT_vertex_weighting;

	extern BOOL		bIsGL_EXT_packed_pixels;				// adds packed pixel formats for glDrawPixels, glReadPixels, glTexImage, etc. 
	extern BOOL		bIsGL_EXT_point_parameters;
	extern BOOL		bIsGL_EXT_texture_compression_s3tc;
	extern BOOL		bIsGL_EXT_texture_env_combine;
	extern BOOL		bIsGL_EXT_cull_vertex;

	// GL_NV
	extern BOOL		bIsGL_NV_vertex_program;
	extern BOOL		bIsGL_NV_register_combiners;
	extern BOOL		bIsGL_NV_vertex_array_range;
	extern BOOL		bIsGL_NV_fence;

	// GL_S3
	extern BOOL		bIsGL_S3_s3tc;

	// GL_WIN
	extern BOOL		bIsGL_WIN_swap_hint;

	// WGL_EXT_
	extern BOOL		bIsWGL_EXT_swap_control;

	// WGL_3DFX
	extern BOOL		bIsWGL_3DFX_gamma_control;

	///////////////////////////////////////////////////////////////////////////
	extern GLint	iMAX_TEXTURE_SIZE;
	extern GLint	iMAX_ACTIVE_TEXTURES_ARB;

	extern BOOL		bIsOpenGLAccel;
	extern BOOL		bIsOpenGLMiniport;

#ifdef __cplusplus
}
#endif

#endif
