// Rasterizer.h: interface for the CRasterizer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RASTERIZER_H__EC0BA1EF_3A1A_4C7A_BA57_291D38E20906__INCLUDED_)
#define AFX_RASTERIZER_H__EC0BA1EF_3A1A_4C7A_BA57_291D38E20906__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

#include "OpenGL.h"

class CRasterizer : public CUnknown  
{
protected:
	HDC		m_hDC;
	HGLRC	m_hRC;

public:
	CRasterizer();
	virtual ~CRasterizer();

	virtual void Destroy();
	virtual bool Create(HDC hDC);

	virtual void Initialize();

	virtual void SetViewport(LONG x, LONG y, LONG width, LONG height);

	virtual void SetOrtho(LONG width, LONG height);
	virtual void SetPerspective(LONG width, LONG height);

	virtual void BeginScene();
	virtual void EndScene();

	virtual bool SetDisplayMode(DWORD dwWidth, DWORD dwHeight, USHORT bitsPerPel);
	virtual void RestoreDisplayMode();
};

#endif // !defined(AFX_RASTERIZER_H__EC0BA1EF_3A1A_4C7A_BA57_291D38E20906__INCLUDED_)
