// Scene.h: interface for the CScene class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCENE_H__9E54170A_962A_48A0_B32F_3EA8438506E1__INCLUDED_)
#define AFX_SCENE_H__9E54170A_962A_48A0_B32F_3EA8438506E1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Kernel.h"

class CCamera;
class CFont;
class CRasterizer;

class CScene : public CKernel  
{
protected:
	CCamera*		m_pCamera;
	CFont*			m_pFont;
	CRasterizer*	m_pRasterizer;

	int				m_iDriver;

	float			m_fFPS;
	POINT			m_ptMouse;

	DWORD			m_dwWidth, m_dwHeight;

protected:
	void UpdateFPS();

public:
	CScene();
	virtual ~CScene();

	virtual void Destroy();
	virtual bool Create(HDC hDC, DWORD dwWidth, DWORD dwHeight, USHORT bitsPerPel);

	virtual void Update();
	virtual void Render();

	virtual void Present();
};

#endif // !defined(AFX_SCENE_H__9E54170A_962A_48A0_B32F_3EA8438506E1__INCLUDED_)
