
#include "Common\FrameWnd.h"

#include "ZGLScene.h"

#define WIDTH	800
#define HEIGHT	600

int WINAPI WinMain(HINSTANCE	hInstance, 
				   HINSTANCE	hPrevInstance, 
				   LPSTR		pCmdLine,
				   int			nCmdShow)
{
	CFrameWnd frameWnd;
	if (!frameWnd.Create("Z3D Test", hInstance, WIDTH, HEIGHT))
		return 0;

	CZGLScene scene;
	if (!scene.Create(frameWnd.GetDC(), WIDTH, HEIGHT, 16))
		return 0;

    MSG	msg;

    while (TRUE)
    {
		// Look for messages, if none are found then 
		// update the state and display it
		if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if (!GetMessage(&msg, NULL, 0, 0))
				break;

			// Translate and dispatch the message
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else
		{
			if (CFrameWnd::m_bActive)
			{
				scene.Update();
				scene.Render();

				scene.Present();
			}
			else
			{
				// Make sure we go to sleep if we have nothing else to do
				WaitMessage();
			}
		}
    }

	scene.Destroy();
	frameWnd.Destroy();

    // WM_QUIT was posted, so exit
    return (int) msg.wParam;
}
