// ZGLScene.cpp: implementation of the CZGLScene class.
//
//////////////////////////////////////////////////////////////////////

#include "ZGLScene.h"

#include "Common\Timer.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CZGLScene::CZGLScene()
{
	m_pMeshFrame = NULL;
	m_pKeyFrame  = NULL;
}

CZGLScene::~CZGLScene()
{
	Destroy();
}

void CZGLScene::Destroy()
{
	if (m_pMeshFrame)
	{
		delete m_pMeshFrame;
		m_pMeshFrame = NULL;
	}

	if (m_pKeyFrame)
	{
		delete m_pKeyFrame;
		m_pKeyFrame = NULL;
	}

	CScene::Destroy();
}

bool CZGLScene::Create(HDC hDC, DWORD dwWidth, DWORD dwHeight, USHORT bitsPerPel)
{
	if (!CScene::Create(hDC, dwWidth, dwHeight, bitsPerPel))
		return false;

	// Load MeshFrame
	m_pMeshFrame = new CMeshFrame;
	if (!m_pMeshFrame)
		return false;


	if (!m_pMeshFrame->Load("2.MES"))
		return false;

	// Load KeyFrame
	m_pKeyFrame = new CKeyFrame;
	if (!m_pKeyFrame)
		return false;

	if (!m_pKeyFrame->Load("2.KNX"))
		return false;

	// Setup KeyFrame
	m_pMeshFrame->SetKeyFrame(m_pKeyFrame);

	return true;
}

void CZGLScene::Render()
{
	CScene::Render();
	
	m_pMeshFrame->Render();
}

void CZGLScene::Update()
{
	CScene::Update();

	static float fLastTick = 0;

	float fTime = Timer(TIMER_GETABSOLUTETIME);
	m_pKeyFrame->AdvanceFrame(fTime - fLastTick);

	m_pMeshFrame->Update();

	// Hold last tick
	fLastTick = fTime;
}
