#include "dxinclude.h"

//******************************************************************
//
// ViewFrustum class
//
class ViewFrustum {

	//clipping planes
	D3DXPLANE m_nr,m_fr;
	D3DXPLANE m_lf,m_rg;
	D3DXPLANE m_up,m_dn;

	//pointers to six clipping planes
	D3DXPLANE *plane[6]; 
	
	//coeficients for cylinder culling for each plane
	FLOAT	  cyl_plane[6];  	

	//perspective specs
	FLOAT m_fovy,m_asp,m_zn,m_zf; 

	//helper vals to compute the planes in world space
	D3DXVECTOR3 m_cpos; //camera position
	D3DXVECTOR3 m_cxpos;//camera x help position
	D3DXVECTOR3 m_cypos;//camera y help position
	
	D3DXVECTOR3 m_nypos; //near plane y pos
	D3DXVECTOR3 m_nxpos; //near plane x

	D3DXVECTOR3 m_nyopos; //near plane negative y pos
	D3DXVECTOR3 m_nxopos; //near plane negative x


	D3DXVECTOR3 m_ncpos; //near plane center
	D3DXVECTOR3 m_fcpos; //far near plane center
	
// Internal funcs
	float abs(float a) {return (a<0)?-a:a;}

	//compute the 6 plane cylinder factors
	void ComputeCylynderUp();

public:
	//curent possition of the camera
	D3DXVECTOR3 cam;       

	//curent vector of the camera
	D3DXVECTOR3 m_current; 

	//constructor 
	ViewFrustum();
	
	
	//is this point in the view frusturm
	bool IsVectorIn(const D3DXVECTOR3 &vec);

	//is this sphere intersects the frusturm :?
	//returns 0 if completely out 1 if intersects and 2 if fully in..
	BYTE IsSphereIn(const D3DXVECTOR3 &center,float radius);

	//same as sphere in but compute sqared distance and accepst a squared radius
	BYTE IsSphereInSQ(const D3DXVECTOR3 &center,float sqradius);

	//comptes intersection of cylinder to the view frusturm for up oriented cylinder
	BYTE IsCylinderUpIn(const D3DXVECTOR3 &center,float radius,float height,BYTE &binf);

	//set the perspecive specs of the frusturm
	void SetPerspectiveSpecs(FLOAT fovy, FLOAT Aspect, 
									FLOAT zn, FLOAT zf); 
    
	//set the view transformation...
	void SetViewTransform(D3DXMATRIX &mtx);
};