

#include "warjo_pscript.h"
#include <ctype.h>
//---------------------------------
// float
void PureScript::Map(float *pvar,char *name) 
{
ENTRY ep;
ep.type=T_FLOAT;
ep.pv=(void *)pvar;
strcpy(ep.name,name);
entries.push_back(ep);
}

//---------------------------------
// int
void PureScript::Map(int *pvar,char *name) 
{
ENTRY ep;
ep.type=T_INT;
ep.pv=(void *)pvar;
strcpy(ep.name,name);
entries.push_back(ep);
}

//---------------------------------
// char 
void PureScript::Map(char *pvar,char *name) 
{
ENTRY ep;
ep.type=T_STRING;
ep.pv=(void *)pvar;
strcpy(ep.name,name);
entries.push_back(ep);
}
//---------------------------------
// func
void PureScript::Mapf(void (*func)(),char *name) {
ENTRY ep;
ep.type=T_VFUNC;
ep.pv=(void *)func;
strcpy(ep.name,name);
entries.push_back(ep);
}

//---------------------------------
// Load a script
bool PureScript::Load(char *name) 
{
	FILE *fp=fopen(name,"rt");
	if (fp==NULL) return false;
	while(fgets(buf,1204,fp)) {
		pre_process();
		if (buf[0]) parse_line();
	}
	fclose(fp);
	return true;
}

//----------------------------------
void PureScript::pre_process()
{
	for(int i=0;buf[i]!=NULL;i++) {
		if ((buf[i]=='/')&&(buf[i]==buf[i+1])) break;
		if ((buf[i]==0xd)||(buf[i]==0xa)) break;
	}
	buf[i]=NULL;
}

//----------------------------------
void PureScript::parse_line()
{
	char *pb=buf;
	char szname[32];
	int i=0;
	while(isalpha(*pb)||isdigit(*pb)) {
		if (i==31) { //syntax error identifier longer than expected
			//LogErr("Bad identifier");
			return;
			}
		szname[i++]=*pb++;
	}
	szname[i]=NULL;
	while((*pb==' ')||(*pb==0x9)) pb++; //clear the white space
	
	VIENTRY it=entries.begin();
	while(true) {
		if (strcmp(it->name,szname)==0) {
			switch(it->type) {
				case T_FLOAT:
					*(float *)(it->pv)=atof(pb);
					break;
				case T_INT:
					*(int *)(it->pv)=atoi(pb);
					break;
				case T_STRING:
					strcpy((char *)(it->pv),pb);
					break;
				case T_VFUNC:
					unsigned int dwp=(unsigned int)(it->pv); 
					__asm {
						mov ebx,dwp
						call ebx
					}
			}
		}
		it++;
		if (it==entries.end()) { //indentifier was not in the list
			//LogErr("Unknown identifier");
			return;
		}
	}
}

bool PureScript::GetStrN(int n,char *szsrc,char *szdst)
{
	char *pb=szsrc;
	while (n>0) {
		while(isalpha(*pb)||isdigit(*pb)) pb++;	
		while((*pb==' ')||(*pb==0x9)) pb++; //clear the white space		
		if (*pb==NULL) return false;
		n--;
	}
	
	while(isalpha(*pb)||isdigit(*pb)) { *szdst++=*pb++;}
	*szdst=NULL;
	return true;
}