#include <vector>
#include "warjo_singleton.h"

//types of the entries in the pure script data base
#define T_FLOAT  1
#define T_INT	 2
#define T_STRING 3
#define T_VFUNC	16  //void function

//******************************************************************
//
// PureScript class
//
class PureScript:public Singleton<PureScript> {

	//the entry type
	typedef struct {
		unsigned char type;	// type of the entry
		char name[32];		//maximum 32 chars
		void *pv;			//pointer to the variable 
	} ENTRY;

	//typedefinition of vector an iterator container for the entry
	typedef std::vector<ENTRY> VENTRY;
	typedef std::vector<ENTRY>::iterator VIENTRY;

	//a vector of entries
	VENTRY entries;

	//internal buffer
	char buf[1024];

	//very very simple parser
	void pre_process();
	void parse_line();
public:
	//map functions
	void Map(float *pvar,char *name);
	void Map(int *pvar,char *name);
	void Map(char *pvar,char *name);
	void Mapf(void (*func)(),char *name);
	bool Load(char *filename);

	static bool GetStrN(int n,char *szsrc,char *szdst);
};

#define g_pscript PureScript::GetSingleton()