#include <stdio.h>
#include "warjo_roam_map.h"

//****************************************************************************
// 
// The patchmap class
//
//----------------------------------------------------------------------------
//
// construction/destruction
//
patchmap::patchmap() {
m_LVariance=NULL;
m_RVariance=NULL;
}

patchmap::~patchmap() {
if (m_LVariance!=NULL) delete [] m_LVariance;
if (m_RVariance!=NULL) delete [] m_RVariance;
}

//----------------------------------------------------------------------------
//
// GetH impements the basic map functionality
//
float patchmap::GetH(int cx,int cy) 
{
	//0.2f hard coded... why? damn i'm stupid....
	return ((float)m_HeightMap[cx+cy*m_width])*0.2f; 
}

//----------------------------------------------------------------------------
//
// init - creates the variance binary trees
// 
//        returns false on failure to allocate memory
//
bool patchmap::init(int width,int height,BYTE vdept) 
{
	//init the bariables
	m_width=width;
	m_height=height;
	m_vd=vdept;

	//get the height 
	int h=1<<(vdept+1);

	//allocate the space
	m_LVariance=new bte[h];
	if	(m_LVariance==NULL) {
		m_HeightMap=NULL;
		return false;
	}

	m_RVariance=new bte[h];
	if (m_RVariance==NULL) {
 		if	(m_LVariance!=NULL)
			delete [] m_LVariance; 
		m_HeightMap=NULL;
		return false;
	}
	
	return true;
}

//****************************************************************************
// 
// The patchmap class
//
//----------------------------------------------------------------------------
//
// construction/destruction
//
bmpatch::bmpatch(BYTE *bmp,int x,int y,int w,int h,int side) {
		//initialize members
		m_rx=x;
		m_ry=y;
		m_side=side;
		m_h=h;
		m_w=w;
		//initialize the parent member
		m_HeightMap=bmp;
		//init the patch map
		init(side,side,9);
	}

//----------------------------------------------------------------------------
//
// GetH 
//
float bmpatch::GetH(int cx,int cy) {
		//get the height at that point accordin to the position in the map
		return ((float)m_HeightMap[((cy+m_ry)*m_w)+(cx+m_rx)])*0.2f;
	}

//****************************************************************************
// 
// The bmpmap class
//
//----------------------------------------------------------------------------
//
// construction/destruction
//
bmpmap::bmpmap()
{
	pbmap=NULL;
}

bmpmap::~bmpmap()
{ 
	if (pbmap!=NULL) 
		free(pbmap);
}

//----------------------------------------------------------------------------
//
// Load the map from the bmp file
//
bool bmpmap::Load(char *szName)
{
	//bmp headers
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmch;

	//open the file
	FILE *fp=fopen(szName,"rb");
	if (fp==NULL) return false;

	//read the headers
	fread(&bmfh,sizeof(bmfh),1,fp);
	fread(&bmch,sizeof(bmch),1,fp);

	//allocate memory for the map
	pbmap=(BYTE *)malloc(bmch.biWidth*bmch.biHeight);

	//read the map
	for(int i=0;i<bmch.biWidth*bmch.biHeight;i++) {
		pbmap[i]=fgetc(fp);
		fgetc(fp);fgetc(fp);
	}

	//initialize members
	m_w=bmch.biWidth;
	m_h=bmch.biHeight;

	//close the file
	fclose(fp);

	return true;
}