#ifndef WJ_RMAP_H
#define WJ_RMAP_H
#include <windows.h>

//***************************************************************************
//
// general map class provides general map functionality
//
class general_map {
protected:
	//map dimentions
	int m_width,m_height;
public:
	//retrieve the dimentions
	int GetX() { return m_width;}
	int GetY() { return m_height;}

	//height at a point
	virtual float GetH(int cx,int cy) {return 0;};

	//normal at a point
//	virtual D3DXVECTOR3 *GetN(int cx,int cy);
};

//***************************************************************************
//binary tree entry
typedef struct {
	unsigned char var;			//agregated variance
	unsigned char height;       //maximum height
//	unsigned char texture;      //texture
} bte;

//***************************************************************************
//
// patchmap class is the base class for the patch
//		
//			implements GetH function
//
class patchmap: public general_map {
	
public:
	//pointer to the map
	BYTE *m_HeightMap;              

	// variance dept
	BYTE m_vd;
	
	// variance trees left & right 
	bte *m_LVariance,*m_RVariance; 

	//construction/destruction
	patchmap();
	~patchmap();

	//initialize the patchmap...
	bool init(int width,int height,BYTE vdept);

	//get the height at the cx,cy point
	float GetH(int cx,int cy);
};

//***************************************************************************
//
// bmppatch class - part of a larger map
//
class bmpatch: public patchmap {
	
	//position of the patch in the map
	int m_rx,m_ry;
	//width and height of the map
	int m_w,m_h;
	//side of the quadratic patch
	int m_side;
public:
	//constructor
	bmpatch(BYTE *bmp,int x,int y,int w,int h,int side);

	//virtual geth
	float GetH(int cx,int cy);
};

//***************************************************************************
//
// bmpmap 
//
// read a 24 bit windows bitmap and uses only the red part of it as a height 
//
class bmpmap {
	//dimentions of the map
	int m_w;
	int m_h;

public:
	//the height field
	BYTE *pbmap;

	//get dimentions
	int GetWidth() { return m_w;}
	int GetHeight() { return m_h;}

	//construction 
	bmpmap();

	//destruction 
	~bmpmap(); 

	//load the bitmap for the file
	bool Load(char *szName);
	
};
#endif