#ifndef WJO_TEXTURE_H
#define WJO_TEXTURE_H
#include "..\warjo_singleton.h"
#include <d3dx8.h>
#include <vector>
//********************************************************************
//
// the texture entry
//
typedef struct {
		//name for recreating the texture
		char name[32];
		
		//the texture
		LPDIRECT3DTEXTURE8		pTex;
		
		//the index buffer associated
		IDirect3DIndexBuffer8*	pIB;
		
		//number of primitives
		WORD wTris;
		WORD wni;
} WGTexture ;

//********************************************************************
//
// raw indices file chunk header
typedef struct {
		char name[32];
		WORD size;
} WGSave;

//********************************************************************
//
// Texture Manager - singleton class that is containing
//					 textrure handles and index buffers
// 
class TextureMngr:public Singleton<TextureMngr> {
	// STL container typedefs  
	typedef std::vector<WGTexture>::iterator Titer;
	std::vector<WGTexture> texs;

	// Direct3DDevice pointer 
	IDirect3DDevice8* p3DDev;

	// texture path
	char m_szTexturePath[256];
public:

	TextureMngr();

	// get the index buffer pointer
	IDirect3DIndexBuffer8* GetIndexStream(WORD texid) { if (texid<texs.size()) return texs[texid].pIB;else return NULL;}

	// get the texture pointer
	LPDIRECT3DTEXTURE8	GetTexture(WORD texid) {
		if (texid<texs.size()) 
			return texs[texid].pTex;
		else return NULL;
	}	

	// get the name of the texture
	char *GetTextureName(WORD texid) {
		if (texid<texs.size()) 
			return texs[texid].name;
		else return NULL;
	}

	// 
	WORD GetTris(WORD texid) {
			if (texid<texs.size()) 
			return texs[texid].wTris;
		else return 0;
	}

	// 
	void SetTris(WORD texid,WORD tri) {
		if (texid<texs.size()) 
			texs[texid].wTris=tri;
	}

	//add new texture - load from szName file and create "wni" index buffer
	WORD AddTexture(char *szName,WORD wni);

	//finds texture with name szName in the collection
	WORD FindTexture(char *szName);

	//get the number of textures
	WORD GetCount() {return texs.size();};

	//get triangle count
	WORD GetTriangleCount();
	
	//reset??!!
	void Reset();

	//Load indices and texture names from a row indices file
	bool LoadIndices(char *szName);

	//init devices
	void InitDevices(IDirect3DDevice8* dev);
	//discard devices
	void FreeDevices();
	//recreate devices
	void Recreate();
};

//global macros to axes the texture manager
#define g_texture TextureMngr::GetSingleton()

#endif