///////////////////////////////////////////////////////////////////////////////
//	Filename:	ImeInput.cpp
//	Coder	:	 (edithe@chollian.net) 
//	Comp.	:	EDITH
//	Compiler:	Visual C++ 6.0
//	Date	:	2002-09-10 11:01:04
//	Title	:   IME ̿ Է ƾ.
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ImeInput.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CImeInput::CImeInput()
{
	ClearBuffer();

	m_iSelectPos = m_iStart = m_iEnd = -1;

	m_bComp = FALSE;
	m_iCurCaretPos = 0;
	m_iSx = 0;
	m_iSy = 0;
	m_iWidth = 0;
	m_iHeight = 0;

	m_BackDC = NULL;
	m_BackBM = NULL;
	m_OldBackBM = NULL;

    SetFont((HFONT)GetStockObject( SYSTEM_FIXED_FONT ));
}

CImeInput::~CImeInput()
{
	if(m_BackDC != NULL)
	{
		DeleteObject(SelectObject(m_BackDC, m_OldBackBM));
		DeleteDC(m_BackDC);
	}
}

VOID CImeInput::OnCreate(HWND hParent, int X, int Y, int Width, int Height )
{
	m_hParent = hParent;

	m_iSx = X;
	m_iSy = Y;
	m_iWidth = Width;
	m_iHeight = Height;

	m_iCurCaretPos = 0;

	SetBkColor(RGB(255,255,255));
	SetTextColor(RGB(0,0,0));

	HDC hDC = GetDC(m_hParent);

	m_BackDC = CreateCompatibleDC(hDC);
	m_BackBM = CreateCompatibleBitmap(hDC, Width, Height);
	m_OldBackBM = (HBITMAP)SelectObject(m_BackDC, m_BackBM);

	ReleaseDC(m_hParent, hDC);

	OnCreateCaret(m_iSx, m_iSy, 1, m_iFHeight);
}

BOOL CImeInput::IMEMessage(HWND hWnd, UINT Msg, WPARAM wParam,LPARAM lParam)
{
	switch (Msg) 
	{
	case WM_IME_STARTCOMPOSITION:     //   . WM_IME_COMPOSITION ޽  غ Ѵ. 
		OnIMEStartComposition(wParam,lParam);
		OnPaint();
		return TRUE;
	case WM_IME_ENDCOMPOSITION:         //   . յ ڿ ó           break; 
		OnIMEEndComposition(wParam,lParam);
		OnPaint();
		return TRUE;
	case WM_IME_COMPOSITION:          //   ڿ̳ ϼ ڿ  ȭ 
		OnIMEComposition(wParam,lParam);
		OnPaint();
		return TRUE;
	case WM_IME_SETCONTEXT:			 //     ȯ 츦 ǥ ʰ ٲ
		lParam &= ~(ISC_SHOWUICOMPOSITIONWINDOW | ISC_SHOWUIALLCANDIDATEWINDOW);
		DefWindowProc(hWnd, WM_IME_SETCONTEXT, wParam, lParam);
		return TRUE;
	case WM_KEYDOWN:
		OnIMEKeyDown(wParam, lParam);
		OnPaint();
		return FALSE;
	case WM_KEYUP:
		OnIMEKeyUp(wParam, lParam);
		OnPaint();
		return FALSE;
	case WM_CHAR:
		OnIMEChar(wParam, lParam);
		OnPaint();
		return FALSE;
	}
	return FALSE;
}

INT CImeInput::GetStringWidth(char* String, int CaretPos, HFONT hFont)
{
	HDC hDC = ::GetDC(m_hParent);

	SIZE size;
    HFONT hOldFont = (HFONT)SelectObject(hDC, hFont);

	GetTextExtentPoint32(hDC, String, CaretPos, &size);

	SelectObject(hDC, hOldFont);
   ::ReleaseDC(m_hParent, hDC);

	return size.cx;
}

VOID CImeInput::OnPaint()
{
	HDC hDC = GetDC(m_hParent);

	POINT Point;
	::GetCaretPos(&Point);
	// Ʈ .
	HFONT hOldFont = (HFONT)SelectObject(m_BackDC, m_hFont);
	SetBkMode(m_BackDC, TRANSPARENT);
	//  
	HBRUSH  hbrBox, hbrOld;
	HPEN	hPen, hPenOld;
	hPen = CreatePen(PS_SOLID, 1, m_BkColor);
	hbrBox = CreateSolidBrush(m_BkColor);
	hbrOld = (HBRUSH)SelectObject(m_BackDC, hbrBox);
	hPenOld = (HPEN)SelectObject(m_BackDC, hPen);
	::Rectangle(m_BackDC, 0, 0, m_iWidth, m_iHeight);
	//  귯 
	DeleteObject(SelectObject(m_BackDC, hbrOld));
	DeleteObject(SelectObject(m_BackDC, hPenOld));
	// ڿ 
	TextOut(m_BackDC, 0, 0, m_String, strlen(m_String));

	// Select κ ׸.
	if(m_iStart != -1 && m_iEnd != -1)
	{
		int Sx,Sy,Ex,Ey;
		// ġ .
		int W = GetStringWidth(m_String, m_iStart, m_hFont);
		Sx = W;	// 
		Sy = 0;		
		W = GetStringWidth(m_String, m_iEnd, m_hFont);
		Ex = W;	// 
		Ey = m_iFHeight;
		//   ̰ 0 ƴϸ..
		if(abs(Ex-Sx) != 0)
		{
			int X = abs(Ex-Sx), Y = abs(Ey-Sy);
			HDC SelectDC = CreateCompatibleDC(hDC);
			HBITMAP SelectBM = CreateCompatibleBitmap(hDC, X, Y);
			HBITMAP OldSelectBM = (HBITMAP)SelectObject(SelectDC, SelectBM);
			//  귯 
			hPen = CreatePen(PS_SOLID, 1, m_BkColor);
			hbrBox = CreateSolidBrush(m_BkColor);
			hbrOld = (HBRUSH)SelectObject(SelectDC, hbrBox);
			hPenOld = (HPEN)SelectObject(SelectDC, hPen);
			::Rectangle(SelectDC, 0, 0, X, Y);
			//  귯 
			DeleteObject(SelectObject(SelectDC, hbrOld));
			DeleteObject(SelectObject(SelectDC, hPenOld));
			// BkColor ä DC XOR  Ų.(ϰ ȴ)
			BitBlt(m_BackDC, Sx, Sy, X, Y, SelectDC, 0, 0, SRCINVERT);
			// DC 
			DeleteObject(SelectObject(SelectDC, SelectBM));
			DeleteDC(SelectDC);
		}
	}
	SelectObject(m_BackDC, hOldFont);
	// ø ȭ鿡  ش.
	BitBlt(hDC, m_iSx, m_iSy, m_iWidth, m_iHeight, m_BackDC, 0, 0, SRCCOPY);
	// DC 
	ReleaseDC(m_hParent, hDC);
}

VOID CImeInput::OnIMEKeyUp(WPARAM wParam, LPARAM lParam)
{
	if(wParam == VK_SHIFT)
	{
		m_iSelectPos = -1;
	}
}

//------------------------------------------------------------------------------
// ѱ ù° Ʈ 1 ι°Ʈ 2  ̸ 0 ȯѴ.
//------------------------------------------------------------------------------
int CImeInput::IsHangul(char* OutText, int Len)
{
	if((int)strlen(OutText) < Len)
		return -1;

	enum TCodeType { ctError = -1, ctEng, ctFirst, ctLast };
	int i;
	TCodeType type = ctEng;

	for(i=0; OutText[i] != '\0'; i++)
	{
		if(type == ctFirst)
			type = ctLast;
		else
		{
			if(OutText[i] & 0x80)
				type = ctFirst;
			else type = ctEng;
		}
		if(i == Len) 
			return type;
	}
	return -1;
}

VOID CImeInput::OnIMEKeyDown(WPARAM wParam, LPARAM lParam)
{
	if(wParam == VK_SHIFT)
	{
		if(m_StringLen == 0)	return;
		//  Select κ 
		if(m_iStart == -1 && m_iEnd == -1)
		{
			m_iSelectPos = m_iCurCaretPos;
			m_iStart = m_iCurCaretPos;
			m_iEnd = m_iCurCaretPos;
		}
		else
		{	// Select  κ  ġ SelectPosġ ´.
			if(m_iCurCaretPos <= m_iStart)
				m_iSelectPos = m_iEnd;
			else
				m_iSelectPos = m_iStart;
		}
	}
	else if(wParam == VK_END)
	{
		if(m_iSelectPos == -1)
			m_iSelectPos = m_iStart = m_iEnd = -1;
		else
		{	//  Ʈ  ¿ End    Select Ѵ.
			if(m_iCurCaretPos <= m_iStart)	// Ŀ ʿ 
			{	
				m_iStart = m_iEnd;
			}
			m_iEnd = m_StringLen;
		}
		m_iCurCaretPos = m_StringLen;
		// ĳ ġ Ѵ.
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
	else if(wParam == VK_HOME)
	{
		if(m_iSelectPos == -1)
			m_iSelectPos = m_iStart = m_iEnd = -1;
		else
		{	//  Ʈ  ¿ End    Select Ѵ.
			if(m_iCurCaretPos >= m_iEnd)	// Ŀ ʿ 
			{	
				m_iEnd = m_iStart;
			}
			m_iStart = 0;
		}
		m_iCurCaretPos = 0;
		// ĳ ġ Ѵ.
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
	else if(wParam == VK_LEFT || wParam == VK_RIGHT)
	{	// ĳ ̵Ų.
		if(wParam == VK_LEFT)
		{	//  0̸ ̴.
			if(IsHangul(m_String, m_iCurCaretPos-1) == 0)	m_iCurCaretPos--;
			else											m_iCurCaretPos -= 2;

			if(m_iCurCaretPos < 0)	m_iCurCaretPos = 0;
		}
		else
		{	//  0̸ ̴.
			if(IsHangul(m_String, m_iCurCaretPos) == 0)		m_iCurCaretPos++;
			else											m_iCurCaretPos += 2;

			if(m_iCurCaretPos > (INT)strlen(m_String))
				m_iCurCaretPos = strlen(m_String);
		}
		// ĳ ġ Ѵ.
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
		//  Select̸..
		if(m_iSelectPos != -1)
		{	// ĳ ġ  Select ٲش.
			if(m_iCurCaretPos < m_iSelectPos)		m_iStart = m_iCurCaretPos;
			else if(m_iCurCaretPos > m_iSelectPos)	m_iEnd = m_iCurCaretPos;
			else 
			{
				m_iStart = m_iCurCaretPos;
				m_iEnd = m_iCurCaretPos;
			}
		}
		else
		{
			m_iSelectPos = -1;
			m_iStart = -1;
			m_iEnd = -1;
		}
	}
	else if(wParam == VK_DELETE || wParam == VK_BACK)
	{
		// Ʈ  κ  Ѵ.
		if(m_iStart != -1 && m_iEnd != -1)
		{
			if(abs(m_iEnd-m_iStart) == 0)
			{
				m_iSelectPos = m_iStart = m_iEnd = -1;
				return;
			}

			m_StringLen -= abs(m_iEnd-m_iStart);

			if(m_iCurCaretPos > m_iStart)
			{
				// ĳ ġ 
				m_iCurCaretPos -=  abs(m_iEnd-m_iStart);
				int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
				SetCaretPos( m_iSx+W, m_iSy );
			}

			if(m_StringLen == 0)
			{
				m_iSelectPos = m_iStart = m_iEnd = -1;
				ClearBuffer();
				return;
			}

			int Len = strlen(&m_String[m_iEnd]);
			memmove(&m_String[m_iStart], &m_String[m_iEnd], Len);
			ZeroMemory(&m_String[m_StringLen], abs(m_iEnd-m_iStart));

			m_iSelectPos = m_iStart = m_iEnd = -1;
			return;
		}

		int nTempPosition = 0;
		if(wParam == VK_DELETE)
		{
			// ڰ ų ĳ  ̸ 
			if(m_StringLen == 0 || m_iCurCaretPos == m_StringLen)
				return;

			if(m_String[m_iCurCaretPos] & 0x80)
			{
				nTempPosition = m_iCurCaretPos;
				m_StringLen = m_StringLen-2;
			}
			else
			{
				nTempPosition = m_iCurCaretPos;
				m_StringLen = m_StringLen-1;
			}
		}
		else if(wParam == VK_BACK)
		{
			// ڰ ų ĳ  ̸ 
			if(m_StringLen == 0 || m_iCurCaretPos == 0)
				return;

			if(m_String[m_iCurCaretPos-1] & 0x80)
			{
				nTempPosition = m_iCurCaretPos-2;
				m_StringLen = m_StringLen-2;
				m_iCurCaretPos -= 2;
			}
			else
			{
				nTempPosition = m_iCurCaretPos-1;
				m_StringLen = m_StringLen-1;
				m_iCurCaretPos -= 1;
			}
		}

		if(m_String[nTempPosition] & 0x80)
		{
			// ڸ Ѵ.
			int Len = strlen(&m_String[nTempPosition+2]);
			memmove(&m_String[nTempPosition], &m_String[nTempPosition+2], Len);
			ZeroMemory(&m_String[m_StringLen], 2);
		}
		else
		{
			// ڸ Ѵ.
			int Len = strlen(&m_String[nTempPosition+1]);
			memmove(&m_String[nTempPosition], &m_String[nTempPosition+1], Len);
			m_String[m_StringLen] = 0;
		}
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
}

VOID CImeInput::OnIMEChar(WPARAM wParam, LPARAM lParam)
{
	WORD wCode = (WORD)wParam;
	switch( wCode )
	{
	case '\r':
	case '\t':
	case '\b':
		return;
	}
	
	// ⼭ ѱ  ʰ  Ѵ.
	// ѱ  OnIMEComposition Ѵ.
	if((wCode & 0x80) == 0)
	{
		//  Ʈ Ǿ
		if(m_iStart != -1 && m_iEnd != -1)
		{
			OnIMEKeyDown(VK_DELETE, 0);
		}

		OnBackMove(1);

		//  1Ʈ  
		m_String[m_iCurCaretPos++] = wCode & 0xff;
		m_StringLen++;

		// ĳ ġ .
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
}

VOID CImeInput::OnBackMove(int Space, int Position)
{
	//    ̸  ʿ  ׳ Ѿ.
	if(m_iCurCaretPos == m_StringLen)
		return;

	if(Position == -1)
	{
		// ߰ ڸ Ѵ.
		int Len = strlen(&m_String[m_iCurCaretPos]);
		memmove(&m_String[m_iCurCaretPos+Space], &m_String[m_iCurCaretPos], Len);
	}
	else
	{
		// ߰ ڸ Ѵ.
		int Len = strlen(&m_String[Position]);
		memmove(&m_String[Position+Space], &m_String[Position], Len);
	}
}

VOID CImeInput::OnIMEStartComposition(WPARAM wParam, LPARAM lParam)
{
	//  Ʈ Ǿ
	// ׺κ .
	if(m_iStart != -1 && m_iEnd != -1)
	{
		OnIMEKeyDown(VK_DELETE, 0);
	}

	// ѱ Է ̹Ƿ ѱ  ĳ .
	// ĳ  .
	int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
	OnCreateCaret(m_iSx+W-m_iFWidth, m_iSy, m_iFWidth, m_iFHeight);

	m_bComp = TRUE;
	OnBackMove(2);
}

VOID CImeInput::OnIMEComposition(WPARAM wParam, LPARAM lParam)
{
	WORD wCode = (WORD)wParam;
	// ̷ ؾ ϴ ڸ ȭ鿡  ǥҼ ִ Ʋ 
	if(lParam == GCS_RESULTSTR) // ڰ ϼǾϴ..
	{
		DWORD len = 0;
		if (Enter()) 
		{
			if ((len = ImmGetCompositionString(m_hIMC, GCS_RESULTSTR, NULL, 0)) > 0) 
			{
				ImmGetCompositionString(m_hIMC, GCS_RESULTSTR, m_Comp, len);
			}
			Leave();
		}
		// ѱ ϶ ߰  .
		if(m_bComp)	OnBackMove(2);		// ѱ ϶ 2ĭ 
		else OnBackMove(len-2, m_iCurCaretPos+2);	// ѱ   .

		memcpy(m_String+m_iCurCaretPos, m_Comp, len);
		m_iCurCaretPos += len;
		m_StringLen += len;

		m_Comp[0] = m_Comp[1] = 0;

		// ⼱ ĳ̵
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
	else	// ڸ մϴ.
	{
		m_Comp[0] = wCode >> 8;
		m_Comp[1] = wCode & 0xff;
		m_String[m_iCurCaretPos] = m_Comp[0];
		m_String[m_iCurCaretPos+1] = m_Comp[1];

		// ⼱ ĳ̵
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
}

VOID CImeInput::OnIMEEndComposition(WPARAM wParam, LPARAM lParam)
{
	// ĳ  .
	// ѱ Է ϷǾǷ 1  ĳ .
	int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
	OnCreateCaret(m_iSx+W, m_iSy, 1, m_iFHeight);

	m_bComp = FALSE;
}

VOID CImeInput::OnCreateCaret(int X, int Y, int Width, int Height)
{
	// ĳ  .
    HideCaret( m_hParent );
    DestroyCaret();
    CreateCaret( m_hParent, NULL, Width, Height);
	int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
	SetCaretPos( X, Y );
    ShowCaret( m_hParent );
}
