// ImeInput.h: interface for the CImeInput class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IMEINPUT_H__BF32B6D7_08A6_4B92_B256_57B376CE91A9__INCLUDED_)
#define AFX_IMEINPUT_H__BF32B6D7_08A6_4B92_B256_57B376CE91A9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma comment(lib,"imm32.lib")
#include <imm.h>

#define MAX_STRING	128

class CImeInput  
{
	HWND	m_hParent;
	HIMC	m_hIMC;
	// Ʈ ؼ
	HFONT	m_hFont;
	INT		m_iFWidth;
	INT		m_iFHeight;
	// Select 
	INT		m_iSelectPos;
	INT		m_iStart;
	INT		m_iEnd;
	// ĳ ġ
	INT		m_iCurCaretPos;
	INT		m_iSx, m_iSy;
	INT		m_iWidth, m_iHeight;
	// ÷
	COLORREF m_BkColor;
	COLORREF m_TextColor;
	//  
	HDC		m_BackDC;
	HBITMAP m_BackBM;
	HBITMAP m_OldBackBM;
	// ѱ ΰ?
	BOOL	m_bComp;
	//  
	INT		m_StringLen;
	char	m_String[MAX_STRING];	//  Է  (ȭ鿡 ̴ )
	char	m_Comp[4];				// ȭ鿡 ϴ  

public:
	BOOL			IMEMessage(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam);
	inline BOOL Enter() {
		if(m_hParent != NULL)
			return (BOOL)(m_hIMC = ImmGetContext(m_hParent));
		else return FALSE;
	};
	inline void Leave() {
		ImmReleaseContext(m_hParent, m_hIMC);
	};
	inline VOID		SetBkColor(COLORREF BkColor) { m_BkColor = BkColor; }
	inline COLORREF	GetBkColor() { return m_BkColor; }
	inline COLORREF	GetTextColor() { return m_TextColor; }
	inline VOID		SetTextColor(COLORREF TextColor) { m_TextColor = TextColor; }
	inline VOID		SetParent(HWND Parent) { m_hParent = Parent; }
	inline HFONT	GetFont()	{ return m_hFont; }
	inline VOID		SetFont(HFONT Font) 
	{ 
		m_hFont = Font; 

		HDC hDC = ::GetDC(m_hParent);

		SIZE size;
		HFONT hOldFont = (HFONT)SelectObject(hDC, m_hFont);

		GetTextExtentPoint32(hDC, (char*)"", strlen(""), &size);

		SelectObject(hDC, hOldFont);

		::ReleaseDC(m_hParent, hDC);

		// Ʈ   ̸ Ѵ.
		m_iFWidth = (BYTE)size.cx;
		m_iFHeight = (BYTE)size.cy;
		OnCreateCaret(m_iSx, m_iSy, 1, m_iFHeight);
	}
	inline VOID		SetString(char* Str) 
	{ 
		strcpy(m_String, Str); 
		m_StringLen = strlen(m_String); 
		int W = GetStringWidth(m_String, m_StringLen, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
	}
	inline char*	GetString() { return m_String; }
	inline INT		GetStringLen() { return m_StringLen; }
	inline VOID		ClearBuffer() { m_StringLen = 0; ZeroMemory(m_String, MAX_STRING); }

	// Ÿ Լ
	int IsHangul(char* OutText, int Len);
	VOID OnCreate(HWND hParent, int X, int Y, int Width, int Height );
	VOID OnCreateCaret(int X, int Y, int Width, int Height);
	VOID OnPaint();
	INT GetStringWidth(char* String, int CaretPos, HFONT hFont);
	VOID OnBackMove(int Space, int Position = -1);
	inline VOID SetSel(int Start, int End)
	{
		m_iStart = Start;
		m_iEnd = End;
		if(Start == -1)
		{
			m_iStart = 0;
			m_iEnd = m_StringLen;
		}
		m_iCurCaretPos = m_iEnd;
		int W = GetStringWidth(m_String, m_iCurCaretPos, m_hFont);
		SetCaretPos( m_iSx+W, m_iSy );
		OnPaint();
	}

	// for IME Message 
	VOID OnIMEStartComposition(WPARAM wParam, LPARAM lParam);
	VOID OnIMEComposition(WPARAM wParam, LPARAM lParam);
	VOID OnIMEEndComposition(WPARAM wParam, LPARAM lParam);
	VOID OnIMEChar(WPARAM wParam, LPARAM lParam);
	VOID OnIMEKeyDown(WPARAM wParam, LPARAM lParam);
	VOID OnIMEKeyUp(WPARAM wParam, LPARAM lParam);

public:
	CImeInput();
	virtual ~CImeInput();

};

#endif // !defined(AFX_IMEINPUT_H__BF32B6D7_08A6_4B92_B256_57B376CE91A9__INCLUDED_)
