#include "inc.h"
#include <stdio.h>
#include <io.h>

char str[256];

struct _FileInfo {
	char Name[256];
	char UpperName[256];
	time_t WriteTime;
};
struct _FileInfo *SourceList;
int SourceTotal;

struct _FileInfo *TargetList;
int TargetTotal;


struct _FileInfo *CurrentFiles;
int CurrentTotal,CurrentAllocTotal;
void recurse_file_list(char RootPath[],char SubPath[],int CurrentDigLevel)
{
  int i,j;
  struct _finddata_t FindData;
  long Handle;
	char SearchPattern[256],DigPath[256];

	if (CurrentDigLevel>10) {
	  puts("10ܰ踦 ʰϴ 丮 ˻ Ұ");
		gets(str);
		exit(0);
	}

	sprintf(SearchPattern,"%s\\%s\\*.*",RootPath,SubPath);

	Handle=_findfirst(SearchPattern,&FindData);
	if (Handle<0) return;
	do {
		if (FindData.name[0]=='.') continue;
		if (stricmp(FindData.name,"")==0) continue;
		if (stricmp(FindData.name,"debug.txt")==0) continue;
		if (FindData.attrib&_A_SUBDIR) {
		  strcpy(DigPath,SubPath);
			strcat(DigPath,"\\");
			strcat(DigPath,FindData.name);
			recurse_file_list(RootPath,DigPath,CurrentDigLevel+1);
		}
		else {
		  sprintf(CurrentFiles[CurrentTotal].Name,"%s\\%s",SubPath,FindData.name);
		  sprintf(CurrentFiles[CurrentTotal].UpperName,"%s\\%s",SubPath,FindData.name);
			strupr(CurrentFiles[CurrentTotal].UpperName);
			CurrentFiles[CurrentTotal].WriteTime=FindData.time_write;
			CurrentTotal++;
			printf("%4d files\r",CurrentTotal);
			if (CurrentTotal==CurrentAllocTotal) {
			  CurrentAllocTotal+=500;
				CurrentFiles=(_FileInfo*)realloc(CurrentFiles,sizeof(CurrentFiles[0])*CurrentAllocTotal);
			}
		}
	} while (_findnext(Handle,&FindData)==0);
	_findclose(Handle);
}

void extract_pathname(char *FullFileName,int UpTotal,char **pName)
{
	int i;
	char *p1,*p2;

	p1=FullFileName; p2=FullFileName+strlen(FullFileName)-1;
	for (i=0;i<UpTotal+1;i++) {
		if (p2>p1) {
		  p2--;
			while (*p2!='\\' && p2>p1) p2--;
		}
	}
	if (p2==p1) {
	  *pName=(char *)malloc(1);
		(*pName)[0]=0;
	}
	else {
		*pName=(char *)malloc(strlen(FullFileName)+1);
	  strncpy(*pName,FullFileName,p2-p1);
		(*pName)[p2-p1]=0;
	}

	if ((*pName)[strlen(*pName)-1]==':') strcat(*pName,"\\");
}

void check_path_existence(char TargetFN[],int LenLimit)
{
  int i,j;
	char *Path;
	int MaxPath;

	for (i=10;i>=0;i--) {
	  extract_pathname(TargetFN,i,&Path);
		if (strlen(Path)>LenLimit) {
		  CreateDirectory(Path,NULL);
		}
	}
}

int get_file_index(char Name[],_FileInfo *List,int Total)
{
  int i,j;

	for (i=0;i<Total;i++) {
	  if (strcmp(Name,List[i].UpperName)==0) return i;
	}
	return -1;
}

char askif_file_exist(char FN[])
{
  int Result;
  struct _finddata_t FindData;

	Result=_findfirst(FN,&FindData);

	if (Result==-1) return 0;
	else {
	  _findclose(Result);
	  return 1;
	}
}

void main(int argc,char **argv)
{
	int i,j,Result;
	char *Paths[]={
	  "",
		"\\\\̶\\c\\work",
		"c:\\work"
	};
	char sfn[256],tfn[256],RecycledPath[256];
	SYSTEMTIME SystemTime;

//	argv=Paths;
//	argc=3;

	if (argc!=3) {
	  printf("Usage : datasync [source] [target]\n");
		gets(str);
		exit(0);
	}

//	printf("Datasync from '%s' to '%s'\n",argv[1],argv[2]);
//	printf("Press ENTER to continue\n"); gets(str);

	sprintf(RecycledPath,"%s\\",argv[2]);
	CreateDirectory(RecycledPath,NULL);

	GetLocalTime(&SystemTime);
	sprintf(RecycledPath,"%s\\\\%04d%02d%02d-%02dh%02dm%02ds",argv[2],SystemTime.wYear,SystemTime.wMonth,SystemTime.wDay,SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond);
	CreateDirectory(RecycledPath,NULL);
	printf("Recycled path is %s\n",RecycledPath);

	printf("Searching source '%s'\n",argv[1]);
	CurrentTotal=0; CurrentAllocTotal=1000;
	CurrentFiles=(_FileInfo*)malloc(sizeof(CurrentFiles[0])*CurrentAllocTotal);
	recurse_file_list(argv[1],".",0);
	SourceList=CurrentFiles; SourceTotal=CurrentTotal;
  if (CurrentTotal==0) {
	  printf("Error : source directory has no file\n");
		exit(0);
	}
	printf("%d files found.\n",SourceTotal);

	printf("Searching target '%s'\n",argv[2]);
	CurrentTotal=0; CurrentAllocTotal=1000;
	CurrentFiles=(_FileInfo*)malloc(sizeof(CurrentFiles[0])*CurrentAllocTotal);
	recurse_file_list(argv[2],".",0);
	TargetList=CurrentFiles; TargetTotal=CurrentTotal;
	printf("%d files found.\n",TargetTotal);

//	puts("Press ENTER to continue"); gets(str);

	int Index,RecycleCounter=0;
	for (i=0;i<SourceTotal;i++) {
	  printf("Checking %d/%d\r",i+1,SourceTotal);
	  Index=get_file_index(SourceList[i].UpperName,TargetList,TargetTotal);
		if (Index<0) {
		  printf(" : %s\n",SourceList[i].Name);
			sprintf(sfn,"%s\\%s",argv[1],SourceList[i].Name);
			sprintf(tfn,"%s\\%s",argv[2],SourceList[i].Name);	check_path_existence(tfn,strlen(argv[2]));
			Result=CopyFile(sfn,tfn,TRUE);
			if (Result==0) {
			  printf(": Copying %s to %s failed\n",sfn,tfn);
				gets(str);
			}
		}
		else
	  if (SourceList[i].WriteTime>TargetList[Index].WriteTime) {
		  printf("Ʈ : %s\n",SourceList[i].Name);
			sprintf(sfn,"%s\\%s",argv[2],SourceList[i].Name);
			sprintf(tfn,"%s\\%s",RecycledPath,SourceList[i].Name); check_path_existence(tfn,strlen(RecycledPath));
			Result=MoveFile(sfn,tfn);
			if (Result==0) {
			  printf(" Moving %s to %s failed\n",sfn,tfn);
				gets(str);
			}
			else RecycleCounter++;

			sprintf(sfn,"%s\\%s",argv[1],SourceList[i].Name);
			sprintf(tfn,"%s\\%s",argv[2],SourceList[i].Name);	check_path_existence(tfn,strlen(argv[2]));
			Result=CopyFile(sfn,tfn,TRUE);
			if (Result==0) {
			  printf(" Copying %s to %s failed\n",sfn,tfn);
				gets(str);
			}
		}
	}

	for (i=0;i<TargetTotal;i++) {
	  printf("  üũ %d/%d\r",i+1,TargetTotal);
		Index=get_file_index(TargetList[i].UpperName,SourceList,SourceTotal);
		if (Index<0) {
		  printf("  () : %s\n",TargetList[i].Name);
			sprintf(sfn,"%s\\%s",argv[2],TargetList[i].Name);
			sprintf(tfn,"%s\\%s",RecycledPath,TargetList[i].Name); check_path_existence(tfn,strlen(RecycledPath));
			Result=MoveFile(sfn,tfn);
			if (Result==0) {
			  printf(" Moving %s to %s failed\n",sfn,tfn);
				gets(str);
			}
			else RecycleCounter++;
		}
	}

	if (RecycleCounter==0) {
	  RemoveDirectory(RecycledPath);
	}

	puts("                                                              \rPress ENTER to exit");
	gets(str);
}
