#include "gpdef.h"
#include "gpgraphic.h"

int GpBitBlt16( GPDRAWTAG *gptag, GPDRAWSURFACE *ptgpds, int dx, int dy, int width, int height,
				unsigned char * src, int sx, int sy,int imgw, int imgh )
{
	uword *video = (uword*)ptgpds->ptbuffer;
	uword *target, *source;
	int xx, yy, i;

	if( dx < 0 )	{ sx = -dx;	dx += sx; }
	if( dy < 0 )	{ sy = -dy; dy += sy; }

	if( dx + width > ptgpds->buf_w )	width  -= ( dx + width )  - ptgpds->buf_w  + 1;
	if( dy + height > ptgpds->buf_h )	height -= ( dy + height ) - ptgpds->buf_h + 1;

	xx = width  - sx + 1;
	yy = height - sy + 1;

	target = video       + dx * ptgpds->buf_h + ptgpds->buf_h - ( dy + yy - 1 ) + 1;
	source = (uword*)src + sx * imgh          + imgh          - ( sy + yy - 1 ) + 1;

	for( i = 0 ; i < xx ; i++ )
	{
		gm_memcpy( target, source, yy * 2 );
		target += ptgpds->buf_h;
		source += imgh;
	}
}

int GpTransBlt16( GPDRAWTAG *gptag, GPDRAWSURFACE *ptgpds, int dx, int dy, int width, int height,
				unsigned char * src, int sx, int sy,int imgw, int imgh, int color )
{
	uword *video = (uword*)ptgpds->ptbuffer;
	uword *target, *source;
	int xx, yy, i, j;
	uword data;

	if( dx < 0 )	{ sx = -dx;	dx += sx; }
	if( dy < 0 )	{ sy = -dy; dy += sy; }

	if( dx + width > ptgpds->buf_w )	width  -= ( dx + width )  - ptgpds->buf_w  + 1;
	if( dy + height > ptgpds->buf_h )	height -= ( dy + height ) - ptgpds->buf_h + 1;

	xx = width  - sx + 1;
	yy = height - sy + 1;

	target = video       + dx * ptgpds->buf_h + ptgpds->buf_h - ( dy + yy - 1 ) + 1;
	source = (uword*)src + sx * imgh          + imgh          - ( sy + yy - 1 ) + 1;

	for( i = 0 ; i < xx ; i++ )
	{
		for( j = 0 ; j < yy ; j++ )
		{
			data = source[j];
			if( data != color )	target[j] = data;
		}

		target += ptgpds->buf_h;
		source += imgh;
	}
}
