#include "gpdef.h"
#include "gpstdio.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "graphic16.h"

#define LCD_WIDTH	GPC_LCD_WIDTH
#define LCD_HEIGHT	GPC_LCD_HEIGHT

#define COLOR_R( c )	( ( (c) >> 11 ) & 0x1F )
#define COLOR_G( c )	( ( (c) >> 6 ) & 0x1F )
#define COLOR_B( c )	( ( (c) >> 1 ) & 0x1F )

GPDRAWSURFACE gpDraw[2];
int nflip = 0;

ubyte *img_back = NULL;

ubyte HANFONT[2350][32];
ubyte ENGFONT[256][16];

void draw_box( int x, int y, int w, int h, int color )
{
	uword *video = (uword*)gpDraw[nflip].ptbuffer;
	uword *target;
	int i, j;

	for( i = 0 ; i < w ; i++ )
	{
		target = video + ( x + i ) * LCD_HEIGHT + LCD_HEIGHT - ( y + h - 1 ) - 1;
		for( j = 0 ; j < h ; j++ )	*target++ = color;
	}
}

void draw_box_alpha( int x, int y, int w, int h, int color, int alpha )
{
	uword *video = (uword*)gpDraw[nflip].ptbuffer;
	uword *target = video + x * LCD_HEIGHT + LCD_HEIGHT - ( y + h - 1 ) - 1;
	ubyte r, g, b;
	int beta = 100 - alpha;
	int i, j;

	for( i = 0 ; i < w ; i++ )
	{
		for( j = 0 ; j < h ; j++ )
		{
			r = COLOR_R( color ) * alpha / 100 + COLOR_R( *target ) * beta / 100;
			g = COLOR_G( color ) * alpha / 100 + COLOR_G( *target ) * beta / 100;
			b = COLOR_B( color ) * alpha / 100 + COLOR_B( *target ) * beta / 100;
			*target++ = ( r << 11 ) | ( g << 6 ) | ( b << 1 );
		}
		target += LCD_HEIGHT - h;
	}
}

ubyte *read_image( char *name )
{
	ubyte *image = NULL;
	ulong size, rcount;
	F_HANDLE h_file;

	GpFileGetSize( name, &size );

	GpFileOpen( name, OPEN_R, &h_file );
	image = gp_mem_func.malloc( size );
	GpFileRead( h_file, image, size, &rcount );
	GpFileClose( h_file );

	return image;
}

void put_image( int x, int y, ubyte *image )
{
	if( image )
	{
		int width = *(word*)image;
		int height = *(word*)( image + 2 );
		GpBitBlt( NULL, &gpDraw[nflip], x, y, width, height, image + 4, 0, 0, width, height );
	}
}

void put_sprite( int x, int y, ubyte *image )
{
	if( image )
	{
		int width = *(word*)image;
		int height = *(word*)( image + 2 );
		GpTransBlt( NULL, &gpDraw[nflip], x, y, width, height, image + 4, 0, 0, width, height, 0xFF );
	}
}

void load_font( char *han, char *eng )
{
	F_HANDLE fh;
	ulong rcount;

	GpFileOpen( han, OPEN_R, &fh );
	GpFileRead( fh, HANFONT, 2350 * 32, &rcount );
	GpFileClose( fh );

	GpFileOpen( eng, OPEN_R, &fh );
	GpFileRead( fh, ENGFONT, 256 * 16, &rcount );
	GpFileClose( fh );
}

void put_eng_font( int x, int y, ubyte *font, uword color )
{
	int i;
	uword *video = (uword*)gpDraw[nflip].ptbuffer + x * LCD_HEIGHT + LCD_HEIGHT - y - 1;

	for( i = 0 ; i < 16 ; i++ )
	{
		if( *font )
		{
			if( *font & 0x80 )	*video                      = color;
			if( *font & 0x40 )	*( video + LCD_HEIGHT     ) = color;
			if( *font & 0x20 )	*( video + LCD_HEIGHT * 2 ) = color;
			if( *font & 0x10 )	*( video + LCD_HEIGHT * 3 ) = color;
			if( *font & 0x08 )	*( video + LCD_HEIGHT * 4 ) = color;
			if( *font & 0x04 )	*( video + LCD_HEIGHT * 5 ) = color;
			if( *font & 0x02 )	*( video + LCD_HEIGHT * 6 ) = color;
			if( *font & 0x01 )	*( video + LCD_HEIGHT * 7 ) = color;
		}
		video--;
		font++;
	}
}

void put_han_font( int x, int y, ubyte *font, uword color )
{
	int i;
	uword *video = (uword*)gpDraw[nflip].ptbuffer + x * LCD_HEIGHT + LCD_HEIGHT - y - 1;

	for( i = 0 ; i < 16 ; i++ )
	{
		if( *font )
		{
			if( *font & 0x80 )	*video                      = color;
			if( *font & 0x40 )	*( video + LCD_HEIGHT     ) = color;
			if( *font & 0x20 )	*( video + LCD_HEIGHT * 2 ) = color;
			if( *font & 0x10 )	*( video + LCD_HEIGHT * 3 ) = color;
			if( *font & 0x08 )	*( video + LCD_HEIGHT * 4 ) = color;
			if( *font & 0x04 )	*( video + LCD_HEIGHT * 5 ) = color;
			if( *font & 0x02 )	*( video + LCD_HEIGHT * 6 ) = color;
			if( *font & 0x01 )	*( video + LCD_HEIGHT * 7 ) = color;
		}
		video += LCD_HEIGHT * 8;
		font++;
		if( *font )
		{
			if( *font & 0x80 )	*video                      = color;
			if( *font & 0x40 )	*( video + LCD_HEIGHT     ) = color;
			if( *font & 0x20 )	*( video + LCD_HEIGHT * 2 ) = color;
			if( *font & 0x10 )	*( video + LCD_HEIGHT * 3 ) = color;
			if( *font & 0x08 )	*( video + LCD_HEIGHT * 4 ) = color;
			if( *font & 0x04 )	*( video + LCD_HEIGHT * 5 ) = color;
			if( *font & 0x02 )	*( video + LCD_HEIGHT * 6 ) = color;
			if( *font & 0x01 )	*( video + LCD_HEIGHT * 7 ) = color;
		}
		video -= LCD_HEIGHT * 8;
		video--;
		font++;
	}
}

void hputs( int x, int y, uword color, char *s )
{
	int i;
	ubyte data, data2;
	int index;

	for( i = 0 ; i < strlen( s ) ; i++ )
	{
		data = s[i];

		if( data & 0x80 )
		{
			data2 = s[++i];
			index = ( data - 0xB0 ) * 94 + data2 - 0xA1;
			put_han_font( x, y, HANFONT[index], color );
			x += 16;
		}
		else
		{
			put_eng_font( x, y, ENGFONT[data], color );
			x += 8;
		}
	}
}

void GpMain( void *arg )
{
	GpGraphicModeSet( 16, NULL );
	GpLcdSurfaceGet( &gpDraw[0], 0 );
	GpLcdSurfaceGet( &gpDraw[1], 1 );

	GpSurfaceSet( &gpDraw[0] );

	if ( !( GPC_LCD_ON_BIT & GpLcdStatusGet() ) )	GpLcdEnable();

	GpFatInit();

	img_back = read_image( "gp:\\game\\data\\back16.img" );

	while( 1 )
	{
		put_image( 0, 0, img_back );

		GpSurfaceFlip( &gpDraw[nflip++] );
		nflip %= 2;
	}
}
