/*
	AcceptThread.cpp
*/

#include "Thread.h"
#include "Global.h"

#define SERVER_PORT 8000


//
// AcceptThread
//
DWORD _stdcall AcceptThread( void* agr )
{
	
	printf( "AcceptThread Start...\n" );

	SOCKET		nServerSocket;
	SOCKADDR_IN addrServer;
	fd_set		fdRecv;

	// DLL Setup
	WSADATA wsaData;

	if( WSAStartup( 0x202, &wsaData ) < 0 )
	{
		printf( "DLL ERROR : WSAStartup(); \n" );
		return FALSE;
	}

	int nAddrSize = sizeof( SOCKADDR_IN );

	//- Socket Init
	nServerSocket = socket( AF_INET, SOCK_STREAM, 6 );

	if( nServerSocket <= 0 )
	{
		printf( "Socket Error\n" );
		return FALSE;
	}

	memset( &addrServer, 0, sizeof( addrServer ) );

	addrServer.sin_family      = AF_INET;
	addrServer.sin_addr.s_addr = htonl( INADDR_ANY );		// (TODO)ServerIP Defin Ѵ.
	addrServer.sin_port        = htons( SERVER_PORT );

	//- Bind
	if( bind( nServerSocket, (struct sockaddr*)&addrServer, nAddrSize ) < 0 )
	{
		return FALSE;
	}

	//- Listen
	if( listen( nServerSocket, SOMAXCONN ) < 0 )
	{
		return FALSE;
	}
		
	timeval time;
	time.tv_sec = 0;
	time.tv_usec = 50;

	while( !bQuitServer )
	{
		Sleep( 1 );

		FD_ZERO( &fdRecv );
		FD_SET( nServerSocket, &fdRecv );

		select( nServerSocket + 1, &fdRecv, NULL, NULL, (struct timeval*)&time );

		if( FD_ISSET( nServerSocket, &fdRecv ) )
		{
			int nClientSocket;

			nClientSocket = accept( nServerSocket, NULL, &nAddrSize );

			if( SessionMgr.AddSession( nClientSocket ) )
			{

				printf( "Accept : New Accept Success.\n" );
			}
			else
			{
				closesocket( nClientSocket );
				printf( "Accept : New Accept Fail.\n" );
			}
		}
	}

	return 0;
}
