/********************************************************************
	
	  File Name			:	CriticalSection.h
	  Created Date		:	2003.01.20.
	  Created By		:	Ronia Asel.
	  
	  Comment			:

********************************************************************/

#ifndef __Narew_Network_Module_CriticalSection_Header__
#define __Narew_Network_Module_CriticalSection_Header__

#include <windows.h>

//s
// CCriticalSection
//
class CCriticalSection
{
public:

	/*
	 * Delete Critical Section 
	 */
	~CCriticalSection()
	{
		DeleteCriticalSection( &m_csLock );
	}

	/*
	 * Initialize Critical Section 
	 */
	CCriticalSection()
	{
		InitializeCriticalSection( &m_csLock );
	}

	/*
	 * Critical Section : Lock
	 */
	void Lock()
	{
		EnterCriticalSection( &m_csLock );
	}

	/*
	 * Critical Section : Unlock
	 */
	void Unlock()
	{
		LeaveCriticalSection( &m_csLock );
	}

private:

	CRITICAL_SECTION	m_csLock;
};



#endif
