#include "Global.h"
#include "Database.h"




CDatabase	global_Database;


/*--------------------------------
	CDatabase();   
--------------------------------*/

CDatabase::CDatabase()
{
	m_hEnv     = NULL;
	m_hConnect = NULL;
	m_hStmt    = NULL;
}


/*--------------------------------
	CDatabase();   
--------------------------------*/

CDatabase::~CDatabase()
{
	Close();
}



/*--------------------------------
	Connect();   
--------------------------------*/

BOOL CDatabase::Connect( char* szDSN )
{
	if( SQL_SUCCESS != SQLAllocEnv( &m_hEnv ) )
	{
		return FALSE;
	}

	if( SQL_SUCCESS != SQLAllocConnect( m_hEnv, &m_hConnect ) )
	{
		return FALSE;
	}

	if( SQLConnect( m_hConnect, (SQLTCHAR*)szDSN, strlen( szDSN ), NULL, NULL, NULL, NULL ) )
	{
		return FALSE;
	}

	if( SQL_SUCCESS != SQLAllocStmt( m_hConnect, &m_hStmt ) )
	{
		return FALSE;
	}


	
	return TRUE;
}


/*--------------------------------
	Close();   
--------------------------------*/

void CDatabase::Close()
{
	if( m_hStmt )
	{
		SQLFreeStmt( m_hStmt, 0 );
		m_hStmt = NULL;
	}

	if( m_hConnect )
	{
		SQLDisconnect( m_hConnect );
		SQLFreeConnect( m_hConnect );
		m_hConnect = NULL;
	}

	if( m_hEnv )
	{
		SQLFreeEnv( m_hEnv );
		m_hEnv = NULL;
	}
}


/*--------------------------------
	Query();   
--------------------------------*/

BOOL CDatabase::Query( char* szQuery )
{
	if( m_hStmt )
	{
		SQLFreeStmt( m_hStmt, 0 );
		m_hStmt = NULL;
	}

	if( SQL_SUCCESS != SQLAllocStmt( m_hConnect, &m_hStmt ) )
	{
		return FALSE;
	}

	if( SQL_SUCCESS != SQLExecDirect( m_hStmt, (SQLTCHAR*)szQuery, strlen( szQuery ) ) )
	{
		return FALSE;
	}

	return TRUE;
}

/*--------------------------------
	Fetch();   
--------------------------------*/

SQLRETURN CDatabase::Fetch()
{
	return SQLFetch( m_hStmt );
}


