/*
	Memory.cpp
*/

// Include
#include "Memory.h"
#include "Assert.h"
#include <map>


 
#define MEMORY_PADDING_SIZE	256
#define MEMORY_GARBAGE		0x23

// Memory
struct Memory
{
	void* pActualBlock;
	int	  nActualSize;

	void* pBlock;
	int	  nSize;
};

CMemory Global_Memory;


typedef std::map< void*, Memory >		MemoryMap;
typedef MemoryMap::iterator				MemoryMapItor;


MemoryMap	mapMemory;
int			nMemoryCount;


//
// CMemory::CMemory
//
CMemory::CMemory()
{
	nMemoryCount = 0;
}

//
// CMemory::~CMemory
//
CMemory::~CMemory()
{
	Assert( nMemoryCount == 0 , "ȯ  ޸𸮰  մϴ." );
	Assert( mapMemory.empty() , "ȯ  ޸𸮰  մϴ." );
}

//
// CMemory::Alloc
//
void* CMemory::Alloc( int nSize_ )
{
	Assert( nSize_ > 0, "޸ Ҵ緮 0 ۽ϴ." );

	int nActualSize = nSize_ + MEMORY_PADDING_SIZE * 2;


	// ޸ Ҵ
	void* ptr = malloc( nActualSize );

	if( ptr )	// Ҵ ...
	{	
		memset( ptr, MEMORY_GARBAGE, nActualSize );

		// Block Infor  
		Memory block;

		block.nSize			= nSize_; 
		block.nActualSize	= nActualSize;

		block.pActualBlock	= ptr;
		block.pBlock		= (BYTE*) ptr + MEMORY_PADDING_SIZE;

		// ̹ ҴǾ ִ°?
		Assert( mapMemory.find( block.pBlock ) == mapMemory.end(), "̹ Ҵ ޸𸮰 մϴ." );

		mapMemory.insert( std::make_pair( block.pBlock, block ) );


		nMemoryCount++;

		return block.pBlock;

	}
	else	// Ҵ 
	{
		Assert( !"޸ Ҵ", "޸ Ҵ " );
	}

	return NULL;
}

//
// CMemory::Free
//
void CMemory::Free( void* ptr_ )
{
	// NULL 
	Assert( ptr_, "NULL ͸  ߽ϴ." );

	// Ҵ  ޸
	MemoryMapItor itor = mapMemory.find( ptr_ );
	
	Assert( itor != mapMemory.end(), "Ҵ  ޸𸮸 Ϸ ߽ϴ." );

	Memory& block = itor->second;

	// ޸   ˻ 
	for( int i = 0 ; i < MEMORY_PADDING_SIZE ; i++ ) 
	{
		BYTE data;

		data = *( (BYTE*)block.pActualBlock + i );
		Assert( data == MEMORY_GARBAGE, "޸  " );

		data = *( (BYTE*)block.pActualBlock + MEMORY_PADDING_SIZE + block.nSize + i );
		Assert( data == MEMORY_GARBAGE, "޸  " );
	}
	
	free( block.pActualBlock );
	mapMemory.erase( itor );
	nMemoryCount--;

}

//
// CMemory::CheckBounce 
//
BOOL CMemory::CheckBounce( void* ptr_ )
{
	// NULL 
	Assert( ptr_, "NULL Դϴ." );

	// Ҵ  ޸
	MemoryMapItor itor = mapMemory.find( ptr_ );
	
	Assert( itor != mapMemory.end(), "Ҵ  ޸Դϴ." );

	Memory& block = itor->second;

	// ޸   ˻ 
	for( int i = 0 ; i < MEMORY_PADDING_SIZE ; i++ ) 
	{
		BYTE data;

		data = *( (BYTE*)block.pActualBlock + i );

		if( data != MEMORY_GARBAGE )
		{
			return false;
		}
		
		data = *( (BYTE*)block.pActualBlock + MEMORY_PADDING_SIZE + block.nSize + i );
		
		if( data != MEMORY_GARBAGE )
		{
			return false;
		}
	}

	return true;
}