/*
	Packet.cpp
*/

#include "Global.h"
#include "Queue.h"
#include "Packet.h"
#include "Memory.h"

CPacket*		 aBasePacket;
CQueue<CPacket*> queueEmptyPacket;


//
// InitPacket
//
void InitPacket()
{
	aBasePacket = (CPacket*)_MemAlloc( sizeof( CPacket) * MAXPACKET );
	queueEmptyPacket.Create( MAXPACKET );

	// ŭ Packet Queue ִ´.

	for( int i = 0 ; i < MAXPACKET ; i++ )
	{
		queueEmptyPacket.Push( &aBasePacket[ i ] );
	}

}

//
// DeletePacket
//
void DeletePacket()
{
	SAFE_FREE( aBasePacket );
}

//
// AllocatePacket
//
CPacket* AllocatePacket()
{
	CPacket* pPacket;

	if( queueEmptyPacket.IsEmpty() )
	{
		// ť  ִ.
		pPacket = NULL;

		printf( "Empty Packet   ʽϴ.\n" );
	}
	else
	{
		//   ʴ.
		pPacket = queueEmptyPacket.Pop();
	}

	return pPacket;
}

//
// FreePacket
//
void FreePacket( CPacket* pPacket_ )
{
	Assert( pPacket_, "Free Packet NULLԴϴ." );

	if( !queueEmptyPacket.Push( pPacket_ ) )
	{
		printf( "Base Packet ߺ Ǿų Queue ̻ ֽϴ.\n" );
	}
	else
	{

	}
}