/********************************************************************
	
	  File Name			:	Packet.h
	  Created Date		:	2003.01.20.
	  Created By		:	Ƽ
	  
	  Comment			:
					Ƽ  Packet.

 ********************************************************************/

#ifndef __Narew_Network_Module_Packet_Header__
#define __Narew_Network_Module_Packet_Header__

#include <windows.h>
#include "Type.h"
#include "Assert.h"


#define BUFFERSIZE	256
#define MAXPACKET	9999

class CPacket
{
public:
	//
	// CPacket::Begin
	//
	// Ŷ ϱ  ݵ ȣؾ ϴ Method.
	// End ¦ ̷.
	// ( Packet Pooling ϱ  /Ҹڿ  ʰ
	//    Method Ѵ. )
	//
	void Begin()
	{
		m_nSize = 0;
		m_nPos  = 2;
	}

	//
	// CPacket::End
	//
	// RETURN : Ŷ 
	//
	int End()
	{
		m_nSize = m_nPos;
		*(WORD*)m_Buffer = m_nSize;

		m_nPos = 0;

		return m_nSize;
	}

	void* GetBuffer()
	{
		return m_Buffer;
	}

	CPacket& GetBuffer( void* data )
	{
		assert( m_nSize >= 0 );

		memcpy( data, m_Buffer, m_nSize );

		return *this;
	}

	// Insert Data --------------------------------------------

	CPacket& operator << ( int32 data )
	{
		assert( m_nPos <= BUFFERSIZE - sizeof( int32 ) );

		*(int32*)( m_Buffer + m_nPos ) = data;
		m_nPos += sizeof( int32 );

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	
	CPacket& operator << ( int data )
	{
		assert( m_nPos <= BUFFERSIZE - sizeof( int32 ) );

		*(int*)( m_Buffer + m_nPos ) = data;
		m_nPos += sizeof( int );

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	CPacket& operator << ( BYTE data )
	{
		assert( m_nPos <= BUFFERSIZE - sizeof( BYTE ) );

		*(BYTE*)( m_Buffer + m_nPos ) = data;
		m_nPos += sizeof( BYTE );

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	CPacket& operator << ( WORD data )
	{
		assert( m_nPos <= BUFFERSIZE - sizeof( WORD ) );

		*(WORD*)( m_Buffer + m_nPos ) = data;
		m_nPos += sizeof( WORD );

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	CPacket& operator << ( DWORD data )
	{
		assert( m_nPos <= BUFFERSIZE - sizeof( DWORD ) );

		*(DWORD*)( m_Buffer + m_nPos ) = data;
		m_nPos += sizeof( DWORD );

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	CPacket& operator << ( const char* szText )
	{
		int nLen = strlen( szText );	

	    // TODO : assert ƴ϶ Release ۵ؾ Ѵ. ŷ  ..
		assert( m_nPos <= BUFFERSIZE - nLen );	

		*(BYTE*)( m_Buffer + m_nPos ) = nLen;
		m_nPos += sizeof( BYTE );

		memcpy( m_Buffer + m_nPos, szText, nLen );
		m_nPos += nLen;

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	CPacket& Insert( const void* data, int size )
	{
		assert( m_nPos <= BUFFERSIZE - size );

		memcpy( m_Buffer + m_nPos, data, size );
		m_nPos += size;

		assert( m_nPos <= BUFFERSIZE );

		return *this;
	}

	// Get Data -----------------------------------------------

	CPacket& operator >> ( WORD& data )
	{
		assert( m_nPos < m_nSize );

		data = *(WORD*)( m_Buffer + m_nPos );
		m_nPos += sizeof( WORD );

		assert( m_nPos <= m_nSize );

		return *this;
	}

	CPacket& operator >> ( DWORD& data )
	{
		assert( m_nPos < m_nSize );

		data = *(DWORD*)( m_Buffer + m_nPos );
		m_nPos += sizeof( DWORD );

		assert( m_nPos <= m_nSize );

		return *this;
	}

	CPacket& operator >> ( char* szText )
	{
		assert( m_nPos < m_nSize );

		int nLen = *(BYTE*)( m_Buffer + m_nPos );
		m_nPos += sizeof( BYTE );

		memcpy( szText, m_Buffer + m_nPos, nLen );
		szText[nLen] = 0;
		m_nPos += nLen;

		assert( m_nPos <= m_nSize );

		return *this;
	}

	CPacket& Get( void* data, int size )
	{
		assert( m_nPos < m_nSize );

		memcpy( data, m_Buffer + m_nPos, size );
		m_nPos += size;

		assert( m_nPos <= m_nSize );

		return *this;
	}

	void Copy( CPacket* packet )
	{
		m_nSize = packet->GetSize();

		assert( m_nSize >= 0 );	

		memcpy( m_Buffer, packet->GetBuffer(), m_nSize );
	}

	void Copy( const void* data, int size )
	{
		m_nSize = size;
		m_nPos = 0;
		
		memcpy( m_Buffer + m_nPos, data, m_nSize );
		
	}

	void SetUse( bool bUse_ ) { m_bUse = bUse_; }
	bool IsUse()	{ return m_bUse; }
	int  GetSize()	{ return m_nSize; }

	
private:
	BYTE	m_Buffer[ BUFFERSIZE ];
	int		m_nSize;
	int		m_nPos;

	bool    m_bUse;

};

////////////////////////////////////////

void InitPacket();
void DeletePacket();

CPacket* AllocatePacket();
void	FreePacket( CPacket* pPacket_ );

////////////////////////////////////////
#endif