/********************************************************************
	
	  File Name			:	Global.h
	  Created Date		:	2003.01.20.
	  Created By		:	Ronia Asel.
	  
	  Comment			:

********************************************************************/


#ifndef __Narew_Network_Module_Queue_Header__
#define __Narew_Network_Module_Queue_Header__

#include "Assert.h"
#include "Type.h"


//
// CQueue
//
template <class T> class CQueue
{
public:

	CQueue()
	: m_nFront( 0 ), m_nRear( 0 ), m_nSize( 0 ), m_pArray( 0 ), m_nCount( 0 )
	{
	}

	~CQueue()
	{
		if( m_pArray )
		{
			delete[] m_pArray;
			m_pArray = 0;
		}
	}
	
	/*
	 *	Queue Ѵ.
	 */
	void Create( int nSize )
	{
		Assert( nSize > 0, "Queue  0 ۽ϴ." );

		m_nSize  = nSize;
		m_nCount = 0;

		m_pArray = new T[ nSize ];
	}

	/*
	 *	Queue  ִ´.
	 */
	BOOL Push( const T& t )
	{
		Assert( m_nCount < m_nSize, "ť  Ůϴ." );
		Assert( t, "߸ Դϴ." );

		m_pArray[ m_nRear ] = t;

		m_nRear++;
		m_nCount++;

		return TRUE;
	}

	/*
	 *	Queue .
	 */
	T Pop( void )
	{
		if( m_nFront < 0 && m_nFront >= m_nSize )
		{
			printf( "ERROR LOG : %d %d\n", m_nFront, m_nSize );
		}

		if( m_nCount <= 0  )
		{			
			m_nCount = 0;
			m_nFront = 0;
			m_nRear = 0;

			return NULL;
		}

		T data = m_pArray[ m_nFront ];

		m_nFront++;
		m_nCount--;
		
		if( !data )
		{
			return NULL;
		}

		return data;
	}

	/*
	 * Queue  ȮѴ.
	 */
	BOOL IsEmpty( void )
	{
		if( m_nCount <= 0 )
		{
			m_nCount = 0;
			return TRUE;
		}
		return FALSE;
	}

	/*
	 *  Queue  Ѵ.
	 */
	int GetCount()
	{
		return m_nCount;
	}
    
private:
	int m_nFront;
	int m_nRear;
	int m_nSize;
	int m_nCount;

	T* m_pArray;
};



#endif