/*
	Session.cpp
*/
#include "Session.h"



//
// CSession::CSession
//
CSession::CSession()
{
	m_nSocket = 0;

	m_QueueRecvPacket.Create( MAXSESSIONPACKET );
	m_QueueSendPacket.Create( MAXSESSIONPACKET );

	/////////////////////////////////////////////////////
	// Static... Ǵ ŭ ID  ش. //
	/////////////////////////////////////////////////////

	static DWORD dwID = 1;
	m_dwID = dwID;
	dwID++;
}

//
// CSession::~CSession
//
CSession::~CSession()
{

}

//
// CSession::Disconnect
//
void CSession::Disconnect()
{
	closesocket( m_nSocket );
}

//
// CSession::SetSocket
//
void CSession::SetSocket( int nSocket_ )
{
	Assert( nSocket_ >= 0, "  ʽϴ." );

	m_nSocket = nSocket_;
}

//
// CSession::GetSocket
//
int CSession::GetSocket()
{
	return m_nSocket;
}

//
// CSession::Recv
// 
BOOL CSession::Recv()
{
	/*
		ϰų ̸ TRUE...
		 ϶ FALSE..
	*/
	
	// Lock...

	int	nResult = 0;
	

	if( m_nRecvSize < 2 )
	{
		nResult = recv( m_nSocket, m_aRecvBuffer + m_nRecvSize, 2 - m_nRecvSize, 0 );

		if( nResult == 0 )
		{
			//  
			m_nRecvSize = 0;
			printf( "disconnect\n" );
			return FALSE;
		}

		if( nResult < 0 )
		{
			// Recv ̰ų..Error
			// Network ṵ̈ų ׷״  .
			m_nRecvSize = 0;
			printf( "recv error\n" );

			return TRUE;
		}

		m_nRecvSize += nResult;

		return TRUE;
	}

	// Recv ũ⸦  ´.
	WORD wPacketSize = *(WORD*)m_aRecvBuffer;

	if( wPacketSize - m_nRecvSize < 0)
	{
		// Packet Size ߸Ǿ.
		// ߸ PACKET   .
	
		printf( "Packet Size Error  : %d %d\n", wPacketSize, m_nRecvSize );

		m_nRecvSize = 0;
	
		return TRUE;
	}	
	
	nResult = recv( m_nSocket, m_aRecvBuffer + m_nRecvSize, wPacketSize - m_nRecvSize, 0 );
	
	m_nRecvSize += nResult;


	if( nResult == 0 )
	{
		//  
		printf( "disconnect\n" );
		return FALSE;
	}

	if( nResult < 0 )
	{
		// Recv  .
		printf( "recv error\n" );
		
		return TRUE;
	}

	if( m_nRecvSize >= wPacketSize )
	{
		// Recv  ..   Packet Queue .

		m_nRecvSize = 0;

		CPacket& Packet = *AllocatePacket();

		Packet.Copy( m_aRecvBuffer, wPacketSize );

		memset( &m_aRecvBuffer, 0, 256 );

		if( !m_QueueRecvPacket.Push( &Packet ) )
		{
			// ʹ  Packet  ִ.
			//  Packet  ° Server ̰ų,
			// Client ̹Ƿ   .
			FreePacket( &Packet );
			return FALSE;
		}

	}

	return TRUE;
}

//
// CSession::Send
//
BOOL CSession::Send()
{
	/*
		̸ TRUE.
		и  FALSE   Ѵ.
	*/


	int nResult = 0;		// Send..

	if( m_nSendSize == 0 )
	{
		//  Ŷ  

		if( m_QueueSendPacket.IsEmpty() )
		{
			// Send Packet Ƿ TRUE 
			return TRUE;
		}

		CPacket* pPacket = m_QueueSendPacket.Pop();

		if( pPacket )
		{
			// Packet ߸Ȱ̹Ƿ ׳ .
			FreePacket( pPacket );
			return TRUE;
		}

		pPacket->GetBuffer( m_aSendBuffer );

		// Ŷ   ֱ.
		FreePacket( pPacket );
	}

	WORD wSize = *(WORD*)( m_aSendBuffer );

	nResult = send( m_nSocket , m_aSendBuffer + m_nSendSize, wSize - m_nSendSize, 0 );

	

	if( nResult < 0 )
	{
		// Send    
		return FALSE;
	}

	m_nSendSize += nResult;

	if( m_nSendSize >= wSize )
	{
		//  ´ٸ, ӽ Buffer ϰ ľ ´.
		m_nSendSize = 0;
		memset( &m_aSendBuffer, 0, 256 );
	}

	return TRUE;
}

//
// CSession::GetRecvPacket();
//
CPacket* CSession::GetRecvPacket()
{
	CPacket* pPacket;

	if( m_QueueRecvPacket.IsEmpty() )
	{
		// Queue  ..
		pPacket = NULL;
	}
	else
	{
		//  Packet ִٸ..
		pPacket = m_QueueRecvPacket.Pop();
	}

	return pPacket;
}

//
// CSession::SendPacket
//
void CSession::SendPacket( CPacket *pPacket )
{
	assert( pPacket );

	Lock();

	if( !m_QueueSendPacket.Push( pPacket ) )
	{
		// ť ̹  ..
		printf( "Session : Queue Overflow.\n" );
	}

	Unlock();
}

//
// CSession::GetID
//
DWORD CSession::GetID()
{
	return m_dwID;
}

//
// CSession::Lock
//
void CSession::Lock()
{
	m_csSession.Lock();
}

//
// CSession::Unlock
//
void CSession::Unlock()
{
	m_csSession.Unlock();
}