/********************************************************************
	
	  File Name			:	Session.h
	  Created Date		:	2003.01.20.
	  Created By		:	Ronia Asel.
	  
	  Comment			:

********************************************************************/

#ifndef __Narew_Network_Module_Session_Header__
#define __Narew_Network_Module_Session_Header__




#pragma comment ( lib, "ws2_32.lib" )

#include <winsock2.h>
#include "CriticalSection.h"
#include "Queue.h"
#include "Packet.h"


#define MAXSESSIONPACKET	100


//
// CSession
//
class CSession
{
public:
	CSession();
	~CSession();

	/*
	 *   Ѵ.
	 */
	void Disconnect();

	/*
	 * Socket Ѵ.
	 */
	void SetSocket( int nSocket_ );
	
	/*
	 * Session Socket Ѵ.
	 */
	int  GetSocket();
	
	/*
	 * Packet RecvϿ Queue ִ´.
	 */
	BOOL Recv();
	
	/*
	 * Queue  ִ Packet SendѴ.
	 */
	BOOL Send();
	
	/*
	 *  Packet Ѵ. ( In Queue )
	 */
	CPacket* GetRecvPacket();
		
	/*
	 *  Packet Queue ִ´.. ( In Queue )
	 */
	void SendPacket( CPacket* pPacket );

	/*
	 * Send Packet ִ  
	 */
	BOOL IsEmptySend();

	/*
	 * Session ID  Ѵ.
	 */
	DWORD GetID();

	/*
	 * Lock
	 */
	void Lock();

	/*
	 * Unlock
	 */
	void Unlock();

private:

	int		m_nSocket;
	DWORD	m_dwID;

	CQueue<CPacket*>	m_QueueRecvPacket;
	CQueue<CPacket*>	m_QueueSendPacket;

	//////////////////////////////////////
	int		m_nRecvSize;	// Recv Size.
	int		m_nSendSize;	// Send Size.

	char	m_aRecvBuffer[ BUFFERSIZE ];// Recv Data
	char	m_aSendBuffer[ BUFFERSIZE ];		// Send Data
	//////////////////////////////////////

	CCriticalSection	m_csSession;

};


#endif