/*
	SessionMgr.cpp
*/

#include "SessionMgr.h"
#include "Queue.h"
#include "Global.h"

//////////////////////////////////////////////////////////////
//							Pooling					
//////////////////////////////////////////////////////////////

CSession*			aBaseSession;
CQueue<CSession*>	queueEmptySession;


//
// CreateEmptySession
//
void CreateEmptySession()
{    
	aBaseSession = (CSession*)_MemAlloc( sizeof( CSession ) * MAXSESSION );

	queueEmptySession.Create( MAXSESSION );
	
	//  Session Queueִ´.
	for( int i = 0 ; i < MAXSESSION ; i++ )
	{
		queueEmptySession.Push( &aBaseSession[ i ] );
	}
}

//
// DeleteEmptySession
//
void DeleteEmptySession()
{
	SAFE_FREE( aBaseSession );
}

//
// GetEmptySession
//
CSession* GetEmptySession()
{
	CSession* pSession;

	if( queueEmptySession.IsEmpty() )
	{
		pSession = NULL;
	}
	else
	{
		pSession = queueEmptySession.Pop();
		
		if( !pSession )
		{
			pSession = NULL;
		}
	}
	return pSession;
}

//
// FreeSession
//
void FreeSession( CSession* pSession )
{
	assert( pSession );

	queueEmptySession.Push( pSession );	
}

//////////////////////////////////////////////////////////////

//
// CSessionMgr::CSessionMgr
//
CSessionMgr::CSessionMgr()
{
	m_nMaxSocket = 0;
}

//
// CSessionMgr::~CSessionMgr
//
CSessionMgr::~CSessionMgr()
{
	
}

//
// CSessionMgr::Init
//
void CSessionMgr::Init()
{
	CreateEmptySession();
}

//
// CSessonMgr::Close
//
void CSessionMgr::Close()
{
	DeleteEmptySession();
}

//
// 
//
BOOL CSessionMgr::IsEmpty()
{
	return m_mapSession.empty();
}

//
// CSessionMgr::AddSession
//
BOOL CSessionMgr::AddSession( int nSocket_ )
{
	assert( nSocket_ >= 0 );


	CSession* pSession = GetEmptySession();

	if( !pSession )
	{
		return FALSE;
	}

	// Non Block .

	u_long ul = 0L;
	ioctlsocket( nSocket_, FIONBIO, &ul );

	pSession->SetSocket( nSocket_ );

	SessionMap::iterator	itor = m_mapSession.find( pSession->GetID() );

	if( itor != m_mapSession.end() )
	{
		// ̹  ID Session ϵǾ ִٸ.
		return FALSE;
	}

	if( m_nMaxSocket < nSocket_ )
	{
		m_nMaxSocket = nSocket_;
	}

	// Map .
	m_mapSession.insert( std::make_pair( pSession->GetID(), pSession ) );

	return TRUE;
}

//
// CSessionMgr::DeleteSession
//
BOOL CSessionMgr::DeleteSession( CSession* pSession_ )
{
	Assert( pSession_, "߸ Session Դϴ." );

	SessionMap::iterator itor = m_mapSession.find( pSession_->GetID() );

	if( itor == m_mapSession.end() )
	{
		//   Session϶.
		return FALSE;
	}

	// TODO : Ÿ ٸ ó ش.
			
	// Map Session 
	m_mapSession.erase( itor );

	return TRUE;
}

//
// CSessionMgr::GetFirstSession
//
CSession* CSessionMgr::GetFirstSession()
{
	if( m_mapSession.empty() )
	{
		return NULL;
	}

	m_itorSession = m_mapSession.begin();

	CSession* pSession = m_itorSession->second;

	if( !pSession )
	{
		return NULL;
	}

	return pSession;

}

//
// CSessionMgr::GetNextSession
//
CSession* CSessionMgr::GetNextSession()
{
	m_itorSession++;

	if( m_itorSession == m_mapSession.end() )
	{
		return NULL;
	}

	CSession* pSession = m_itorSession->second;

	if( !pSession )
	{
		return NULL;
	}

	return pSession;
}

//
// CSessionMgr::Lock
//
void CSessionMgr::Lock()
{
	m_csMap.Lock();
}

//
// CSessionMgr::Unlock
//
void CSessionMgr::Unlock()
{
	m_csMap.Unlock();
}

//
// CSessionMgr::Send
//
void CSessionMgr::Send()
{
	SessionMap::iterator itor = m_mapSession.begin();

	while( itor != m_mapSession.end() )
	{
		CSession* pSession = itor->second;
		
		if( !pSession )
		{
			// ߸ Session  ҽ..Map ̰ .
			itor = m_mapSession.erase( itor );
			continue;
		}

		pSession->Lock();

		while( !pSession->IsEmptySend() )
		{
			if( !pSession->Send() )
			{
				// Sendн... ó..
				DeleteSession( pSession );
				break;
			}
		}

		pSession->Unlock();

		itor++;
	}
}

//
// CSessionMgr::Recv
//
void CSessionMgr::Recv()
{
	fd_set fdRecv;

	timeval tv;
	tv.tv_sec	= 0;
	tv.tv_usec	= 50;

	FD_ZERO( &fdRecv );


	SessionMap::iterator itor = m_mapSession.begin();

	while( itor != m_mapSession.end() )
	{
		CSession* pSession = itor->second;
		
		if( !pSession )
		{
			// ߸ Session  ҽ..Map ̰ .
			itor = m_mapSession.erase( itor );
			continue;
		}

		FD_SET( pSession->GetSocket(), &fdRecv );

		itor++;
	}

	
	select( m_nMaxSocket + 1, &fdRecv, NULL, NULL, &tv );

	itor = m_mapSession.begin();

	while( itor != m_mapSession.end() )
	{
		CSession* pSession = itor->second;
		
		if( !pSession )
		{
			// ߸ Session  ҽ..Map ̰ .
			itor = m_mapSession.erase( itor );
			continue;
		}

		if( FD_ISSET( pSession->GetSocket(), &fdRecv ) )
		{
		
			pSession->Lock();

			if( !pSession->Recv() )
			{
				// Recv .. Recv  ܴ̿ TRUE̹Ƿ
				//  ó Ѵ.

				DeleteSession( pSession );
				pSession->Unlock();
				break;
			}

			pSession->Unlock();
		}
	
		itor++;
	}
}
