/********************************************************************
	
	  File Name			:	SessionMgr.h
	  Created Date		:	2003.01.20.
	  Created By		:	Ronia Asel.
	  
	  Comment			:

********************************************************************/


#ifndef __Narew_Network_Module_SessionManager_Header__
#define __Narew_Network_Module_SessionManager_Header__

#pragma warning( disable : 4786 )

#include "Session.h"
#include "CriticalSection.h"
#include <map>

#define MAXSESSION 1000

class CSessionMgr
{
public:
	~CSessionMgr();
	CSessionMgr();

	/*
	 * Session Mgr ʱȭ.
	 */
	void Init();

	/*
	 * Session Mgr   մϴ.
	 */
	void Close();

	/*
 	 * Session ִ 
	 */
	BOOL IsEmpty();

	/*
	 * ο Session Ѵ.
	 */
	BOOL AddSession( int nSocket_ );

	/*
	 * ϵ Session Ѵ.
	 */
	BOOL DeleteSession( CSession* pSession_ );

	/*
	 * ù Session Ѵ.
	 */
	CSession* GetFirstSession();

	/*
	 *  Session Ѵ.
	 */
	CSession* GetNextSession();

	/*
	 * Critical Section : Lock
	 */
	void Lock();

	/*
	 * Critical Section : Unlock
	 */
	void Unlock();

	/*
	 * Send
	 */
	void Send();

	/*
	 * Recv
	 */
	void Recv();

private:

	typedef std::map<DWORD, CSession*> SessionMap;

	SessionMap				m_mapSession;
	SessionMap::iterator	m_itorSession;

	int						m_nMaxSocket;

	CCriticalSection		m_csMap;
	
};



#endif