// TestPPC.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "TestPPC.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include <stdio.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE			hInst;					// The current instance
HWND				hwndCB;					// The command bar handle

static SHACTIVATEINFO s_sai;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
HWND				CreateRpCommandBar(HWND);

HWND				g_hWnd;
BOOL				g_bReady = FALSE; 

HDC					g_hBMDC;
HBITMAP				g_hbmp, g_hOldbmp;                        // handle of the bitmaps to add

HDC					g_hDC;
HBITMAP				g_hBM, g_hOldBM;

int					g_Continuity = 0;
int					g_Level = 1;
int					g_Score = 0;
int					g_AddPoint = 0;

// g_DownFrame  -1϶ Ϲ  -1 ƴҶ   ִϸ Ѵ.
int					g_DownFrame = -1;// ؿ ϳ    1ӿ 6Ʈ ٿ
int					g_BombFrame = -1;//   
char				g_TempBlock[8];	//   (μ  )
char				g_Block[8*8];	//  
char				g_BlockDead[8*8];// ״  Ÿ 

int					g_MovePixel = 3;
int					g_DownMovePixel = 5;

int					g_SelectStart = -1;
int					g_SelectEnd = -1;
int					g_MoveBlockCnt = -1;

VOID				SettingBlock();	//  Ѵ.
BOOL				CheckBlock();	//  üũѴ.
VOID				OnPaint(HDC hDC);
VOID				OnDraw(HDC hDC);

int levelindex[20] = { 1000, 3000, 6000, 10000, 15000, 
					  21000,28000,36000, 45000, 55000,
					  66000,78000,91000,105000,130000,
					 200000,30000,50000,700000,900000};

VOID InitData()
{
	//  ʱȭ..
	srand( GetTickCount() );

	g_Level = 1;
	g_Score = 0;
	g_AddPoint = 0;

	g_DownFrame = -1;// ؿ ϳ    1ӿ 6Ʈ ٿ
	g_BombFrame = -1;//   

}

VOID SettingBlock()
{
	//  0 ʱȭ
	// 0   ٴ Ҹ̴.
	ZeroMemory(g_Block, 64);
	ZeroMemory(g_TempBlock, 8);

	int index = 0;
	
	for(int y = 0; y < 8; y++)
	{
		g_TempBlock[y] = rand()%7+1;

		for(int x = 0; x < 8; x++)
		{
			index = y*8+x;
			g_Block[index] = rand()%7+1;
		}
	}
}

//   ִ ˻Ѵ.
BOOL CheckNonBlock()
{
	for(int x = 0; x < 64; x++)
	{
		if(g_Block[x] == 0)
		{
			return TRUE;
		}
	}

	return FALSE;
}

// μ  Ѵ.
VOID DeleteBlock()
{
	for(int x = 0; x < 64; x++)
	{
		if(g_BlockDead[x] != 0)
		{
			g_Block[x] = 0;
		}
	}
	g_BombFrame = -1;
	g_DownFrame = 0;
}

//   Ǿִ ȮѴ.
BOOL CheckBlock()
{
	g_AddPoint = 0;
	ZeroMemory(g_BlockDead, 64);

	int BlockDeadCount = 0;
	int x = 0; 
	int y = 0;

	int Index = 0;
	int SBlockIndex = 0; //  ε
	int BlockCount = 0;	//  ӵǴ 

	for(y = 0; y < 8; y++)
	{
		// x == 0;
		Index = y*8;
		SBlockIndex = g_Block[Index];
		BlockCount = 1;

		for(x = 1; x < 8; x++)
		{
			if(SBlockIndex == g_Block[Index+x])
				BlockCount++;
			else
			{
				if(BlockCount >= 3)
				{
					g_AddPoint += (BlockCount*10)*g_Level;
					BlockDeadCount += BlockCount;
					for(int i = 0; i < BlockCount; i++)
					{
						g_BlockDead[(Index+x)-BlockCount+i]++;
					}
				}
				SBlockIndex = g_Block[Index+x];
				BlockCount = 1;
			}
		}
		if(BlockCount >= 3)
		{
			g_AddPoint += (BlockCount*10)*g_Level;
			BlockDeadCount += BlockCount;
			for(int i = 0; i < BlockCount; i++)
			{
				g_BlockDead[(Index+8)-BlockCount+i]++;
			}
		}
	}
	
	for(x = 0; x < 8; x++)
	{
		// y == 0;
		Index = x;
		SBlockIndex = g_Block[Index];
		BlockCount = 1;

		for(y = 1; y < 8; y++)
		{
			if(SBlockIndex != 0 && SBlockIndex == g_Block[Index+y*8])
				BlockCount++;
			else
			{
				if(BlockCount >= 3)
				{
					g_AddPoint += (BlockCount*10)*g_Level;
					BlockDeadCount += BlockCount;
					for(int i = 0; i < BlockCount; i++)
					{
						g_BlockDead[(Index+y*8)-(BlockCount*8)+(i*8)]++;
					}
				}
				SBlockIndex = g_Block[Index+y*8];
				BlockCount = 1;
			}
		}
		if(BlockCount >= 3)
		{
			g_AddPoint += (BlockCount*10)*g_Level;
			BlockDeadCount += BlockCount;
			for(int i = 0; i < BlockCount; i++)
			{
				g_BlockDead[(Index+8*8)-(BlockCount*8)+(i*8)]++;
			}
		}
	}

	if(BlockDeadCount != 0)
	{
		g_BombFrame = 0;
		return TRUE;
	}
	return FALSE;
}

VOID OnDraw(HDC hDC)
{
	int index;
	RECT rt;
	GetClientRect(g_hWnd, &rt);
	int DownFlag = 0;

	if(g_DownFrame == -1)
	{
		// ̵Ǵ   
		if(g_MoveBlockCnt != -1 && g_SelectStart != -1 && g_SelectEnd != -1)
		{
			int tx = g_SelectStart%8;
			int ty = g_SelectStart/8;
			BitBlt(g_hDC, tx*30, ty*30, 30, 30, g_hBMDC, 0, 0, SRCCOPY);
			tx = g_SelectEnd%8;
			ty = g_SelectEnd/8;
			BitBlt(g_hDC, tx*30, ty*30, 30, 30, g_hBMDC, 0, 0, SRCCOPY);
		}

		for(int x = 0; x < 8; x++)
		{
			for(int y = 0; y < 8; y++)
			{
				index = y*8+x;

				if(g_MoveBlockCnt == -1 && g_BombFrame == -1)
				{
					if(g_SelectStart == index)
					{
						BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
						BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, 0, 0, SRCINVERT);
						continue;
					}
				}
				else if(g_MoveBlockCnt != -1)
				{
					if(abs(g_SelectStart-g_SelectEnd) == 1)
					{
						if(g_SelectStart == index)
						{
							BitBlt(g_hDC, x*30+g_MoveBlockCnt, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
						else if(g_SelectEnd == index)
						{
							BitBlt(g_hDC, x*30-g_MoveBlockCnt, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
					}
					else if(abs(g_SelectStart-g_SelectEnd) > 1)
					{
						if(g_SelectStart == index)
						{
							BitBlt(g_hDC, x*30, y*30+g_MoveBlockCnt, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
						else if(g_SelectEnd == index)
						{
							BitBlt(g_hDC, x*30, y*30-g_MoveBlockCnt, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
					}					
				}
				// ı   ı ִϸ Ѵ.
				else if(g_BombFrame != -1 && g_BlockDead[index] != 0)
				{
					BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, 0, 0, SRCCOPY);
					BitBlt(g_hDC, x*30+(g_BombFrame*3), y*30+(g_BombFrame*3), 30-(g_BombFrame*6), 30-(g_BombFrame*6), g_hBMDC, g_Block[index]*30+(g_BombFrame*3), 0+(g_BombFrame*3), SRCCOPY);
				}
			}
		}
	}
	else
	{
		int DownFlag = -1;
		for(int x = 0; x < 8; x++)
		{
			DownFlag = -1;
			for(int y = 7; y >= 0; y--)
			{
				index = y*8+x;

				if(g_Block[index] == 0)
					DownFlag = y;

				if(g_Block[index] == 0)
					continue;

				if(DownFlag == -1 || y == 7)
					continue;

				BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, 0, 0, SRCCOPY);
				BitBlt(g_hDC, x*30, g_DownFrame+y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
			}
			if(DownFlag != -1)
			{
				BitBlt(g_hDC, x*30, 0, 30, g_DownFrame, g_hBMDC, g_TempBlock[x]*30, 30-g_DownFrame, SRCCOPY);
			}
		}
	}

	int Point;
	int scoreboard[6] = { 100000, 10000, 1000, 100, 10, 1 };
	if(g_Score == 0)
	{
		for(int i = 0; i < 6; i++)
		{
			BitBlt(g_hDC, 30+i*30, 240, 30, 30, g_hBMDC, 0, 30, SRCCOPY);
		}
	}
	else
	{
		Point = g_Score;
		for(int i = 0; i < 6; i++)
		{
			index = Point/scoreboard[i];
			BitBlt(g_hDC, 30+i*30, 240, 30, 30, g_hBMDC, index*30, 30, SRCCOPY);
			Point = Point%scoreboard[i];
		}
	}

	BitBlt(hDC, 0, 0, rt.right, rt.bottom, g_hDC, 0, 0, SRCCOPY);
}

// ȭ鿡 ׸.
VOID OnPaint(HDC hDC)
{
	RECT rt, rect;
	TCHAR Buff[20];
	GetClientRect(g_hWnd, &rt);

	HPEN	hPen, hPenOld;
	HBRUSH  hbrBox, hbrOld;
	hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
	hPenOld = (HPEN)SelectObject(g_hDC, hPen); 
	//    ä.
	hbrBox = CreateSolidBrush(RGB(255,255,255));
	hbrOld = (HBRUSH)SelectObject(g_hDC, hbrBox);

	Rectangle(g_hDC, rt.left, rt.top, rt.right, rt.bottom);

	DeleteObject(SelectObject(g_hDC, hPenOld));
	DeleteObject(SelectObject(g_hDC, hbrOld));

	// ⿡ ׸ ׸
	//  ׸ Ʒ   ׸. ( ִϸ ϱ)
	int index = 0;
	int DownFlag = 0;

	// ׳ ´.
	if(g_DownFrame == -1)
	{
		for(int x = 0; x < 8; x++)
		{
			for(int y = 0; y < 8; y++)
			{
				index = y*8+x;

				if(g_MoveBlockCnt != -1)
				{
					if(abs(g_SelectStart-g_SelectEnd) == 1)
					{
						if(g_SelectStart == index)
						{
							BitBlt(g_hDC, x*30+g_MoveBlockCnt, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
						else if(g_SelectEnd == index)
						{
							BitBlt(g_hDC, x*30-g_MoveBlockCnt, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
					}
					else if(abs(g_SelectStart-g_SelectEnd) > 1)
					{
						if(g_SelectStart == index)
						{
							BitBlt(g_hDC, x*30, y*30+g_MoveBlockCnt, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
						else if(g_SelectEnd == index)
						{
							BitBlt(g_hDC, x*30, y*30-g_MoveBlockCnt, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
							continue;
						}
					}					
					BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
				}
				// ı   ı ִϸ Ѵ.
				else if(g_BombFrame != -1 && g_BlockDead[index] != 0)
				{
					BitBlt(g_hDC, x*30+(g_BombFrame*3), y*30+(g_BombFrame*3), 30-(g_BombFrame*6), 30-(g_BombFrame*6), g_hBMDC, g_Block[index]*30+(g_BombFrame*3), 0+(g_BombFrame*3), SRCCOPY);
				}
				else
				{
					BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
				}
			}
		}
	}
	else
	{
		int DownFlag = -1;
		for(int x = 0; x < 8; x++)
		{
			DownFlag = -1;
			for(int y = 7; y >= 0; y--)
			{
				index = y*8+x;

				if(g_Block[index] == 0)
					DownFlag = y;

				if(g_Block[index] == 0)
					continue;

				if(DownFlag == -1 || y == 7)
					BitBlt(g_hDC, x*30, y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
				else
					BitBlt(g_hDC, x*30, g_DownFrame+y*30, 30, 30, g_hBMDC, g_Block[index]*30, 0, SRCCOPY);
			}
			if(DownFlag != -1)
			{
				BitBlt(g_hDC, x*30, 0, 30, g_DownFrame, g_hBMDC, g_TempBlock[x]*30, 30-g_DownFrame, SRCCOPY);
			}
		}
	}

	int Point;
	int scoreboard[6] = { 100000, 10000, 1000, 100, 10, 1 };
	wsprintf(Buff, TEXT("Point"));
	SetRect(&rect, 0, 240, 30, 255 );
	DrawText(g_hDC, Buff, -1, &rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
	wsprintf(Buff, TEXT("LV%d"), g_Level);
	SetRect(&rect, 0, 255, 30, 270 );
	DrawText(g_hDC, Buff, -1, &rect, DT_CENTER | DT_SINGLELINE | DT_VCENTER);

	if(g_Score == 0)
	{
		for(int i = 0; i < 6; i++)
		{
			BitBlt(g_hDC, 30+i*30, 240, 30, 30, g_hBMDC, 0, 30, SRCCOPY);
		}
	}
	else
	{
		Point = g_Score;
		for(int i = 0; i < 6; i++)
		{
			index = Point/scoreboard[i];
			BitBlt(g_hDC, 30+i*30, 240, 30, 30, g_hBMDC, index*30, 30, SRCCOPY);
			Point = Point%scoreboard[i];
		}
	}

	BitBlt(hDC, 0, 0, rt.right, rt.bottom, g_hDC, 0, 0, SRCCOPY);
}

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}


	InvalidateRect(g_hWnd, NULL, TRUE );

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TESTPPC);

    g_bReady = TRUE;


	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TESTPPC));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_TESTPPC, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		g_hWnd = hWnd;
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 
	MyRegisterClass(hInstance, szWindowClass);
	
	RECT	rect;
	GetClientRect(hWnd, &rect);
	
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}
	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it
	// if a menubar is present
	{
		RECT rc;
		GetWindowRect(hWnd, &rc);
		rc.bottom -= MENU_HEIGHT;
		if (hwndCB)
			MoveWindow(hWnd, rc.left, rc.top, rc.right, rc.bottom, FALSE);
	}


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	g_hWnd = hWnd;

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
static int x = 0,y = 0;

BOOL MoveBlock()
{
	++g_Continuity;

	int DPoint = 0;

	HDC hDC;

	if(CheckBlock())
	{
		if(g_Continuity != 0)
			DPoint = ((g_AddPoint*g_Continuity)/100)*g_Level;

		g_Score = g_Score+g_AddPoint+DPoint;

		if(g_Score >= 999999)
		{
			g_Score = 999999;
		}
		
		if(g_Score > levelindex[g_Level-1])
		{
			g_Level++;
			if(g_Level >= 20)
				g_Level = 20;
		}

		// ⿡  ȿ ִ´.
		do{
			// ȭ鿡 
			hDC = GetDC(g_hWnd);
			g_BombFrame++;
			OnDraw(hDC);
			ReleaseDC(g_hWnd, hDC);
			
			if(g_BombFrame >= 5)
				DeleteBlock();
		}while(g_BombFrame != -1);

		int DownAdd = 0;
		//   ȿ ִ´.
		do{
			// ȭ鿡 
			hDC = GetDC(g_hWnd);
			OnDraw(hDC);
			ReleaseDC(g_hWnd, hDC);

			g_DownFrame += (g_DownMovePixel+(DownAdd++));
			// Ѵܰ Դ. ׷ ٽ üũѴ.
			if(g_DownFrame >= 30)
			{
				for(int x = 0; x < 8; x++)
				{
					for(int y = 7; y > 0; y--)
					{
						if(g_Block[x+y*8] == 0)
						{
							g_Block[x+y*8] = g_Block[x+(y-1)*8];
							g_Block[x+(y-1)*8] = 0;
						}
					}
					if(g_Block[x] == 0) 
					{
						g_Block[x] = g_TempBlock[x];
						g_TempBlock[x] = rand()%7+1;
					}
				}

				g_DownFrame = -1;
				g_MoveBlockCnt = -1;
				g_SelectStart = -1;
				g_SelectEnd = -1;

				if(CheckNonBlock())
					g_DownFrame = 0;
				else 
				{
					// ȭ鿡 
					hDC = GetDC(g_hWnd);
					OnPaint(hDC);
					ReleaseDC(g_hWnd, hDC);

					MoveBlock();	// ٽ  ̵Ű Լ ȣѴ.( Լ)
				}
			}
		} while(g_DownFrame != -1);

		return TRUE;
	}
	return FALSE;
}

int ClickBlock(int mx, int my)
{
	for(int x = 0; x < 8; x++)
	{
		for(int y = 0; y < 8; y++)
		{
			if(x*30 < mx && mx < x*30+30)
			{
				if(y*30 < my && my < y*30+30)
				{
					return y*8+x;
				}
			}
		}
	}
	return -1;
}

BOOL m_BtnClick = FALSE;

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	HDC hdc;
	PAINTSTRUCT ps;
	switch (message) 
	{
	case WM_LBUTTONDOWN:
		g_Continuity = 0;
		m_BtnClick = TRUE;
		x    = LOWORD(lParam); 
		y = HIWORD(lParam); 
		g_MoveBlockCnt = -1;

		// ù°  ã´.
		if(g_SelectStart == -1)
		{
			g_SelectStart = ClickBlock(x, y);
			if(g_SelectStart != -1)		
			{
				HDC hDC = GetDC(hWnd);
				g_MoveBlockCnt = -1;
				OnDraw(hDC);
				ReleaseDC(g_hWnd, hDC);
			}
		}
		else	// ι°  ã´.
		{
			g_SelectEnd = ClickBlock(x, y);

			if(g_SelectEnd == -1)
				break;

			if(g_SelectStart == g_SelectEnd)
			{
				g_SelectStart = -1;
				g_SelectEnd = -1;
				InvalidateRect(hWnd, NULL, FALSE);
				break;
			}

			if(abs(g_SelectStart-g_SelectEnd) != 1 && abs(g_SelectStart-g_SelectEnd) != 8)
			{
				g_SelectStart = -1;
				g_SelectEnd = -1;
				InvalidateRect(hWnd, NULL, FALSE);
				break;
			}

			int Temp;
			BOOL MoveFlag;
			//  ༮ ̳  
			if(g_SelectStart > g_SelectEnd)  
			{
				Temp = g_SelectStart;
				g_SelectStart = g_SelectEnd;
				g_SelectEnd = Temp;
			}

			//  ̵Ƿ
			MoveFlag = FALSE;
			g_MoveBlockCnt = 0;
			do{
				// ȭ鿡 
				HDC hDC = GetDC(hWnd);
				g_MoveBlockCnt+=g_MovePixel;
				OnDraw(hDC);
				ReleaseDC(g_hWnd, hDC);

				if(g_MoveBlockCnt >= 30)
				{
					g_MoveBlockCnt = -1;
					Temp = g_Block[g_SelectStart];
					g_Block[g_SelectStart] = g_Block[g_SelectEnd];
					g_Block[g_SelectEnd] = Temp;

					if(!MoveBlock() && MoveFlag == FALSE)
					{
						MoveFlag = TRUE;
						g_MoveBlockCnt = 0;
					}
				}
			}while(g_MoveBlockCnt != -1);
			g_SelectStart = -1;
			g_SelectEnd = -1;
			InvalidateRect(hWnd, NULL, FALSE);
		}
		break;
	case WM_LBUTTONUP:
		m_BtnClick = FALSE;
		x    = LOWORD(lParam); 
		y = HIWORD(lParam); 
		break;
	case WM_MOUSEMOVE:
		x    = LOWORD(lParam); 
		y = HIWORD(lParam);

		if(m_BtnClick == FALSE)
			break;

		g_SelectEnd = ClickBlock(x, y);

		if(g_SelectStart == g_SelectEnd)
		{
			g_SelectEnd = -1;
			break;
		}

		if(abs(g_SelectStart-g_SelectEnd) != 1 && abs(g_SelectStart-g_SelectEnd) != 8)
		{
			g_SelectEnd = -1;
			break;
		}

		int Temp;
		BOOL MoveFlag;
		//  ༮ ̳  
		if(g_SelectStart > g_SelectEnd)  
		{
			Temp = g_SelectStart;
			g_SelectStart = g_SelectEnd;
			g_SelectEnd = Temp;
		}

		m_BtnClick = FALSE;

		//  ̵Ƿ
		MoveFlag = FALSE;
		g_MoveBlockCnt = 0;
		do{
			// ȭ鿡 
			HDC hDC = GetDC(hWnd);
			g_MoveBlockCnt+=g_MovePixel;
			OnDraw(hDC);
			ReleaseDC(g_hWnd, hDC);

			if(g_MoveBlockCnt >= 30)
			{
				g_MoveBlockCnt = -1;
				Temp = g_Block[g_SelectStart];
				g_Block[g_SelectStart] = g_Block[g_SelectEnd];
				g_Block[g_SelectEnd] = Temp;

				if(!MoveBlock() && MoveFlag == FALSE)
				{
					MoveFlag = TRUE;
					g_MoveBlockCnt = 0;
				}
			}
		}while(g_MoveBlockCnt != -1);
		g_SelectStart = -1;
		g_SelectEnd = -1;
		InvalidateRect(hWnd, NULL, FALSE);
		break;

		case WM_SYSCOMMAND:
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
				case IDM_HELP_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				    break;
				case ID_RESET:	// Ÿ Ѵ.
					//  ʱȭѴ.
					do
					{
						SettingBlock();
					}while(CheckBlock());

					g_Level = 1;
					g_Score = 0;
					g_AddPoint = 0;

					g_SelectStart = -1;
					g_SelectEnd = -1;
					g_DownFrame = -1;// ؿ ϳ    1ӿ 6Ʈ ٿ
					g_BombFrame = -1;//   
					InvalidateRect(hWnd, NULL, FALSE);
					break;
				case ID_EXIT:
				case IDOK:
					SendMessage(hWnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM)hWnd);
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CreateRpCommandBar(hWnd);

			{
				// MemDC 
				RECT	rect;
				GetClientRect(hWnd, &rect);

				HDC hdc = GetDC(hWnd);
				
				// 
				g_hDC = CreateCompatibleDC(hdc);
				g_hBM = CreateCompatibleBitmap(hdc, rect.right-rect.left, rect.bottom-rect.top);
				g_hOldBM = (HBITMAP)SelectObject(g_hDC, g_hBM);

				// BITMAP ε
				g_hbmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP));

				// ׸ .
				g_hBMDC = CreateCompatibleDC(hdc);
				g_hOldbmp = (HBITMAP)SelectObject(g_hBMDC, g_hbmp);

				ReleaseDC(hWnd, hdc);

				InitData();

				//  ʱȭѴ.
				do
				{
					SettingBlock();
				}while(CheckBlock());

				g_Level = 1;
				g_Score = 0;
				g_AddPoint = 0;

				g_DownFrame = -1;// ؿ ϳ    1ӿ 6Ʈ ٿ
				g_BombFrame = -1;//   
			}
			break;

		case WM_PAINT:
			hdc = BeginPaint(g_hWnd, &ps);
			OnPaint(hdc);
			EndPaint(g_hWnd, &ps);		
			break; 

		case WM_CLOSE:
			DestroyWindow(hWnd);
			break;

		case WM_DESTROY:
			// ⼭ α׷ .
			CommandBar_Destroy(hwndCB);

			// ۸ Ѵ.
			SelectObject(g_hDC, g_hOldBM);
			DeleteDC(g_hDC);

			// ׸ ø Ѵ.
			SelectObject(g_hBMDC, g_hOldbmp);
			DeleteDC(g_hBMDC);

			// ̹ Ѵ.
			DeleteObject(g_hbmp);

			PostQuitMessage(0);
			break;

		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai);
     		break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	SHMENUBARINFO mbi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi)) 
		return NULL;

	return mbi.hwndMB;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;

	switch (message)
	{
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			shidi.dwMask = SHIDIM_FLAGS;
			 shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
			return TRUE; 

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
