#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpstdio.h"
#include "gpmem.h"
#include "gpmain.h"
//
GPDRAWSURFACE gpDraw[2];								// ̸Ӹ, 鼭ǽ
int nflip;												// ø

#define 		MAX_ALPHA   8							//  ܰ (1 - 8)
unsigned char   AlphaTable[256][256][8]; 				//  ̺
//
//  Ʈ ּ  (X Editor  Ʈ ּ  Ͽ մϴ.)
//
typedef struct
{
    unsigned short      Left;
    unsigned short      Top;
    unsigned short      Width;
    unsigned short      Height;
} _MINAREA;

//
// GPF  
//
typedef struct
{
    int         FileKind;       //  
    int         ColorMode;      // ÷ 
    int         Size;           // Ʈ   (   )
    int         Col, Row;       // Ʈ (Col), (Row) 迭 
    int         Width, Height;  // Ʈ ũ
    int         TileNumber;     // Ʈ 
    int         ColorKey;       // ÷Ű ()
} GPFHEADER;

//
//  Ʈ  
//
typedef struct
{
    _MINAREA    *Area;          //  Ʈ ּ ũ
    int         *SaveSize;      //   Ʈ  
} GPFDATA;

//
// GPF ü
//
typedef struct
{
    // CompressMode = 1 : ޸𸮿   Ÿ ״ ִ´.
    // CompressMode = 0 :  Ǯ ǽ Ѵ.
    int                 CompressMode;

    GPFHEADER           stHeader;
    GPFDATA             stData;

    // CompressMode   Bitmap  Ÿ  Surface Ÿ  ȴ.
    unsigned char       **Bitmap;
    GPDRAWSURFACE       *Surface;
} _GPF;

//
// GPF εѴ.
//
int GPF_Load(_GPF *pGpf, char *pFileName, int pCompressMode)
{
    int		        i, j, l;
    ulong           ReadCount, TotalCount;
    unsigned char   *ReadBuffer, *PutPtr, *TempBuffer;
    int             ReadBufferSize = 0;

    F_HANDLE        fp;

    //  
    if(GpFileOpen(pFileName, OPEN_R, &fp) != SM_OK)
        return 0;

    //  д´.
    GpFileRead(fp, &pGpf->stHeader, sizeof(GPFHEADER), &ReadCount);

    // GPF  ˻Ѵ. (ĺڴ  0x7839)
    if(pGpf->stHeader.FileKind != 0x7839)
        return 0;

    // 8Bit ̹ΰ?
    if(pGpf->stHeader.ColorMode != 1)
        return 0;

    // Ÿ  ̸ 4Ʈ Ѵ. ( κ Ȯġ ,  ׸ ϴ. -.-)
    while(pGpf->stHeader.Width % 4)
        pGpf->stHeader.Width++;

    // Ÿ  ̸ 4Ʈ Ѵ. ( κ Ȯġ ,  ׸ ϴ. -.-)
    //while(pGpf->stHeader.Height % 4)
    //    pGpf->stHeader.Height++;

    // ε (, ) Ѵ.
    pGpf->CompressMode    = pCompressMode;

    //  Ʈ ּ    .
    pGpf->stData.Area       = (_MINAREA *)gp_mem_func.malloc(pGpf->stHeader.TileNumber * sizeof(_MINAREA));

    // GPF Ͽ ִ  Ʈ ̹  
    pGpf->stData.SaveSize   = (int *)gp_mem_func.malloc(pGpf->stHeader.TileNumber * sizeof(int));

    //  Ʈ ̹ ּ  о´.
    GpFileRead(fp, pGpf->stData.Area, sizeof(_MINAREA) * pGpf->stHeader.TileNumber, &ReadCount);

    // GPF Ͽ ִ  Ʈ   о´.
    GpFileRead(fp, pGpf->stData.SaveSize, sizeof(int) * pGpf->stHeader.TileNumber, &ReadCount);

    // ̹  Ǯ ʰ  (Ʈ   ִ 쿡 )
    if(pGpf->CompressMode)
    {
        // Ʈ  ° ̹   Ѵ.
        pGpf->Bitmap    = (unsigned char **)gp_mem_func.malloc(pGpf->stHeader.TileNumber * sizeof(int));

        //  Ʈ ൥Ÿ ҷͼ ״ Ѵ.
        for(l = 0; l < pGpf->stHeader.TileNumber; l++)
        {
            pGpf->Bitmap[l] = (unsigned char *)gp_mem_func.malloc(pGpf->stData.SaveSize[l]);

            //   Ÿ Ÿ оͼ Ѵ.
            GpFileRead(fp, pGpf->Bitmap[l], pGpf->stData.SaveSize[l], &ReadCount);
        }
    }
    // ̹  Ǯ  (Ʈ    쿡 )
    else
    {
        // Ʈ  ° ǽ  Ѵ.
        pGpf->Surface   = (GPDRAWSURFACE *)gp_mem_func.malloc(pGpf->stHeader.TileNumber * sizeof(GPDRAWSURFACE));

        //  Ʈ ũ⸦ ˻Ͽ ӽ  ִ ũ⸦ Ѵ.
        for(l = 0; l < pGpf->stHeader.TileNumber; l++)
        {
            if(ReadBufferSize < pGpf->stData.SaveSize[l])
                ReadBufferSize  = pGpf->stData.SaveSize[l];
        }

        // ӽ ۿ ޸𸮸 ҴѴ.
        ReadBuffer   = (unsigned char *)gp_mem_func.malloc(ReadBufferSize);

        //  ǽ Ʈ Ÿ ҷͼ    Ѵ.
        for(l = 0; l < pGpf->stHeader.TileNumber; l++)
        {
            // ִ Ʈ ǳʶڴ.
            if(pGpf->stData.Area[l].Width == 0) continue;

            // Ʈ  ǽ . ޸  ؼ ּ  .
            pGpf->Surface[l].bpp    = 8;
            pGpf->Surface[l].buf_w  = pGpf->stData.Area[l].Width;
            pGpf->Surface[l].buf_h  = pGpf->stData.Area[l].Height;

            GpMemSurfaceGet(&pGpf->Surface[l]);

            //  Ʈ Ÿ д´.
            GpFileRead(fp, ReadBuffer, pGpf->stData.SaveSize[l], &ReadCount);

            //  Ͽ ǽ Ѵ. (׽Ʈ غ ʾҽϴ.)
            i   = 0;
            j   = 0;

            while(i < pGpf->stData.SaveSize[l])
            {
                //   ŭ ä.
                if(ReadBuffer[i + 1] == pGpf->stHeader.ColorKey)
                {
                    gm_memset(&pGpf->Surface[l].o_buffer[j], pGpf->stHeader.ColorKey, ReadBuffer[i]);

                    j += ReadBuffer[i];
                    i += 2;
                }
                // ٸ  
                else
                {
                    gm_memcpy(&pGpf->Surface[l].o_buffer[j], &ReadBuffer[i + 1], ReadBuffer[i]);

                    j += ReadBuffer[i];
                    i += (ReadBuffer[i] + 1);
                }
            }
        }

        gp_mem_func.free(ReadBuffer);
    }

    GpFileClose(fp);

	return 1;
}
//
// GPF Ѵ.
//
void GPF_Delete(_GPF *pGpf)
{
    int i;
    
    if(pGpf->CompressMode)
    {
        for(i = 0; i < pGpf->stHeader.TileNumber; i++)
        {
            if(pGpf->Bitmap[i]) gp_mem_func.free(pGpf->Bitmap[i]);
        }
    }
    else
    {
        for(i = 0; i < pGpf->stHeader.TileNumber; i++)
        {
			// ϴ ǽ ޸𸮸 Ѵ.
            if(pGpf->stData.Area[i].Width)
            {
                gp_mem_func.free(pGpf->Surface[i].o_buffer);
            }
        }
    }

	gp_mem_func.free(pGpf->stData.Area);
    gp_mem_func.free(pGpf->stData.SaveSize);

    gm_memset(pGpf, 0, sizeof(_GPF));
}

//
// ȷƮ ҷ´.
//
int Palette_Load(char *pFileName)
{
    int             i;
    unsigned char   PalOk;
    unsigned char   PalEntry[768];
    ulong           ReadCount;
    GP_HPALETTE     GpPalette;
    GP_LOGPALENTRY  GpPalEntry[256];
    F_HANDLE        fp;

    if(GpFileOpen(pFileName, OPEN_R, &fp) != SM_OK)
        return 0;

    //  д´.
    GpFileRead(fp, &PalOk, 1, &ReadCount);

    // GP32 ȷƮ ƴϸ
    if(PalOk != 1)
    {
        GpFileClose(fp);

        return 0;
    }

    // ȷƮ
    GpFileRead(fp, PalEntry, 768, &ReadCount);

    //  ̺
    GpFileRead(fp, AlphaTable, sizeof(AlphaTable), &ReadCount);

    GpFileClose(fp);

    // ȷƮ GP ȷƮ ü 
    for(i = 0; i < 256; i++)
    {
        GpPalEntry[i].peRed    	= PalEntry[i * 3];
        GpPalEntry[i].peGreen  	= PalEntry[i * 3 + 1];
        GpPalEntry[i].peBlue   	= PalEntry[i * 3 + 2];
		GpPalEntry[i].peFlags	= 0;
    }

    // ȷƮ 
    GpPalette    = GpPaletteCreateEx(256, GpPalEntry);
	GpPaletteSelect(GpPalette);
    GpPaletteRealize();

    return 1;
}
//
// ޸ Ѵ. (pPutBuffer =  ǽ , pLineBuffer =  ̹)
//
void SprCopyMemory(unsigned char *pPutBuffer, unsigned char *pLineBuffer, int pSize, unsigned short pAlphaDepth)
{
    int 	i, j = 0;

    // ϰ Ѵ.
    if(pAlphaDepth == 0)
    {
        gm_memcpy(pPutBuffer, pLineBuffer, pSize);
    }
    //  Ѵ.
    else if(pAlphaDepth <= MAX_ALPHA)
    {
        for(i = 0; i < pSize; i++)
        {
            //  Ͽ Ѵ.
            pPutBuffer[i]   = AlphaTable[pPutBuffer[i]][pLineBuffer[j++]][pAlphaDepth - 1];
        }
    }
}
//
//   մϴ. (pFrame =  ȣ, pRotateMode = ¿  , pAlphaDepth = Ĵܰ)
//
void GPF_ShowFrame(GPDRAWSURFACE *pSurface, int pLeft, int pTop, _GPF *pGpf, int pFrame, int pRotateMode, int pAlphaDepth)
{
    int		    i, j, w, h;

    int		    PutLoc, LineCount, LineStart, LineWidth, BlockStart;
    int             PutSurfaceWidth, PutSurfaceHeight;
    int             RealLeft, RealTop;
    int             SprWidth, SprHeight;

    unsigned char   *SprPtr;
    unsigned char   *PutPtr;

    GPRECT	    	stMinRect, stGpRect;
    GPFHEADER       *GpfHeader;
    GPFDATA         *GpfData;

    // Ʈ 
    GpfHeader   = &pGpf->stHeader;
    GpfData     = &pGpf->stData;

	//  Ʈ ( ȿ )
    if(pGpf->CompressMode == 0)
    {
		GpBitBlt(NULL, 
				pSurface, 
				pLeft, pTop, 
				pGpf->Surface[pFrame].buf_w, pGpf->Surface[pFrame].buf_h, 
				pGpf->Surface[pFrame].o_buffer, 
				0, 0, 
				pGpf->Surface[pFrame].buf_w, pGpf->Surface[pFrame].buf_h);
    }
	else
	{
	    // Ʈ  ּҸ Ѵ.
    	SprPtr    = pGpf->Bitmap[pFrame];

	    // Ʈ  GP  ٲ۴. .. Ϳ ٲ㼭 ϸ   ߵ!!
    	stGpRect.left       = GpfHeader->Height - (GpfData->Area[pFrame].Top + GpfData->Area[pFrame].Height);
	    stGpRect.top        = GpfData->Area[pFrame].Left;
    	stGpRect.right      = GpfHeader->Height - GpfData->Area[pFrame].Top;
	    stGpRect.bottom     = GpfData->Area[pFrame].Left + GpfData->Area[pFrame].Width;

    	// Ʈ ʺ  (GP ǥ̹Ƿ ݴ մϴ.)
	    SprWidth            = GpfData->Area[pFrame].Height;
    	SprHeight           = GpfData->Area[pFrame].Width;

	    // Ʈ ּ   ʱȭ (Ŭνÿ  ˴ϴ.)
    	stMinRect.left	    = 0;
	    stMinRect.top		= 0;
    	stMinRect.right	    = SprWidth;
	    stMinRect.bottom	= SprHeight;

    	//  ȭ ũ⸦ Ѵ. (GP ǥ̹Ƿ ݴ մϴ.)
	    PutSurfaceWidth     = pSurface->buf_h;
    	PutSurfaceHeight    = pSurface->buf_w;

	    //  ǥ (GP ǥ ȯ)
    	RealLeft	        = PutSurfaceWidth - pTop - GpfHeader->Height + stGpRect.left;
	    if(pRotateMode)
    	{
        	RealTop         = pLeft + GpfHeader->Width - stGpRect.top - SprHeight;
	        LineCount       = SprHeight;
    	}
	    else
    	{
        	RealTop         = pLeft + stGpRect.top;
	        LineCount       = 0;
    	}

	    //   ȭ ̶  ʴ´.
    	if(RealLeft <= -SprWidth || RealLeft >= PutSurfaceWidth || RealTop <= -SprHeight || RealTop >= PutSurfaceHeight)
        	return;

	    // Ŭο     Ѵ.
    	if(RealLeft < 0 && RealLeft > -SprWidth)
        	stMinRect.left	    = -RealLeft;

	    if(RealLeft + SprWidth >= PutSurfaceWidth)
    	    stMinRect.right	    = stMinRect.left + PutSurfaceWidth - RealLeft;

	    if(RealTop < 0 && RealTop > -SprHeight)
    	    stMinRect.top		= -RealTop;

	    if(RealTop + SprHeight >= PutSurfaceHeight)
    	    stMinRect.bottom	= PutSurfaceHeight - RealTop;

	    //  ǽ  ּҸ ˾ƿ´.
    	PutPtr 	= pSurface->ptbuffer;

	    //   ġ Ѵ.
    	PutLoc  = RealTop * PutSurfaceWidth + RealLeft;

	    i	= 0;
    	j   = 0;
	    // ش Ʈ ŭ  .
    	while(i < GpfData->SaveSize[pFrame])
	    {
    	    // ÷Ű
        	if(SprPtr[i + 1] == GpfHeader->ColorKey)
	        {
    	        j += SprPtr[i];
        	    i += 2;
	        }
    	    // Ϲݻ̶
        	else
	        {
    	        // Y Ŭ
        	    if((RealTop + LineCount) >= 0 && (RealTop + LineCount) < PutSurfaceHeight)
            	{
	                BlockStart	= j;

    	            // ȭ   ĥ 
        	        if(stMinRect.left > 0)
            	    {
                	    // ִٸ
                    	if(stMinRect.left > BlockStart && stMinRect.left < BlockStart + SprPtr[i])
	                    {
    	                    LineWidth	= (BlockStart + SprPtr[i]) - stMinRect.left;
        	                LineStart	= stMinRect.left;
	
    	                    if(PutLoc + LineStart >= 0)
        	                {
            	                SprCopyMemory(&PutPtr[PutLoc + LineStart], &SprPtr[i + stMinRect.left - j + 1], LineWidth, pAlphaDepth);
                	        }
                    	}
	                    //   ̶
    	                else if(stMinRect.left <= BlockStart)
        	            {
            	            LineWidth	= SprPtr[i];
                	        LineStart	= BlockStart;

                    	    if(PutLoc + LineStart >= 0)
                        	    SprCopyMemory(&PutPtr[PutLoc + LineStart], &SprPtr[i + 1], LineWidth, pAlphaDepth);
	                    }
    	            }
        	        // ȭ   ĥ 
            	    else if(stMinRect.right < SprWidth)
                	{
                    	// ִٸ
	                    if(stMinRect.right > BlockStart && stMinRect.right < BlockStart + SprPtr[i])
    	                {
        	                LineWidth	= stMinRect.right - BlockStart;
            	            LineStart	= BlockStart;

                	        if(PutLoc + LineStart >= 0)
                    	        SprCopyMemory(&PutPtr[PutLoc + LineStart], &SprPtr[i + 1], LineWidth, pAlphaDepth);
	                    }
    	                //   ̶
        	            else if(stMinRect.right >= BlockStart + SprPtr[i])
            	        {
                	        LineWidth	= SprPtr[i];
                    	    LineStart	= BlockStart;
	
    	                    if(PutLoc + LineStart >= 0)
        	                    SprCopyMemory(&PutPtr[PutLoc + LineStart], &SprPtr[i + 1], LineWidth, pAlphaDepth);
            	        }
                	}
	                //    
    	            else
        	        {
            	        if(PutLoc + BlockStart >= 0)
                	        SprCopyMemory(&PutPtr[PutLoc + BlockStart], &SprPtr[i + 1], SprPtr[i], pAlphaDepth);
	                }
    	        }
	

    	        j += SprPtr[i];
        	    i += (SprPtr[i] + 1);
	        }

    	    // 1    Ǯȴٸ
        	if(j == SprWidth)
	        {
    	        if(pRotateMode)
        	    {
            	    //    Ѵ.
                	LineCount--;
	                //  ̹  ġ Ѵ.
    	            PutLoc -= PutSurfaceWidth;
    	        }
	            else
    	        {
        	        //    Ѵ.
            	    LineCount++;
                	//  ̹  ġ Ѵ.
	                PutLoc += PutSurfaceWidth;
    	        }
	
    	        j   = 0;
        	}
	    }
	}
}

//
//  α׷
//
int Frame = 0;
int GpMain(void *arg)
{
	int n_tick, i, j;

	_GPF stGpf;

	GpFatInit();
    GpRelativePathSet("gp:\\gpmm\\XEditor");

	GpLcdSurfaceGet(&gpDraw[0], 0);
	GpLcdSurfaceGet(&gpDraw[1], 1);
	GpRectFill(NULL, &gpDraw[0], 0, 0, 320, 240, 0);
	GpRectFill(NULL, &gpDraw[1], 0, 0, 320, 240, 0);
	GpSurfaceSet(&gpDraw[0]);
	nflip	= 1;

	// ȷƮ εѴ.
	if(Palette_Load("Palette.Pal") == 0) return 0;
	
	// GPF ʱȭ
	gm_memset(&stGpf, 0, sizeof(_GPF));

	// GPF ҷͼ ޸𸮿 Ѵ. ̹  Ƿ  1 ִ´.
	if(GPF_Load(&stGpf, "Sample.Gpf", 1) == 0) return 0;

	// GPF ҷͼ ޸𸮿 Ѵ. ̹  Ƿ  0 ִ´.
	//if(GPF_Load(&stGpf, "Sample2.Gpf", 0) == 0) return 0;
	
	while(1)
	{
		GpKeyInit();

		// 
		if(GpKeyGet() == GPC_VK_FA)
		{
			// GPF Ѵ.
			GPF_Delete(&stGpf);

			GpAppExit();
			return 0;
		}
		
		// 25  ӵ
		if(GpTickCountGet() - n_tick > 1000 / 25)
		{
			n_tick = GpTickCountGet();

			// ȭ ˰ ĥѴ.
			GpRectFill(NULL, &gpDraw[nflip], 0, 0, 320, 240, 0);

			// Ʈ Ѵ.
			GPF_ShowFrame(	&gpDraw[nflip], 		//  ǽ
							0, 0, 					//  ǥ
							&stGpf, 				// GPF ü
							Frame++, 				//   ȣ
							0, 						// ¿   
							0						// (1 - 8) GPF_Load() ڰ ݵ 1     ִ.
						 );		
			
			//   ߴٸ  ó  ư.
			if(Frame == stGpf.stHeader.TileNumber) 
				Frame = 0;

			// øѴ.
			GpSurfaceFlip(&gpDraw[nflip++]);
			nflip %= 2;
		}
	}

    return 0;
}
