--=====================================================================================================================
-- 
--  HeightMap Export By ji sang joon ( wxywxy@hitel.net )
--
--=====================================================================================================================
global g_PlaneSegments   = 2
global g_PlaneTileWidth  = 1.0
global g_PlaneTileHeight = 1.0
global g_CurrentDir = sysInfo.currentdir 

--=====================================================================================================================
-- GetColorFromBMP
--=====================================================================================================================
fn GetColorFromBMP bmp x y = 
(
	if x < 0 then
	(	
		format "Error fn GetColorFromeBMP ( Get less Width Size ) % / %\n" x y

--		MessageBox "Error fn GetColorFromeBMP ( Get less Width Size )"
	
		return [ -1 , -1 , -1 ] as color
	)

	if y < 0 then
	(	
		format "Error fn GetColorFromeBMP ( Get less Height Size ) % / %\n" x y

--		MessageBox "Error fn GetColorFromeBMP ( Get less Height Size )"
	
		return [ -1 , -1 , -1 ] as color
	)


	if bmp.height <= y then
	(	
		format "Error fn GetColorFromeBMP ( Get More Height Size ) % / %\n" x y

--		MessageBox "Error fn GetColorFromeBMP ( Get More Height Size )"
	
		return [ -1 , -1 , -1 ] as color
	)

	if bmp.width <= x then
	(	
		format "Error fn GetColorFromeBMP ( Get More Width Size ) % / %\n" x y

--		MessageBox "Error fn GetColorFromeBMP ( Get More Width Size )"
	
		return [ -1 , -1 , -1 ] as color
	)

	
	Pixels = getpixels bmp[ 0 , y ] bmp.width
	
	return Pixels[ ( x + 1 ) ]
)


--=====================================================================================================================
-- MakePlane
--=====================================================================================================================
fn MakePlaneFromBMP Pos TileSize HeightSize Segments PlaneName =
(
	local bmp      = selectbitmap()                           -- open image file browser 
	local MakePlane;

	if bmp != undefined then
	(
		local bmpname  = getfilenamefile bmp.filename 

		local Width  		        = bmp.width
		local Height 		        = bmp.height
--		local float PlaneSizeWidth  = ( Width  * TileSize )
--		local float PlaneSizeHeight = ( Height * TileSize )

		local float PlaneSizeWidth  = ( Segments * TileSize )
		local float PlaneSizeHeight = ( Segments * TileSize )
 
		local MoveX  		        = PlaneSizeWidth  / 2
		local MoveZ  		        = PlaneSizeHeight / 2
		local AddCount	  		    = bmp.width / Segments
		
		MakePlane                   = Plane name:PlaneName length:PlaneSizeHeight width:PlaneSizeWidth lengthsegs:Segments widthsegs:Segments transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [ MoveX , MoveZ , 0 ] ) isSelected:on
		
		MakePlane.wirecolor = [ 150 , 150 , 150 ] as color
		
--		format "FileName : % , Segments : % , Width : % , Height : %, AddCount : %\n" bmp.filename Segments bmp.width bmp.height AddCount

		ConvertToMesh MakePlane							-- Change Enable Edit Mesh 

		local num = MakePlane.numverts
			
		local count = 1

		local float px     = 0
		local float py     = 0
		
		local float y      = 0	
		
		for z = 0 to Segments do
		(  
			for x = 0 to Segments do
		   (  
				if( x == Segments ) then px = Width - 1;
				else
					px = ( AddCount * x ) as integer

				y = Segments - z

				if( y == Segments ) then py = Height - 1;
				else
					py = ( AddCount * y ) as integer

				GetColor    = GetColorFromBMP bmp px py
				
				HeightValue = GetColor.r * HeightSize

				p = getvert MakePlane count			
				
				setvert MakePlane count [ p.x , p.y , HeightValue ]		

--				format "count % : % / % => % / %\n" count x z px py

			    count += 1

		   ) 

		) 
	)
)


--=====================================================================================================================
-- Load Height Map
--=====================================================================================================================
fn LoadHeightMap FileName Dialog =
(
	actionMan.executeAction 0 "40004"
	actionMan.executeAction 0 "40005"

	local fp = fopen FileName "rb"

	Segments     = ReadLong   fp 
	TileWidth    = ReadFloat  fp  
	TileHeight   = ReadFloat  fp  
	NumVertice   = ReadLong   fp  
	TVertexCount = ReadLong   fp  


--	format "Segments % \n" Segments

	g_PlaneSegments   = Segments
	g_PlaneTileWidth  = TileWidth
	g_PlaneTileHeight = TileHeight

	Dialog.PlaneSegsSpin.value  = Segments
	Dialog.WidthSizeSpin.value  = TileWidth
	Dialog.HeightSizeSpin.value = TileHeight

	local float PlaneSizeWidth  = ( g_PlaneSegments * g_PlaneTileWidth )
	local float PlaneSizeHeight = ( g_PlaneSegments * g_PlaneTileWidth )
	local MoveX  		        = PlaneSizeWidth  / 2
	local MoveZ  		        = PlaneSizeHeight / 2

--	format "Segment          = % \n" g_PlaneSegments
--	format "Tile Width  Size = % \n" g_PlaneTileWidth
--	format "Tile Height Size = % \n" g_PlaneTileHeight
	

	MakePlane                = Plane name:"Plane0" length:PlaneSizeHeight width:PlaneSizeWidth lengthsegs:g_PlaneSegments widthsegs:g_PlaneSegments transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [ MoveX , MoveZ , 0 ] ) isSelected:on
		
	MakePlane.wirecolor		 = [ 150 , 150 , 150 ] as color

	ConvertToMesh MakePlane                

	Count = 1;
	
	local float	 x = 0
	local float	 y = 0
	local float	 z = 0

	TextureFileName = getFilenameFile FileName + ".tex"
		
    if TextureFileName != undefined then 
	(
		fpTexture = openFile TextureFileName

		DiffuseMapName = readline fpTexture
		BumpMapName    = readline fpTexture

		meditMaterials[1].diffuseMap          			  = Bitmaptexture fileName:DiffuseMapName 
		meditMaterials[1].bumpMap              			  = Bitmaptexture fileName:BumpMapName 
		meditMaterials[1].Name                 			  = "Terrain Texture"
		meditMaterials[1].bumpMapAmount       			  = 100
		meditMaterials[1].bumpMap.coordinates.mappingType = 1
		meditMaterials[1].bumpMap.coordinates.mapping     = 3

		close fpTexture
	)



	for z = 0 to g_PlaneSegments do
	(  
		for x = 0 to g_PlaneSegments do
		(
			x = ReadFloat fp
			z = ReadFloat fp
			y = ReadFloat fp 

			setVert MakePlane Count [ x , y , z ]
	
			x = ReadFloat fp 
			z = ReadFloat fp 
			y = ReadFloat fp 
			
--			setNormal MakePlane Count [ x , y , z ]					

			if TVertexCount > 0 then
			(
				x = ReadFloat fp
				y = ReadFloat fp
				z = ReadFloat fp

--				format "% % %\n" x y z
				
--				setTVert MakePlane Count [ x , y , z ]
			)

  	 		Count += 1
		)
	)
	
	fclose( fp )

	MakePlane.material = meditMaterials[1] 
	
	modPanel.addModToSelection (Uvwmap ()) ui:on	
)

--=====================================================================================================================
-- Save Height Map
--=====================================================================================================================
fn SaveHeightMap FileName Obj =
(
	ConvertToMesh Obj

   	NumVertice   = Obj.numverts 
	TVertexCount = getNumTVerts Obj
 
	fp = fopen FileName "wb"

	WriteLong	fp	g_PlaneSegments
	WriteFloat	fp  g_PlaneTileWidth
	WriteFloat  fp  g_PlaneTileHeight
	WriteLong   fp  NumVertice
	WriteLong   fp  TVertexCount

	
	-- -------------------------------------------------------------------
	-- Save Textue FileName
	-- -------------------------------------------------------------------
	if meditMaterials[1] != undefined then
	(
		DiffuseMapName  = filenameFromPath meditMaterials[1].diffuseMap.FileName 
		BumpMapName     = filenameFromPath meditMaterials[1].bumpMap.FileName 
		TextureFileName = getFilenameFile FileName + ".tex"
		
		fpTexture = createfile TextureFileName

		format "%\n" DiffuseMapName to:fpTexture
		format "%\n" BumpMapName    to:fpTexture
		
		close fpTexture
	)
	
	Count = 1;
	
	local float reverse = 0.0f
	
	for z = 0 to g_PlaneSegments do
	(  
		for x = 0 to g_PlaneSegments do
		(
			Vertex = getvert   Obj Count
			
			Normal = getNormal Obj Count
					 
			WriteFloat fp Vertex.x
			WriteFloat fp Vertex.z
			WriteFloat fp Vertex.y

			WriteFloat fp Normal.x
			WriteFloat fp Normal.z
			WriteFloat fp Normal.y
			
			if TVertexCount > 0 then
			(
				TVertex = getTVert Obj Count

				WriteFloat fp TVertex.x
				WriteFloat fp TVertex.y
				WriteFloat fp TVertex.z
			)

			Count += 1
		)
	)
	
	fclose( fp )
)



--=====================================================================================================================
-- MakePlane
--=====================================================================================================================
rollout  MakePlane "Make Plane"
(
	-------------------------------------------------------------------------------------------------------------------
	-- Local Variable
	-------------------------------------------------------------------------------------------------------------------
	local Segments  	= 2
	local MaxWidthSeg   = 10000
	local MaxLengthSeg  = 10000
	
	local TileSize		= 1
	local HeightSize	= 1

	local PlaneName 	= "Plane0"
	local StartPosition = [ 0.0 , 0.0 , 0.0 ]

	-------------------------------------------------------------------------------------------------------------------
	-- Create Control in MakePlane RolloutFloater
	-------------------------------------------------------------------------------------------------------------------
	button LoadImageMapBtn "Load Image Map" pos:[9,10] width:370 height:30														-- Load Image Map Button
	
	spinner	PlaneSegsSpin  "Segments   "      type:#Integer scale:1 pos:[35,50] width:100 range:[Segments,1000,Segments]		-- Width  Segment Count Spinner

	spinner	PositionXSpin  " Position X    " type:#Float scale:0.1 pos:[13,80 ] width:150 range:[0,9999999,0] 					-- Start X Position Spinner
	spinner	PositionYSpin  " Position Y    " type:#Float scale:0.1 pos:[13,110] width:150 range:[0,9999999,0] 					-- Start Y Position Spinner
	spinner	PositionZSpin  " Position Z    " type:#Float scale:0.1 pos:[13,140] width:150 range:[0,9999999,0] 					-- Start Z Position Spinner

	edittext PlaneNameEditBox   "Plane Name" fieldWidth:300	pos:[11,170] text:PlaneName 

	spinner	WidthSizeSpin  "Tile   Size      " type:#Float scale:0.1 pos:[250,80 ] width:100 range:[0.1,9999,TileSize  ] 		-- Tile   Size Spinner
	spinner	HeightSizeSpin "Height Size   "    type:#Float scale:0.1 pos:[250,110] width:100 range:[0.1,9999,HeightSize] 		-- Height Size Spinner

	button SaveHeightMapBtn      "Save Height Map" pos:[9,200] width:370 height:30											-- Save Height Map Button
	button LoadHeightMapBtn      "Load Height Map" pos:[9,240] width:370 height:30											-- Load Height Map Button
	
	-------------------------------------------------------------------------------------------------------------------
	-- Initial MakePlane RolloutFloater
	-------------------------------------------------------------------------------------------------------------------
	
	--=================================================================================================================
	-- Event Control
	--=================================================================================================================
	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged PlaneSegsSpiner
	-------------------------------------------------------------------------------------------------------------------
	on PlaneSegsSpin changed Seg do
	( 
		Segments 		  = Seg
		
		g_PlaneSegments   = Seg
	)
	
	-------------------------------------------------------------------------------------------------------------------
	-- Pressed Load Image Map Button
	-------------------------------------------------------------------------------------------------------------------
	on LoadImageMapBtn pressed do
	(
		MakePlaneFromBMP StartPosition TileSize HeightSize Segments PlaneName
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged Start Position X Spinner
	-------------------------------------------------------------------------------------------------------------------
	on PositionXSpin changed X do
	( 
		StartPosition.x = X
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged Start Position Y Spinner
	-------------------------------------------------------------------------------------------------------------------
	on PositionYSpin changed Y do
	( 
		StartPosition.y = Y
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged Start Position X Spinner
	-------------------------------------------------------------------------------------------------------------------
	on PositionZSpin changed Z do
	( 
		StartPosition.z = Z
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged Tile Size Spinner
	-------------------------------------------------------------------------------------------------------------------
	on WidthSizeSpin changed size do
	( 
		TileSize 		  = size
	
		g_PlaneTileWidth  = size
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Chnaged Height Size Spinner
	-------------------------------------------------------------------------------------------------------------------
	on HeightSizeSpin changed size do
	( 
		HeightSize        = size
	
		g_PlaneTileHeight = size
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Changed Plane Name
	-------------------------------------------------------------------------------------------------------------------
	on  PlaneNameEditBox changed Str do

	(
		PlaneName = Str
	)


	-------------------------------------------------------------------------------------------------------------------
	-- Pressed Save Height Map Button
	-------------------------------------------------------------------------------------------------------------------
	on SaveHeightMapBtn pressed do
	(
		Obj = $																-- Selected Object
		
		if Obj == undefined then										
		(
			MessageBox "Select Save Plane"
		)
		else
		(
			FileName = getSaveFileName types:"Height Map(*.Map)|*.map|" 
		
			if FileName != undefined then 
			(
				SaveHeightMap FileName Obj
			)
		)
	)

	-------------------------------------------------------------------------------------------------------------------
	-- Pressed Load Height Map Button
	-------------------------------------------------------------------------------------------------------------------
	on LoadHeightMapBtn pressed do
	(
		FileName = getOpenFileName types:"Height Map(*.Map)|*.map|" 
		
		if FileName != undefined then 
		(
			LoadHeightMap FileName MakePlane
		)
	)
)

rollout  Excute "View Plane"
(
	button ViewHeightMapBtn "View Map" pos:[9,10] width:370 height:30														-- Load Image Map Button

	-------------------------------------------------------------------------------------------------------------------
	-- Pressed View Height Map Button
	-------------------------------------------------------------------------------------------------------------------
	on ViewHeightMapBtn pressed do
	(
		FileName = getOpenFileName types:"Height Map(*.Map)|*.map|" 
		
		format "% \n" FileName
		
		if FileName != undefined then 
		(
			PathName = getFilenamePath FileName
			MapFile  = getFilenameFile FileName

			cmd      = g_CurrentDir+"\viewer "+PathName+" "+MapFile

			DOSCommand ( cmd )
		)
	)

)


--=====================================================================================================================
-- Main 
--=====================================================================================================================
try(closeRolloutFloater HeightDlg)catch()

HeightDlg = newRollOutFloater "HeightMap Editor" 400 500

AddRollout MakePlane HeightDlg
AddRollout Excute HeightDlg

