;
;		Extended memory control functions
;		Copyright (c) 1989 Alchemy Mindworks Inc.
;

VERSION		EQU	1			;VERSION
SUBVERSION	EQU	0			;SUBVERSION

_AOFF		EQU	6			;FAR STACK OFFSET

;THIS MACRO FETCHES THE DATA SEGEMENT
DATASE		MACRO
		PUSH	AX
		MOV	AX,_DATA
		MOV	DS,AX
		POP	AX
		ENDM

XMEM_TEXT	SEGMENT BYTE PUBLIC 'CODE'
		ASSUME	CS:XMEM_TEXT,DS:_DATA

;THIS FUNCTION INITIALIZES THE DRIVER
;		CALLED AS
;		get_xmem();
;
;		Returns the version number or -1 if no driver
;
		PUBLIC	_get_xmem
_get_xmem	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	AX,4300H
		INT	2FH
		CMP	AL,80H
		JE	GETX1

		MOV	AX,0FFFFH
                JMP	GETX2

GETX1:		MOV	AX,4310H

		INT	2FH
		MOV	WORD PTR CS:[_CONTOFF],BX
		MOV	WORD PTR CS:[_CONTSEG],ES

		XOR	AX,AX
		CALL    CS:[CONTROL]

GETX2:		DATASE
		POP	BP
		RET
_get_xmem	ENDP

;THIS FUNCTION MOVES EXTENDED MEMORY
;		CALLED AS
;		move_xmem(p);
;		p = pointer to move structure
;			/* returns true if successfull */
;
		PUBLIC	_move_xmem
_move_xmem	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	SI,[BP + _AOFF + 0]	;OFFSET OF STRUCTURE
		MOV	DS,[BP + _AOFF + 2]	;SEGMENT OF STRUCTURE

                MOV	AH,11
		CALL	CS:[CONTROL]

		DATASE
		POP	BP
		RET
_move_xmem	ENDP

;THIS FUNCTION DEALLOCATES EXTENDED MEMORY
;		CALLED AS
;		dealloc_xmem(h);
;		int h; 	/* handle to deallocate */
;			/* returns true if successfull */
;
		PUBLIC	_dealloc_xmem
_dealloc_xmem	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	DX,[BP + _AOFF + 0]	;OFFSET OF DESTINATION
                MOV	AH,10
		CALL	CS:[CONTROL]

		DATASE
		POP	BP
		RET
_dealloc_xmem	ENDP

;THIS FUNCTION ALLOCATES EXTENDED MEMORY
;		CALLED AS
;		alloc_xmem(n);
;		int n; 	/* number of kilobytes to allocate */
;                       /* returns handle or -1 if error */
;
		PUBLIC	_alloc_xmem
_alloc_xmem	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	DX,[BP + _AOFF + 0]	;OFFSET OF DESTINATION
                MOV	AH,9
		CALL	CS:[CONTROL]

		OR	AX,AX
		JZ	ALLOC1

		MOV	AX,DX
		JMP     ALLOC2

ALLOC1:		MOV	AX,0FFFFH

ALLOC2:		DATASE
		POP	BP
		RET
_alloc_xmem	ENDP

;THIS FUNCTION CONVERTS A POINTER TO AN INTEL LONG
;		CALLED AS
;		long ptr2long(p);
;		char *p
;
		PUBLIC	_ptr2long
_ptr2long	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	AX,[BP + _AOFF + 0]	;OFFSET OF POINTER
		MOV	DX,[BP + _AOFF + 2]	;SEGMENT OF POINTER

		DATASE
		POP	BP
		RET
_ptr2long	ENDP

;THIS FUNCTION IS A DUMMY RETURN FOR UNSET PROCEDURES
_DUMMY		PROC	FAR
		MOV	AX,0FFFFH
		RET
_DUMMY		ENDP

CONTROL		LABEL	DWORD
_CONTOFF	DW	_DUMMY
_CONTSEG	DW	XMEM_TEXT

XMEM_TEXT	ENDS

DGROUP		GROUP	_DATA,_BSS
_DATA		SEGMENT WORD PUBLIC 'DATA'

_DATA		ENDS

_BSS		SEGMENT WORD PUBLIC 'BSS'
_BSS		ENDS
		END
