#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include "adlib.h"

unsigned long byte_size,cur_byte;
char *ins_name,*ims_data[6];
int *ins_data,d_mode,basic_tempo,ins_num,ch_num;
int *cur_ins,cur_vol[11];
unsigned int page_num,page_etc;

int readmem( unsigned long cub )
{  unsigned int pg,rm;
   pg=(cub/32768);
   rm=(cub%32768);
   return( *(ims_data[pg]+rm) );
}
/*--------------------------------------------------*/
void load_bnk(char *bnk_name)
{  unsigned int i,j,ins_max_num,ins_cur_num,num;
   unsigned long ins_list_off,ins_data_off,curfp,num2;
   char *t1,name[9];
   int *t2;
   FILE *fp;
   if (bnk_name!=NULL )   fp=fopen(bnk_name,"rb");
     else fp=fopen("standard.bnk","rb");
   if ( fp==NULL ) exit(0);
   fseek (fp,8l,SEEK_SET);
   fread (&ins_max_num,2,1,fp);
   fseek (fp,2l,SEEK_CUR);
   fread (&ins_list_off,4,1,fp);
   fread (&ins_data_off,4,1,fp);
/*--------------------------------------------*/

 for ( i=0;i<ins_num;i++)
     {   fseek(fp,ins_list_off,SEEK_SET);
	 t1=ins_name+i*9;
	 t2=ins_data+i*28;
	 ins_cur_num=0;
	 printf("\n%s ",t1);
	 do {
	      fread(&num,2,1,fp);
	      num2=num;
	      fseek(fp,1l,SEEK_CUR);
	      fread(name,9,1,fp);
	      if ( strcmp(t1,name)==0 )
		   { printf("..Ok ");
		     curfp=ftell(fp);
		     fseek(fp,ins_data_off+num2*30+2,SEEK_SET);
		     for ( j=0;j<28;j++)
		      *(t2++)=fgetc(fp);
		     fseek(fp,curfp,SEEK_SET);
		   }
	     ins_cur_num++;
	    }
	 while ( ins_max_num>ins_cur_num );
      }
fclose(fp);
}
/*--------------------------------------*/
void load_ims(char *name)
{  int i,j,ts;
   long cpblen;
   char *t1,ims_name[30];
   FILE *fp;
   fp=fopen(name,"rb");
   if ( fp==NULL ) { fclose(fp);exit(0);}
   fseek(fp,6,SEEK_SET);
   fread(ims_name,30,1,fp);
   fseek(fp,58,SEEK_SET);
  d_mode=fgetc(fp);
  ch_num=9+d_mode*2;
  fseek(fp,42,SEEK_SET);
  fread(&byte_size,4,1,fp);
  fseek(fp,60,SEEK_SET);
  fread(&basic_tempo,2,1,fp);
  fseek(fp,71,SEEK_SET);
  page_num=(byte_size/32768);
  for ( i=0;i<page_num;i++ )
   { ims_data[i]=malloc(32768);
     fread(ims_data[i],32768,1,fp);
   }
  page_etc=byte_size%32768;
if ( page_etc )
 {
  ims_data[page_num]=malloc(page_etc);
  fread(ims_data[page_num],page_etc,1,fp);
}
fseek(fp,1,SEEK_CUR);
fread(&ins_num,2,1,fp);
ins_name=malloc(ins_num*9);
ins_data=malloc(ins_num*56);
fread(ins_name,ins_num*9,1,fp);
for ( i=0;i<ins_num;i++ )
  strlwr(ins_name+i*9);
fclose(fp);
}
/*-----------------------------------*/
/*    play ims                       */
/*-----------------------------------*/
void ins_rt( int ch )
{  int *tibre;
   tibre=ins_data+readmem(cur_byte++)*28;
   SetVoiceTimbre(ch,tibre);
}
void vol_rt( int ch )
{  cur_vol[ch]=readmem(cur_byte++);
   SetVoiceVolume( ch,cur_vol[ch]);
}

void pit_rt( int ch)
{  unsigned int data1;
   data1=readmem(cur_byte+1)<<8;
   data1+=readmem(cur_byte);
   data1=data1>>1;
   SetVoicePitch(ch,data1);
   cur_byte+=2;
}
void tem_rt()
{ int data1,data2;
  unsigned int rate;
  long ttem;
  cur_byte+=2;
  data1=readmem(cur_byte++);
  data2=readmem(cur_byte++);
  ttem=basic_tempo;
  ttem=ttem*data2/128+basic_tempo*data1;
  rate=(298295l/ttem);
  SetClkRate(rate);
  cur_byte++;
}
void note1_rt( int ch)
{  int data1;
   data1=readmem(cur_byte+1);
   NoteOff (ch);
   if ( cur_vol[ch]!=data1 )
    {  cur_vol[ch]=data1;
       SetVoiceVolume( ch,data1);
    }
   NoteOn ( ch,readmem(cur_byte));
   cur_byte+=2;
}

void note2_rt( int ch)
{  int data1;
   data1=readmem(cur_byte+1);
   NoteOff (ch);
   if ( data1 )
      {  if ( cur_vol[ch]!=data1 )
	      { cur_vol[ch]=data1;
		SetVoiceVolume( ch,data1);
	      }
	 NoteOn ( ch,readmem(cur_byte));
      }
   cur_byte+=2;
}


void play_ims()
{  int i;
/*-----------------------------*/
   SoundColdInit(0x388);
   SetMode(d_mode);
for ( i=0;i<ch_num;i++)
   { cur_vol[i]=0;NoteOff(i);SetVoiceVolume( i,0); }
cur_byte=0;
StartTimeOut(10);
}
void end_ims()
{ int i;
  free(ins_data);
  free(ins_name);
  for ( i=0;i<page_num;i++ )
      free(ims_data[i]);
  if ( page_etc )
     free( ims_data[page_num]);
  for ( i=0;i<ch_num;i++)
      NoteOff(i);
  SetClkRate(0);
}
/*--------------------------------------------*/
main(int argc,char *argv[])
{
  load_ims(argv[1]);
  load_bnk(argv[2]);
  printf("\n OK");
  Clk_install();
  play_ims();
  system("command.com");
  end_ims();
  Clk_uninstall();
}
/*-----------------*/


TimeOut()
{  static idcode_st;
   int ch,idcode,t_delay;
   idcode=readmem(cur_byte);
   if ( idcode <0x80 ) idcode=idcode_st;
     else { cur_byte++;idcode_st=idcode; }
   ch=0x0f & idcode;
   switch ( 0xf0 & idcode )
     { case 0xc0:ins_rt(ch);break;
       case 0xa0:vol_rt(ch);break;
       case 0xe0:pit_rt(ch);break;
       case 0xf0:tem_rt();break;
       case 0x80:note1_rt(ch);break;
       case 0x90:note2_rt(ch);break;
      }
t_delay=0;
time_size:
     ch=readmem(cur_byte++);
     if ( readmem(cur_byte)==0xfc ) cur_byte=0;
     if ( ch==0xf8 )
	   { t_delay+=240;
	     goto time_size;
	   }
     if ( ch )
	  t_delay+=ch;
  return (t_delay);
}
