/******************************************************/
/*  splay.c                                           */
/*  Creative VOC & Windows WAV PC speaker player V1.1 */
/*  original program created in assembly code         */
/*   1993. 6. 21    ( Creator Unknown )               */
/*  translated to C code by Kim Sung Wan              */
/*   1993. 10. 9    ( Hitel ID : kaswan )  v1.0       */
/* large file version( can play upto 640k bytes file) */
/*   can read large file & some useles code removed   */
/*   1993. 10. 10                          v1.1       */
/*  Compiler BC++ 3.1  Memory model : LARGE           */
/******************************************************/
// this program use the FM method for playing VOC into PC speaker.
// FM method is better than Zero-cross method used in SFII.
// can play Windows WAV file (because of same data structure).

/*
  Timer chip 8253(XT) or 8254(AT) has three 16bit counters.

  timer counter Channel 0 : generate timer interrupt 0x8
  timer counter Channel 1 : DRAM refresh
  timer counter Channel 2 : set speaker tone frequency


  8253 I/O address

  0x40 : channel 0 data ( read & write )
  0x41 : channel 1 data ( read & write )
  0x42 : channel 2 data ( read & write )
  0x43 : 8253 command address
  first write command data to 0x43 and write data to a channel.

  8253 command

  7  6 5   4 3  1   0
 -----------------------
 | SC | RWM | TM | BCD |
 -----------------------

 SC : Select Counter
     00 : counter 0
     01 : counter 1
     10 : counter 2
     11 : read back command

 RWM : read/write mode
     00 : latch current counter value
     01 : read/write low byte of data
     10 : read/write high byte of data
     11 : read/write data low first high next

 TM : Timer pulse type
     000 : interrupt on terminal counter                  ___------------
     001 : ..
     X01 : Rate Generator ( use Timer Interrupt )         ---_---_---_---_
     X11 : Square Wave mode ( use speaker tone generate ) __--__--__--__--
     100 : ..
     101 : ..

 BCD : set Binary or BCD counter
     0 : Binary
     1 : BCD

 Timer chip 8253 generats 1193180 Hz clock tick.
 Interrupt rate depend on counter value.

 maximum frequency = 1193180 / 1            ( counter value 1 )
	  22096 Hz = 1193180 / 54(0x36)     ( counter value 54 )
	    896 Hz = 1193180 / 1331(0x533)  ( counter value 1331 )
 minimum frequency = 1193180 / 65536 = 18.2 ( counter value 0 ) default

  for change interrupt 08 rate you change counter 0 value.

  1. you first write command data 00110100(b) to 8253 chip.
  2. and write proper data to counter 0.

      outportb(0x43,0x34);
      outportb(0x40,low byte);
      outportb(0x40,high byte);

*/

#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>

#define BUSY 1   // voice playing
#define IDLE 0   // voice not playing

typedef unsigned char byte;


FILE * fp;

byte * voice_data[20]; // data buffer 20 pages
byte voice;            // voice value read
byte reg_data;         // register data read ( 8253 chip etc )
byte flag;             // end of play or not

unsigned long data_pointer = 0x1a; // voice data pointer
				   // 0x1a means skip hader
unsigned long data_size;           // file size
unsigned int page_num, page_etc;   // data buffer page number & remained data
int rate = 2, counter;             // for sampling rate

void interrupt far (* org_int08)(void); // original timer interrupt (IRQ 0)
void interrupt int_08(void);            // our new timer interrupt
void read_voice_data(char * );          // read data from file
byte read_data( unsigned long );        // read voice value from buffer

main(int argc, char * argv[])
{

	if (argc < 2)   // if no parameter
	{
	    printf("Creative VOC & Windows WAV file PC speaker player V1.1\n");
	    printf("Using FM method\n\n");
	    printf("Usage : splay  filename  [n]\n");
	    printf("n = ( 1 | 2 | 3 | 4 ) Sampling Rate \n");
	    printf("(2.75Khz | 5.5Khz | 11Khz | 22Khz) Default 11Khz\n");
	    return 1;
	}
	read_voice_data(argv[1]);

	if (argv[2]!=NULL)  // if sampling rate specified
	{
	    rate = atoi(argv[2]);      // char to int
	    if (0 < rate && rate < 5)  // check for range
	    rate = 5 - rate;           // convert to counter value
	}
	voice = 0;                     // voice value set to 0


	org_int08 = getvect(0x08);  // save original interrupt vector


	setvect(0x08,int_08);  // set user timer interrupt

	counter = rate;        // counter is skip numbers for sampling rate
	flag = BUSY;           // cf. int_08()

	outportb(0x43,0x34);   // command(timer)  0110100b
	// port 43h, 8253 wrt timr mode
	outportb(0x40,0x36);   // write timer rate 22 KHz
	outportb(0x40,0);      // 1193180/0x36 = 22 KHz
	// port 40h, 8253 timer 0 clock

	outportb(0x43,0x90);    // command(speaker) pulse type ___-------
	// port 43h, 8253 wrt timr mode   10010000b    no sound wave

	reg_data=inportb(0x61);    // speaker ON
	// port 61h, 8255 port B, read
	outportb(0x61,reg_data|3);
	// port 61h, 8255 B - spkr, etc


	do{                       //
				  // sound play
				  //
				  //
	}while( flag == BUSY);    //

	reg_data = inportb(0x61);  // speaker OFF
	// port 61h, 8255 port B, read
	outportb(0x61,reg_data&0xfc);
	// port 61h, 8255 B - spkr, etc

	outportb(0x43,0x34);   // command (timer)
	// port 43h, 8253 wrt timr mode
	outportb(0x40,0);      // restore original timer rate
	outportb(0x40,0);
	// port 40h, 8253 timer 0 clock

	outportb(0x43,0xb6);    // command (speaker)
	// port 43h, 8253 wrt timr mode
	asm	mov	ax, 0x533;
	asm	out	0x42, al;
	asm	mov	al, ah;
	asm	out	0x42, al;   // set frequency 0.9 KHz
	// port 42h, 8253 timer 2 spkr


	setvect(0x08,org_int08); // restore original interrupt

	return 0;
}

void read_voice_data(char * filename)// can read data larger than 64K
{
	int i;

	if ((fp = fopen(filename, "rb")) == NULL)
	{
	   printf("Cannot open file.\n");
	   exit(1);
	}

	data_size = filelength(fileno(fp));

	page_num=(data_size/32768);
	for ( i=0;i<page_num;i++ )
	{
	    voice_data[i]=malloc(32768);
	    fread(voice_data[i],32768,1,fp);
	}

	page_etc=data_size%32768;
	if ( page_etc )
	{
	    voice_data[page_num]=malloc(page_etc);
	    fread(voice_data[page_num],page_etc,1,fp);
	}

	fclose(fp);

}

byte read_data( unsigned long cub ) // read data from voice_data buffer
{
	unsigned int page, remain;

	page = (cub/32768);   //  32768 =  65536 / 2
	remain = (cub%32768);

	return( *( voice_data[page] + remain) );
}

void interrupt int_08(void)
{
	asm	cli

	asm	xor	al, al;       //
	asm	out	0x42, al;     //
	asm	mov     al, voice     //
	asm	out     0x42, al      // out voice data to spkr
	// port 42h, 8253 timer 2 spkr

	counter--;
	if ( counter == 0 )
	{
	   counter = rate;

	   voice = read_data(data_pointer) / 4 + 1;
	   // I don't know why calclulate like this!!

	   data_pointer++;
	   if (data_pointer >= data_size)  flag = IDLE;
	}

	asm	mov	al, 0x20;
	asm	out	0x20, al;   // end of interrupt message to 8259-1

	asm	sti
}



