#include<stdio.h>
#include<conio.h>
#include<math.h>

#define ESC 	27

#define ATTACK 	0
#define RUN_AWAY 1

#define X_MOVE	0
#define Y_MOVE	1

#define ML	0
#define SL	1
#define CT	2
#define SR      3
#define MR      4

#define MT	0
#define ST	1
#define SB      3
#define MB      4

#define LEFT	0
#define CENTER	1
#define RIGHT	2

#define TOP	0
#define BOTTOM	2

typedef unsigned char BYTE;

			     //  ML  SL  0  SR  MR
char rule_base_x[2][3][5] = {   -5, -3,  0,  1,  3, // LEFT
				-2, -1,  0,  1,  2, // CENTER
				-3, -1,  0,  3,  5, // RIGHT

				 1,  2,  1, -4, -2,
				 1,  2,  0, -2, -1,
				 1,  3, -1, -1,  0
				};


			     //  MT  ST  0  SB  MB
char rule_base_y[2][3][5] = {   -4, -2,  0,  1,  2, // TOP
				-4, -2,  0,  2,  4, // CENTER
				-2, -1,  0,  3,  5, // BOTTOM

				 6,  5,  2, -3, -2,
				 5,  4, -1, -2, -1,
				 4,  3, -2, -1,  0
				};

typedef struct {
	int x;
	int y;
	char shape;
	} OBJECT;

OBJECT my_ship,other_ship;

put_object(void)
{
	clrscr();

	if(other_ship.x < 1)
		other_ship.x = 1;
	if(my_ship.x < 1)
		my_ship.x = 1;
	if(other_ship.y < 1)
		other_ship.y = 1;
	if(my_ship.y < 1)
		my_ship.y = 1;

	gotoxy(1,1);
	printf("My Ship \(%d,%d\)   Other Ship \(%d,%d\)",my_ship.x,my_ship.y,other_ship.x,other_ship.y);
	gotoxy(my_ship.x,my_ship.y);
	printf("%c",my_ship.shape);
	gotoxy(other_ship.x,other_ship.y);
	printf("%c",other_ship.shape);
}

char compare_d_x(int d_x)
{
	char index;

	if(d_x<-6)		index=MR;
	else if(d_x<-2)		index=SR;
	else if(d_x<2)		index=CT;
	else if(d_x<=6)		index=SL;
	else if(d_x>6)		index=ML;

	return index;
}

char compare_d_y(int d_y)
{
	char index;

	if(d_y<-6)		index=MB;
	else if(d_y<-2)		index=SB;
	else if(d_y<2)		index=CT;
	else if(d_y<=6)		index=ST;
	else if(d_y>6)		index=MT;

	return index;
}

com_thinking(char arrow,char ship_mode,char x_or_y)
{
	int d_x,d_y;
	char index;
	char x_arrow,y_arrow;

	x_arrow=y_arrow=arrow;

	d_x=other_ship.x-my_ship.x;
	d_y=other_ship.y-my_ship.y;

	if(x_or_y == X_MOVE)
		y_arrow=CENTER;
	else
		x_arrow=CENTER;

	index=compare_d_x(d_x);
	if( (other_ship.x += rule_base_x[ship_mode][x_arrow][index]) > 80)
		other_ship.x = 80;

	index=compare_d_y(d_y);
	if( (other_ship.y += rule_base_y[ship_mode][y_arrow][index]) > 25)
		other_ship.y = 25;

}


main()
{
	BYTE key,arrow=CENTER;
	BYTE mode=2;
	BYTE x_or_y;

	my_ship.shape='M';
	other_ship.shape='R';

	my_ship.x = 35;
	my_ship.y = 23;
	other_ship.x = 2;
	other_ship.y = 2;

	while(mode>1){
		clrscr();

		printf("==================\n");
		printf(" 1. Attack Mode  \n");
		printf(" 2. Run Away Mode\n");
		printf("==================\n\n");
		printf(" select -> ");
		mode=getch()-'1';
		}

	clrscr();
	put_object();

	while( ((key=getch())!=ESC) && ((my_ship.x != other_ship.x) || (my_ship.y != other_ship.y)) ){
		switch(key){
			case '4':
				if((--my_ship.x)<1)
					my_ship.x=1;
				arrow=LEFT;
				x_or_y=X_MOVE;
				break;
			case '6':
				if((++my_ship.x)>80)
					my_ship.x=80;
				arrow=RIGHT;
				x_or_y=X_MOVE;
				break;
			case '8':
				if((--my_ship.y)<1)
					my_ship.y=1;
				arrow=TOP;
				x_or_y=Y_MOVE;
				break;
			case '2':
				if((++my_ship.y)>25)
					my_ship.y=25;
				arrow=BOTTOM;
				x_or_y=Y_MOVE;
				break;
			case 'A':
			case 'a':
				com_thinking(arrow,ATTACK,x_or_y);
			case 'G':
			case 'g':
				com_thinking(arrow,RUN_AWAY,x_or_y);
				break;
			default:
				com_thinking(arrow,mode,x_or_y);
				break;
			}/* for switch */

		com_thinking(arrow,mode,x_or_y);
		put_object();

		}/* for while */

}

