#include"mouse.h"

/* aa 
   b : ax - 0x0000
   b : ax - -1 (aa a awaw)
	     -  0 (aa a aww)
	  bx -  e 
   q : aaaaa aae  a a aea. */

int InitMouse(int mode)
{
   int result;

   _asm mov ax,0x0000
   _asm int 0x33
   _asm mov cl,mode
   _asm mov _screen_mode,cl
   _asm mov _button_how,bl
   _asm mov result,ax

   return result;
}

/* aa ɬ
   b : ax - 0x0001
   b : q */

void MPutOn()
{
   _asm mov ax,0x0001
   _asm int 0x33
}

/* aa ɬ
   b : ax - 0x0002
   b : q
   q : aa a eA gae , A aae q */

void MPutOff()
{
   _asm mov ax,0x0002
   _asm int 0x33
}

/* aa  Bb
   b : ax - 0x0003
   b : bx - e wȁ
	  cx - ᷁ xa
	  dx - ᷁ ya
   q :  +-+-+-+-+-+-+-+-+
	   |#|#|#|#|#|2|1|0| a
	   +-+-+-+-+-+-+-+-+
	  0 a E e
	  1 a e e
	  2 a e e (b e clickAi w 1 setting) */

int MPosiX()
{
   int result;

   _asm mov ax,0x0003
   _asm int 0x33
   _asm mov bx,cx
   _asm mov cl,_screen_mode
   _asm shr bx,cl              /* mule shr ae awaa,   */
   _asm mov cx,bx              /*  ae i   a. */
   _asm mov result,cx          /*  ae i  ϩaa a~? */

   return result;
}

int MPosiY()
{
   int result;

   _asm mov ax,0x0003
   _asm int 0x33
   _asm mov cl,_screen_mode
   _asm shr dx,cl
   _asm mov result,dx

   return result;
}

int MBHit()
{
   int result;

   _asm mov ax,0x0003
   _asm int 0x33
   _asm mov result,bx   /*  e clickAei bxA resultA w */

   return result;       /* clickE e ae 1 setting */
}

/* aai q clickAe 1 return, a ae 0 return
   aa e ae 2a returnQ ( 1.0.......2 ) */

int MBState(int button)
{
   int result=0;

   _asm mov ax,0x0003
   _asm int 0x33

start_cmp:
   _asm cmp _button_state,bx   /* a e awaa ae */
   _asm je end_mbstate         /* eai a */

lp1:
   _asm mov cx,_button_state   /* (_button_state&button)==button */
   _asm and cx,button
   _asm cmp cx,button
   _asm jne lp2
   _asm mov cx,bx
   _asm and cx,button
   _asm cmp cx,0               /* (bx&button)==0 */
   _asm jne lp2
   _asm mov word ptr result,2           /* e Aụ wȁ */
   _asm jmp end_mbstate

lp2:
   _asm mov cx,_button_state   /* (_button_state&button)==0 */
   _asm and cx,button
   _asm cmp cx,0
   _asm jne end_mbstate
   _asm mov cx,bx              /* (bx&button)==button */
   _asm and cx,button
   _asm cmp cx,button
   _asm jne end_mbstate
   _asm mov word ptr result,1           /* e clickbE wȁ */

end_mbstate:
   _asm mov _button_state,bx

   return result;
}

/* aa ᷁ ái 
   b : ax - 0x0004
	  cx - xa
	  dx - ya
   b : q
   q : aa ae aϢ Aai aaa Baa wAe
	  b 8 Ёea. */

void MSetXY(int x,int y)
{
   _asm push bx
   _asm mov ax,0x0004
   _asm mov cl,_screen_mode;
   _asm mov bx,x
   _asm mov dx,y
   _asm shr bx,cl   /* b aA xA Ё(mul -> shrewaw) */
   _asm shr dx,cl
   _asm mov cx,bx
   _asm pop bx
   _asm mov cx,x
   _asm mov dx,y
   _asm int 0x33
}

int MBClick(int left,int top,int right,int bottom,int button)
{
   if((MPosiX()>left-1 && MPosiX()<right+1) &&
      (MPosiY()>top-1 && MPosiY()<bottom+1) &&
      MBHit()==button) return _OK_CLICK;
   return _NO_CLICK;
}

/* aa ᷁ xa  Ae  
   b : ax - 0x0007
	  cx - x a At
	  dx - x a At
   b : q
   aa ᷁ ya  Ae  
   b : ax - 0x0008
	  cx - y a At
	  dx - y a At
   b : q */

void MWindow(int left,int top,int right,int bottom)
{
   _asm push bx   /* xa  b */
   _asm mov ax,0x0007
   _asm mov cl,_screen_mode
   _asm mov bx,left
   _asm mov dx,right
   _asm shl bx,cl
   _asm shl dx,cl
   _asm mov cx,bx
   _asm int 0x33
   _asm pop bx

   _asm push bx   /* ya  b */
   _asm mov ax,0x0008
   _asm mov cl,_screen_mode
   _asm mov bx,top
   _asm mov dx,bottom
   _asm shl bx,cl
   _asm shl dx,cl
   _asm mov cx,bx
   _asm int 0x33
   _asm pop bx
}

void MNotSee(int left,int top,int right,int bottom)
{
   if((MPosiX()>left-1 && MPosiX()<right+1) &&
      (MPosiY()>top-1 && MPosiY()<bottom+1)) MPutOff();
   else MPutOn();
}

void MNotSee2(int left,int top,int right,int bottom)
{
   if((MPosiX()>left-1 && MPosiX()<right+1) &&
      (MPosiY()>top-1 && MPosiY()<bottom+1)) MPutOn();
   else MPutOff();
}

/* aa ᷁ i 
   b : ax - 0x0009
	  bx -  xa
	  cx -  ya (click  Ae a)
	  es - aa ᷁ i a data segment
	  dx - aa ᷁ i a data offset
   b : q
   q : dxA b AND MASK OR MASK  i b
	   !  e ᷁ i aa(᷁ click á)
	  ##..............     ................
	  ###.............     .!..............
	  ####............     .##.............
	  #####...........     .###............
	  ######..........     .####...........
	  ######..........     ..#.............
	  .###............     ..#.............
	  .###............     ................
	  ................     ................
	  ................     ................
	  ................     ................
	  ................     ................
	  ................     ................
	  ................     ................
	  ................     ................
	  ................     ................

	  0011111111111111     0000000000000000
	  0001111111111111     0100000000000000
	  0000111111111111     0110000000000000
	  0000011111111111     0111000000000000
	  0000001111111111     0111100000000000
	  0000001111111111     0010000000000000
	  1000111111111111     0010000000000000
	  1000111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000
	  1111111111111111     0000000000000000

	      AND MASK             OR MASK
	       0x3fff               0x0000
	       0x1fff               0x4000
	       0x0fff               0x6000
	       0x07ff               0x7000
	       0x03ff               0x2000
	       0x03ff               0x2000
	       0x8fff               0x0000
	       0x8fff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       0xffff               0x0000
	       -> example.curA wA e w */

int MGSetCursor(int cent_x,int cent_y,unsigned int *data)
{
   unsigned int _segment;
   _segment=FP_SEG(data);
   if(data==NULL) return _NO_SET;

   _asm push es
   _asm mov ax,_segment
   _asm mov es,ax
   _asm mov bx,cent_x
   _asm mov cx,cent_y
   _asm mov dx,data
   _asm mov ax,0x0009
   _asm int 0x33
   _asm pop es

   return _OK_SET;
}

Cursor *LoadCursorData(char *file_name)
{
   FILE *rf;
   Cursor *new_data;
   if((rf=fopen(file_name,"rb"))==NULL) {
      free(new_data);
      return NULL;
   }
   new_data->data=(unsigned int *)malloc(64);
   fread(&new_data->cent_x,1,2,rf);   /* x i q (1aa) */
   fread(&new_data->cent_y,1,2,rf);   /* y i q (1aa) */
   fread(new_data->data,32,2,rf);     /*  datai q (32*2aa) */
   fclose(rf);
   return(new_data);
}

/* aa q 
   b : ax - 0x000f
	  cx - x q
	  dx - y q
   b : q
   q :  qe (x,y) - (8,16) a, t i  qe aa
          Ae  ӱia. */

void MSpeed(int x,int y)
{
   _asm mov ax,0x000f
   _asm mov cx,x
   _asm mov dx,y
}

