(***************************************************)
(* Flags & Counters --- What they stand for        *)
(* Flags 0   Display CMD detail as being processed *)
(*           enter DEBUG to toggle ON and OFF      *)
(* Flags 1   ON if player has been in cave         *)
(* Flags 2   Has thrown something into chasm if ON *)
(* Flags 3   Harp is in tune if ON                 *)
(* Flags 5   Has met toad if ON                    *)
(* Flags 6   Has met princess if ON                *)
(* Flags 7   Has met horse if ON                   *)
(* Counter 1 Number of turns torch has been lit    *)
(* Counter 2 Number of turns player has been       *)
(*           stumbling around in the dark          *)
(***************************************************)

(***************************************************)
(*   First -- Automatic commands executed each turn*)
(*   Part     regardless of command's VERB etc     *)
(***************************************************)

(***************************************************)
(*  Automatic commands to control time torch is ON *)
(*   -- Torch starts to flicker at 50 turns        *)
(*   -- Torch goes off at 75 turns                 *)
(*   -- Player dies if he stumbles around in dark  *)
(*      for 5 turns                                *)
(***************************************************)


COMMAND ANY
Present 210 (* Blazing torch *)
CounterEquals 1 50 (* light has been on for 50 turns *)
PrintMessage 74 (* light is flickering *)
RoomNeedsLight (* will be dark if no light *)
PrintMessage 75 (* Better get out before light goes out *)
END_COMMAND

COMMAND ANY
Present 210 (* Blazing torch *)
CounterGT 1 50 (* light has been on for more than 50 turns *)
CounterLT 1 75 (* light has been on for less than 75 turns *)
PrintMessage 74 (* light is flickering *)
END_COMMAND

COMMAND ANY
Present 210 (* Blazing torch *)
CounterEquals 1 75 (* light has been on for 75 turns *)
PrintMessage 76 (* light has gone out *)
SwapLocations 210 203 (* switch to unlit torch *)
Destroy 207 (* dry matches *)
RoomNeedsLight (* will be dark if no light *)
TurnCounterON 2 (* now stumbling around in dark *)
LookAtRoom
END_COMMAND

COMMAND ANY
RoomNeedsLight (* will be dark if no light *)
NOT LightPresent (* no light in room *)
CounterEquals 2 0 (* stumbling counter not currently on *)
PrintMessage 77 (* stumbling is dangerous *)
TurnCounterON 2 (* now start counter for stumbling around in dark *)
END_COMMAND

COMMAND ANY
CounterGT 2 1 (* stumbling around in dark *)
RoomNeedsLight (* will be dark if no light *)
NOT LightPresent (* no light in room *)
PrintMessage 77 (* stumbling is dangerous *)
CounterEquals 2 5
KillPlayer (* Player dies *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
CounterGT 2 5 (* have previously been stumbling around in dark *)
RoomNeedsLight (* will be dark if no light *)
NOT LightPresent (* no light in room *)
TurnCounterON 2 (* re-start counter for stumbling around in dark *)
END_COMMAND

(***************************************************)
(*  Automatic commands to offer player hint if     *)
(*  player has not been in cave by TURN 10         *)
(***************************************************)

COMMAND ANY
ATlocation 7 (* in cave *)
TurnFlagON 1 (* has visited cave *)
END_COMMAND

COMMAND ANY
FlagOFF 1 (* hasn't visited cave yet *)
TurnsEquals 10
PrintMessage 14 (* offer player a hint for 10 points *)
PromptForYes (* get player's answer *)
PrintMessage 16 (* give hint *)
MinusScore 10 (* subtract 10 points from score *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

(***************************************************)
(*  Automatic commands to control appearance and   *)
(*  disappearance of guard at various locations    *)
(***************************************************)

COMMAND ANY
Chance 20
AtLocation 24  (* Baron's private chamber *)
NOT InRoom 301  (* Guard *)
PutInCurrentRoom 301  (* Put guard in room *)
PrintMessage 33   (* Guard suddenly appears *)
BlankLine
END_COMMAND

COMMAND ANY
Chance 50
AtLocation 17  (* Guard's quarters *)
NOT InRoom 301  (* guard *)
PutInCurrentRoom 301 (* angry guard *)
PrintMessage 33 (* guard appears *)
BlankLine
END_COMMAND

COMMAND ANY
Chance 50
AtLocation 39 (* passage near cell *)
NOT InRoom 301 (* guard *)
NOT InRoom 259 (* unconscious guard *)
PutInCurrentRoom 301 (* angry guard *)
PrintMessage 33 (* Guard appears *)
BlankLine
END_COMMAND

COMMAND ANY
InRoom 301 (* guard *)
NOT atLocation 39 (* passage near cell *)
IsWearing 230 (* Baron's Armor *)
SendToRoom 301 11 (* guard leaves *)
PrintMessage 45 (* Guard leaves *)
AtLocation 11 (* small room in cave *)
Destroy 301 (* Guard disappears *)
END_COMMAND

(***************************************************)
(*  Automatic commands to give and heal player     *)
(*  a broken leg                                   *)
(***************************************************)

COMMAND ANY
IsCarrying 215 (* Broken leg *)
VerbIsDirection (* Trying to move *)
PrintMessage 8 (* Sorry, but you can't *)
PrintMessage 43 (* with a broken leg *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
Chance 20
IsCarrying 215 (* Broken leg *)
PrintMessage 44 (* Leg is healed *)
BlankLine
Destroy 215  (* get rid of broken leg *)
END_COMMAND

COMMAND ANY
Chance 25
AtLocation 11 (* room in wall *)
InRoom 301 (* Guard *)
GetIt 215 (* give broken leg *)
GoToRoom 10  (* guard throws you into room 10 *)
PrintMessage 42
PutInCurrentRoom 204 (* rope goes in to room also *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

(***************************************************)
(*  Automatic commands to control meeting horse    *)
(*  and have horse follow player                   *)
(***************************************************)

COMMAND ANY
Present 303 (* horse *)
FlagOFF 7 (* hasn't met horse yet *)
TurnFlagON 7 (* now has met *)
PrintMessage 83 (* met horse *)
BlankLine
END_COMMAND

COMMAND ANY
FlagON 7 (* has met horse *)
AtLocation 19 (* in courtyard *)
PutInCurrentRoom 304 (* grazing horse *)
END_COMMAND

COMMAND ANY
FlagON 7 (* has met horse *)
IsSomeWhere 216 (* drawbridge is down *)
AtLocationGT 1 (* outside castle *)
AtLocationLT 7 (* not in cave *)
NOT AtLocation 3 (* not at top of tree *)
PutInCurrentRoom 304 (* grazing horse *)
END_COMMAND

COMMAND ANY
FlagON 7 (* has met horse *)
IsSomeWhere 216 (* drawbridge is down *)
AtLocation 43 (* thick woods *)
PutInCurrentRoom 304 (* grazing horse *)
END_COMMAND

COMMAND ANY
FlagON 7 (* has met horse *)
IsSomeWhere 216 (* drawbridge is down *)
AtLocation 12 (* top of hill *)
SendToRoom 304 45 (* grazing horse goes to winning room *)
END_COMMAND

(***************************************************)
(*  Automatic commands to control meeting toad     *)
(*  and have toad follow player and speak          *)
(***************************************************)

COMMAND ANY
Present 300 (* toad *)
TurnFlagON 5 (* has met toad *)
END_COMMAND

COMMAND ANY
IsSomewhere 300 (* toad exists *)
FlagON 5 (* has met toad *)
PutInCurrentRoom 300 (* put toad in room *)
VerbIsDirection (* moving to another location *)
PrintMessage 80 (* the toad follows you *)
END_COMMAND

COMMAND ANY
Chance 50
Present 300 (* horny toad *)
PrintMessage 66 (* Toad says Rib-bit *)
BlankLine
END_COMMAND

(***************************************************)
(*  Automatic commands to control meeting princess *)
(*  and have princess follow player                *)
(***************************************************)

COMMAND ANY
Present 302 (* princess *)
TurnFlagON 6 (* has met princess *)
END_COMMAND

COMMAND ANY
IsSomewhere 302 (* princess exists *)
FlagON 6 (* has met princess *)
PutInCurrentRoom 302 (* put princess in room *)
VerbIsDirection (* moving to another location *)
PrintMessage 81 (* the princess follows you *)
END_COMMAND

(***************************************************)
(*  Automatic commands to control skull speaking   *)
(***************************************************)

COMMAND ANY
Chance 10
Present 245  (* Skull *)
PrintMessage 57  (* Skull speaks *)
PrintMessage 26  (* Baron sucks eggs *)
BlankLine
END_COMMAND

COMMAND ANY
Present 245  (* Skull *)
AtLocation 28  (* A cavern with glowing walls *)
PrintMessage 57  (* Skull speaks *)
PrintMessage 58  (* Beware the vampire *)
BlankLine
END_COMMAND

COMMAND ANY
Present 245  (* Skull *)
AtLocation 31 (* east end of cavern *)
PrintMessage 57  (* Skull speaks *)
PrintMessage 59  (* Beware the chest *)
BlankLine
END_COMMAND

COMMAND ANY
Present 245 (* Skull *)
AtLocation 40  (* A secret passageway *)
PrintMessage 57  (* Skull speaks *)
PrintMessage 60  (* Beware the gold bars *)
BlankLine
END_COMMAND

(***************************************************)
(*  Automatic commands to control appearance of    *)
(*  vampire bats and their biting of player        *)
(***************************************************)

COMMAND ANY
Chance 50
InRoom 246 (* vampire bat *)
NOT IsWearing 252 (* Silver cross *)
PrintMessage 63  (* Bat just bit you *)
GoToRoom 42  (* go limbo *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
Chance 80
AtLocation 29  (* room with strange smell *)
NOT InRoom 246  (* vampire bat *)
PutInCurrentRoom 246 (* put bat in room *)
PrintMessage 65 (* you hear bat wings flapping *)
LookAtRoom
END_COMMAND

(***************************************************)
(*  Automatic commands whenever player is swimming *)
(*  -- matches get soggy                           *)
(*  -- torch goes out                              *)
(*  -- piranha eat player                          *)
(***************************************************)

COMMAND ANY
AtLocation 13  (* in water *)
Present 207 (* dry matches *)
SwapLocations 207 208  (* swap with wet soggy matches *)
END_COMMAND

COMMAND ANY
AtLocation 13  (* in water *)
Present 210 (* blazing torch *)
SwapLocations 210 203  (* swap with unlit torch *)
TurnCounterOFF 1 (* no longer counting number of turns torch is lit *)
END_COMMAND

COMMAND ANY
Chance 80
AtLocation 13 (* in water *)
InRoom 217 (* Piranha *)
PrintMessage 1 (* hear strange sound *)
PrintMessage 38 (* you made as tasty meal *)
KillPlayer  (* go to limbo *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

(***************************************************)
(*   Last   -- Specific VERB,NOUN & OBJECT commands*)
(*   Part      executed only when VERB,NOUN,OBJECT *)
(***************************************************)

COMMAND CLIMB ROPE
Present 204 (* Rope with hook *)
PrintMessage 30 (* Throw it first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB ROPE
InRoom 229 (* Drawbridge rope *)
GoToRoom 15 (* catwalk *)
PrintMessage 39 (* climb up rope... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB ROPE
InRoom 234 (* hanging rope *)
AtLocation 15 (* catwalk *)
GoToRoom 14 (* outer wall *)
PutInCurrentRoom 234 (* hanging rope *)
PrintMessage 41 (* climb down rope... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB ROPE
InRoom 234 (* hanging rope *)
AtLocation 14 (* outer wall *)
GoToRoom 15 (* catwalk *)
PutInCurrentRoom 234 (* hanging rope *)
PrintMessage 39 (* climb up rope... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB ROPE
InRoom 234 (* hanging rope *)
AtLocation 11 (* room in wall *)
GoToRoom 10 (* large cavern *)
PutInCurrentRoom 234 (* hanging rope *)
PrintMessage 41 (* climb down rope... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB ROPE
InRoom 234 (* hanging rope *)
AtLocation 10 (* large cavern *)
GoToRoom 11 (* room in wall *)
PutInCurrentRoom 234 (* hanging rope *)
PrintMessage 39 (* climb up rope... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB WALL
AtLocation 10 (* large cavern *)
PrintMessage 34 (* too high to climb!! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLIMB WALL
AtLocation 14 (* outer wall *)
PrintMessage 34 (* too high to climb!! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO PASSAGE
InRoom 224 (* secret passage *)
GoToRoom 40 (* passageway *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ENTER PASSAGE
InRoom 224 (* secret passage *)
GoToRoom 40 (* passageway *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO OPENING
AtLocation 10 (* large cavern *)
PrintMessage 34 (* too high to climb!! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DRAWBRIDGE
InRoom 216 (* lowered bridge *)
AtLocation 4 (* water's edge *)
GoToRoom 19 (* Courtyard *)
PutInCurrentRoom 216 (* lowered bridge *)
PrintMessage 19 (* you walk across bridge *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DRAWBRIDGE
InRoom 216 (* lowered bridge *)
AtLocation 19 (* Courtyard *)
GoToRoom 4 (* water's edge *)
PutInCurrentRoom 216 (* lowered bridge *)
PrintMessage 19 (* you walk across bridge *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DRAWBRIDGE
InRoom 212 (* Raised bridge *)
PrintMessage 8 (* Sorry, you can't *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO COFFIN
InRoom 243 (* open coffin *)
GoToRoom 28 (* cavern *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO LEDGE
PrintMessage 8 (* Sorry, you can't *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND JUMP ANY
GetIt 215 (* Broken leg *)
PrintMessage 6 (* That's not safe! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET ANY
InRoom 301 (* angry guard *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 25 (* Guard won't allow *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET ANY
IsCarrying 215 (* Broken leg *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 43 (* with broken leg *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET KEY
InRoom 259 (* unconscious guard *)
IsNowhere 253 (* guard's keys *)
GetIt 253 (* get his keys *)
PrintMessage 82 (* you search guard and find keys *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET ROPE
InRoom 234 (* hanging rope *)
Destroy 234 (* hanging rope *)
GetIt 204 (* Rope with hook *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET BOOK
InRoom 224 (* secret passage *)
IsNowhere 232 (* Scott book *)
GetIt 232 (* Scott book *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET BOOK
AtLocation 24 (* Baron's chamber *)
InRoom 223 (* Bookcase *)
SwapLocations 223 224
GetIt 231 (* adventure hint book *)
PrintMessage 15 (* OK... *)
PrintMessage 1 (* hear strange sound *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET CHEST
AtLocation 35 (* Baron's stronghold *)
Present 249 (* Chest *)
SendToRoom 249 26 (* send chest to east tower room *)
PrintMessage 79 (* It disappears in a puff of blue smoke *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET SKULL
AtLocation 27 (* family crypt *)
InRoom 245 (* skull *)
PrintMessage 57 (* skull speaks *)
PrintMessage 58 (* beware the vampire *)
END_COMMAND

COMMAND GET SIGN
NOUNInRoom (* any sign is here *)
PrintMessage 22 (* Voice booms out *)
PrintMessage 23 (* leave the sign alone *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET WATER
PrintMessage 8 (* sorry, but you can't *)
PrintMessage 11 (* you've no container *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET BAR
InRoom 254 (* open door *)
SwapLocations 254 255 (* put closed door in room *)
GetIt 251 (* gold bar *)
PrintMessage 15 (* OK *)
BlankLine
ChangePassageway 4 0 (* Close exit to west *)
PrintMessage 64 (* door slams shut *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET COBWEB
NOUNinRoom (* cobwebs are here *)
PrintMessage 68 (* Spider bites you *)
GoToRoom 42 (* Go to Limbo *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT MATCHES
Present 207 (* dry matches *)
PrintMessage 85 (* It burns for a few minutes and then goes out *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT MATCHES
Present 208 (* soggy matches *)
PrintMessage 8 (* Sorry, but you can't *)
PrintMessage 31 (* matches too wet *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT TORCH
Present 203 (* torch *)
Present 207 (* dry matches *)
SwapLocations 203 210 (* swap to blazing torch *)
PrintMessage 15 (* OK... *)
TurnCounterON 1 (* start count for light being lit *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT TORCH
Present 203 (* torch *)
Present 208 (* soggy matches *)
PrintMessage 8 (* Sorry, but you can't *)
PrintMessage 31 (* matches too wet *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT TORCH
Present 203 (* torch *)
NOT Present 207 (* dry matches *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 46 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT WOOD
Present 267 (* fire wood *)
Present 208 (* soggy matches *)
PrintMessage 31 (* matches too wet *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT WOOD
Present 267 (* fire wood *)
NOT Present 207 (* dry matches *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 46 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT WOOD
ATlocation 18 (* west end of great hall *)
Present 267 (* fire wood *)
Present 207 (* dry matches *)
SwapLocations 267 273
PrintMessage 37 (* that feels good!! *)
InRoom 235 (* unlit fireplace *)
SwapLocations 236 235 (* put blazing fireplace in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT WOOD
Present 267 (* fire wood *)
Present 207 (* dry matches *)
PutInCurrentRoom 267 (* fire wood *)
SwapLocations 267 273
PrintMessage 37 (* that feels good!! *)
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT FIRE
Present 267 (* fire wood *)
Present 208 (* soggy matches *)
PrintMessage 31 (* matches too wet *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT FIRE
Present 267 (* fire wood *)
NOT Present 207 (* dry matches *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 46 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT FIRE
ATlocation 18 (* west end of great hall *)
Present 267 (* fire wood *)
Present 207 (* dry matches *)
SwapLocations 267 273
PrintMessage 37 (* that feels good!! *)
InRoom 235 (* unlit fireplace *)
SwapLocations 236 235 (* put blazing fireplace in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT FIRE
Present 267 (* fire wood *)
Present 207 (* dry matches *)
PutInCurrentRoom 267 (* fire wood *)
SwapLocations 267 273
PrintMessage 37 (* that feels good!! *)
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH TORCH
Present 210 (* blazing torch *)
PrintMessage 15 (* OK... *)
SwapLocations 203 210
TurnCounterOFF 1 (* stop count of light being on *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH FIRE WITH WINE
Present 273 (* blazing fire *)
Present 226 (* fine wine *)
Destroy 226 (* fine wine *)
SwapLocations 273 272
PrintMessage 67 (* extinguish fire with wine *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH FIRE
Present 273 (* blazing fire *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 72 (* Don't have water *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP ANY
AtLocation 12 (* Top of hill *)
NOUNpresent
SendNOUNToRoom 45 (* send noun to winning room *)
PrintMessage 79 (* It disappears in a puff of blue smoke *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP ALL
AtLocation 12 (* Top of hill *)
SendAllToRoom 45 (* send items being carried noun to winning room *)
PrintMessage 84 (* They disappear in a puff of blue smoke *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP PILLS IN WATER
AtLocation 4 (* water's edge *)
IsCarrying 220 (* sleeping pills *)
SwapLocations 221 217
Destroy 220 (* sleeping pills *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP PILLS
AtLocation 13 (* in water *)
IsCarrying 220 (* sleeping pills *)
SwapLocations 221 217
Destroy 220 (* sleeping pills *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP LEG
IsCarrying 215 (* Broken leg *)
PrintMessage 22 (* voice booms out *)
PrintMessage 24 (* Don't be silly! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP WINE ON FIRE
Present 273 (* blazing fire *)
Present 226 (* fine wine *)
Destroy 226 (* fine wine *)
SwapLocations 273 272 (* swap blazing fire for soggy wood *)
PrintMessage 67 (* extinguish fire with wine *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND POUR WINE ON FIRE
Present 273 (* blazing fire *)
Present 226 (* fine wine *)
Destroy 226 (* fine wine *)
SwapLocations 273 272
PrintMessage 67 (* extinguish fire with wine *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP WINE
NOT Present 273 (* blazing fire *)
Present 226 (* wine *)
Destroy 226 (* wine *)
PrintMessage 73 (* bottle shatters *)
PrintMessage 12 (* what a waste *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THROW WINE ON FIRE
Present 273 (* blazing fire *)
Present 226 (* fine wine *)
Destroy 226 (* fine wine *)
SwapLocations 273 272
PrintMessage 67 (* extinguish fire with wine *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THROW PILLS IN WATER
AtLocation 4 (* water's edge *)
IsCarrying 220 (* sleeping pills *)
SwapLocations 221 217
Destroy 220 (* sleeping pills *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THROW PILLS
AtLocation 13 (* in water *)
IsCarrying 220 (* sleeping pills *)
SwapLocations 221 217
Destroy 220 (* sleeping pills *)
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THROW ANY
NOUNPresent (* any noun *)
AtLocation 36 (* south ledge *)
OR
AtLocation 30 (* north ledge *)
DestroyNOUN (* any noun *)
TurnFlagON 2 (* has thrown something *)
PrintMessage 52 (* It disappears into the chasm *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THROW ROPE
AtLocation 14 (* outer wall *)
OR
AtLocation 10 (* large cavern *)
Present 204 (* Rope with hook *)
Destroy 204 (* Rope with hook *)
PutInCurrentRoom 234 (* hanging rope *)
PrintMessage 29 (* rope catches *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN ANY
InRoom 301 (* angry guard *)
PrintMessage 25 (* Guard won't allow *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN EGG
Present 274 (* golden egg *)
PrintMessage 10 (* crack egg -- sparrow appears *)
SwapLocations 274 279 (* replace egg with eggshell pieces *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 213 (* closed door *)
IsUnLocked 213 (* door is unlocked *)
SwapLocations 213 237 (* put open door in room *)
ChangePassageway 1 31 (* open passage north to room 31 *)
PrintMessage 4 (* The door is now open *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 256 (* closed door *)
IsUnLocked 256 (* door is unlocked *)
SwapLocations 262 256 (* put open door in room *)
SwapLocations 270 271 (* put open door on other side -- also *)
ChangePassageway 4 39 (* open passage west to room 39 *)
PrintMessage 4 (* The door is now open *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 270 (* closed door *)
IsUnLocked 270 (* door is unlocked *)
SwapLocations 270 271 (* put open door in room *)
SwapLocations 262 256 (* put open door on other side -- also *)
ChangePassageway 3 41 (* open passage east to room 41 *)
PrintMessage 4 (* The door is now open *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 255 (*closed door*)
IsUnLocked 255 (* door is unlocked *)
SwapLocations 254 255
ChangePassageway 4 40 (* open passage west to room 40 *)
PrintMessage 4 (* It's open *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN BOOK
PrintMessage 15 (* OK... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN CHEST
NOT AtLocation 45 (* Winning room *)
PrintMessage 69 (* Baron appears and kills you *)
KillPlayer (* Go to Limbo *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN COFFIN
InRoom 242 (* closed coffin *)
SwapLocations 242 243
PrintMessage 15 (* OK... *)
ChangePassageway 10 28 (* open passage down to room 28 *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ATTACK GUARD
InRoom 301 (* angry guard *)
AtLocation 39 (* near dungeon cell *)
SwapLocations 259 301 (* put unconscious guard in room *)
PrintMessage 49 (* It was a fierce fight *)
PrintMessage 51 (* but you won! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ATTACK GUARD
InRoom 301 (* angry guard *)
GoToRoom 41 (* Cell *)
PrintMessage 49 (* It was a fierce fight *)
PrintMessage 50 (* but you lost! *)
SendAllToRoom 17 (* Guard's takes stuff to his quarters *)
SendtoRoom 202 41 (* Put shining lamp in dungeon cell with you *) 
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SEARCH GUARD
InRoom 259 (* unconscious guard *)
GetIt 253 (* get his keys *)
PrintMessage 82 (* you search guard and find keys *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FIND KEY
InRoom 259 (* unconscious guard *)
GetIt 253 (* get his keys *)
PrintMessage 82 (* you search guard and find keys *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FIND KEY
IsNowhere 259 (* unconscious guard *)
PrintMessage 36 (* try the harp *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FIND ANY
PrintMessage 18 (* don't see it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND HELP ANY
RoomNeedsLight (* will be dark if no light *)
NOT LightPresent (* no light in room *)
PrintMessage 17 (* You are in real trouble... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND HELP ANY
AtLocation 36 (* south ledge *)
OR
AtLocation 30 (* north ledge *)
FlagON 2 (* has thrown something *)
TurnFlagOFF 2
PrintMessage 56 (* Sorry about that ... *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND HELP ANY
IsCarrying 215 (* Broken leg *)
PrintMessage 47 (* time heals all things *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CRACK EGG
Present 274 (* golden egg *)
PrintMessage 10 (* crack egg -- sparrow appears *)
SwapLocations 274 279 (* replace egg with eggshell pieces *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BREAK DOOR WITH AXE
AtLocation 41 (* Cell *)
IsCarrying 227 (* Axe *)
SwapLocations 256 262
SwapLocations 270 271
PrintMessage 15 (* OK... *)
PrintMessage 40 (* Timber !! *)
ChangePassageway 4 39 (* open passage to room 39 *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BREAK DOOR WITH AXE
AtLocation 39 (* passage outside Cell *)
IsCarrying 227 (* Axe *)
SwapLocations 256 262
SwapLocations 270 271
PrintMessage 15 (* OK... *)
PrintMessage 40 (* Timber !! *)
ChangePassageway 3 41 (* open passage to room 41 *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BREAK DOOR WITH AXE
AtLocation 11 (* small room in cave *)
IsCarrying 227 (* Axe *)
SwapLocations 213 237
PrintMessage 15 (* OK... *)
PrintMessage 40 (* Timber !! *)
ChangePassageway 1 31 (* open passage to room 31 *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BREAK DOOR
PrintMessage 9 (* rush door with shoulder *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BREAK ANY
NOT Present 227 (* axe *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 13 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TUNE HARP
Present 222 (* harp *)
NOT Present 233 (* harp tuning key *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 13 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TUNE HARP
Present 222 (* harp *)
Present 233 (* harp tuning key *)
PrintMessage 20 (* you tune the harp *)
TurnFlagON 3 (* harp has now been tuned *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXAMINE HARP
Present 222 (* harp *)
FlagON 3 (* harp is in tune *)
PrintMessage 48 (* harp is in tune *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PLAY HARP
Present 222 (* harp *)
FlagON 3 (* harp is in tune *)
PrintMessage 32 (* play harp beautifully *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PLAY HARP
Present 222 (* harp *)
IsNowhere 233 (* harp tuning key *)
PutInCurrentRoom 233 (* harp tuning key *)
PrintMessage 1 (* hear strange sound *)
LookAtRoom
END_COMMAND

COMMAND CUT TREE
IsCarrying 227 (* Axe *)
AtLocation 2 (* dense forest *)
OR
AtLocation 43 (* thick woods *)
PrintMessage 40 (* Timber !! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CUT ROPE
InRoom 229 (* Drawbridge rope *)
IsCarrying 227 (* Axe *)
SwapLocations 229 216 (* put lowered drawbridge in room *)
Destroy 212 (* Raised bridge *)
PrintMessage 78 (* Drawbridge may now be crossed *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CUT ANY
NOT Present 227 (* axe *)
PrintMessage 8 (* Sorry, you can't *)
PrintMessage 13 (* don't have resources *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO PRINCESS
Present 302 (* Princess *)
PrintMessage 5 (* chat with princess *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO GUARD
Present 301 (* Guard *)
GoToRoom 41 (* Cell *)
PrintMessage 3 (* chat with guard *)
PrintMessage 49 (* It was a fierce fight *)
PrintMessage 50 (* but you lost! *)
SendAllToRoom 17 (* Guard's takes stuff to his quarters *)
SendtoRoom 202 41 (* Put shining lamp in dungeon cell with you *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO TOAD
Present 300 (* toad *)
PrintMessage 2 (* chat with toad *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ASK TOAD ABOUT ANY
Present 300 (* toad *)
PrintMessage 2 (* chat with toad *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ASK GUARD ABOUT ANY
Present 301 (* Guard *)
GoToRoom 41 (* Cell *)
PrintMessage 3 (* chat with guard *)
PrintMessage 49 (* It was a fierce fight *)
PrintMessage 50 (* but you lost! *)
SendAllToRoom 17 (* Guard's takes stuff to his quarters *)
SendtoRoom 202 41 (* Put shining lamp in dungeon cell with you *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ASK PRINCESS ABOUT ANY
Present 302 (* Princess *)
PrintMessage 7 (* ask princess *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ BOOK
IsCarrying 231 (* adventure hint book *)
IsNowhere 238 (* large diamond *)
PrintMessage 35 (* something fell out *)
BlankLine
PutInCurrentRoom 238 (* large diamond *)
LookAtRoom
END_COMMAND

COMMAND RIDE HORSE
Present 304 (* Baron's horse *)
PrintMessage 21 (* You ride the horse for a while *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS TOAD
Present 300 (* toad *)
SwapLocations 300 302
PrintMessage 54 (* Toad turns into princess! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS PRINCESS
AtLocation 45 (* winning room *)
Present 302 (* princess *)
PrintMessage 61 (* last kiss for princess!! *)
PlusScore 50 (* get special BONUS for being a true romantic! *)
WinGame (* one last kiss to win *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS PRINCESS
NOT AtLocation 12 (* Top of hill *)
Present 302 (* princess *)
PrintMessage 55 (* kiss princess!! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS PRINCESS
AtLocation 12 (* Top of hill *)
Present 302 (* princess *)
PrintMessage 86 (* Oh! Rapture!! *)
GoToRoom 45 (* Win Game Room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS ANY
NOT AtLocation 12 (* Top of hill *)
PrintMessage 24 (* Don't be silly! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DEBUG
ToggleFlag 0 (* toggle diagnostic mode *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

