#include <stdio.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <dos.h>
#include "header.h"
#include "extern.h"

struct   PCX_File PCX1024;
unsigned width1024, height1024;

static   FILE   *fp1024;
static   BYTE   s1024[1024];         /* 1024*768*256 -> 1024 */
static   struct ExtendPalette p1024;
static   union  REGS r1024;
int      temp1024 = 0;
int      active_bank1024 = 0;

/*~~~~~~~~~~~~~~~~*\
\*___Recompress___*/

static CompletionCode expand_data1024(FILE *fpp)   /* si ΁e q. */
{
 register short R;
 unsigned B, cnt, ptr = 0;

 B = PCX1024.Info.Num_plane * PCX1024.Info.Byte_line;
 do {
    R = getc(fpp);
    if(R == EOF) return(0);
    if((R & 0xc0) == 0xc0) {
			   cnt = R & 0x3f;
			   R = getc(fpp);
			   if(R == EOF) return(0);
			   while (cnt--) s1024[ptr++] = R;
			   }
	else
	    s1024[ptr++] = R;
 } while (ptr < B);
 return(1);
}


/*~~~~~~~~~~~~~~~~~~*\
\*___See_pcx_file___*/

see_pcx_1024(char *f_name) /*  PCXi bea. */
{
 register unsigned s, c, i;

 fp1024 = fopen(f_name, "rb");
 fread(&PCX1024, 128, 1, fp1024);

 width1024  = PCX1024.x2 - PCX1024.x1 + 1;    /*PCX.PCXHeader.hres;*/
 height1024 = PCX1024.y2 - PCX1024.y1 + 1;    /*PCX.PCXHeader.vres;*/

/* set_your_video(0x5d); */
 set_stand_video1024(0x105);          /* 1024*768*256 */
 for(s = 0; s < height1024; s++) {
		 expand_data1024(fp1024);
		 for(c = 0; c < width1024; c++)
				 set_pixel1024(c, s, s1024[c]);
		 }

 fread(&p1024, 769, 1, fp1024);
 for(i = 0; i < 256; i++)
		 {
		 p1024.Palette[i].red   >>= 2;
		 p1024.Palette[i].green >>= 2;
		 p1024.Palette[i].blue  >>= 2;
		 }
 set_pal1024((ColorRegister *) & (p1024.Palette));
 fclose(fp1024);
}


/*~~~~~~~~~~~~~~~~~~~~*\
\*___set_your_video___*/

set_your_video1024(int mode)
{
 r1024.h.ah = 0;
 r1024.h.al = mode;
 int86(0x10, &r1024, &r1024);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~*\
\*___set_standard_video___*/

int set_stand_video1024(int mode1)
{
 r1024.x.ax = 0x4f02;
 r1024.x.bx = mode1;
 int86(0x10, &r1024, &r1024);
}


/*~~~~~~~~~~~~~~~*\
\*___set_pixel___*/

set_pixel1024(int x, int y, int color)
{
 long int offset, base;
 char far *address;
 int bank, temp1024;

 offset = (long)1024*(long)y + (long)x;    /* 1024*768*256 -> 1024 */

 if( y <= 63) bank = 0;
 else if( y >= 64 && y <= 127) bank = 1;
 else if( y >= 128 && y <= 191) bank = 2;
 else if( y >= 192 && y <= 255) bank = 3;
 else if( y >= 256 && y <= 319) bank = 4;
 else if( y >= 320 && y <= 383) bank = 5;
 else if( y >= 384 && y <= 447) bank = 6;
 else if( y >= 448 && y <= 511) bank = 7;
 else if( y >= 512 && y <= 575) bank = 8;
 else if( y >= 576 && y <= 639) bank = 9;
 else if( y >= 640 && y <= 703) bank = 10;
 else if( y >= 704 && y <= 767) bank = 11;
 else
     bank = offset / 65536L;

/* offset = offset % 65536L; */
 offset = offset - bank * 65536L;

 if( bank != active_bank1024) {
     active_bank1024 = bank;
     bank ^= 0x0002;
     outp(0x3c4, 0x0b);
     temp1024 = inp(0x3c5);
     outp(0x3ce, 0x06);
     temp1024 = inp(0x3cf);
     temp1024 = (temp1024 & 0xf3) | 0x04;
     outp(0x3cf, temp1024);
     outp(0x3c4, 0x0e);
     temp1024 = (inp(0x3c5) & 0xf0) | bank;
     outp(0x3c5, temp1024);
     }

 address = (char far *) (0xa0000000L + offset);
 *address = color;
}


/*~~~~~~~~~~~~~~~~~*\
\*___set_palette___*/

set_pal1024(ColorRegister *p)
{
 r1024.x.ax = 0x1012;
 r1024.x.bx = 0;
 r1024.x.cx = 256;
 _ES    = FP_SEG(p);
 r1024.x.dx = FP_OFF(p);
 int86(0x10, &r1024, &r1024);
}


