#include <stdio.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <dos.h>
#include "header.h"
#include "extern.h"

struct   PCX_File PCX;
unsigned width, height;

static   FILE   *fp;
static   BYTE   sline[320];          /* 320*200*256 -> 320 */
static   struct ExtendPalette p256;
static   union  REGS r;
int      temp = 0;
int      active_bank = 0;


/*~~~~~~~~~~~~~~~~*\
\*___Recompress___*/

static CompletionCode expand_data(FILE *fpp)
{
 register short R;
 unsigned B, cnt, ptr = 0;

 B = PCX.Info.Num_plane * PCX.Info.Byte_line;
 do {
    R = getc(fpp);
    if(R == EOF) return(0);
    if((R & 0xc0) == 0xc0) {
			   cnt = R & 0x3f;
			   R = getc(fpp);
			   if(R == EOF) return(0);
			   while (cnt--) sline[ptr++] = R;
			   }
	else
	    sline[ptr++] = R;
 } while (ptr < B);
 return(1);
}


/*~~~~~~~~~~~~~~~~~~*\
\*___See_pcx_file___*/

see_pcx_320(char *f_name)
{
 register unsigned s, c, i;

 fp = fopen(f_name, "rb");
 fread(&PCX, 128, 1, fp);

 width  = PCX.x2 - PCX.x1 + 1;    /*PCX.PCXHeader.hres;*/
 height = PCX.y2 - PCX.y1 + 1;    /*PCX.PCXHeader.vres;*/

 set_your_video(0x13);
/* set_stand_video(0x101); */

 for(s = 0; s < height; s++) {
		 expand_data(fp);
		 for(c = 0; c < width; c++)
				 set_pixel(c, s, sline[c]);
		 }

 fread(&p256, 769, 1, fp);
 for(i = 0; i < 256; i++)
		 {
		 p256.Palette[i].red   >>= 2;
		 p256.Palette[i].green >>= 2;
		 p256.Palette[i].blue  >>= 2;
		 }
 set_pal((ColorRegister *) & (p256.Palette));
 fclose(fp);
}


/*~~~~~~~~~~~~~~~~~~~~*\
\*___set_your_video___*/

set_your_video(int mode)
{
 r.h.ah = 0;
 r.h.al = mode;
 int86(0x10, &r, &r);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~*\
\*___set_standard_video___*/

int set_stand_video(int mode1)
{
 r.x.ax = 0x4f02;
 r.x.bx = mode1;
 int86(0x10, &r, &r);
}


/*~~~~~~~~~~~~~~~*\
\*___set_pixel___*/

set_pixel(int x, int y, int color)
{
 long int offset, base;
 char far *address;
 int bank, temp;

 offset = (long)320*(long)y + (long)x;

 address = (char far *) (0xa0000000L + offset);
 *address = color;
}


/*~~~~~~~~~~~~~~~~~*\
\*___set_palette___*/

set_pal(ColorRegister *p)
{
 r.x.ax = 0x1012;
 r.x.bx = 0;
 r.x.cx = 256;
 _ES    = FP_SEG(p);
 r.x.dx = FP_OFF(p);
 int86(0x10, &r, &r);
}


