#include <stdio.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <dos.h>
#include "header.h"
#include "extern.h"

struct   PCX_File PCX640;
unsigned width640, height640;

static   FILE   *fp640;
static   BYTE   s640[640];          /* 640*480*256 -> 640 */
static   struct ExtendPalette p640;
static   union  REGS r640;
int      temp640 = 0;
int      active_bank640 = 0;


/*~~~~~~~~~~~~~~~~*\
\*___Recompress___*/

static CompletionCode expand_data640(FILE *fpp)
{
 register short R;
 unsigned B, cnt, ptr = 0;

 B = PCX640.Info.Num_plane * PCX640.Info.Byte_line;
 do {
    R = getc(fpp);
    if(R == EOF) return(0);
    if((R & 0xc0) == 0xc0) {
			   cnt = R & 0x3f;
			   R = getc(fpp);
			   if(R == EOF) return(0);
			   while (cnt--) s640[ptr++] = R;
			   }
	else
	    s640[ptr++] = R;
 } while (ptr < B);
 return(1);
}


/*~~~~~~~~~~~~~~~~~~*\
\*___See_pcx_file___*/

see_pcx_640(char *f_name)
{
 register unsigned s, c, i;

 fp640 = fopen(f_name, "rb");
 fread(&PCX640, 128, 1, fp640);

 width640  = PCX640.x2 - PCX640.x1 + 1;    /*PCX640.PCX640Header.hres;*/
 height640 = PCX640.y2 - PCX640.y1 + 1;    /*PCX640.PCXHeader.vres;*/

/* set_your_video(0x5d); */
 set_stand_video640(0x101);

 for(s = 0; s < height640; s++) {
		 expand_data640(fp640);
		 for(c = 0; c < width640; c++)
				 set_pixel640(c, s, s640[c]);
		 }

 fread(&p640, 769, 1, fp640);
 for(i = 0; i < 256; i++)
		 {
		 p640.Palette[i].red   >>= 2;
		 p640.Palette[i].green >>= 2;
		 p640.Palette[i].blue  >>= 2;
		 }
 set_pal640((ColorRegister *) & (p640.Palette));
 fclose(fp640);
}


/*~~~~~~~~~~~~~~~~~~~~*\
\*___set_your_video___*/

set_your_video640(int mode)
{
 r640.h.ah = 0;
 r640.h.al = mode;
 int86(0x10, &r640, &r640);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~*\
\*___set_standard_video___*/

int set_stand_video640(int mode1)
{
 r640.x.ax = 0x4f02;
 r640.x.bx = mode1;
 int86(0x10, &r640, &r640);
}


/*~~~~~~~~~~~~~~~*\
\*___set_pixel___*/

set_pixel640(int x, int y, int color)
{
 long int offset, base;
 char far *address;
 int bank, temp640;

 offset = (long)640*(long)y + (long)x;

 if( y <= 101) bank = 0;
 else if( y >= 103 && y <= 203) bank = 1;
 else if( y >= 205 && y <= 306) bank = 2;
 else if( y >= 308 && y <= 408) bank = 3;
 else if( y >= 410) bank = 4;
 else
     bank = offset / 65536L;

/* offset = offset % 65536L; */
 offset = offset - bank * 65536L;

 if( bank != active_bank640) {
     active_bank640 = bank;
     bank ^= 0x0002;
     outp(0x3c4, 0x0b);
     temp640 = inp(0x3c5);
     outp(0x3ce, 0x06);
     temp640 = inp(0x3cf);
     temp640 = (temp640 & 0xf3) | 0x04;
     outp(0x3cf, temp640);
     outp(0x3c4, 0x0e);
     temp640 = (inp(0x3c5) & 0xf0) | bank;
     outp(0x3c5, temp640);
     }

 address = (char far *) (0xa0000000L + offset);
 *address = color;
}


/*~~~~~~~~~~~~~~~~~*\
\*___set_palette___*/

set_pal640(ColorRegister *p)
{
 r640.x.ax = 0x1012;
 r640.x.bx = 0;
 r640.x.cx = 256;
 _ES    = FP_SEG(p);
 r640.x.dx = FP_OFF(p);
 int86(0x10, &r640, &r640);
}


