#include <stdio.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <dos.h>
#include "header.h"
#include "extern.h"

struct   PCX_File PCX800;
unsigned width800, height800;

static   FILE   *fp800;
static   BYTE   s800[800];
static   struct ExtendPalette p800;
static   union  REGS r800;
int      temp800 = 0;
int      active_bank800 = 0;

/*~~~~~~~~~~~~~~~~*\
\*___Recompress___*/

static CompletionCode expand_data800(FILE *fpp)
{
 register short R;
 unsigned B, cnt, ptr = 0;

 B = PCX800.Info.Num_plane * PCX800.Info.Byte_line;
 do {
    R = getc(fpp);
    if(R == EOF) return(0);
    if((R & 0xc0) == 0xc0) {
			   cnt = R & 0x3f;
			   R = getc(fpp);
			   if(R == EOF) return(0);
			   while (cnt--) s800[ptr++] = R;
			   }
	else
	    s800[ptr++] = R;
 } while (ptr < B);
 return(1);
}


/*~~~~~~~~~~~~~~~~~~*\
\*___See_pcx_file___*/

see_pcx_800(char *f_name)
{
 register unsigned s, c, i;

 fp800 = fopen(f_name, "rb");
 fread(&PCX800, 128, 1, fp800);

 width800  = PCX800.x2 - PCX800.x1 + 1;    /*PCX.PCXHeader.hres;*/
 height800 = PCX800.y2 - PCX800.y1 + 1;    /*PCX.PCXHeader.vres;*/

/* set_your_video(0x5d); */
 set_stand_video800(0x103);  /* 800*600*256 */
 for(s = 0; s < height800; s++) {
		 expand_data800(fp800);
		 for(c = 0; c < width800; c++)
				 set_pixel800(c, s, s800[c]);
		 }

 fread(&p800, 769, 1, fp800);
 for(i = 0; i < 256; i++)
		 {
		 p800.Palette[i].red   >>= 2;
		 p800.Palette[i].green >>= 2;
		 p800.Palette[i].blue  >>= 2;
		 }
 set_pal800((ColorRegister *) & (p800.Palette));
 fclose(fp800);
}


/*~~~~~~~~~~~~~~~~~~~~*\
\*___set_your_video___*/

set_your_video800(int mode)
{
 r800.h.ah = 0;
 r800.h.al = mode;
 int86(0x10, &r800, &r800);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~*\
\*___set_standard_video___*/

int set_stand_video800(int mode1)
{
 r800.x.ax = 0x4f02;
 r800.x.bx = mode1;
 int86(0x10, &r800, &r800);
}


/*~~~~~~~~~~~~~~~*\
\*___set_pixel___*/

set_pixel800(int x, int y, int color)
{
 long int offset, base;
 char far *address;
 int bank, temp800;

 offset = (long)800*(long)y + (long)x;  /* 800*600*256 -> 800 */

 if( y <= 80) bank = 0;
 else if( y >= 82 && y <= 162) bank = 1;
 else if( y >= 164 && y <= 244) bank = 2;
 else if( y >= 246 && y <= 326) bank = 3;
 else if( y >= 328 && y <= 408) bank = 4;
 else if( y >= 410 && y <= 490) bank = 5;
 else if( y >= 492 && y <= 572) bank = 6;
 else if( y >= 574) bank = 7;
 else
     bank = offset / 65536L;

/* offset = offset % 65536L; */
 offset = offset - bank * 65536L;

 if( bank != active_bank800) {
     active_bank800 = bank;
     bank ^= 0x0002;
     outp(0x3c4, 0x0b);
     temp800 = inp(0x3c5);
     outp(0x3ce, 0x06);
     temp800 = inp(0x3cf);
     temp800 = (temp800 & 0xf3) | 0x04;
     outp(0x3cf, temp800);
     outp(0x3c4, 0x0e);
     temp800 = (inp(0x3c5) & 0xf0) | bank;
     outp(0x3c5, temp800);
     }

 address = (char far *) (0xa0000000L + offset);
 *address = color;
}


/*~~~~~~~~~~~~~~~~~*\
\*___set_palette___*/

set_pal800(ColorRegister *p)
{
 r800.x.ax = 0x1012;
 r800.x.bx = 0;
 r800.x.cx = 256;
 _ES    = FP_SEG(p);
 r800.x.dx = FP_OFF(p);
 int86(0x10, &r800, &r800);
}


