#ifndef __BYTE
#define __BYTE
typedef unsigned char BYTE;
#endif

#ifndef _CompletionCode_
#define _CompletionCode_
typedef int CompletionCode;
#endif

#ifndef __ColorRegister
#define __ColorRegister
typedef struct  {
	 BYTE red;
	 BYTE green;
	 BYTE blue;
} ColorRegister;
#endif

struct PCXFileHeader  {
	 BYTE     header;
	 BYTE     version;
	 BYTE     encode;
	 BYTE     bit_pix;
	 unsigned x1;
	 unsigned y1;
	 unsigned x2;
	 unsigned y2;
	 unsigned hres;
	 unsigned vres;
};

struct PCXInfo  {
	 BYTE     Vmode;
	 BYTE     Num_plane;
	 unsigned Byte_line;
	 BYTE     Un_used[60];
};

struct PCX_File  {
   struct PCXFileHeader PCXHeader;
   ColorRegister        Palette[16];
   struct PCXInfo       Info;
};

struct ExtendPalette  {
	 BYTE ExtendPalette;
	 ColorRegister Palette[256]; /* 768 bytes */
};

